package software.amazon.awscdk.services.logs;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * ColumnRestriction columnRestriction = ColumnRestriction.builder()
 *         .comparison("comparison")
 *         // the properties below are optional
 *         .numberValue(123)
 *         .stringValue("stringValue")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:40.703Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.ColumnRestriction")
@software.amazon.jsii.Jsii.Proxy(ColumnRestriction.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ColumnRestriction extends software.amazon.jsii.JsiiSerializable {

    /**
     * Comparison operator to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComparison();

    /**
     * Number value to compare to.
     * <p>
     * Exactly one of 'stringValue' and 'numberValue' must be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberValue() {
        return null;
    }

    /**
     * String value to compare to.
     * <p>
     * Exactly one of 'stringValue' and 'numberValue' must be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ColumnRestriction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ColumnRestriction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ColumnRestriction> {
        java.lang.String comparison;
        java.lang.Number numberValue;
        java.lang.String stringValue;

        /**
         * Sets the value of {@link ColumnRestriction#getComparison}
         * @param comparison Comparison operator to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comparison(java.lang.String comparison) {
            this.comparison = comparison;
            return this;
        }

        /**
         * Sets the value of {@link ColumnRestriction#getNumberValue}
         * @param numberValue Number value to compare to.
         *                    Exactly one of 'stringValue' and 'numberValue' must be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberValue(java.lang.Number numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        /**
         * Sets the value of {@link ColumnRestriction#getStringValue}
         * @param stringValue String value to compare to.
         *                    Exactly one of 'stringValue' and 'numberValue' must be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stringValue(java.lang.String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ColumnRestriction}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ColumnRestriction build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ColumnRestriction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnRestriction {
        private final java.lang.String comparison;
        private final java.lang.Number numberValue;
        private final java.lang.String stringValue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numberValue = software.amazon.jsii.Kernel.get(this, "numberValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
            this.numberValue = builder.numberValue;
            this.stringValue = builder.stringValue;
        }

        @Override
        public final java.lang.String getComparison() {
            return this.comparison;
        }

        @Override
        public final java.lang.Number getNumberValue() {
            return this.numberValue;
        }

        @Override
        public final java.lang.String getStringValue() {
            return this.stringValue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("comparison", om.valueToTree(this.getComparison()));
            if (this.getNumberValue() != null) {
                data.set("numberValue", om.valueToTree(this.getNumberValue()));
            }
            if (this.getStringValue() != null) {
                data.set("stringValue", om.valueToTree(this.getStringValue()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.ColumnRestriction"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ColumnRestriction.Jsii$Proxy that = (ColumnRestriction.Jsii$Proxy) o;

            if (!comparison.equals(that.comparison)) return false;
            if (this.numberValue != null ? !this.numberValue.equals(that.numberValue) : that.numberValue != null) return false;
            return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comparison.hashCode();
            result = 31 * result + (this.numberValue != null ? this.numberValue.hashCode() : 0);
            result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
            return result;
        }
    }
}
