package software.amazon.awscdk.services.kinesisanalyticsv2;

/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 * <p>
 * Creates an Amazon Kinesis Data Analytics application. For information about creating a Kinesis Data Analytics application, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html">Creating an Application</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
 * CfnApplication cfnApplication = CfnApplication.Builder.create(this, "MyCfnApplication")
 *         .runtimeEnvironment("runtimeEnvironment")
 *         .serviceExecutionRole("serviceExecutionRole")
 *         // the properties below are optional
 *         .applicationConfiguration(ApplicationConfigurationProperty.builder()
 *                 .applicationCodeConfiguration(ApplicationCodeConfigurationProperty.builder()
 *                         .codeContent(CodeContentProperty.builder()
 *                                 .s3ContentLocation(S3ContentLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         .fileKey("fileKey")
 *                                         // the properties below are optional
 *                                         .objectVersion("objectVersion")
 *                                         .build())
 *                                 .textContent("textContent")
 *                                 .zipFileContent("zipFileContent")
 *                                 .build())
 *                         .codeContentType("codeContentType")
 *                         .build())
 *                 .applicationSnapshotConfiguration(ApplicationSnapshotConfigurationProperty.builder()
 *                         .snapshotsEnabled(false)
 *                         .build())
 *                 .environmentProperties(EnvironmentPropertiesProperty.builder()
 *                         .propertyGroups(List.of(PropertyGroupProperty.builder()
 *                                 .propertyGroupId("propertyGroupId")
 *                                 .propertyMap(Map.of(
 *                                         "propertyMapKey", "propertyMap"))
 *                                 .build()))
 *                         .build())
 *                 .flinkApplicationConfiguration(FlinkApplicationConfigurationProperty.builder()
 *                         .checkpointConfiguration(CheckpointConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .checkpointingEnabled(false)
 *                                 .checkpointInterval(123)
 *                                 .minPauseBetweenCheckpoints(123)
 *                                 .build())
 *                         .monitoringConfiguration(MonitoringConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .logLevel("logLevel")
 *                                 .metricsLevel("metricsLevel")
 *                                 .build())
 *                         .parallelismConfiguration(ParallelismConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .autoScalingEnabled(false)
 *                                 .parallelism(123)
 *                                 .parallelismPerKpu(123)
 *                                 .build())
 *                         .build())
 *                 .sqlApplicationConfiguration(SqlApplicationConfigurationProperty.builder()
 *                         .inputs(List.of(InputProperty.builder()
 *                                 .inputSchema(InputSchemaProperty.builder()
 *                                         .recordColumns(List.of(RecordColumnProperty.builder()
 *                                                 .name("name")
 *                                                 .sqlType("sqlType")
 *                                                 // the properties below are optional
 *                                                 .mapping("mapping")
 *                                                 .build()))
 *                                         .recordFormat(RecordFormatProperty.builder()
 *                                                 .recordFormatType("recordFormatType")
 *                                                 // the properties below are optional
 *                                                 .mappingParameters(MappingParametersProperty.builder()
 *                                                         .csvMappingParameters(CSVMappingParametersProperty.builder()
 *                                                                 .recordColumnDelimiter("recordColumnDelimiter")
 *                                                                 .recordRowDelimiter("recordRowDelimiter")
 *                                                                 .build())
 *                                                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
 *                                                                 .recordRowPath("recordRowPath")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .recordEncoding("recordEncoding")
 *                                         .build())
 *                                 .namePrefix("namePrefix")
 *                                 // the properties below are optional
 *                                 .inputParallelism(InputParallelismProperty.builder()
 *                                         .count(123)
 *                                         .build())
 *                                 .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
 *                                         .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
 *                                                 .resourceArn("resourceArn")
 *                                                 .build())
 *                                         .build())
 *                                 .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
 *                                         .resourceArn("resourceArn")
 *                                         .build())
 *                                 .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
 *                                         .resourceArn("resourceArn")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .vpcConfigurations(List.of(VpcConfigurationProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnetIds(List.of("subnetIds"))
 *                         .build()))
 *                 .zeppelinApplicationConfiguration(ZeppelinApplicationConfigurationProperty.builder()
 *                         .catalogConfiguration(CatalogConfigurationProperty.builder()
 *                                 .glueDataCatalogConfiguration(GlueDataCatalogConfigurationProperty.builder()
 *                                         .databaseArn("databaseArn")
 *                                         .build())
 *                                 .build())
 *                         .customArtifactsConfiguration(List.of(CustomArtifactConfigurationProperty.builder()
 *                                 .artifactType("artifactType")
 *                                 // the properties below are optional
 *                                 .mavenReference(MavenReferenceProperty.builder()
 *                                         .artifactId("artifactId")
 *                                         .groupId("groupId")
 *                                         .version("version")
 *                                         .build())
 *                                 .s3ContentLocation(S3ContentLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         .fileKey("fileKey")
 *                                         // the properties below are optional
 *                                         .objectVersion("objectVersion")
 *                                         .build())
 *                                 .build()))
 *                         .deployAsApplicationConfiguration(DeployAsApplicationConfigurationProperty.builder()
 *                                 .s3ContentLocation(S3ContentBaseLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         // the properties below are optional
 *                                         .basePath("basePath")
 *                                         .build())
 *                                 .build())
 *                         .monitoringConfiguration(ZeppelinMonitoringConfigurationProperty.builder()
 *                                 .logLevel("logLevel")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .applicationDescription("applicationDescription")
 *         .applicationMaintenanceConfiguration(ApplicationMaintenanceConfigurationProperty.builder()
 *                 .applicationMaintenanceWindowStartTime("applicationMaintenanceWindowStartTime")
 *                 .build())
 *         .applicationMode("applicationMode")
 *         .applicationName("applicationName")
 *         .runConfiguration(RunConfigurationProperty.builder()
 *                 .applicationRestoreConfiguration(ApplicationRestoreConfigurationProperty.builder()
 *                         .applicationRestoreType("applicationRestoreType")
 *                         // the properties below are optional
 *                         .snapshotName("snapshotName")
 *                         .build())
 *                 .flinkRunConfiguration(FlinkRunConfigurationProperty.builder()
 *                         .allowNonRestoredState(false)
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:40.240Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::KinesisAnalyticsV2::Application`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of one or more tags to assign to the application.
     * <p>
     * A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The runtime environment for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuntimeEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "runtimeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The runtime environment for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "runtimeEnvironment", java.util.Objects.requireNonNull(value, "runtimeEnvironment is required"));
    }

    /**
     * Specifies the IAM role that the application uses to access external resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceExecutionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the IAM role that the application uses to access external resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceExecutionRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceExecutionRole", java.util.Objects.requireNonNull(value, "serviceExecutionRole is required"));
    }

    /**
     * Use this parameter to configure the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApplicationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "applicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this parameter to configure the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "applicationConfiguration", value);
    }

    /**
     * Use this parameter to configure the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "applicationConfiguration", value);
    }

    /**
     * The description of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationDescription() {
        return software.amazon.jsii.Kernel.get(this, "applicationDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationDescription", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationMaintenanceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApplicationMaintenanceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "applicationMaintenanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationMaintenanceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationMaintenanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationMaintenanceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "applicationMaintenanceConfiguration", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationMaintenanceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationMaintenanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "applicationMaintenanceConfiguration", value);
    }

    /**
     * To create a Kinesis Data Analytics Studio notebook, you must set the mode to `INTERACTIVE` .
     * <p>
     * However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationMode() {
        return software.amazon.jsii.Kernel.get(this, "applicationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * To create a Kinesis Data Analytics Studio notebook, you must set the mode to `INTERACTIVE` .
     * <p>
     * However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationMode", value);
    }

    /**
     * The name of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationName() {
        return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationName", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.RunConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRunConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "runConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.RunConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRunConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.RunConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "runConfiguration", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.RunConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRunConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "runConfiguration", value);
    }
    /**
     * Describes code configuration for an application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * ApplicationCodeConfigurationProperty applicationCodeConfigurationProperty = ApplicationCodeConfigurationProperty.builder()
     *         .codeContent(CodeContentProperty.builder()
     *                 .s3ContentLocation(S3ContentLocationProperty.builder()
     *                         .bucketArn("bucketArn")
     *                         .fileKey("fileKey")
     *                         // the properties below are optional
     *                         .objectVersion("objectVersion")
     *                         .build())
     *                 .textContent("textContent")
     *                 .zipFileContent("zipFileContent")
     *                 .build())
     *         .codeContentType("codeContentType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationCodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationCodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationCodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location and type of the application code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCodeContent();

        /**
         * Specifies whether the code content is in text or zip format.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCodeContentType();

        /**
         * @return a {@link Builder} of {@link ApplicationCodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationCodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationCodeConfigurationProperty> {
            java.lang.Object codeContent;
            java.lang.String codeContentType;

            /**
             * Sets the value of {@link ApplicationCodeConfigurationProperty#getCodeContent}
             * @param codeContent The location and type of the application code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeContent(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.CodeContentProperty codeContent) {
                this.codeContent = codeContent;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationCodeConfigurationProperty#getCodeContent}
             * @param codeContent The location and type of the application code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeContent(software.amazon.awscdk.IResolvable codeContent) {
                this.codeContent = codeContent;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationCodeConfigurationProperty#getCodeContentType}
             * @param codeContentType Specifies whether the code content is in text or zip format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeContentType(java.lang.String codeContentType) {
                this.codeContentType = codeContentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationCodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationCodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationCodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationCodeConfigurationProperty {
            private final java.lang.Object codeContent;
            private final java.lang.String codeContentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeContent = software.amazon.jsii.Kernel.get(this, "codeContent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeContentType = software.amazon.jsii.Kernel.get(this, "codeContentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeContent = java.util.Objects.requireNonNull(builder.codeContent, "codeContent is required");
                this.codeContentType = java.util.Objects.requireNonNull(builder.codeContentType, "codeContentType is required");
            }

            @Override
            public final java.lang.Object getCodeContent() {
                return this.codeContent;
            }

            @Override
            public final java.lang.String getCodeContentType() {
                return this.codeContentType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("codeContent", om.valueToTree(this.getCodeContent()));
                data.set("codeContentType", om.valueToTree(this.getCodeContentType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationCodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationCodeConfigurationProperty.Jsii$Proxy that = (ApplicationCodeConfigurationProperty.Jsii$Proxy) o;

                if (!codeContent.equals(that.codeContent)) return false;
                return this.codeContentType.equals(that.codeContentType);
            }

            @Override
            public final int hashCode() {
                int result = this.codeContent.hashCode();
                result = 31 * result + (this.codeContentType.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the creation parameters for a Kinesis Data Analytics application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * ApplicationConfigurationProperty applicationConfigurationProperty = ApplicationConfigurationProperty.builder()
     *         .applicationCodeConfiguration(ApplicationCodeConfigurationProperty.builder()
     *                 .codeContent(CodeContentProperty.builder()
     *                         .s3ContentLocation(S3ContentLocationProperty.builder()
     *                                 .bucketArn("bucketArn")
     *                                 .fileKey("fileKey")
     *                                 // the properties below are optional
     *                                 .objectVersion("objectVersion")
     *                                 .build())
     *                         .textContent("textContent")
     *                         .zipFileContent("zipFileContent")
     *                         .build())
     *                 .codeContentType("codeContentType")
     *                 .build())
     *         .applicationSnapshotConfiguration(ApplicationSnapshotConfigurationProperty.builder()
     *                 .snapshotsEnabled(false)
     *                 .build())
     *         .environmentProperties(EnvironmentPropertiesProperty.builder()
     *                 .propertyGroups(List.of(PropertyGroupProperty.builder()
     *                         .propertyGroupId("propertyGroupId")
     *                         .propertyMap(Map.of(
     *                                 "propertyMapKey", "propertyMap"))
     *                         .build()))
     *                 .build())
     *         .flinkApplicationConfiguration(FlinkApplicationConfigurationProperty.builder()
     *                 .checkpointConfiguration(CheckpointConfigurationProperty.builder()
     *                         .configurationType("configurationType")
     *                         // the properties below are optional
     *                         .checkpointingEnabled(false)
     *                         .checkpointInterval(123)
     *                         .minPauseBetweenCheckpoints(123)
     *                         .build())
     *                 .monitoringConfiguration(MonitoringConfigurationProperty.builder()
     *                         .configurationType("configurationType")
     *                         // the properties below are optional
     *                         .logLevel("logLevel")
     *                         .metricsLevel("metricsLevel")
     *                         .build())
     *                 .parallelismConfiguration(ParallelismConfigurationProperty.builder()
     *                         .configurationType("configurationType")
     *                         // the properties below are optional
     *                         .autoScalingEnabled(false)
     *                         .parallelism(123)
     *                         .parallelismPerKpu(123)
     *                         .build())
     *                 .build())
     *         .sqlApplicationConfiguration(SqlApplicationConfigurationProperty.builder()
     *                 .inputs(List.of(InputProperty.builder()
     *                         .inputSchema(InputSchemaProperty.builder()
     *                                 .recordColumns(List.of(RecordColumnProperty.builder()
     *                                         .name("name")
     *                                         .sqlType("sqlType")
     *                                         // the properties below are optional
     *                                         .mapping("mapping")
     *                                         .build()))
     *                                 .recordFormat(RecordFormatProperty.builder()
     *                                         .recordFormatType("recordFormatType")
     *                                         // the properties below are optional
     *                                         .mappingParameters(MappingParametersProperty.builder()
     *                                                 .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                                                         .recordColumnDelimiter("recordColumnDelimiter")
     *                                                         .recordRowDelimiter("recordRowDelimiter")
     *                                                         .build())
     *                                                 .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                                                         .recordRowPath("recordRowPath")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .recordEncoding("recordEncoding")
     *                                 .build())
     *                         .namePrefix("namePrefix")
     *                         // the properties below are optional
     *                         .inputParallelism(InputParallelismProperty.builder()
     *                                 .count(123)
     *                                 .build())
     *                         .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
     *                                 .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
     *                                         .resourceArn("resourceArn")
     *                                         .build())
     *                                 .build())
     *                         .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
     *                                 .resourceArn("resourceArn")
     *                                 .build())
     *                         .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
     *                                 .resourceArn("resourceArn")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .vpcConfigurations(List.of(VpcConfigurationProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build()))
     *         .zeppelinApplicationConfiguration(ZeppelinApplicationConfigurationProperty.builder()
     *                 .catalogConfiguration(CatalogConfigurationProperty.builder()
     *                         .glueDataCatalogConfiguration(GlueDataCatalogConfigurationProperty.builder()
     *                                 .databaseArn("databaseArn")
     *                                 .build())
     *                         .build())
     *                 .customArtifactsConfiguration(List.of(CustomArtifactConfigurationProperty.builder()
     *                         .artifactType("artifactType")
     *                         // the properties below are optional
     *                         .mavenReference(MavenReferenceProperty.builder()
     *                                 .artifactId("artifactId")
     *                                 .groupId("groupId")
     *                                 .version("version")
     *                                 .build())
     *                         .s3ContentLocation(S3ContentLocationProperty.builder()
     *                                 .bucketArn("bucketArn")
     *                                 .fileKey("fileKey")
     *                                 // the properties below are optional
     *                                 .objectVersion("objectVersion")
     *                                 .build())
     *                         .build()))
     *                 .deployAsApplicationConfiguration(DeployAsApplicationConfigurationProperty.builder()
     *                         .s3ContentLocation(S3ContentBaseLocationProperty.builder()
     *                                 .bucketArn("bucketArn")
     *                                 // the properties below are optional
     *                                 .basePath("basePath")
     *                                 .build())
     *                         .build())
     *                 .monitoringConfiguration(ZeppelinMonitoringConfigurationProperty.builder()
     *                         .logLevel("logLevel")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The code location and type parameters for a Flink-based Kinesis Data Analytics application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationCodeConfiguration() {
            return null;
        }

        /**
         * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationSnapshotConfiguration() {
            return null;
        }

        /**
         * Describes execution properties for a Flink-based Kinesis Data Analytics application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentProperties() {
            return null;
        }

        /**
         * The creation and update parameters for a Flink-based Kinesis Data Analytics application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFlinkApplicationConfiguration() {
            return null;
        }

        /**
         * The creation and update parameters for a SQL-based Kinesis Data Analytics application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqlApplicationConfiguration() {
            return null;
        }

        /**
         * `CfnApplication.ApplicationConfigurationProperty.VpcConfigurations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfigurations() {
            return null;
        }

        /**
         * The configuration parameters for a Kinesis Data Analytics Studio notebook.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZeppelinApplicationConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationConfigurationProperty> {
            java.lang.Object applicationCodeConfiguration;
            java.lang.Object applicationSnapshotConfiguration;
            java.lang.Object environmentProperties;
            java.lang.Object flinkApplicationConfiguration;
            java.lang.Object sqlApplicationConfiguration;
            java.lang.Object vpcConfigurations;
            java.lang.Object zeppelinApplicationConfiguration;

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getApplicationCodeConfiguration}
             * @param applicationCodeConfiguration The code location and type parameters for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationCodeConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationCodeConfigurationProperty applicationCodeConfiguration) {
                this.applicationCodeConfiguration = applicationCodeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getApplicationCodeConfiguration}
             * @param applicationCodeConfiguration The code location and type parameters for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationCodeConfiguration(software.amazon.awscdk.IResolvable applicationCodeConfiguration) {
                this.applicationCodeConfiguration = applicationCodeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getApplicationSnapshotConfiguration}
             * @param applicationSnapshotConfiguration Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationSnapshotConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationSnapshotConfigurationProperty applicationSnapshotConfiguration) {
                this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getApplicationSnapshotConfiguration}
             * @param applicationSnapshotConfiguration Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationSnapshotConfiguration(software.amazon.awscdk.IResolvable applicationSnapshotConfiguration) {
                this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getEnvironmentProperties}
             * @param environmentProperties Describes execution properties for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentProperties(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.EnvironmentPropertiesProperty environmentProperties) {
                this.environmentProperties = environmentProperties;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getEnvironmentProperties}
             * @param environmentProperties Describes execution properties for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentProperties(software.amazon.awscdk.IResolvable environmentProperties) {
                this.environmentProperties = environmentProperties;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getFlinkApplicationConfiguration}
             * @param flinkApplicationConfiguration The creation and update parameters for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flinkApplicationConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.FlinkApplicationConfigurationProperty flinkApplicationConfiguration) {
                this.flinkApplicationConfiguration = flinkApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getFlinkApplicationConfiguration}
             * @param flinkApplicationConfiguration The creation and update parameters for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flinkApplicationConfiguration(software.amazon.awscdk.IResolvable flinkApplicationConfiguration) {
                this.flinkApplicationConfiguration = flinkApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getSqlApplicationConfiguration}
             * @param sqlApplicationConfiguration The creation and update parameters for a SQL-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlApplicationConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.SqlApplicationConfigurationProperty sqlApplicationConfiguration) {
                this.sqlApplicationConfiguration = sqlApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getSqlApplicationConfiguration}
             * @param sqlApplicationConfiguration The creation and update parameters for a SQL-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlApplicationConfiguration(software.amazon.awscdk.IResolvable sqlApplicationConfiguration) {
                this.sqlApplicationConfiguration = sqlApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getVpcConfigurations}
             * @param vpcConfigurations `CfnApplication.ApplicationConfigurationProperty.VpcConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfigurations(software.amazon.awscdk.IResolvable vpcConfigurations) {
                this.vpcConfigurations = vpcConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getVpcConfigurations}
             * @param vpcConfigurations `CfnApplication.ApplicationConfigurationProperty.VpcConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfigurations(java.util.List<? extends java.lang.Object> vpcConfigurations) {
                this.vpcConfigurations = vpcConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getZeppelinApplicationConfiguration}
             * @param zeppelinApplicationConfiguration The configuration parameters for a Kinesis Data Analytics Studio notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zeppelinApplicationConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ZeppelinApplicationConfigurationProperty zeppelinApplicationConfiguration) {
                this.zeppelinApplicationConfiguration = zeppelinApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigurationProperty#getZeppelinApplicationConfiguration}
             * @param zeppelinApplicationConfiguration The configuration parameters for a Kinesis Data Analytics Studio notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zeppelinApplicationConfiguration(software.amazon.awscdk.IResolvable zeppelinApplicationConfiguration) {
                this.zeppelinApplicationConfiguration = zeppelinApplicationConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationConfigurationProperty {
            private final java.lang.Object applicationCodeConfiguration;
            private final java.lang.Object applicationSnapshotConfiguration;
            private final java.lang.Object environmentProperties;
            private final java.lang.Object flinkApplicationConfiguration;
            private final java.lang.Object sqlApplicationConfiguration;
            private final java.lang.Object vpcConfigurations;
            private final java.lang.Object zeppelinApplicationConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationCodeConfiguration = software.amazon.jsii.Kernel.get(this, "applicationCodeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.applicationSnapshotConfiguration = software.amazon.jsii.Kernel.get(this, "applicationSnapshotConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentProperties = software.amazon.jsii.Kernel.get(this, "environmentProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.flinkApplicationConfiguration = software.amazon.jsii.Kernel.get(this, "flinkApplicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqlApplicationConfiguration = software.amazon.jsii.Kernel.get(this, "sqlApplicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfigurations = software.amazon.jsii.Kernel.get(this, "vpcConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zeppelinApplicationConfiguration = software.amazon.jsii.Kernel.get(this, "zeppelinApplicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationCodeConfiguration = builder.applicationCodeConfiguration;
                this.applicationSnapshotConfiguration = builder.applicationSnapshotConfiguration;
                this.environmentProperties = builder.environmentProperties;
                this.flinkApplicationConfiguration = builder.flinkApplicationConfiguration;
                this.sqlApplicationConfiguration = builder.sqlApplicationConfiguration;
                this.vpcConfigurations = builder.vpcConfigurations;
                this.zeppelinApplicationConfiguration = builder.zeppelinApplicationConfiguration;
            }

            @Override
            public final java.lang.Object getApplicationCodeConfiguration() {
                return this.applicationCodeConfiguration;
            }

            @Override
            public final java.lang.Object getApplicationSnapshotConfiguration() {
                return this.applicationSnapshotConfiguration;
            }

            @Override
            public final java.lang.Object getEnvironmentProperties() {
                return this.environmentProperties;
            }

            @Override
            public final java.lang.Object getFlinkApplicationConfiguration() {
                return this.flinkApplicationConfiguration;
            }

            @Override
            public final java.lang.Object getSqlApplicationConfiguration() {
                return this.sqlApplicationConfiguration;
            }

            @Override
            public final java.lang.Object getVpcConfigurations() {
                return this.vpcConfigurations;
            }

            @Override
            public final java.lang.Object getZeppelinApplicationConfiguration() {
                return this.zeppelinApplicationConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationCodeConfiguration() != null) {
                    data.set("applicationCodeConfiguration", om.valueToTree(this.getApplicationCodeConfiguration()));
                }
                if (this.getApplicationSnapshotConfiguration() != null) {
                    data.set("applicationSnapshotConfiguration", om.valueToTree(this.getApplicationSnapshotConfiguration()));
                }
                if (this.getEnvironmentProperties() != null) {
                    data.set("environmentProperties", om.valueToTree(this.getEnvironmentProperties()));
                }
                if (this.getFlinkApplicationConfiguration() != null) {
                    data.set("flinkApplicationConfiguration", om.valueToTree(this.getFlinkApplicationConfiguration()));
                }
                if (this.getSqlApplicationConfiguration() != null) {
                    data.set("sqlApplicationConfiguration", om.valueToTree(this.getSqlApplicationConfiguration()));
                }
                if (this.getVpcConfigurations() != null) {
                    data.set("vpcConfigurations", om.valueToTree(this.getVpcConfigurations()));
                }
                if (this.getZeppelinApplicationConfiguration() != null) {
                    data.set("zeppelinApplicationConfiguration", om.valueToTree(this.getZeppelinApplicationConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationConfigurationProperty.Jsii$Proxy that = (ApplicationConfigurationProperty.Jsii$Proxy) o;

                if (this.applicationCodeConfiguration != null ? !this.applicationCodeConfiguration.equals(that.applicationCodeConfiguration) : that.applicationCodeConfiguration != null) return false;
                if (this.applicationSnapshotConfiguration != null ? !this.applicationSnapshotConfiguration.equals(that.applicationSnapshotConfiguration) : that.applicationSnapshotConfiguration != null) return false;
                if (this.environmentProperties != null ? !this.environmentProperties.equals(that.environmentProperties) : that.environmentProperties != null) return false;
                if (this.flinkApplicationConfiguration != null ? !this.flinkApplicationConfiguration.equals(that.flinkApplicationConfiguration) : that.flinkApplicationConfiguration != null) return false;
                if (this.sqlApplicationConfiguration != null ? !this.sqlApplicationConfiguration.equals(that.sqlApplicationConfiguration) : that.sqlApplicationConfiguration != null) return false;
                if (this.vpcConfigurations != null ? !this.vpcConfigurations.equals(that.vpcConfigurations) : that.vpcConfigurations != null) return false;
                return this.zeppelinApplicationConfiguration != null ? this.zeppelinApplicationConfiguration.equals(that.zeppelinApplicationConfiguration) : that.zeppelinApplicationConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationCodeConfiguration != null ? this.applicationCodeConfiguration.hashCode() : 0;
                result = 31 * result + (this.applicationSnapshotConfiguration != null ? this.applicationSnapshotConfiguration.hashCode() : 0);
                result = 31 * result + (this.environmentProperties != null ? this.environmentProperties.hashCode() : 0);
                result = 31 * result + (this.flinkApplicationConfiguration != null ? this.flinkApplicationConfiguration.hashCode() : 0);
                result = 31 * result + (this.sqlApplicationConfiguration != null ? this.sqlApplicationConfiguration.hashCode() : 0);
                result = 31 * result + (this.vpcConfigurations != null ? this.vpcConfigurations.hashCode() : 0);
                result = 31 * result + (this.zeppelinApplicationConfiguration != null ? this.zeppelinApplicationConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * ApplicationMaintenanceConfigurationProperty applicationMaintenanceConfigurationProperty = ApplicationMaintenanceConfigurationProperty.builder()
     *         .applicationMaintenanceWindowStartTime("applicationMaintenanceWindowStartTime")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationMaintenanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationMaintenanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationMaintenanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplication.ApplicationMaintenanceConfigurationProperty.ApplicationMaintenanceWindowStartTime`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApplicationMaintenanceWindowStartTime();

        /**
         * @return a {@link Builder} of {@link ApplicationMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationMaintenanceConfigurationProperty> {
            java.lang.String applicationMaintenanceWindowStartTime;

            /**
             * Sets the value of {@link ApplicationMaintenanceConfigurationProperty#getApplicationMaintenanceWindowStartTime}
             * @param applicationMaintenanceWindowStartTime `CfnApplication.ApplicationMaintenanceConfigurationProperty.ApplicationMaintenanceWindowStartTime`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationMaintenanceWindowStartTime(java.lang.String applicationMaintenanceWindowStartTime) {
                this.applicationMaintenanceWindowStartTime = applicationMaintenanceWindowStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationMaintenanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationMaintenanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationMaintenanceConfigurationProperty {
            private final java.lang.String applicationMaintenanceWindowStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationMaintenanceWindowStartTime = software.amazon.jsii.Kernel.get(this, "applicationMaintenanceWindowStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationMaintenanceWindowStartTime = java.util.Objects.requireNonNull(builder.applicationMaintenanceWindowStartTime, "applicationMaintenanceWindowStartTime is required");
            }

            @Override
            public final java.lang.String getApplicationMaintenanceWindowStartTime() {
                return this.applicationMaintenanceWindowStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("applicationMaintenanceWindowStartTime", om.valueToTree(this.getApplicationMaintenanceWindowStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationMaintenanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationMaintenanceConfigurationProperty.Jsii$Proxy that = (ApplicationMaintenanceConfigurationProperty.Jsii$Proxy) o;

                return this.applicationMaintenanceWindowStartTime.equals(that.applicationMaintenanceWindowStartTime);
            }

            @Override
            public final int hashCode() {
                int result = this.applicationMaintenanceWindowStartTime.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * ApplicationRestoreConfigurationProperty applicationRestoreConfigurationProperty = ApplicationRestoreConfigurationProperty.builder()
     *         .applicationRestoreType("applicationRestoreType")
     *         // the properties below are optional
     *         .snapshotName("snapshotName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationRestoreConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationRestoreConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationRestoreConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplication.ApplicationRestoreConfigurationProperty.ApplicationRestoreType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApplicationRestoreType();

        /**
         * `CfnApplication.ApplicationRestoreConfigurationProperty.SnapshotName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationRestoreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationRestoreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationRestoreConfigurationProperty> {
            java.lang.String applicationRestoreType;
            java.lang.String snapshotName;

            /**
             * Sets the value of {@link ApplicationRestoreConfigurationProperty#getApplicationRestoreType}
             * @param applicationRestoreType `CfnApplication.ApplicationRestoreConfigurationProperty.ApplicationRestoreType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationRestoreType(java.lang.String applicationRestoreType) {
                this.applicationRestoreType = applicationRestoreType;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationRestoreConfigurationProperty#getSnapshotName}
             * @param snapshotName `CfnApplication.ApplicationRestoreConfigurationProperty.SnapshotName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotName(java.lang.String snapshotName) {
                this.snapshotName = snapshotName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationRestoreConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationRestoreConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationRestoreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationRestoreConfigurationProperty {
            private final java.lang.String applicationRestoreType;
            private final java.lang.String snapshotName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationRestoreType = software.amazon.jsii.Kernel.get(this, "applicationRestoreType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotName = software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationRestoreType = java.util.Objects.requireNonNull(builder.applicationRestoreType, "applicationRestoreType is required");
                this.snapshotName = builder.snapshotName;
            }

            @Override
            public final java.lang.String getApplicationRestoreType() {
                return this.applicationRestoreType;
            }

            @Override
            public final java.lang.String getSnapshotName() {
                return this.snapshotName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("applicationRestoreType", om.valueToTree(this.getApplicationRestoreType()));
                if (this.getSnapshotName() != null) {
                    data.set("snapshotName", om.valueToTree(this.getSnapshotName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationRestoreConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationRestoreConfigurationProperty.Jsii$Proxy that = (ApplicationRestoreConfigurationProperty.Jsii$Proxy) o;

                if (!applicationRestoreType.equals(that.applicationRestoreType)) return false;
                return this.snapshotName != null ? this.snapshotName.equals(that.snapshotName) : that.snapshotName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationRestoreType.hashCode();
                result = 31 * result + (this.snapshotName != null ? this.snapshotName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * ApplicationSnapshotConfigurationProperty applicationSnapshotConfigurationProperty = ApplicationSnapshotConfigurationProperty.builder()
     *         .snapshotsEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationSnapshotConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationSnapshotConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationSnapshotConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSnapshotsEnabled();

        /**
         * @return a {@link Builder} of {@link ApplicationSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationSnapshotConfigurationProperty> {
            java.lang.Object snapshotsEnabled;

            /**
             * Sets the value of {@link ApplicationSnapshotConfigurationProperty#getSnapshotsEnabled}
             * @param snapshotsEnabled Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotsEnabled(java.lang.Boolean snapshotsEnabled) {
                this.snapshotsEnabled = snapshotsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationSnapshotConfigurationProperty#getSnapshotsEnabled}
             * @param snapshotsEnabled Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotsEnabled(software.amazon.awscdk.IResolvable snapshotsEnabled) {
                this.snapshotsEnabled = snapshotsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationSnapshotConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationSnapshotConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationSnapshotConfigurationProperty {
            private final java.lang.Object snapshotsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.snapshotsEnabled = software.amazon.jsii.Kernel.get(this, "snapshotsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.snapshotsEnabled = java.util.Objects.requireNonNull(builder.snapshotsEnabled, "snapshotsEnabled is required");
            }

            @Override
            public final java.lang.Object getSnapshotsEnabled() {
                return this.snapshotsEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("snapshotsEnabled", om.valueToTree(this.getSnapshotsEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ApplicationSnapshotConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationSnapshotConfigurationProperty.Jsii$Proxy that = (ApplicationSnapshotConfigurationProperty.Jsii$Proxy) o;

                return this.snapshotsEnabled.equals(that.snapshotsEnabled);
            }

            @Override
            public final int hashCode() {
                int result = this.snapshotsEnabled.hashCode();
                return result;
            }
        }
    }
    /**
     * For a SQL-based Kinesis Data Analytics application, provides additional mapping information when the record format uses delimiters, such as CSV.
     * <p>
     * For example, the following sample records use CSV format, where the records use the <em>'\n'</em> as the row delimiter and a comma (",") as the column delimiter:
     * <p>
     * <code>"name1", "address1"</code>
     * <p>
     * <code>"name2", "address2"</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * CSVMappingParametersProperty cSVMappingParametersProperty = CSVMappingParametersProperty.builder()
     *         .recordColumnDelimiter("recordColumnDelimiter")
     *         .recordRowDelimiter("recordRowDelimiter")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CSVMappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(CSVMappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CSVMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column delimiter.
         * <p>
         * For example, in a CSV format, a comma (",") is the typical column delimiter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordColumnDelimiter();

        /**
         * The row delimiter.
         * <p>
         * For example, in a CSV format, <em>'\n'</em> is the typical row delimiter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordRowDelimiter();

        /**
         * @return a {@link Builder} of {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CSVMappingParametersProperty> {
            java.lang.String recordColumnDelimiter;
            java.lang.String recordRowDelimiter;

            /**
             * Sets the value of {@link CSVMappingParametersProperty#getRecordColumnDelimiter}
             * @param recordColumnDelimiter The column delimiter. This parameter is required.
             *                              For example, in a CSV format, a comma (",") is the typical column delimiter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumnDelimiter(java.lang.String recordColumnDelimiter) {
                this.recordColumnDelimiter = recordColumnDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link CSVMappingParametersProperty#getRecordRowDelimiter}
             * @param recordRowDelimiter The row delimiter. This parameter is required.
             *                           For example, in a CSV format, <em>'\n'</em> is the typical row delimiter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordRowDelimiter(java.lang.String recordRowDelimiter) {
                this.recordRowDelimiter = recordRowDelimiter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CSVMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CSVMappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CSVMappingParametersProperty {
            private final java.lang.String recordColumnDelimiter;
            private final java.lang.String recordRowDelimiter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordColumnDelimiter = software.amazon.jsii.Kernel.get(this, "recordColumnDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordRowDelimiter = software.amazon.jsii.Kernel.get(this, "recordRowDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordColumnDelimiter = java.util.Objects.requireNonNull(builder.recordColumnDelimiter, "recordColumnDelimiter is required");
                this.recordRowDelimiter = java.util.Objects.requireNonNull(builder.recordRowDelimiter, "recordRowDelimiter is required");
            }

            @Override
            public final java.lang.String getRecordColumnDelimiter() {
                return this.recordColumnDelimiter;
            }

            @Override
            public final java.lang.String getRecordRowDelimiter() {
                return this.recordRowDelimiter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordColumnDelimiter", om.valueToTree(this.getRecordColumnDelimiter()));
                data.set("recordRowDelimiter", om.valueToTree(this.getRecordRowDelimiter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CSVMappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CSVMappingParametersProperty.Jsii$Proxy that = (CSVMappingParametersProperty.Jsii$Proxy) o;

                if (!recordColumnDelimiter.equals(that.recordColumnDelimiter)) return false;
                return this.recordRowDelimiter.equals(that.recordRowDelimiter);
            }

            @Override
            public final int hashCode() {
                int result = this.recordColumnDelimiter.hashCode();
                result = 31 * result + (this.recordRowDelimiter.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration parameters for the default Amazon Glue database.
     * <p>
     * You use this database for SQL queries that you write in a Kinesis Data Analytics Studio notebook.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * CatalogConfigurationProperty catalogConfigurationProperty = CatalogConfigurationProperty.builder()
     *         .glueDataCatalogConfiguration(GlueDataCatalogConfigurationProperty.builder()
     *                 .databaseArn("databaseArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CatalogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CatalogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CatalogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration parameters for the default Amazon Glue database.
         * <p>
         * You use this database for Apache Flink SQL queries and table API transforms that you write in a Kinesis Data Analytics Studio notebook.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueDataCatalogConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CatalogConfigurationProperty> {
            java.lang.Object glueDataCatalogConfiguration;

            /**
             * Sets the value of {@link CatalogConfigurationProperty#getGlueDataCatalogConfiguration}
             * @param glueDataCatalogConfiguration The configuration parameters for the default Amazon Glue database.
             *                                     You use this database for Apache Flink SQL queries and table API transforms that you write in a Kinesis Data Analytics Studio notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueDataCatalogConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.GlueDataCatalogConfigurationProperty glueDataCatalogConfiguration) {
                this.glueDataCatalogConfiguration = glueDataCatalogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CatalogConfigurationProperty#getGlueDataCatalogConfiguration}
             * @param glueDataCatalogConfiguration The configuration parameters for the default Amazon Glue database.
             *                                     You use this database for Apache Flink SQL queries and table API transforms that you write in a Kinesis Data Analytics Studio notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueDataCatalogConfiguration(software.amazon.awscdk.IResolvable glueDataCatalogConfiguration) {
                this.glueDataCatalogConfiguration = glueDataCatalogConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CatalogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CatalogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CatalogConfigurationProperty {
            private final java.lang.Object glueDataCatalogConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glueDataCatalogConfiguration = software.amazon.jsii.Kernel.get(this, "glueDataCatalogConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glueDataCatalogConfiguration = builder.glueDataCatalogConfiguration;
            }

            @Override
            public final java.lang.Object getGlueDataCatalogConfiguration() {
                return this.glueDataCatalogConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGlueDataCatalogConfiguration() != null) {
                    data.set("glueDataCatalogConfiguration", om.valueToTree(this.getGlueDataCatalogConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CatalogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CatalogConfigurationProperty.Jsii$Proxy that = (CatalogConfigurationProperty.Jsii$Proxy) o;

                return this.glueDataCatalogConfiguration != null ? this.glueDataCatalogConfiguration.equals(that.glueDataCatalogConfiguration) : that.glueDataCatalogConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.glueDataCatalogConfiguration != null ? this.glueDataCatalogConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes an application's checkpointing configuration.
     * <p>
     * Checkpointing is the process of persisting application state for fault tolerance. For more information, see <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance">Checkpoints for Fault Tolerance</a> in the <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * CheckpointConfigurationProperty checkpointConfigurationProperty = CheckpointConfigurationProperty.builder()
     *         .configurationType("configurationType")
     *         // the properties below are optional
     *         .checkpointingEnabled(false)
     *         .checkpointInterval(123)
     *         .minPauseBetweenCheckpoints(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CheckpointConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CheckpointConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CheckpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior.
         * <p>
         * You must set this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code> , <code>CheckpointInterval</code> , or <code>MinPauseBetweenCheckpoints</code> parameters.
         * <p>
         * <blockquote>
         * <p>
         * If this value is set to <code>DEFAULT</code> , the application will use the following values, even if they are set to other values using APIs or application code:
         * <p>
         * <ul>
         * <li><em>CheckpointingEnabled:</em> true</li>
         * <li><em>CheckpointInterval:</em> 60000</li>
         * <li><em>MinPauseBetweenCheckpoints:</em> 5000</li>
         * </ul>
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConfigurationType();

        /**
         * Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
         * <p>
         * <blockquote>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code> , the application will use a <code>CheckpointingEnabled</code> value of <code>true</code> , even if this value is set to another value using this API or in application code.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCheckpointingEnabled() {
            return null;
        }

        /**
         * Describes the interval in milliseconds between checkpoint operations.
         * <p>
         * <blockquote>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code> , the application will use a <code>CheckpointInterval</code> value of 60000, even if this value is set to another value using this API or in application code.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCheckpointInterval() {
            return null;
        }

        /**
         * Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start.
         * <p>
         * If a checkpoint operation takes longer than the <code>CheckpointInterval</code> , the application otherwise performs continual checkpoint operations. For more information, see <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing">Tuning Checkpointing</a> in the <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a> .
         * <p>
         * <blockquote>
         * <p>
         * If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code> , the application will use a <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this API or in application code.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinPauseBetweenCheckpoints() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CheckpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CheckpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CheckpointConfigurationProperty> {
            java.lang.String configurationType;
            java.lang.Object checkpointingEnabled;
            java.lang.Number checkpointInterval;
            java.lang.Number minPauseBetweenCheckpoints;

            /**
             * Sets the value of {@link CheckpointConfigurationProperty#getConfigurationType}
             * @param configurationType Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. This parameter is required.
             *                          You must set this property to <code>CUSTOM</code> in order to set the <code>CheckpointingEnabled</code> , <code>CheckpointInterval</code> , or <code>MinPauseBetweenCheckpoints</code> parameters.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If this value is set to <code>DEFAULT</code> , the application will use the following values, even if they are set to other values using APIs or application code:
             *                          <p>
             *                          <ul>
             *                          <li><em>CheckpointingEnabled:</em> true</li>
             *                          <li><em>CheckpointInterval:</em> 60000</li>
             *                          <li><em>MinPauseBetweenCheckpoints:</em> 5000</li>
             *                          </ul>
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationType(java.lang.String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            /**
             * Sets the value of {@link CheckpointConfigurationProperty#getCheckpointingEnabled}
             * @param checkpointingEnabled Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
             *                             <blockquote>
             *                             <p>
             *                             If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code> , the application will use a <code>CheckpointingEnabled</code> value of <code>true</code> , even if this value is set to another value using this API or in application code.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder checkpointingEnabled(java.lang.Boolean checkpointingEnabled) {
                this.checkpointingEnabled = checkpointingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link CheckpointConfigurationProperty#getCheckpointingEnabled}
             * @param checkpointingEnabled Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
             *                             <blockquote>
             *                             <p>
             *                             If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code> , the application will use a <code>CheckpointingEnabled</code> value of <code>true</code> , even if this value is set to another value using this API or in application code.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder checkpointingEnabled(software.amazon.awscdk.IResolvable checkpointingEnabled) {
                this.checkpointingEnabled = checkpointingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link CheckpointConfigurationProperty#getCheckpointInterval}
             * @param checkpointInterval Describes the interval in milliseconds between checkpoint operations.
             *                           <blockquote>
             *                           <p>
             *                           If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code> , the application will use a <code>CheckpointInterval</code> value of 60000, even if this value is set to another value using this API or in application code.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder checkpointInterval(java.lang.Number checkpointInterval) {
                this.checkpointInterval = checkpointInterval;
                return this;
            }

            /**
             * Sets the value of {@link CheckpointConfigurationProperty#getMinPauseBetweenCheckpoints}
             * @param minPauseBetweenCheckpoints Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start.
             *                                   If a checkpoint operation takes longer than the <code>CheckpointInterval</code> , the application otherwise performs continual checkpoint operations. For more information, see <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing">Tuning Checkpointing</a> in the <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a> .
             *                                   <p>
             *                                   <blockquote>
             *                                   <p>
             *                                   If <code>CheckpointConfiguration.ConfigurationType</code> is <code>DEFAULT</code> , the application will use a <code>MinPauseBetweenCheckpoints</code> value of 5000, even if this value is set using this API or in application code.
             *                                   <p>
             *                                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minPauseBetweenCheckpoints(java.lang.Number minPauseBetweenCheckpoints) {
                this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CheckpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CheckpointConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CheckpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CheckpointConfigurationProperty {
            private final java.lang.String configurationType;
            private final java.lang.Object checkpointingEnabled;
            private final java.lang.Number checkpointInterval;
            private final java.lang.Number minPauseBetweenCheckpoints;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationType = software.amazon.jsii.Kernel.get(this, "configurationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.checkpointingEnabled = software.amazon.jsii.Kernel.get(this, "checkpointingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.checkpointInterval = software.amazon.jsii.Kernel.get(this, "checkpointInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minPauseBetweenCheckpoints = software.amazon.jsii.Kernel.get(this, "minPauseBetweenCheckpoints", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationType = java.util.Objects.requireNonNull(builder.configurationType, "configurationType is required");
                this.checkpointingEnabled = builder.checkpointingEnabled;
                this.checkpointInterval = builder.checkpointInterval;
                this.minPauseBetweenCheckpoints = builder.minPauseBetweenCheckpoints;
            }

            @Override
            public final java.lang.String getConfigurationType() {
                return this.configurationType;
            }

            @Override
            public final java.lang.Object getCheckpointingEnabled() {
                return this.checkpointingEnabled;
            }

            @Override
            public final java.lang.Number getCheckpointInterval() {
                return this.checkpointInterval;
            }

            @Override
            public final java.lang.Number getMinPauseBetweenCheckpoints() {
                return this.minPauseBetweenCheckpoints;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("configurationType", om.valueToTree(this.getConfigurationType()));
                if (this.getCheckpointingEnabled() != null) {
                    data.set("checkpointingEnabled", om.valueToTree(this.getCheckpointingEnabled()));
                }
                if (this.getCheckpointInterval() != null) {
                    data.set("checkpointInterval", om.valueToTree(this.getCheckpointInterval()));
                }
                if (this.getMinPauseBetweenCheckpoints() != null) {
                    data.set("minPauseBetweenCheckpoints", om.valueToTree(this.getMinPauseBetweenCheckpoints()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CheckpointConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CheckpointConfigurationProperty.Jsii$Proxy that = (CheckpointConfigurationProperty.Jsii$Proxy) o;

                if (!configurationType.equals(that.configurationType)) return false;
                if (this.checkpointingEnabled != null ? !this.checkpointingEnabled.equals(that.checkpointingEnabled) : that.checkpointingEnabled != null) return false;
                if (this.checkpointInterval != null ? !this.checkpointInterval.equals(that.checkpointInterval) : that.checkpointInterval != null) return false;
                return this.minPauseBetweenCheckpoints != null ? this.minPauseBetweenCheckpoints.equals(that.minPauseBetweenCheckpoints) : that.minPauseBetweenCheckpoints == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationType.hashCode();
                result = 31 * result + (this.checkpointingEnabled != null ? this.checkpointingEnabled.hashCode() : 0);
                result = 31 * result + (this.checkpointInterval != null ? this.checkpointInterval.hashCode() : 0);
                result = 31 * result + (this.minPauseBetweenCheckpoints != null ? this.minPauseBetweenCheckpoints.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies either the application code, or the location of the application code, for a Flink-based Kinesis Data Analytics application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * CodeContentProperty codeContentProperty = CodeContentProperty.builder()
     *         .s3ContentLocation(S3ContentLocationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .fileKey("fileKey")
     *                 // the properties below are optional
     *                 .objectVersion("objectVersion")
     *                 .build())
     *         .textContent("textContent")
     *         .zipFileContent("zipFileContent")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CodeContentProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeContentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeContentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the Amazon S3 bucket that contains the application code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3ContentLocation() {
            return null;
        }

        /**
         * The text-format code for a Flink-based Kinesis Data Analytics application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextContent() {
            return null;
        }

        /**
         * The zip-format code for a Flink-based Kinesis Data Analytics application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getZipFileContent() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeContentProperty> {
            java.lang.Object s3ContentLocation;
            java.lang.String textContent;
            java.lang.String zipFileContent;

            /**
             * Sets the value of {@link CodeContentProperty#getS3ContentLocation}
             * @param s3ContentLocation Information about the Amazon S3 bucket that contains the application code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ContentLocation(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.S3ContentLocationProperty s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            /**
             * Sets the value of {@link CodeContentProperty#getS3ContentLocation}
             * @param s3ContentLocation Information about the Amazon S3 bucket that contains the application code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ContentLocation(software.amazon.awscdk.IResolvable s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            /**
             * Sets the value of {@link CodeContentProperty#getTextContent}
             * @param textContent The text-format code for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textContent(java.lang.String textContent) {
                this.textContent = textContent;
                return this;
            }

            /**
             * Sets the value of {@link CodeContentProperty#getZipFileContent}
             * @param zipFileContent The zip-format code for a Flink-based Kinesis Data Analytics application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zipFileContent(java.lang.String zipFileContent) {
                this.zipFileContent = zipFileContent;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeContentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeContentProperty {
            private final java.lang.Object s3ContentLocation;
            private final java.lang.String textContent;
            private final java.lang.String zipFileContent;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3ContentLocation = software.amazon.jsii.Kernel.get(this, "s3ContentLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textContent = software.amazon.jsii.Kernel.get(this, "textContent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.zipFileContent = software.amazon.jsii.Kernel.get(this, "zipFileContent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3ContentLocation = builder.s3ContentLocation;
                this.textContent = builder.textContent;
                this.zipFileContent = builder.zipFileContent;
            }

            @Override
            public final java.lang.Object getS3ContentLocation() {
                return this.s3ContentLocation;
            }

            @Override
            public final java.lang.String getTextContent() {
                return this.textContent;
            }

            @Override
            public final java.lang.String getZipFileContent() {
                return this.zipFileContent;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3ContentLocation() != null) {
                    data.set("s3ContentLocation", om.valueToTree(this.getS3ContentLocation()));
                }
                if (this.getTextContent() != null) {
                    data.set("textContent", om.valueToTree(this.getTextContent()));
                }
                if (this.getZipFileContent() != null) {
                    data.set("zipFileContent", om.valueToTree(this.getZipFileContent()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CodeContentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeContentProperty.Jsii$Proxy that = (CodeContentProperty.Jsii$Proxy) o;

                if (this.s3ContentLocation != null ? !this.s3ContentLocation.equals(that.s3ContentLocation) : that.s3ContentLocation != null) return false;
                if (this.textContent != null ? !this.textContent.equals(that.textContent) : that.textContent != null) return false;
                return this.zipFileContent != null ? this.zipFileContent.equals(that.zipFileContent) : that.zipFileContent == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3ContentLocation != null ? this.s3ContentLocation.hashCode() : 0;
                result = 31 * result + (this.textContent != null ? this.textContent.hashCode() : 0);
                result = 31 * result + (this.zipFileContent != null ? this.zipFileContent.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of connectors and user-defined functions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * CustomArtifactConfigurationProperty customArtifactConfigurationProperty = CustomArtifactConfigurationProperty.builder()
     *         .artifactType("artifactType")
     *         // the properties below are optional
     *         .mavenReference(MavenReferenceProperty.builder()
     *                 .artifactId("artifactId")
     *                 .groupId("groupId")
     *                 .version("version")
     *                 .build())
     *         .s3ContentLocation(S3ContentLocationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .fileKey("fileKey")
     *                 // the properties below are optional
     *                 .objectVersion("objectVersion")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CustomArtifactConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomArtifactConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomArtifactConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set this to either `UDF` or `DEPENDENCY_JAR` .
         * <p>
         * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArtifactType();

        /**
         * The parameters required to fully specify a Maven reference.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMavenReference() {
            return null;
        }

        /**
         * The location of the custom artifacts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3ContentLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomArtifactConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomArtifactConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomArtifactConfigurationProperty> {
            java.lang.String artifactType;
            java.lang.Object mavenReference;
            java.lang.Object s3ContentLocation;

            /**
             * Sets the value of {@link CustomArtifactConfigurationProperty#getArtifactType}
             * @param artifactType Set this to either `UDF` or `DEPENDENCY_JAR` . This parameter is required.
             *                     <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactType(java.lang.String artifactType) {
                this.artifactType = artifactType;
                return this;
            }

            /**
             * Sets the value of {@link CustomArtifactConfigurationProperty#getMavenReference}
             * @param mavenReference The parameters required to fully specify a Maven reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mavenReference(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.MavenReferenceProperty mavenReference) {
                this.mavenReference = mavenReference;
                return this;
            }

            /**
             * Sets the value of {@link CustomArtifactConfigurationProperty#getMavenReference}
             * @param mavenReference The parameters required to fully specify a Maven reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mavenReference(software.amazon.awscdk.IResolvable mavenReference) {
                this.mavenReference = mavenReference;
                return this;
            }

            /**
             * Sets the value of {@link CustomArtifactConfigurationProperty#getS3ContentLocation}
             * @param s3ContentLocation The location of the custom artifacts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ContentLocation(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.S3ContentLocationProperty s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            /**
             * Sets the value of {@link CustomArtifactConfigurationProperty#getS3ContentLocation}
             * @param s3ContentLocation The location of the custom artifacts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ContentLocation(software.amazon.awscdk.IResolvable s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomArtifactConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomArtifactConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomArtifactConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomArtifactConfigurationProperty {
            private final java.lang.String artifactType;
            private final java.lang.Object mavenReference;
            private final java.lang.Object s3ContentLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.artifactType = software.amazon.jsii.Kernel.get(this, "artifactType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mavenReference = software.amazon.jsii.Kernel.get(this, "mavenReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3ContentLocation = software.amazon.jsii.Kernel.get(this, "s3ContentLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.artifactType = java.util.Objects.requireNonNull(builder.artifactType, "artifactType is required");
                this.mavenReference = builder.mavenReference;
                this.s3ContentLocation = builder.s3ContentLocation;
            }

            @Override
            public final java.lang.String getArtifactType() {
                return this.artifactType;
            }

            @Override
            public final java.lang.Object getMavenReference() {
                return this.mavenReference;
            }

            @Override
            public final java.lang.Object getS3ContentLocation() {
                return this.s3ContentLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("artifactType", om.valueToTree(this.getArtifactType()));
                if (this.getMavenReference() != null) {
                    data.set("mavenReference", om.valueToTree(this.getMavenReference()));
                }
                if (this.getS3ContentLocation() != null) {
                    data.set("s3ContentLocation", om.valueToTree(this.getS3ContentLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.CustomArtifactConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomArtifactConfigurationProperty.Jsii$Proxy that = (CustomArtifactConfigurationProperty.Jsii$Proxy) o;

                if (!artifactType.equals(that.artifactType)) return false;
                if (this.mavenReference != null ? !this.mavenReference.equals(that.mavenReference) : that.mavenReference != null) return false;
                return this.s3ContentLocation != null ? this.s3ContentLocation.equals(that.s3ContentLocation) : that.s3ContentLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.artifactType.hashCode();
                result = 31 * result + (this.mavenReference != null ? this.mavenReference.hashCode() : 0);
                result = 31 * result + (this.s3ContentLocation != null ? this.s3ContentLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * DeployAsApplicationConfigurationProperty deployAsApplicationConfigurationProperty = DeployAsApplicationConfigurationProperty.builder()
     *         .s3ContentLocation(S3ContentBaseLocationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 // the properties below are optional
     *                 .basePath("basePath")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.DeployAsApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeployAsApplicationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeployAsApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the version number of the Amazon S3 object that contains the data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3ContentLocation();

        /**
         * @return a {@link Builder} of {@link DeployAsApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeployAsApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeployAsApplicationConfigurationProperty> {
            java.lang.Object s3ContentLocation;

            /**
             * Sets the value of {@link DeployAsApplicationConfigurationProperty#getS3ContentLocation}
             * @param s3ContentLocation The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the version number of the Amazon S3 object that contains the data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ContentLocation(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.S3ContentBaseLocationProperty s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            /**
             * Sets the value of {@link DeployAsApplicationConfigurationProperty#getS3ContentLocation}
             * @param s3ContentLocation The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the version number of the Amazon S3 object that contains the data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ContentLocation(software.amazon.awscdk.IResolvable s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeployAsApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeployAsApplicationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeployAsApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeployAsApplicationConfigurationProperty {
            private final java.lang.Object s3ContentLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3ContentLocation = software.amazon.jsii.Kernel.get(this, "s3ContentLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3ContentLocation = java.util.Objects.requireNonNull(builder.s3ContentLocation, "s3ContentLocation is required");
            }

            @Override
            public final java.lang.Object getS3ContentLocation() {
                return this.s3ContentLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3ContentLocation", om.valueToTree(this.getS3ContentLocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.DeployAsApplicationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeployAsApplicationConfigurationProperty.Jsii$Proxy that = (DeployAsApplicationConfigurationProperty.Jsii$Proxy) o;

                return this.s3ContentLocation.equals(that.s3ContentLocation);
            }

            @Override
            public final int hashCode() {
                int result = this.s3ContentLocation.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes execution properties for a Flink-based Kinesis Data Analytics application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * EnvironmentPropertiesProperty environmentPropertiesProperty = EnvironmentPropertiesProperty.builder()
     *         .propertyGroups(List.of(PropertyGroupProperty.builder()
     *                 .propertyGroupId("propertyGroupId")
     *                 .propertyMap(Map.of(
     *                         "propertyMapKey", "propertyMap"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.EnvironmentPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the execution property groups.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentPropertiesProperty> {
            java.lang.Object propertyGroups;

            /**
             * Sets the value of {@link EnvironmentPropertiesProperty#getPropertyGroups}
             * @param propertyGroups Describes the execution property groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyGroups(software.amazon.awscdk.IResolvable propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentPropertiesProperty#getPropertyGroups}
             * @param propertyGroups Describes the execution property groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyGroups(java.util.List<? extends java.lang.Object> propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentPropertiesProperty {
            private final java.lang.Object propertyGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.propertyGroups = software.amazon.jsii.Kernel.get(this, "propertyGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propertyGroups = builder.propertyGroups;
            }

            @Override
            public final java.lang.Object getPropertyGroups() {
                return this.propertyGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPropertyGroups() != null) {
                    data.set("propertyGroups", om.valueToTree(this.getPropertyGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.EnvironmentPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentPropertiesProperty.Jsii$Proxy that = (EnvironmentPropertiesProperty.Jsii$Proxy) o;

                return this.propertyGroups != null ? this.propertyGroups.equals(that.propertyGroups) : that.propertyGroups == null;
            }

            @Override
            public final int hashCode() {
                int result = this.propertyGroups != null ? this.propertyGroups.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes configuration parameters for a Flink-based Kinesis Data Analytics application or a Studio notebook.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * FlinkApplicationConfigurationProperty flinkApplicationConfigurationProperty = FlinkApplicationConfigurationProperty.builder()
     *         .checkpointConfiguration(CheckpointConfigurationProperty.builder()
     *                 .configurationType("configurationType")
     *                 // the properties below are optional
     *                 .checkpointingEnabled(false)
     *                 .checkpointInterval(123)
     *                 .minPauseBetweenCheckpoints(123)
     *                 .build())
     *         .monitoringConfiguration(MonitoringConfigurationProperty.builder()
     *                 .configurationType("configurationType")
     *                 // the properties below are optional
     *                 .logLevel("logLevel")
     *                 .metricsLevel("metricsLevel")
     *                 .build())
     *         .parallelismConfiguration(ParallelismConfigurationProperty.builder()
     *                 .configurationType("configurationType")
     *                 // the properties below are optional
     *                 .autoScalingEnabled(false)
     *                 .parallelism(123)
     *                 .parallelismPerKpu(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.FlinkApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlinkApplicationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlinkApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes an application's checkpointing configuration.
         * <p>
         * Checkpointing is the process of persisting application state for fault tolerance. For more information, see <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance">Checkpoints for Fault Tolerance</a> in the <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCheckpointConfiguration() {
            return null;
        }

        /**
         * Describes configuration parameters for Amazon CloudWatch logging for an application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoringConfiguration() {
            return null;
        }

        /**
         * Describes parameters for how an application executes multiple tasks simultaneously.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParallelismConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlinkApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlinkApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlinkApplicationConfigurationProperty> {
            java.lang.Object checkpointConfiguration;
            java.lang.Object monitoringConfiguration;
            java.lang.Object parallelismConfiguration;

            /**
             * Sets the value of {@link FlinkApplicationConfigurationProperty#getCheckpointConfiguration}
             * @param checkpointConfiguration Describes an application's checkpointing configuration.
             *                                Checkpointing is the process of persisting application state for fault tolerance. For more information, see <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance">Checkpoints for Fault Tolerance</a> in the <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder checkpointConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.CheckpointConfigurationProperty checkpointConfiguration) {
                this.checkpointConfiguration = checkpointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlinkApplicationConfigurationProperty#getCheckpointConfiguration}
             * @param checkpointConfiguration Describes an application's checkpointing configuration.
             *                                Checkpointing is the process of persisting application state for fault tolerance. For more information, see <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance">Checkpoints for Fault Tolerance</a> in the <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder checkpointConfiguration(software.amazon.awscdk.IResolvable checkpointConfiguration) {
                this.checkpointConfiguration = checkpointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlinkApplicationConfigurationProperty#getMonitoringConfiguration}
             * @param monitoringConfiguration Describes configuration parameters for Amazon CloudWatch logging for an application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.MonitoringConfigurationProperty monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlinkApplicationConfigurationProperty#getMonitoringConfiguration}
             * @param monitoringConfiguration Describes configuration parameters for Amazon CloudWatch logging for an application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringConfiguration(software.amazon.awscdk.IResolvable monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlinkApplicationConfigurationProperty#getParallelismConfiguration}
             * @param parallelismConfiguration Describes parameters for how an application executes multiple tasks simultaneously.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelismConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ParallelismConfigurationProperty parallelismConfiguration) {
                this.parallelismConfiguration = parallelismConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlinkApplicationConfigurationProperty#getParallelismConfiguration}
             * @param parallelismConfiguration Describes parameters for how an application executes multiple tasks simultaneously.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelismConfiguration(software.amazon.awscdk.IResolvable parallelismConfiguration) {
                this.parallelismConfiguration = parallelismConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlinkApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlinkApplicationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlinkApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlinkApplicationConfigurationProperty {
            private final java.lang.Object checkpointConfiguration;
            private final java.lang.Object monitoringConfiguration;
            private final java.lang.Object parallelismConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.checkpointConfiguration = software.amazon.jsii.Kernel.get(this, "checkpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringConfiguration = software.amazon.jsii.Kernel.get(this, "monitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parallelismConfiguration = software.amazon.jsii.Kernel.get(this, "parallelismConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.checkpointConfiguration = builder.checkpointConfiguration;
                this.monitoringConfiguration = builder.monitoringConfiguration;
                this.parallelismConfiguration = builder.parallelismConfiguration;
            }

            @Override
            public final java.lang.Object getCheckpointConfiguration() {
                return this.checkpointConfiguration;
            }

            @Override
            public final java.lang.Object getMonitoringConfiguration() {
                return this.monitoringConfiguration;
            }

            @Override
            public final java.lang.Object getParallelismConfiguration() {
                return this.parallelismConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCheckpointConfiguration() != null) {
                    data.set("checkpointConfiguration", om.valueToTree(this.getCheckpointConfiguration()));
                }
                if (this.getMonitoringConfiguration() != null) {
                    data.set("monitoringConfiguration", om.valueToTree(this.getMonitoringConfiguration()));
                }
                if (this.getParallelismConfiguration() != null) {
                    data.set("parallelismConfiguration", om.valueToTree(this.getParallelismConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.FlinkApplicationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlinkApplicationConfigurationProperty.Jsii$Proxy that = (FlinkApplicationConfigurationProperty.Jsii$Proxy) o;

                if (this.checkpointConfiguration != null ? !this.checkpointConfiguration.equals(that.checkpointConfiguration) : that.checkpointConfiguration != null) return false;
                if (this.monitoringConfiguration != null ? !this.monitoringConfiguration.equals(that.monitoringConfiguration) : that.monitoringConfiguration != null) return false;
                return this.parallelismConfiguration != null ? this.parallelismConfiguration.equals(that.parallelismConfiguration) : that.parallelismConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.checkpointConfiguration != null ? this.checkpointConfiguration.hashCode() : 0;
                result = 31 * result + (this.monitoringConfiguration != null ? this.monitoringConfiguration.hashCode() : 0);
                result = 31 * result + (this.parallelismConfiguration != null ? this.parallelismConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * FlinkRunConfigurationProperty flinkRunConfigurationProperty = FlinkRunConfigurationProperty.builder()
     *         .allowNonRestoredState(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.FlinkRunConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlinkRunConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlinkRunConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplication.FlinkRunConfigurationProperty.AllowNonRestoredState`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowNonRestoredState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlinkRunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlinkRunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlinkRunConfigurationProperty> {
            java.lang.Object allowNonRestoredState;

            /**
             * Sets the value of {@link FlinkRunConfigurationProperty#getAllowNonRestoredState}
             * @param allowNonRestoredState `CfnApplication.FlinkRunConfigurationProperty.AllowNonRestoredState`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowNonRestoredState(java.lang.Boolean allowNonRestoredState) {
                this.allowNonRestoredState = allowNonRestoredState;
                return this;
            }

            /**
             * Sets the value of {@link FlinkRunConfigurationProperty#getAllowNonRestoredState}
             * @param allowNonRestoredState `CfnApplication.FlinkRunConfigurationProperty.AllowNonRestoredState`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowNonRestoredState(software.amazon.awscdk.IResolvable allowNonRestoredState) {
                this.allowNonRestoredState = allowNonRestoredState;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlinkRunConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlinkRunConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlinkRunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlinkRunConfigurationProperty {
            private final java.lang.Object allowNonRestoredState;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowNonRestoredState = software.amazon.jsii.Kernel.get(this, "allowNonRestoredState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowNonRestoredState = builder.allowNonRestoredState;
            }

            @Override
            public final java.lang.Object getAllowNonRestoredState() {
                return this.allowNonRestoredState;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowNonRestoredState() != null) {
                    data.set("allowNonRestoredState", om.valueToTree(this.getAllowNonRestoredState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.FlinkRunConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlinkRunConfigurationProperty.Jsii$Proxy that = (FlinkRunConfigurationProperty.Jsii$Proxy) o;

                return this.allowNonRestoredState != null ? this.allowNonRestoredState.equals(that.allowNonRestoredState) : that.allowNonRestoredState == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowNonRestoredState != null ? this.allowNonRestoredState.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration of the Glue Data Catalog that you use for Apache Flink SQL queries and table API transforms that you write in an application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * GlueDataCatalogConfigurationProperty glueDataCatalogConfigurationProperty = GlueDataCatalogConfigurationProperty.builder()
     *         .databaseArn("databaseArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.GlueDataCatalogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GlueDataCatalogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlueDataCatalogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the database.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlueDataCatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlueDataCatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlueDataCatalogConfigurationProperty> {
            java.lang.String databaseArn;

            /**
             * Sets the value of {@link GlueDataCatalogConfigurationProperty#getDatabaseArn}
             * @param databaseArn The Amazon Resource Name (ARN) of the database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseArn(java.lang.String databaseArn) {
                this.databaseArn = databaseArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlueDataCatalogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlueDataCatalogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlueDataCatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueDataCatalogConfigurationProperty {
            private final java.lang.String databaseArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseArn = software.amazon.jsii.Kernel.get(this, "databaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseArn = builder.databaseArn;
            }

            @Override
            public final java.lang.String getDatabaseArn() {
                return this.databaseArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatabaseArn() != null) {
                    data.set("databaseArn", om.valueToTree(this.getDatabaseArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.GlueDataCatalogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlueDataCatalogConfigurationProperty.Jsii$Proxy that = (GlueDataCatalogConfigurationProperty.Jsii$Proxy) o;

                return this.databaseArn != null ? this.databaseArn.equals(that.databaseArn) : that.databaseArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseArn != null ? this.databaseArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that contains the Amazon Resource Name (ARN) of the Amazon Lambda function that is used to preprocess records in the stream in a SQL-based Kinesis Data Analytics application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * InputLambdaProcessorProperty inputLambdaProcessorProperty = InputLambdaProcessorProperty.builder()
     *         .resourceArn("resourceArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputLambdaProcessorProperty")
    @software.amazon.jsii.Jsii.Proxy(InputLambdaProcessorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputLambdaProcessorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon Lambda function that operates on records in the stream.
         * <p>
         * <blockquote>
         * <p>
         * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: Amazon Lambda</a>
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputLambdaProcessorProperty> {
            java.lang.String resourceArn;

            /**
             * Sets the value of {@link InputLambdaProcessorProperty#getResourceArn}
             * @param resourceArn The ARN of the Amazon Lambda function that operates on records in the stream. This parameter is required.
             *                    <blockquote>
             *                    <p>
             *                    To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: Amazon Lambda</a>
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputLambdaProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputLambdaProcessorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputLambdaProcessorProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputLambdaProcessorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputLambdaProcessorProperty.Jsii$Proxy that = (InputLambdaProcessorProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * For a SQL-based Kinesis Data Analytics application, describes the number of in-application streams to create for a given streaming source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * InputParallelismProperty inputParallelismProperty = InputParallelismProperty.builder()
     *         .count(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputParallelismProperty")
    @software.amazon.jsii.Jsii.Proxy(InputParallelismProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputParallelismProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of in-application streams to create.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputParallelismProperty> {
            java.lang.Number count;

            /**
             * Sets the value of {@link InputParallelismProperty#getCount}
             * @param count The number of in-application streams to create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputParallelismProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputParallelismProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputParallelismProperty {
            private final java.lang.Number count;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputParallelismProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputParallelismProperty.Jsii$Proxy that = (InputParallelismProperty.Jsii$Proxy) o;

                return this.count != null ? this.count.equals(that.count) : that.count == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * For an SQL-based Amazon Kinesis Data Analytics application, describes a processor that is used to preprocess the records in the stream before being processed by your application code.
     * <p>
     * Currently, the only input processor available is <a href="https://docs.aws.amazon.com/lambda/">Amazon Lambda</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * InputProcessingConfigurationProperty inputProcessingConfigurationProperty = InputProcessingConfigurationProperty.builder()
     *         .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
     *                 .resourceArn("resourceArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputProcessingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InputProcessingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputLambdaProcessor.html) that is used to preprocess the records in the stream before being processed by your application code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputLambdaProcessor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputProcessingConfigurationProperty> {
            java.lang.Object inputLambdaProcessor;

            /**
             * Sets the value of {@link InputProcessingConfigurationProperty#getInputLambdaProcessor}
             * @param inputLambdaProcessor The [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputLambdaProcessor.html) that is used to preprocess the records in the stream before being processed by your application code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputLambdaProcessor(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.InputLambdaProcessorProperty inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            /**
             * Sets the value of {@link InputProcessingConfigurationProperty#getInputLambdaProcessor}
             * @param inputLambdaProcessor The [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputLambdaProcessor.html) that is used to preprocess the records in the stream before being processed by your application code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputLambdaProcessor(software.amazon.awscdk.IResolvable inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputProcessingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProcessingConfigurationProperty {
            private final java.lang.Object inputLambdaProcessor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputLambdaProcessor = software.amazon.jsii.Kernel.get(this, "inputLambdaProcessor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputLambdaProcessor = builder.inputLambdaProcessor;
            }

            @Override
            public final java.lang.Object getInputLambdaProcessor() {
                return this.inputLambdaProcessor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInputLambdaProcessor() != null) {
                    data.set("inputLambdaProcessor", om.valueToTree(this.getInputLambdaProcessor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputProcessingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputProcessingConfigurationProperty.Jsii$Proxy that = (InputProcessingConfigurationProperty.Jsii$Proxy) o;

                return this.inputLambdaProcessor != null ? this.inputLambdaProcessor.equals(that.inputLambdaProcessor) : that.inputLambdaProcessor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputLambdaProcessor != null ? this.inputLambdaProcessor.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * When you configure the application input for a SQL-based Kinesis Data Analytics application, you specify the streaming source, the in-application stream name that is created, and the mapping between the two.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * InputProperty inputProperty = InputProperty.builder()
     *         .inputSchema(InputSchemaProperty.builder()
     *                 .recordColumns(List.of(RecordColumnProperty.builder()
     *                         .name("name")
     *                         .sqlType("sqlType")
     *                         // the properties below are optional
     *                         .mapping("mapping")
     *                         .build()))
     *                 .recordFormat(RecordFormatProperty.builder()
     *                         .recordFormatType("recordFormatType")
     *                         // the properties below are optional
     *                         .mappingParameters(MappingParametersProperty.builder()
     *                                 .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                                         .recordColumnDelimiter("recordColumnDelimiter")
     *                                         .recordRowDelimiter("recordRowDelimiter")
     *                                         .build())
     *                                 .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                                         .recordRowPath("recordRowPath")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .recordEncoding("recordEncoding")
     *                 .build())
     *         .namePrefix("namePrefix")
     *         // the properties below are optional
     *         .inputParallelism(InputParallelismProperty.builder()
     *                 .count(123)
     *                 .build())
     *         .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
     *                 .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
     *                         .resourceArn("resourceArn")
     *                         .build())
     *                 .build())
     *         .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
     *                 .resourceArn("resourceArn")
     *                 .build())
     *         .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
     *                 .resourceArn("resourceArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputProperty")
    @software.amazon.jsii.Jsii.Proxy(InputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
         * <p>
         * Also used to describe the format of the reference data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInputSchema();

        /**
         * The name prefix to use when creating an in-application stream.
         * <p>
         * Suppose that you specify a prefix " <code>MyInApplicationStream</code> ." Kinesis Data Analytics then creates one or more (as per the <code>InputParallelism</code> count you specified) in-application streams with the names " <code>MyInApplicationStream_001</code> ," " <code>MyInApplicationStream_002</code> ," and so on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamePrefix();

        /**
         * Describes the number of in-application streams to create.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputParallelism() {
            return null;
        }

        /**
         * The [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputProcessingConfiguration.html) for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputLambdaProcessor.html) .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputProcessingConfiguration() {
            return null;
        }

        /**
         * If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseInput() {
            return null;
        }

        /**
         * If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamsInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputProperty> {
            java.lang.Object inputSchema;
            java.lang.String namePrefix;
            java.lang.Object inputParallelism;
            java.lang.Object inputProcessingConfiguration;
            java.lang.Object kinesisFirehoseInput;
            java.lang.Object kinesisStreamsInput;

            /**
             * Sets the value of {@link InputProperty#getInputSchema}
             * @param inputSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created. This parameter is required.
             *                    Also used to describe the format of the reference data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSchema(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.InputSchemaProperty inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputSchema}
             * @param inputSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created. This parameter is required.
             *                    Also used to describe the format of the reference data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSchema(software.amazon.awscdk.IResolvable inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getNamePrefix}
             * @param namePrefix The name prefix to use when creating an in-application stream. This parameter is required.
             *                   Suppose that you specify a prefix " <code>MyInApplicationStream</code> ." Kinesis Data Analytics then creates one or more (as per the <code>InputParallelism</code> count you specified) in-application streams with the names " <code>MyInApplicationStream_001</code> ," " <code>MyInApplicationStream_002</code> ," and so on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namePrefix(java.lang.String namePrefix) {
                this.namePrefix = namePrefix;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputParallelism}
             * @param inputParallelism Describes the number of in-application streams to create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParallelism(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.InputParallelismProperty inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputParallelism}
             * @param inputParallelism Describes the number of in-application streams to create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParallelism(software.amazon.awscdk.IResolvable inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputProcessingConfiguration}
             * @param inputProcessingConfiguration The [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputProcessingConfiguration.html) for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputLambdaProcessor.html) .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputProcessingConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.InputProcessingConfigurationProperty inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputProcessingConfiguration}
             * @param inputProcessingConfiguration The [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputProcessingConfiguration.html) for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_InputLambdaProcessor.html) .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputProcessingConfiguration(software.amazon.awscdk.IResolvable inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getKinesisFirehoseInput}
             * @param kinesisFirehoseInput If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseInput(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.KinesisFirehoseInputProperty kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getKinesisFirehoseInput}
             * @param kinesisFirehoseInput If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseInput(software.amazon.awscdk.IResolvable kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getKinesisStreamsInput}
             * @param kinesisStreamsInput If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamsInput(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.KinesisStreamsInputProperty kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getKinesisStreamsInput}
             * @param kinesisStreamsInput If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamsInput(software.amazon.awscdk.IResolvable kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProperty {
            private final java.lang.Object inputSchema;
            private final java.lang.String namePrefix;
            private final java.lang.Object inputParallelism;
            private final java.lang.Object inputProcessingConfiguration;
            private final java.lang.Object kinesisFirehoseInput;
            private final java.lang.Object kinesisStreamsInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputSchema = software.amazon.jsii.Kernel.get(this, "inputSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namePrefix = software.amazon.jsii.Kernel.get(this, "namePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputParallelism = software.amazon.jsii.Kernel.get(this, "inputParallelism", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputProcessingConfiguration = software.amazon.jsii.Kernel.get(this, "inputProcessingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisFirehoseInput = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisStreamsInput = software.amazon.jsii.Kernel.get(this, "kinesisStreamsInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputSchema = java.util.Objects.requireNonNull(builder.inputSchema, "inputSchema is required");
                this.namePrefix = java.util.Objects.requireNonNull(builder.namePrefix, "namePrefix is required");
                this.inputParallelism = builder.inputParallelism;
                this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
                this.kinesisFirehoseInput = builder.kinesisFirehoseInput;
                this.kinesisStreamsInput = builder.kinesisStreamsInput;
            }

            @Override
            public final java.lang.Object getInputSchema() {
                return this.inputSchema;
            }

            @Override
            public final java.lang.String getNamePrefix() {
                return this.namePrefix;
            }

            @Override
            public final java.lang.Object getInputParallelism() {
                return this.inputParallelism;
            }

            @Override
            public final java.lang.Object getInputProcessingConfiguration() {
                return this.inputProcessingConfiguration;
            }

            @Override
            public final java.lang.Object getKinesisFirehoseInput() {
                return this.kinesisFirehoseInput;
            }

            @Override
            public final java.lang.Object getKinesisStreamsInput() {
                return this.kinesisStreamsInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputSchema", om.valueToTree(this.getInputSchema()));
                data.set("namePrefix", om.valueToTree(this.getNamePrefix()));
                if (this.getInputParallelism() != null) {
                    data.set("inputParallelism", om.valueToTree(this.getInputParallelism()));
                }
                if (this.getInputProcessingConfiguration() != null) {
                    data.set("inputProcessingConfiguration", om.valueToTree(this.getInputProcessingConfiguration()));
                }
                if (this.getKinesisFirehoseInput() != null) {
                    data.set("kinesisFirehoseInput", om.valueToTree(this.getKinesisFirehoseInput()));
                }
                if (this.getKinesisStreamsInput() != null) {
                    data.set("kinesisStreamsInput", om.valueToTree(this.getKinesisStreamsInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputProperty.Jsii$Proxy that = (InputProperty.Jsii$Proxy) o;

                if (!inputSchema.equals(that.inputSchema)) return false;
                if (!namePrefix.equals(that.namePrefix)) return false;
                if (this.inputParallelism != null ? !this.inputParallelism.equals(that.inputParallelism) : that.inputParallelism != null) return false;
                if (this.inputProcessingConfiguration != null ? !this.inputProcessingConfiguration.equals(that.inputProcessingConfiguration) : that.inputProcessingConfiguration != null) return false;
                if (this.kinesisFirehoseInput != null ? !this.kinesisFirehoseInput.equals(that.kinesisFirehoseInput) : that.kinesisFirehoseInput != null) return false;
                return this.kinesisStreamsInput != null ? this.kinesisStreamsInput.equals(that.kinesisStreamsInput) : that.kinesisStreamsInput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputSchema.hashCode();
                result = 31 * result + (this.namePrefix.hashCode());
                result = 31 * result + (this.inputParallelism != null ? this.inputParallelism.hashCode() : 0);
                result = 31 * result + (this.inputProcessingConfiguration != null ? this.inputProcessingConfiguration.hashCode() : 0);
                result = 31 * result + (this.kinesisFirehoseInput != null ? this.kinesisFirehoseInput.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamsInput != null ? this.kinesisStreamsInput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For a SQL-based Kinesis Data Analytics application, describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * InputSchemaProperty inputSchemaProperty = InputSchemaProperty.builder()
     *         .recordColumns(List.of(RecordColumnProperty.builder()
     *                 .name("name")
     *                 .sqlType("sqlType")
     *                 // the properties below are optional
     *                 .mapping("mapping")
     *                 .build()))
     *         .recordFormat(RecordFormatProperty.builder()
     *                 .recordFormatType("recordFormatType")
     *                 // the properties below are optional
     *                 .mappingParameters(MappingParametersProperty.builder()
     *                         .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                                 .recordColumnDelimiter("recordColumnDelimiter")
     *                                 .recordRowDelimiter("recordRowDelimiter")
     *                                 .build())
     *                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                                 .recordRowPath("recordRowPath")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .recordEncoding("recordEncoding")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(InputSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of `RecordColumn` objects.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRecordColumns();

        /**
         * Specifies the format of the records on the streaming source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRecordFormat();

        /**
         * Specifies the encoding of the records in the streaming source.
         * <p>
         * For example, UTF-8.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordEncoding() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputSchemaProperty> {
            java.lang.Object recordColumns;
            java.lang.Object recordFormat;
            java.lang.String recordEncoding;

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordColumns}
             * @param recordColumns A list of `RecordColumn` objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumns(software.amazon.awscdk.IResolvable recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordColumns}
             * @param recordColumns A list of `RecordColumn` objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumns(java.util.List<? extends java.lang.Object> recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordFormat}
             * @param recordFormat Specifies the format of the records on the streaming source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormat(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.RecordFormatProperty recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordFormat}
             * @param recordFormat Specifies the format of the records on the streaming source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormat(software.amazon.awscdk.IResolvable recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordEncoding}
             * @param recordEncoding Specifies the encoding of the records in the streaming source.
             *                       For example, UTF-8.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordEncoding(java.lang.String recordEncoding) {
                this.recordEncoding = recordEncoding;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputSchemaProperty {
            private final java.lang.Object recordColumns;
            private final java.lang.Object recordFormat;
            private final java.lang.String recordEncoding;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordColumns = software.amazon.jsii.Kernel.get(this, "recordColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordFormat = software.amazon.jsii.Kernel.get(this, "recordFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordEncoding = software.amazon.jsii.Kernel.get(this, "recordEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordColumns = java.util.Objects.requireNonNull(builder.recordColumns, "recordColumns is required");
                this.recordFormat = java.util.Objects.requireNonNull(builder.recordFormat, "recordFormat is required");
                this.recordEncoding = builder.recordEncoding;
            }

            @Override
            public final java.lang.Object getRecordColumns() {
                return this.recordColumns;
            }

            @Override
            public final java.lang.Object getRecordFormat() {
                return this.recordFormat;
            }

            @Override
            public final java.lang.String getRecordEncoding() {
                return this.recordEncoding;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordColumns", om.valueToTree(this.getRecordColumns()));
                data.set("recordFormat", om.valueToTree(this.getRecordFormat()));
                if (this.getRecordEncoding() != null) {
                    data.set("recordEncoding", om.valueToTree(this.getRecordEncoding()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.InputSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputSchemaProperty.Jsii$Proxy that = (InputSchemaProperty.Jsii$Proxy) o;

                if (!recordColumns.equals(that.recordColumns)) return false;
                if (!recordFormat.equals(that.recordFormat)) return false;
                return this.recordEncoding != null ? this.recordEncoding.equals(that.recordEncoding) : that.recordEncoding == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordColumns.hashCode();
                result = 31 * result + (this.recordFormat.hashCode());
                result = 31 * result + (this.recordEncoding != null ? this.recordEncoding.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For a SQL-based Kinesis Data Analytics application, provides additional mapping information when JSON is the record format on the streaming source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * JSONMappingParametersProperty jSONMappingParametersProperty = JSONMappingParametersProperty.builder()
     *         .recordRowPath("recordRowPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.JSONMappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(JSONMappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JSONMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path to the top-level parent that contains the records.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordRowPath();

        /**
         * @return a {@link Builder} of {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JSONMappingParametersProperty> {
            java.lang.String recordRowPath;

            /**
             * Sets the value of {@link JSONMappingParametersProperty#getRecordRowPath}
             * @param recordRowPath The path to the top-level parent that contains the records. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordRowPath(java.lang.String recordRowPath) {
                this.recordRowPath = recordRowPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JSONMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JSONMappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JSONMappingParametersProperty {
            private final java.lang.String recordRowPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordRowPath = software.amazon.jsii.Kernel.get(this, "recordRowPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordRowPath = java.util.Objects.requireNonNull(builder.recordRowPath, "recordRowPath is required");
            }

            @Override
            public final java.lang.String getRecordRowPath() {
                return this.recordRowPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordRowPath", om.valueToTree(this.getRecordRowPath()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.JSONMappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JSONMappingParametersProperty.Jsii$Proxy that = (JSONMappingParametersProperty.Jsii$Proxy) o;

                return this.recordRowPath.equals(that.recordRowPath);
            }

            @Override
            public final int hashCode() {
                int result = this.recordRowPath.hashCode();
                return result;
            }
        }
    }
    /**
     * For a SQL-based Kinesis Data Analytics application, identifies a Kinesis Data Firehose delivery stream as the streaming source.
     * <p>
     * You provide the delivery stream's Amazon Resource Name (ARN).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * KinesisFirehoseInputProperty kinesisFirehoseInputProperty = KinesisFirehoseInputProperty.builder()
     *         .resourceArn("resourceArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.KinesisFirehoseInputProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseInputProperty> {
            java.lang.String resourceArn;

            /**
             * Sets the value of {@link KinesisFirehoseInputProperty#getResourceArn}
             * @param resourceArn The Amazon Resource Name (ARN) of the delivery stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseInputProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.KinesisFirehoseInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseInputProperty.Jsii$Proxy that = (KinesisFirehoseInputProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Identifies a Kinesis data stream as the streaming source.
     * <p>
     * You provide the stream's Amazon Resource Name (ARN).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * KinesisStreamsInputProperty kinesisStreamsInputProperty = KinesisStreamsInputProperty.builder()
     *         .resourceArn("resourceArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.KinesisStreamsInputProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamsInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamsInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the input Kinesis data stream to read.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamsInputProperty> {
            java.lang.String resourceArn;

            /**
             * Sets the value of {@link KinesisStreamsInputProperty#getResourceArn}
             * @param resourceArn The ARN of the input Kinesis data stream to read. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisStreamsInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamsInputProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.KinesisStreamsInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamsInputProperty.Jsii$Proxy that = (KinesisStreamsInputProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * When you configure a SQL-based Kinesis Data Analytics application's input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * MappingParametersProperty mappingParametersProperty = MappingParametersProperty.builder()
     *         .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                 .recordColumnDelimiter("recordColumnDelimiter")
     *                 .recordRowDelimiter("recordRowDelimiter")
     *                 .build())
     *         .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                 .recordRowPath("recordRowPath")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.MappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Provides additional mapping information when the record format uses delimiters (for example, CSV).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsvMappingParameters() {
            return null;
        }

        /**
         * Provides additional mapping information when JSON is the record format on the streaming source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonMappingParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MappingParametersProperty> {
            java.lang.Object csvMappingParameters;
            java.lang.Object jsonMappingParameters;

            /**
             * Sets the value of {@link MappingParametersProperty#getCsvMappingParameters}
             * @param csvMappingParameters Provides additional mapping information when the record format uses delimiters (for example, CSV).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvMappingParameters(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.CSVMappingParametersProperty csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getCsvMappingParameters}
             * @param csvMappingParameters Provides additional mapping information when the record format uses delimiters (for example, CSV).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvMappingParameters(software.amazon.awscdk.IResolvable csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getJsonMappingParameters}
             * @param jsonMappingParameters Provides additional mapping information when JSON is the record format on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonMappingParameters(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.JSONMappingParametersProperty jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getJsonMappingParameters}
             * @param jsonMappingParameters Provides additional mapping information when JSON is the record format on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonMappingParameters(software.amazon.awscdk.IResolvable jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MappingParametersProperty {
            private final java.lang.Object csvMappingParameters;
            private final java.lang.Object jsonMappingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csvMappingParameters = software.amazon.jsii.Kernel.get(this, "csvMappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jsonMappingParameters = software.amazon.jsii.Kernel.get(this, "jsonMappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csvMappingParameters = builder.csvMappingParameters;
                this.jsonMappingParameters = builder.jsonMappingParameters;
            }

            @Override
            public final java.lang.Object getCsvMappingParameters() {
                return this.csvMappingParameters;
            }

            @Override
            public final java.lang.Object getJsonMappingParameters() {
                return this.jsonMappingParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsvMappingParameters() != null) {
                    data.set("csvMappingParameters", om.valueToTree(this.getCsvMappingParameters()));
                }
                if (this.getJsonMappingParameters() != null) {
                    data.set("jsonMappingParameters", om.valueToTree(this.getJsonMappingParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.MappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MappingParametersProperty.Jsii$Proxy that = (MappingParametersProperty.Jsii$Proxy) o;

                if (this.csvMappingParameters != null ? !this.csvMappingParameters.equals(that.csvMappingParameters) : that.csvMappingParameters != null) return false;
                return this.jsonMappingParameters != null ? this.jsonMappingParameters.equals(that.jsonMappingParameters) : that.jsonMappingParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csvMappingParameters != null ? this.csvMappingParameters.hashCode() : 0;
                result = 31 * result + (this.jsonMappingParameters != null ? this.jsonMappingParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The information required to specify a Maven reference.
     * <p>
     * You can use Maven references to specify dependency JAR files.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * MavenReferenceProperty mavenReferenceProperty = MavenReferenceProperty.builder()
     *         .artifactId("artifactId")
     *         .groupId("groupId")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.MavenReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(MavenReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MavenReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The artifact ID of the Maven reference.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArtifactId();

        /**
         * The group ID of the Maven reference.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupId();

        /**
         * The version of the Maven reference.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link MavenReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MavenReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MavenReferenceProperty> {
            java.lang.String artifactId;
            java.lang.String groupId;
            java.lang.String version;

            /**
             * Sets the value of {@link MavenReferenceProperty#getArtifactId}
             * @param artifactId The artifact ID of the Maven reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactId(java.lang.String artifactId) {
                this.artifactId = artifactId;
                return this;
            }

            /**
             * Sets the value of {@link MavenReferenceProperty#getGroupId}
             * @param groupId The group ID of the Maven reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupId(java.lang.String groupId) {
                this.groupId = groupId;
                return this;
            }

            /**
             * Sets the value of {@link MavenReferenceProperty#getVersion}
             * @param version The version of the Maven reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MavenReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MavenReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MavenReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MavenReferenceProperty {
            private final java.lang.String artifactId;
            private final java.lang.String groupId;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.artifactId = software.amazon.jsii.Kernel.get(this, "artifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.artifactId = java.util.Objects.requireNonNull(builder.artifactId, "artifactId is required");
                this.groupId = java.util.Objects.requireNonNull(builder.groupId, "groupId is required");
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            }

            @Override
            public final java.lang.String getArtifactId() {
                return this.artifactId;
            }

            @Override
            public final java.lang.String getGroupId() {
                return this.groupId;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("artifactId", om.valueToTree(this.getArtifactId()));
                data.set("groupId", om.valueToTree(this.getGroupId()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.MavenReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MavenReferenceProperty.Jsii$Proxy that = (MavenReferenceProperty.Jsii$Proxy) o;

                if (!artifactId.equals(that.artifactId)) return false;
                if (!groupId.equals(that.groupId)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public final int hashCode() {
                int result = this.artifactId.hashCode();
                result = 31 * result + (this.groupId.hashCode());
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes configuration parameters for Amazon CloudWatch logging for a Java-based Kinesis Data Analytics application.
     * <p>
     * For more information about CloudWatch logging, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/monitoring-overview">Monitoring</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * MonitoringConfigurationProperty monitoringConfigurationProperty = MonitoringConfigurationProperty.builder()
     *         .configurationType("configurationType")
     *         // the properties below are optional
     *         .logLevel("logLevel")
     *         .metricsLevel("metricsLevel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.MonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes whether to use the default CloudWatch logging configuration for an application.
         * <p>
         * You must set this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or <code>MetricsLevel</code> parameters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConfigurationType();

        /**
         * Describes the verbosity of the CloudWatch Logs for an application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
            return null;
        }

        /**
         * Describes the granularity of the CloudWatch Logs for an application.
         * <p>
         * The <code>Parallelism</code> level is not recommended for applications with a Parallelism over 64 due to excessive costs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricsLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringConfigurationProperty> {
            java.lang.String configurationType;
            java.lang.String logLevel;
            java.lang.String metricsLevel;

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getConfigurationType}
             * @param configurationType Describes whether to use the default CloudWatch logging configuration for an application. This parameter is required.
             *                          You must set this property to <code>CUSTOM</code> in order to set the <code>LogLevel</code> or <code>MetricsLevel</code> parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationType(java.lang.String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getLogLevel}
             * @param logLevel Describes the verbosity of the CloudWatch Logs for an application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logLevel(java.lang.String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getMetricsLevel}
             * @param metricsLevel Describes the granularity of the CloudWatch Logs for an application.
             *                     The <code>Parallelism</code> level is not recommended for applications with a Parallelism over 64 due to excessive costs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsLevel(java.lang.String metricsLevel) {
                this.metricsLevel = metricsLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringConfigurationProperty {
            private final java.lang.String configurationType;
            private final java.lang.String logLevel;
            private final java.lang.String metricsLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationType = software.amazon.jsii.Kernel.get(this, "configurationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricsLevel = software.amazon.jsii.Kernel.get(this, "metricsLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationType = java.util.Objects.requireNonNull(builder.configurationType, "configurationType is required");
                this.logLevel = builder.logLevel;
                this.metricsLevel = builder.metricsLevel;
            }

            @Override
            public final java.lang.String getConfigurationType() {
                return this.configurationType;
            }

            @Override
            public final java.lang.String getLogLevel() {
                return this.logLevel;
            }

            @Override
            public final java.lang.String getMetricsLevel() {
                return this.metricsLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("configurationType", om.valueToTree(this.getConfigurationType()));
                if (this.getLogLevel() != null) {
                    data.set("logLevel", om.valueToTree(this.getLogLevel()));
                }
                if (this.getMetricsLevel() != null) {
                    data.set("metricsLevel", om.valueToTree(this.getMetricsLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.MonitoringConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringConfigurationProperty.Jsii$Proxy that = (MonitoringConfigurationProperty.Jsii$Proxy) o;

                if (!configurationType.equals(that.configurationType)) return false;
                if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
                return this.metricsLevel != null ? this.metricsLevel.equals(that.metricsLevel) : that.metricsLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationType.hashCode();
                result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
                result = 31 * result + (this.metricsLevel != null ? this.metricsLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes parameters for how a Flink-based Kinesis Data Analytics application executes multiple tasks simultaneously.
     * <p>
     * For more information about parallelism, see <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/dev/parallel.html">Parallel Execution</a> in the <a href="https://docs.aws.amazon.com/https://ci.apache.org/projects/flink/flink-docs-release-1.8/">Apache Flink Documentation</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * ParallelismConfigurationProperty parallelismConfigurationProperty = ParallelismConfigurationProperty.builder()
     *         .configurationType("configurationType")
     *         // the properties below are optional
     *         .autoScalingEnabled(false)
     *         .parallelism(123)
     *         .parallelismPerKpu(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ParallelismConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParallelismConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParallelismConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
         * <p>
         * You must set this property to <code>CUSTOM</code> in order to change your application's <code>AutoScalingEnabled</code> , <code>Parallelism</code> , or <code>ParallelismPerKPU</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConfigurationType();

        /**
         * Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoScalingEnabled() {
            return null;
        }

        /**
         * Describes the initial number of parallel tasks that a Java-based Kinesis Data Analytics application can perform.
         * <p>
         * The Kinesis Data Analytics service can increase this number automatically if <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_ParallelismConfiguration.html#kinesisanalytics-Type-ParallelismConfiguration-AutoScalingEnabled.html">ParallelismConfiguration:AutoScalingEnabled</a> is set to <code>true</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelism() {
            return null;
        }

        /**
         * Describes the number of parallel tasks that a Java-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application.
         * <p>
         * For more information about KPUs, see <a href="https://docs.aws.amazon.com/kinesis/data-analytics/pricing/">Amazon Kinesis Data Analytics Pricing</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelismPerKpu() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParallelismConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParallelismConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParallelismConfigurationProperty> {
            java.lang.String configurationType;
            java.lang.Object autoScalingEnabled;
            java.lang.Number parallelism;
            java.lang.Number parallelismPerKpu;

            /**
             * Sets the value of {@link ParallelismConfigurationProperty#getConfigurationType}
             * @param configurationType Describes whether the application uses the default parallelism for the Kinesis Data Analytics service. This parameter is required.
             *                          You must set this property to <code>CUSTOM</code> in order to change your application's <code>AutoScalingEnabled</code> , <code>Parallelism</code> , or <code>ParallelismPerKPU</code> properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationType(java.lang.String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            /**
             * Sets the value of {@link ParallelismConfigurationProperty#getAutoScalingEnabled}
             * @param autoScalingEnabled Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingEnabled(java.lang.Boolean autoScalingEnabled) {
                this.autoScalingEnabled = autoScalingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ParallelismConfigurationProperty#getAutoScalingEnabled}
             * @param autoScalingEnabled Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingEnabled(software.amazon.awscdk.IResolvable autoScalingEnabled) {
                this.autoScalingEnabled = autoScalingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ParallelismConfigurationProperty#getParallelism}
             * @param parallelism Describes the initial number of parallel tasks that a Java-based Kinesis Data Analytics application can perform.
             *                    The Kinesis Data Analytics service can increase this number automatically if <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_ParallelismConfiguration.html#kinesisanalytics-Type-ParallelismConfiguration-AutoScalingEnabled.html">ParallelismConfiguration:AutoScalingEnabled</a> is set to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelism(java.lang.Number parallelism) {
                this.parallelism = parallelism;
                return this;
            }

            /**
             * Sets the value of {@link ParallelismConfigurationProperty#getParallelismPerKpu}
             * @param parallelismPerKpu Describes the number of parallel tasks that a Java-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application.
             *                          For more information about KPUs, see <a href="https://docs.aws.amazon.com/kinesis/data-analytics/pricing/">Amazon Kinesis Data Analytics Pricing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelismPerKpu(java.lang.Number parallelismPerKpu) {
                this.parallelismPerKpu = parallelismPerKpu;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParallelismConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParallelismConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParallelismConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParallelismConfigurationProperty {
            private final java.lang.String configurationType;
            private final java.lang.Object autoScalingEnabled;
            private final java.lang.Number parallelism;
            private final java.lang.Number parallelismPerKpu;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationType = software.amazon.jsii.Kernel.get(this, "configurationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.autoScalingEnabled = software.amazon.jsii.Kernel.get(this, "autoScalingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parallelism = software.amazon.jsii.Kernel.get(this, "parallelism", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parallelismPerKpu = software.amazon.jsii.Kernel.get(this, "parallelismPerKpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationType = java.util.Objects.requireNonNull(builder.configurationType, "configurationType is required");
                this.autoScalingEnabled = builder.autoScalingEnabled;
                this.parallelism = builder.parallelism;
                this.parallelismPerKpu = builder.parallelismPerKpu;
            }

            @Override
            public final java.lang.String getConfigurationType() {
                return this.configurationType;
            }

            @Override
            public final java.lang.Object getAutoScalingEnabled() {
                return this.autoScalingEnabled;
            }

            @Override
            public final java.lang.Number getParallelism() {
                return this.parallelism;
            }

            @Override
            public final java.lang.Number getParallelismPerKpu() {
                return this.parallelismPerKpu;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("configurationType", om.valueToTree(this.getConfigurationType()));
                if (this.getAutoScalingEnabled() != null) {
                    data.set("autoScalingEnabled", om.valueToTree(this.getAutoScalingEnabled()));
                }
                if (this.getParallelism() != null) {
                    data.set("parallelism", om.valueToTree(this.getParallelism()));
                }
                if (this.getParallelismPerKpu() != null) {
                    data.set("parallelismPerKpu", om.valueToTree(this.getParallelismPerKpu()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ParallelismConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParallelismConfigurationProperty.Jsii$Proxy that = (ParallelismConfigurationProperty.Jsii$Proxy) o;

                if (!configurationType.equals(that.configurationType)) return false;
                if (this.autoScalingEnabled != null ? !this.autoScalingEnabled.equals(that.autoScalingEnabled) : that.autoScalingEnabled != null) return false;
                if (this.parallelism != null ? !this.parallelism.equals(that.parallelism) : that.parallelism != null) return false;
                return this.parallelismPerKpu != null ? this.parallelismPerKpu.equals(that.parallelismPerKpu) : that.parallelismPerKpu == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationType.hashCode();
                result = 31 * result + (this.autoScalingEnabled != null ? this.autoScalingEnabled.hashCode() : 0);
                result = 31 * result + (this.parallelism != null ? this.parallelism.hashCode() : 0);
                result = 31 * result + (this.parallelismPerKpu != null ? this.parallelismPerKpu.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Property key-value pairs passed into an application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * PropertyGroupProperty propertyGroupProperty = PropertyGroupProperty.builder()
     *         .propertyGroupId("propertyGroupId")
     *         .propertyMap(Map.of(
     *                 "propertyMapKey", "propertyMap"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.PropertyGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(PropertyGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the key of an application execution property key-value pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyGroupId() {
            return null;
        }

        /**
         * Describes the value of an application execution property key-value pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropertyGroupProperty> {
            java.lang.String propertyGroupId;
            java.lang.Object propertyMap;

            /**
             * Sets the value of {@link PropertyGroupProperty#getPropertyGroupId}
             * @param propertyGroupId Describes the key of an application execution property key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyGroupId(java.lang.String propertyGroupId) {
                this.propertyGroupId = propertyGroupId;
                return this;
            }

            /**
             * Sets the value of {@link PropertyGroupProperty#getPropertyMap}
             * @param propertyMap Describes the value of an application execution property key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyMap(software.amazon.awscdk.IResolvable propertyMap) {
                this.propertyMap = propertyMap;
                return this;
            }

            /**
             * Sets the value of {@link PropertyGroupProperty#getPropertyMap}
             * @param propertyMap Describes the value of an application execution property key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyMap(java.util.Map<java.lang.String, java.lang.String> propertyMap) {
                this.propertyMap = propertyMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropertyGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyGroupProperty {
            private final java.lang.String propertyGroupId;
            private final java.lang.Object propertyMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.propertyGroupId = software.amazon.jsii.Kernel.get(this, "propertyGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyMap = software.amazon.jsii.Kernel.get(this, "propertyMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propertyGroupId = builder.propertyGroupId;
                this.propertyMap = builder.propertyMap;
            }

            @Override
            public final java.lang.String getPropertyGroupId() {
                return this.propertyGroupId;
            }

            @Override
            public final java.lang.Object getPropertyMap() {
                return this.propertyMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPropertyGroupId() != null) {
                    data.set("propertyGroupId", om.valueToTree(this.getPropertyGroupId()));
                }
                if (this.getPropertyMap() != null) {
                    data.set("propertyMap", om.valueToTree(this.getPropertyMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.PropertyGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyGroupProperty.Jsii$Proxy that = (PropertyGroupProperty.Jsii$Proxy) o;

                if (this.propertyGroupId != null ? !this.propertyGroupId.equals(that.propertyGroupId) : that.propertyGroupId != null) return false;
                return this.propertyMap != null ? this.propertyMap.equals(that.propertyMap) : that.propertyMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.propertyGroupId != null ? this.propertyGroupId.hashCode() : 0;
                result = 31 * result + (this.propertyMap != null ? this.propertyMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For a SQL-based Kinesis Data Analytics application, describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     * <p>
     * Also used to describe the format of the reference data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * RecordColumnProperty recordColumnProperty = RecordColumnProperty.builder()
     *         .name("name")
     *         .sqlType("sqlType")
     *         // the properties below are optional
     *         .mapping("mapping")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.RecordColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column that is created in the in-application input stream or reference table.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The type of column created in the in-application input stream or reference table.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlType();

        /**
         * A reference to the data element in the streaming input or the reference data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMapping() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordColumnProperty> {
            java.lang.String name;
            java.lang.String sqlType;
            java.lang.String mapping;

            /**
             * Sets the value of {@link RecordColumnProperty#getName}
             * @param name The name of the column that is created in the in-application input stream or reference table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RecordColumnProperty#getSqlType}
             * @param sqlType The type of column created in the in-application input stream or reference table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlType(java.lang.String sqlType) {
                this.sqlType = sqlType;
                return this;
            }

            /**
             * Sets the value of {@link RecordColumnProperty#getMapping}
             * @param mapping A reference to the data element in the streaming input or the reference data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapping(java.lang.String mapping) {
                this.mapping = mapping;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordColumnProperty {
            private final java.lang.String name;
            private final java.lang.String sqlType;
            private final java.lang.String mapping;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqlType = software.amazon.jsii.Kernel.get(this, "sqlType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mapping = software.amazon.jsii.Kernel.get(this, "mapping", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.sqlType = java.util.Objects.requireNonNull(builder.sqlType, "sqlType is required");
                this.mapping = builder.mapping;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSqlType() {
                return this.sqlType;
            }

            @Override
            public final java.lang.String getMapping() {
                return this.mapping;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("sqlType", om.valueToTree(this.getSqlType()));
                if (this.getMapping() != null) {
                    data.set("mapping", om.valueToTree(this.getMapping()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.RecordColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordColumnProperty.Jsii$Proxy that = (RecordColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!sqlType.equals(that.sqlType)) return false;
                return this.mapping != null ? this.mapping.equals(that.mapping) : that.mapping == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.sqlType.hashCode());
                result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For a SQL-based Kinesis Data Analytics application, describes the record format and relevant mapping information that should be applied to schematize the records on the stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * RecordFormatProperty recordFormatProperty = RecordFormatProperty.builder()
     *         .recordFormatType("recordFormatType")
     *         // the properties below are optional
     *         .mappingParameters(MappingParametersProperty.builder()
     *                 .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                         .recordColumnDelimiter("recordColumnDelimiter")
     *                         .recordRowDelimiter("recordRowDelimiter")
     *                         .build())
     *                 .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                         .recordRowPath("recordRowPath")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.RecordFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of record format.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordFormatType();

        /**
         * When you configure application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMappingParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordFormatProperty> {
            java.lang.String recordFormatType;
            java.lang.Object mappingParameters;

            /**
             * Sets the value of {@link RecordFormatProperty#getRecordFormatType}
             * @param recordFormatType The type of record format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormatType(java.lang.String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            /**
             * Sets the value of {@link RecordFormatProperty#getMappingParameters}
             * @param mappingParameters When you configure application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mappingParameters(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.MappingParametersProperty mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link RecordFormatProperty#getMappingParameters}
             * @param mappingParameters When you configure application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mappingParameters(software.amazon.awscdk.IResolvable mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordFormatProperty {
            private final java.lang.String recordFormatType;
            private final java.lang.Object mappingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordFormatType = software.amazon.jsii.Kernel.get(this, "recordFormatType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mappingParameters = software.amazon.jsii.Kernel.get(this, "mappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordFormatType = java.util.Objects.requireNonNull(builder.recordFormatType, "recordFormatType is required");
                this.mappingParameters = builder.mappingParameters;
            }

            @Override
            public final java.lang.String getRecordFormatType() {
                return this.recordFormatType;
            }

            @Override
            public final java.lang.Object getMappingParameters() {
                return this.mappingParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                if (this.getMappingParameters() != null) {
                    data.set("mappingParameters", om.valueToTree(this.getMappingParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.RecordFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordFormatProperty.Jsii$Proxy that = (RecordFormatProperty.Jsii$Proxy) o;

                if (!recordFormatType.equals(that.recordFormatType)) return false;
                return this.mappingParameters != null ? this.mappingParameters.equals(that.mappingParameters) : that.mappingParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordFormatType.hashCode();
                result = 31 * result + (this.mappingParameters != null ? this.mappingParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * RunConfigurationProperty runConfigurationProperty = RunConfigurationProperty.builder()
     *         .applicationRestoreConfiguration(ApplicationRestoreConfigurationProperty.builder()
     *                 .applicationRestoreType("applicationRestoreType")
     *                 // the properties below are optional
     *                 .snapshotName("snapshotName")
     *                 .build())
     *         .flinkRunConfiguration(FlinkRunConfigurationProperty.builder()
     *                 .allowNonRestoredState(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.RunConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RunConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RunConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplication.RunConfigurationProperty.ApplicationRestoreConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationRestoreConfiguration() {
            return null;
        }

        /**
         * `CfnApplication.RunConfigurationProperty.FlinkRunConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFlinkRunConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RunConfigurationProperty> {
            java.lang.Object applicationRestoreConfiguration;
            java.lang.Object flinkRunConfiguration;

            /**
             * Sets the value of {@link RunConfigurationProperty#getApplicationRestoreConfiguration}
             * @param applicationRestoreConfiguration `CfnApplication.RunConfigurationProperty.ApplicationRestoreConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationRestoreConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationRestoreConfigurationProperty applicationRestoreConfiguration) {
                this.applicationRestoreConfiguration = applicationRestoreConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigurationProperty#getApplicationRestoreConfiguration}
             * @param applicationRestoreConfiguration `CfnApplication.RunConfigurationProperty.ApplicationRestoreConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationRestoreConfiguration(software.amazon.awscdk.IResolvable applicationRestoreConfiguration) {
                this.applicationRestoreConfiguration = applicationRestoreConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigurationProperty#getFlinkRunConfiguration}
             * @param flinkRunConfiguration `CfnApplication.RunConfigurationProperty.FlinkRunConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flinkRunConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.FlinkRunConfigurationProperty flinkRunConfiguration) {
                this.flinkRunConfiguration = flinkRunConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigurationProperty#getFlinkRunConfiguration}
             * @param flinkRunConfiguration `CfnApplication.RunConfigurationProperty.FlinkRunConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flinkRunConfiguration(software.amazon.awscdk.IResolvable flinkRunConfiguration) {
                this.flinkRunConfiguration = flinkRunConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RunConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunConfigurationProperty {
            private final java.lang.Object applicationRestoreConfiguration;
            private final java.lang.Object flinkRunConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationRestoreConfiguration = software.amazon.jsii.Kernel.get(this, "applicationRestoreConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.flinkRunConfiguration = software.amazon.jsii.Kernel.get(this, "flinkRunConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationRestoreConfiguration = builder.applicationRestoreConfiguration;
                this.flinkRunConfiguration = builder.flinkRunConfiguration;
            }

            @Override
            public final java.lang.Object getApplicationRestoreConfiguration() {
                return this.applicationRestoreConfiguration;
            }

            @Override
            public final java.lang.Object getFlinkRunConfiguration() {
                return this.flinkRunConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationRestoreConfiguration() != null) {
                    data.set("applicationRestoreConfiguration", om.valueToTree(this.getApplicationRestoreConfiguration()));
                }
                if (this.getFlinkRunConfiguration() != null) {
                    data.set("flinkRunConfiguration", om.valueToTree(this.getFlinkRunConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.RunConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RunConfigurationProperty.Jsii$Proxy that = (RunConfigurationProperty.Jsii$Proxy) o;

                if (this.applicationRestoreConfiguration != null ? !this.applicationRestoreConfiguration.equals(that.applicationRestoreConfiguration) : that.applicationRestoreConfiguration != null) return false;
                return this.flinkRunConfiguration != null ? this.flinkRunConfiguration.equals(that.flinkRunConfiguration) : that.flinkRunConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationRestoreConfiguration != null ? this.applicationRestoreConfiguration.hashCode() : 0;
                result = 31 * result + (this.flinkRunConfiguration != null ? this.flinkRunConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The base location of the Amazon Data Analytics application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * S3ContentBaseLocationProperty s3ContentBaseLocationProperty = S3ContentBaseLocationProperty.builder()
     *         .bucketArn("bucketArn")
     *         // the properties below are optional
     *         .basePath("basePath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.S3ContentBaseLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ContentBaseLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ContentBaseLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * The base path for the S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBasePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ContentBaseLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ContentBaseLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ContentBaseLocationProperty> {
            java.lang.String bucketArn;
            java.lang.String basePath;

            /**
             * Sets the value of {@link S3ContentBaseLocationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3ContentBaseLocationProperty#getBasePath}
             * @param basePath The base path for the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basePath(java.lang.String basePath) {
                this.basePath = basePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ContentBaseLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ContentBaseLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ContentBaseLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ContentBaseLocationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String basePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.basePath = software.amazon.jsii.Kernel.get(this, "basePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.basePath = builder.basePath;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getBasePath() {
                return this.basePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                if (this.getBasePath() != null) {
                    data.set("basePath", om.valueToTree(this.getBasePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.S3ContentBaseLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ContentBaseLocationProperty.Jsii$Proxy that = (S3ContentBaseLocationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                return this.basePath != null ? this.basePath.equals(that.basePath) : that.basePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.basePath != null ? this.basePath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The location of an application or a custom artifact.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * S3ContentLocationProperty s3ContentLocationProperty = S3ContentLocationProperty.builder()
     *         .bucketArn("bucketArn")
     *         .fileKey("fileKey")
     *         // the properties below are optional
     *         .objectVersion("objectVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.S3ContentLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ContentLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ContentLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the S3 bucket containing the application code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * The file key for the object containing the application code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileKey();

        /**
         * The version of the object containing the application code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ContentLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ContentLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ContentLocationProperty> {
            java.lang.String bucketArn;
            java.lang.String fileKey;
            java.lang.String objectVersion;

            /**
             * Sets the value of {@link S3ContentLocationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) for the S3 bucket containing the application code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3ContentLocationProperty#getFileKey}
             * @param fileKey The file key for the object containing the application code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileKey(java.lang.String fileKey) {
                this.fileKey = fileKey;
                return this;
            }

            /**
             * Sets the value of {@link S3ContentLocationProperty#getObjectVersion}
             * @param objectVersion The version of the object containing the application code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectVersion(java.lang.String objectVersion) {
                this.objectVersion = objectVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ContentLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ContentLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ContentLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ContentLocationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String fileKey;
            private final java.lang.String objectVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileKey = software.amazon.jsii.Kernel.get(this, "fileKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectVersion = software.amazon.jsii.Kernel.get(this, "objectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.fileKey = java.util.Objects.requireNonNull(builder.fileKey, "fileKey is required");
                this.objectVersion = builder.objectVersion;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getFileKey() {
                return this.fileKey;
            }

            @Override
            public final java.lang.String getObjectVersion() {
                return this.objectVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                data.set("fileKey", om.valueToTree(this.getFileKey()));
                if (this.getObjectVersion() != null) {
                    data.set("objectVersion", om.valueToTree(this.getObjectVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.S3ContentLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ContentLocationProperty.Jsii$Proxy that = (S3ContentLocationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!fileKey.equals(that.fileKey)) return false;
                return this.objectVersion != null ? this.objectVersion.equals(that.objectVersion) : that.objectVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.fileKey.hashCode());
                result = 31 * result + (this.objectVersion != null ? this.objectVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * SqlApplicationConfigurationProperty sqlApplicationConfigurationProperty = SqlApplicationConfigurationProperty.builder()
     *         .inputs(List.of(InputProperty.builder()
     *                 .inputSchema(InputSchemaProperty.builder()
     *                         .recordColumns(List.of(RecordColumnProperty.builder()
     *                                 .name("name")
     *                                 .sqlType("sqlType")
     *                                 // the properties below are optional
     *                                 .mapping("mapping")
     *                                 .build()))
     *                         .recordFormat(RecordFormatProperty.builder()
     *                                 .recordFormatType("recordFormatType")
     *                                 // the properties below are optional
     *                                 .mappingParameters(MappingParametersProperty.builder()
     *                                         .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                                                 .recordColumnDelimiter("recordColumnDelimiter")
     *                                                 .recordRowDelimiter("recordRowDelimiter")
     *                                                 .build())
     *                                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                                                 .recordRowPath("recordRowPath")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .recordEncoding("recordEncoding")
     *                         .build())
     *                 .namePrefix("namePrefix")
     *                 // the properties below are optional
     *                 .inputParallelism(InputParallelismProperty.builder()
     *                         .count(123)
     *                         .build())
     *                 .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
     *                         .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
     *                                 .resourceArn("resourceArn")
     *                                 .build())
     *                         .build())
     *                 .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
     *                         .resourceArn("resourceArn")
     *                         .build())
     *                 .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
     *                         .resourceArn("resourceArn")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.SqlApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SqlApplicationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqlApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The array of [Input](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_Input.html) objects describing the input streams used by the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SqlApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqlApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqlApplicationConfigurationProperty> {
            java.lang.Object inputs;

            /**
             * Sets the value of {@link SqlApplicationConfigurationProperty#getInputs}
             * @param inputs The array of [Input](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_Input.html) objects describing the input streams used by the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputs(software.amazon.awscdk.IResolvable inputs) {
                this.inputs = inputs;
                return this;
            }

            /**
             * Sets the value of {@link SqlApplicationConfigurationProperty#getInputs}
             * @param inputs The array of [Input](https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_Input.html) objects describing the input streams used by the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputs(java.util.List<? extends java.lang.Object> inputs) {
                this.inputs = inputs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqlApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqlApplicationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqlApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqlApplicationConfigurationProperty {
            private final java.lang.Object inputs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputs = software.amazon.jsii.Kernel.get(this, "inputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputs = builder.inputs;
            }

            @Override
            public final java.lang.Object getInputs() {
                return this.inputs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInputs() != null) {
                    data.set("inputs", om.valueToTree(this.getInputs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.SqlApplicationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqlApplicationConfigurationProperty.Jsii$Proxy that = (SqlApplicationConfigurationProperty.Jsii$Proxy) o;

                return this.inputs != null ? this.inputs.equals(that.inputs) : that.inputs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputs != null ? this.inputs.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * VpcConfigurationProperty vpcConfigurationProperty = VpcConfigurationProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplication.VpcConfigurationProperty.SecurityGroupIds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * `CfnApplication.VpcConfigurationProperty.SubnetIds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link VpcConfigurationProperty#getSecurityGroupIds}
             * @param securityGroupIds `CfnApplication.VpcConfigurationProperty.SecurityGroupIds`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigurationProperty#getSubnetIds}
             * @param subnetIds `CfnApplication.VpcConfigurationProperty.SubnetIds`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.VpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigurationProperty.Jsii$Proxy that = (VpcConfigurationProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration of a Kinesis Data Analytics Studio notebook.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * ZeppelinApplicationConfigurationProperty zeppelinApplicationConfigurationProperty = ZeppelinApplicationConfigurationProperty.builder()
     *         .catalogConfiguration(CatalogConfigurationProperty.builder()
     *                 .glueDataCatalogConfiguration(GlueDataCatalogConfigurationProperty.builder()
     *                         .databaseArn("databaseArn")
     *                         .build())
     *                 .build())
     *         .customArtifactsConfiguration(List.of(CustomArtifactConfigurationProperty.builder()
     *                 .artifactType("artifactType")
     *                 // the properties below are optional
     *                 .mavenReference(MavenReferenceProperty.builder()
     *                         .artifactId("artifactId")
     *                         .groupId("groupId")
     *                         .version("version")
     *                         .build())
     *                 .s3ContentLocation(S3ContentLocationProperty.builder()
     *                         .bucketArn("bucketArn")
     *                         .fileKey("fileKey")
     *                         // the properties below are optional
     *                         .objectVersion("objectVersion")
     *                         .build())
     *                 .build()))
     *         .deployAsApplicationConfiguration(DeployAsApplicationConfigurationProperty.builder()
     *                 .s3ContentLocation(S3ContentBaseLocationProperty.builder()
     *                         .bucketArn("bucketArn")
     *                         // the properties below are optional
     *                         .basePath("basePath")
     *                         .build())
     *                 .build())
     *         .monitoringConfiguration(ZeppelinMonitoringConfigurationProperty.builder()
     *                 .logLevel("logLevel")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ZeppelinApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ZeppelinApplicationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZeppelinApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Glue Data Catalog that you use in queries in a Kinesis Data Analytics Studio notebook.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCatalogConfiguration() {
            return null;
        }

        /**
         * A list of `CustomArtifactConfiguration` objects.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomArtifactsConfiguration() {
            return null;
        }

        /**
         * The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeployAsApplicationConfiguration() {
            return null;
        }

        /**
         * The monitoring configuration of a Kinesis Data Analytics Studio notebook.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoringConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZeppelinApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZeppelinApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZeppelinApplicationConfigurationProperty> {
            java.lang.Object catalogConfiguration;
            java.lang.Object customArtifactsConfiguration;
            java.lang.Object deployAsApplicationConfiguration;
            java.lang.Object monitoringConfiguration;

            /**
             * Sets the value of {@link ZeppelinApplicationConfigurationProperty#getCatalogConfiguration}
             * @param catalogConfiguration The Amazon Glue Data Catalog that you use in queries in a Kinesis Data Analytics Studio notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.CatalogConfigurationProperty catalogConfiguration) {
                this.catalogConfiguration = catalogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ZeppelinApplicationConfigurationProperty#getCatalogConfiguration}
             * @param catalogConfiguration The Amazon Glue Data Catalog that you use in queries in a Kinesis Data Analytics Studio notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogConfiguration(software.amazon.awscdk.IResolvable catalogConfiguration) {
                this.catalogConfiguration = catalogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ZeppelinApplicationConfigurationProperty#getCustomArtifactsConfiguration}
             * @param customArtifactsConfiguration A list of `CustomArtifactConfiguration` objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customArtifactsConfiguration(software.amazon.awscdk.IResolvable customArtifactsConfiguration) {
                this.customArtifactsConfiguration = customArtifactsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ZeppelinApplicationConfigurationProperty#getCustomArtifactsConfiguration}
             * @param customArtifactsConfiguration A list of `CustomArtifactConfiguration` objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customArtifactsConfiguration(java.util.List<? extends java.lang.Object> customArtifactsConfiguration) {
                this.customArtifactsConfiguration = customArtifactsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ZeppelinApplicationConfigurationProperty#getDeployAsApplicationConfiguration}
             * @param deployAsApplicationConfiguration The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deployAsApplicationConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.DeployAsApplicationConfigurationProperty deployAsApplicationConfiguration) {
                this.deployAsApplicationConfiguration = deployAsApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ZeppelinApplicationConfigurationProperty#getDeployAsApplicationConfiguration}
             * @param deployAsApplicationConfiguration The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deployAsApplicationConfiguration(software.amazon.awscdk.IResolvable deployAsApplicationConfiguration) {
                this.deployAsApplicationConfiguration = deployAsApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ZeppelinApplicationConfigurationProperty#getMonitoringConfiguration}
             * @param monitoringConfiguration The monitoring configuration of a Kinesis Data Analytics Studio notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ZeppelinMonitoringConfigurationProperty monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ZeppelinApplicationConfigurationProperty#getMonitoringConfiguration}
             * @param monitoringConfiguration The monitoring configuration of a Kinesis Data Analytics Studio notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringConfiguration(software.amazon.awscdk.IResolvable monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZeppelinApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZeppelinApplicationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZeppelinApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZeppelinApplicationConfigurationProperty {
            private final java.lang.Object catalogConfiguration;
            private final java.lang.Object customArtifactsConfiguration;
            private final java.lang.Object deployAsApplicationConfiguration;
            private final java.lang.Object monitoringConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogConfiguration = software.amazon.jsii.Kernel.get(this, "catalogConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customArtifactsConfiguration = software.amazon.jsii.Kernel.get(this, "customArtifactsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deployAsApplicationConfiguration = software.amazon.jsii.Kernel.get(this, "deployAsApplicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringConfiguration = software.amazon.jsii.Kernel.get(this, "monitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogConfiguration = builder.catalogConfiguration;
                this.customArtifactsConfiguration = builder.customArtifactsConfiguration;
                this.deployAsApplicationConfiguration = builder.deployAsApplicationConfiguration;
                this.monitoringConfiguration = builder.monitoringConfiguration;
            }

            @Override
            public final java.lang.Object getCatalogConfiguration() {
                return this.catalogConfiguration;
            }

            @Override
            public final java.lang.Object getCustomArtifactsConfiguration() {
                return this.customArtifactsConfiguration;
            }

            @Override
            public final java.lang.Object getDeployAsApplicationConfiguration() {
                return this.deployAsApplicationConfiguration;
            }

            @Override
            public final java.lang.Object getMonitoringConfiguration() {
                return this.monitoringConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogConfiguration() != null) {
                    data.set("catalogConfiguration", om.valueToTree(this.getCatalogConfiguration()));
                }
                if (this.getCustomArtifactsConfiguration() != null) {
                    data.set("customArtifactsConfiguration", om.valueToTree(this.getCustomArtifactsConfiguration()));
                }
                if (this.getDeployAsApplicationConfiguration() != null) {
                    data.set("deployAsApplicationConfiguration", om.valueToTree(this.getDeployAsApplicationConfiguration()));
                }
                if (this.getMonitoringConfiguration() != null) {
                    data.set("monitoringConfiguration", om.valueToTree(this.getMonitoringConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ZeppelinApplicationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZeppelinApplicationConfigurationProperty.Jsii$Proxy that = (ZeppelinApplicationConfigurationProperty.Jsii$Proxy) o;

                if (this.catalogConfiguration != null ? !this.catalogConfiguration.equals(that.catalogConfiguration) : that.catalogConfiguration != null) return false;
                if (this.customArtifactsConfiguration != null ? !this.customArtifactsConfiguration.equals(that.customArtifactsConfiguration) : that.customArtifactsConfiguration != null) return false;
                if (this.deployAsApplicationConfiguration != null ? !this.deployAsApplicationConfiguration.equals(that.deployAsApplicationConfiguration) : that.deployAsApplicationConfiguration != null) return false;
                return this.monitoringConfiguration != null ? this.monitoringConfiguration.equals(that.monitoringConfiguration) : that.monitoringConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogConfiguration != null ? this.catalogConfiguration.hashCode() : 0;
                result = 31 * result + (this.customArtifactsConfiguration != null ? this.customArtifactsConfiguration.hashCode() : 0);
                result = 31 * result + (this.deployAsApplicationConfiguration != null ? this.deployAsApplicationConfiguration.hashCode() : 0);
                result = 31 * result + (this.monitoringConfiguration != null ? this.monitoringConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes configuration parameters for Amazon CloudWatch logging for a Kinesis Data Analytics Studio notebook.
     * <p>
     * For more information about CloudWatch logging, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/monitoring-overview.html">Monitoring</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
     * ZeppelinMonitoringConfigurationProperty zeppelinMonitoringConfigurationProperty = ZeppelinMonitoringConfigurationProperty.builder()
     *         .logLevel("logLevel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ZeppelinMonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ZeppelinMonitoringConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZeppelinMonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The verbosity of the CloudWatch Logs for an application.
         * <p>
         * You can set it to <code>INFO</code> , <code>WARN</code> , <code>ERROR</code> , or <code>DEBUG</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZeppelinMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZeppelinMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZeppelinMonitoringConfigurationProperty> {
            java.lang.String logLevel;

            /**
             * Sets the value of {@link ZeppelinMonitoringConfigurationProperty#getLogLevel}
             * @param logLevel The verbosity of the CloudWatch Logs for an application.
             *                 You can set it to <code>INFO</code> , <code>WARN</code> , <code>ERROR</code> , or <code>DEBUG</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logLevel(java.lang.String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZeppelinMonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZeppelinMonitoringConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZeppelinMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZeppelinMonitoringConfigurationProperty {
            private final java.lang.String logLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logLevel = builder.logLevel;
            }

            @Override
            public final java.lang.String getLogLevel() {
                return this.logLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogLevel() != null) {
                    data.set("logLevel", om.valueToTree(this.getLogLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication.ZeppelinMonitoringConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZeppelinMonitoringConfigurationProperty.Jsii$Proxy that = (ZeppelinMonitoringConfigurationProperty.Jsii$Proxy) o;

                return this.logLevel != null ? this.logLevel.equals(that.logLevel) : that.logLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logLevel != null ? this.logLevel.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationProps.Builder();
        }

        /**
         * The runtime environment for the application.
         * <p>
         * @return {@code this}
         * @param runtimeEnvironment The runtime environment for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeEnvironment(final java.lang.String runtimeEnvironment) {
            this.props.runtimeEnvironment(runtimeEnvironment);
            return this;
        }

        /**
         * Specifies the IAM role that the application uses to access external resources.
         * <p>
         * @return {@code this}
         * @param serviceExecutionRole Specifies the IAM role that the application uses to access external resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceExecutionRole(final java.lang.String serviceExecutionRole) {
            this.props.serviceExecutionRole(serviceExecutionRole);
            return this;
        }

        /**
         * Use this parameter to configure the application.
         * <p>
         * @return {@code this}
         * @param applicationConfiguration Use this parameter to configure the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationConfiguration(final software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationConfigurationProperty applicationConfiguration) {
            this.props.applicationConfiguration(applicationConfiguration);
            return this;
        }
        /**
         * Use this parameter to configure the application.
         * <p>
         * @return {@code this}
         * @param applicationConfiguration Use this parameter to configure the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationConfiguration(final software.amazon.awscdk.IResolvable applicationConfiguration) {
            this.props.applicationConfiguration(applicationConfiguration);
            return this;
        }

        /**
         * The description of the application.
         * <p>
         * @return {@code this}
         * @param applicationDescription The description of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationDescription(final java.lang.String applicationDescription) {
            this.props.applicationDescription(applicationDescription);
            return this;
        }

        /**
         * `AWS::KinesisAnalyticsV2::Application.ApplicationMaintenanceConfiguration`.
         * <p>
         * @return {@code this}
         * @param applicationMaintenanceConfiguration `AWS::KinesisAnalyticsV2::Application.ApplicationMaintenanceConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationMaintenanceConfiguration(final software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationMaintenanceConfigurationProperty applicationMaintenanceConfiguration) {
            this.props.applicationMaintenanceConfiguration(applicationMaintenanceConfiguration);
            return this;
        }
        /**
         * `AWS::KinesisAnalyticsV2::Application.ApplicationMaintenanceConfiguration`.
         * <p>
         * @return {@code this}
         * @param applicationMaintenanceConfiguration `AWS::KinesisAnalyticsV2::Application.ApplicationMaintenanceConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationMaintenanceConfiguration(final software.amazon.awscdk.IResolvable applicationMaintenanceConfiguration) {
            this.props.applicationMaintenanceConfiguration(applicationMaintenanceConfiguration);
            return this;
        }

        /**
         * To create a Kinesis Data Analytics Studio notebook, you must set the mode to `INTERACTIVE` .
         * <p>
         * However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
         * <p>
         * @return {@code this}
         * @param applicationMode To create a Kinesis Data Analytics Studio notebook, you must set the mode to `INTERACTIVE` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationMode(final java.lang.String applicationMode) {
            this.props.applicationMode(applicationMode);
            return this;
        }

        /**
         * The name of the application.
         * <p>
         * @return {@code this}
         * @param applicationName The name of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * `AWS::KinesisAnalyticsV2::Application.RunConfiguration`.
         * <p>
         * @return {@code this}
         * @param runConfiguration `AWS::KinesisAnalyticsV2::Application.RunConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfiguration(final software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.RunConfigurationProperty runConfiguration) {
            this.props.runConfiguration(runConfiguration);
            return this;
        }
        /**
         * `AWS::KinesisAnalyticsV2::Application.RunConfiguration`.
         * <p>
         * @return {@code this}
         * @param runConfiguration `AWS::KinesisAnalyticsV2::Application.RunConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfiguration(final software.amazon.awscdk.IResolvable runConfiguration) {
            this.props.runConfiguration(runConfiguration);
            return this;
        }

        /**
         * A list of one or more tags to assign to the application.
         * <p>
         * A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
         * <p>
         * @return {@code this}
         * @param tags A list of one or more tags to assign to the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication build() {
            return new software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
