package software.amazon.awscdk.services.healthlake;

/**
 * A CloudFormation `AWS::HealthLake::FHIRDatastore`.
 * <p>
 * Creates a Data Store that can ingest and export FHIR formatted data.
 * <p>
 * <blockquote>
 * <p>
 * Please note that when a user tries to do an Update operation via CloudFormation, changes to the Data Store name, Type Version, PreloadDataConfig, or SSEConfiguration will delete their existing Data Store for the stack and create a new one. This will lead to potential loss of data.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.healthlake.*;
 * CfnFHIRDatastore cfnFHIRDatastore = CfnFHIRDatastore.Builder.create(this, "MyCfnFHIRDatastore")
 *         .datastoreTypeVersion("datastoreTypeVersion")
 *         // the properties below are optional
 *         .datastoreName("datastoreName")
 *         .preloadDataConfig(PreloadDataConfigProperty.builder()
 *                 .preloadDataType("preloadDataType")
 *                 .build())
 *         .sseConfiguration(SseConfigurationProperty.builder()
 *                 .kmsEncryptionConfig(KmsEncryptionConfigProperty.builder()
 *                         .cmkType("cmkType")
 *                         // the properties below are optional
 *                         .kmsKeyId("kmsKeyId")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:39.705Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore")
public class CfnFHIRDatastore extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFHIRDatastore(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFHIRDatastore(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::HealthLake::FHIRDatastore`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFHIRDatastore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.healthlake.CfnFHIRDatastoreProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Data Store ARN is generated during the creation of the Data Store and can be found in the output from the initial Data Store creation request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatastoreArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDatastoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint for the created Data Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatastoreEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrDatastoreEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon generated Data Store id.
     * <p>
     * This id is in the output from the initial Data Store creation call.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatastoreId() {
        return software.amazon.jsii.Kernel.get(this, "attrDatastoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the FHIR Data Store.
     * <p>
     * Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatastoreStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrDatastoreStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The FHIR version of the Data Store.
     * <p>
     * The only supported version is R4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatastoreTypeVersion() {
        return software.amazon.jsii.Kernel.get(this, "datastoreTypeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The FHIR version of the Data Store.
     * <p>
     * The only supported version is R4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastoreTypeVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datastoreTypeVersion", java.util.Objects.requireNonNull(value, "datastoreTypeVersion is required"));
    }

    /**
     * The user generated name for the Data Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatastoreName() {
        return software.amazon.jsii.Kernel.get(this, "datastoreName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user generated name for the Data Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastoreName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datastoreName", value);
    }

    /**
     * The preloaded data configuration for the Data Store.
     * <p>
     * Only data preloaded from Synthea is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPreloadDataConfig() {
        return software.amazon.jsii.Kernel.get(this, "preloadDataConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The preloaded data configuration for the Data Store.
     * <p>
     * Only data preloaded from Synthea is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreloadDataConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.PreloadDataConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "preloadDataConfig", value);
    }

    /**
     * The preloaded data configuration for the Data Store.
     * <p>
     * Only data preloaded from Synthea is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreloadDataConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "preloadDataConfig", value);
    }

    /**
     * The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSseConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "sseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSseConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.SseConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sseConfiguration", value);
    }

    /**
     * The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSseConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sseConfiguration", value);
    }
    /**
     * The customer-managed-key(CMK) used when creating a Data Store.
     * <p>
     * If a customer owned key is not specified, an Amazon owned key will be used for encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.healthlake.*;
     * KmsEncryptionConfigProperty kmsEncryptionConfigProperty = KmsEncryptionConfigProperty.builder()
     *         .cmkType("cmkType")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.KmsEncryptionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KmsEncryptionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KmsEncryptionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of customer-managed-key(CMK) used for encryption.
         * <p>
         * The two types of supported CMKs are customer owned CMKs and Amazon owned CMKs. For more information on CMK types, see <a href="https://docs.aws.amazon.com/healthlake/latest/APIReference/API_KmsEncryptionConfig.html#HealthLake-Type-KmsEncryptionConfig-CmkType">KmsEncryptionConfig</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCmkType();

        /**
         * The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KmsEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KmsEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KmsEncryptionConfigProperty> {
            java.lang.String cmkType;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link KmsEncryptionConfigProperty#getCmkType}
             * @param cmkType The type of customer-managed-key(CMK) used for encryption. This parameter is required.
             *                The two types of supported CMKs are customer owned CMKs and Amazon owned CMKs. For more information on CMK types, see <a href="https://docs.aws.amazon.com/healthlake/latest/APIReference/API_KmsEncryptionConfig.html#HealthLake-Type-KmsEncryptionConfig-CmkType">KmsEncryptionConfig</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmkType(java.lang.String cmkType) {
                this.cmkType = cmkType;
                return this;
            }

            /**
             * Sets the value of {@link KmsEncryptionConfigProperty#getKmsKeyId}
             * @param kmsKeyId The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KmsEncryptionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KmsEncryptionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KmsEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KmsEncryptionConfigProperty {
            private final java.lang.String cmkType;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cmkType = software.amazon.jsii.Kernel.get(this, "cmkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cmkType = java.util.Objects.requireNonNull(builder.cmkType, "cmkType is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getCmkType() {
                return this.cmkType;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cmkType", om.valueToTree(this.getCmkType()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.KmsEncryptionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KmsEncryptionConfigProperty.Jsii$Proxy that = (KmsEncryptionConfigProperty.Jsii$Proxy) o;

                if (!cmkType.equals(that.cmkType)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cmkType.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Optional parameter to preload data upon creation of the Data Store.
     * <p>
     * Currently, the only supported preloaded data is synthetic data generated from Synthea.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.healthlake.*;
     * PreloadDataConfigProperty preloadDataConfigProperty = PreloadDataConfigProperty.builder()
     *         .preloadDataType("preloadDataType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.PreloadDataConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PreloadDataConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PreloadDataConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of preloaded data.
         * <p>
         * Only Synthea preloaded data is supported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPreloadDataType();

        /**
         * @return a {@link Builder} of {@link PreloadDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PreloadDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PreloadDataConfigProperty> {
            java.lang.String preloadDataType;

            /**
             * Sets the value of {@link PreloadDataConfigProperty#getPreloadDataType}
             * @param preloadDataType The type of preloaded data. This parameter is required.
             *                        Only Synthea preloaded data is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preloadDataType(java.lang.String preloadDataType) {
                this.preloadDataType = preloadDataType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PreloadDataConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PreloadDataConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PreloadDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PreloadDataConfigProperty {
            private final java.lang.String preloadDataType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.preloadDataType = software.amazon.jsii.Kernel.get(this, "preloadDataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.preloadDataType = java.util.Objects.requireNonNull(builder.preloadDataType, "preloadDataType is required");
            }

            @Override
            public final java.lang.String getPreloadDataType() {
                return this.preloadDataType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("preloadDataType", om.valueToTree(this.getPreloadDataType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.PreloadDataConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PreloadDataConfigProperty.Jsii$Proxy that = (PreloadDataConfigProperty.Jsii$Proxy) o;

                return this.preloadDataType.equals(that.preloadDataType);
            }

            @Override
            public final int hashCode() {
                int result = this.preloadDataType.hashCode();
                return result;
            }
        }
    }
    /**
     * The server-side encryption key configuration for a customer provided encryption key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.healthlake.*;
     * SseConfigurationProperty sseConfigurationProperty = SseConfigurationProperty.builder()
     *         .kmsEncryptionConfig(KmsEncryptionConfigProperty.builder()
     *                 .cmkType("cmkType")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.SseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The server-side encryption key configuration for a customer provided encryption key (CMK).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKmsEncryptionConfig();

        /**
         * @return a {@link Builder} of {@link SseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SseConfigurationProperty> {
            java.lang.Object kmsEncryptionConfig;

            /**
             * Sets the value of {@link SseConfigurationProperty#getKmsEncryptionConfig}
             * @param kmsEncryptionConfig The server-side encryption key configuration for a customer provided encryption key (CMK). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsEncryptionConfig(software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.KmsEncryptionConfigProperty kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link SseConfigurationProperty#getKmsEncryptionConfig}
             * @param kmsEncryptionConfig The server-side encryption key configuration for a customer provided encryption key (CMK). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsEncryptionConfig(software.amazon.awscdk.IResolvable kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SseConfigurationProperty {
            private final java.lang.Object kmsEncryptionConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsEncryptionConfig = software.amazon.jsii.Kernel.get(this, "kmsEncryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsEncryptionConfig = java.util.Objects.requireNonNull(builder.kmsEncryptionConfig, "kmsEncryptionConfig is required");
            }

            @Override
            public final java.lang.Object getKmsEncryptionConfig() {
                return this.kmsEncryptionConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kmsEncryptionConfig", om.valueToTree(this.getKmsEncryptionConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.SseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SseConfigurationProperty.Jsii$Proxy that = (SseConfigurationProperty.Jsii$Proxy) o;

                return this.kmsEncryptionConfig.equals(that.kmsEncryptionConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.kmsEncryptionConfig.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.healthlake.CfnFHIRDatastore}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.healthlake.CfnFHIRDatastore> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.healthlake.CfnFHIRDatastoreProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.healthlake.CfnFHIRDatastoreProps.Builder();
        }

        /**
         * The FHIR version of the Data Store.
         * <p>
         * The only supported version is R4.
         * <p>
         * @return {@code this}
         * @param datastoreTypeVersion The FHIR version of the Data Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreTypeVersion(final java.lang.String datastoreTypeVersion) {
            this.props.datastoreTypeVersion(datastoreTypeVersion);
            return this;
        }

        /**
         * The user generated name for the Data Store.
         * <p>
         * @return {@code this}
         * @param datastoreName The user generated name for the Data Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreName(final java.lang.String datastoreName) {
            this.props.datastoreName(datastoreName);
            return this;
        }

        /**
         * The preloaded data configuration for the Data Store.
         * <p>
         * Only data preloaded from Synthea is supported.
         * <p>
         * @return {@code this}
         * @param preloadDataConfig The preloaded data configuration for the Data Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preloadDataConfig(final software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.PreloadDataConfigProperty preloadDataConfig) {
            this.props.preloadDataConfig(preloadDataConfig);
            return this;
        }
        /**
         * The preloaded data configuration for the Data Store.
         * <p>
         * Only data preloaded from Synthea is supported.
         * <p>
         * @return {@code this}
         * @param preloadDataConfig The preloaded data configuration for the Data Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preloadDataConfig(final software.amazon.awscdk.IResolvable preloadDataConfig) {
            this.props.preloadDataConfig(preloadDataConfig);
            return this;
        }

        /**
         * The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store.
         * <p>
         * @return {@code this}
         * @param sseConfiguration The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfiguration(final software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.SseConfigurationProperty sseConfiguration) {
            this.props.sseConfiguration(sseConfiguration);
            return this;
        }
        /**
         * The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store.
         * <p>
         * @return {@code this}
         * @param sseConfiguration The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfiguration(final software.amazon.awscdk.IResolvable sseConfiguration) {
            this.props.sseConfiguration(sseConfiguration);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.healthlake.CfnFHIRDatastore}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.healthlake.CfnFHIRDatastore build() {
            return new software.amazon.awscdk.services.healthlake.CfnFHIRDatastore(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
