package software.amazon.awscdk.services.greengrass;

/**
 * Properties for defining a `CfnFunctionDefinitionVersion`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * Object variables;
 * CfnFunctionDefinitionVersionProps cfnFunctionDefinitionVersionProps = CfnFunctionDefinitionVersionProps.builder()
 *         .functionDefinitionId("functionDefinitionId")
 *         .functions(List.of(FunctionProperty.builder()
 *                 .functionArn("functionArn")
 *                 .functionConfiguration(FunctionConfigurationProperty.builder()
 *                         .encodingType("encodingType")
 *                         .environment(EnvironmentProperty.builder()
 *                                 .accessSysfs(false)
 *                                 .execution(ExecutionProperty.builder()
 *                                         .isolationMode("isolationMode")
 *                                         .runAs(RunAsProperty.builder()
 *                                                 .gid(123)
 *                                                 .uid(123)
 *                                                 .build())
 *                                         .build())
 *                                 .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
 *                                         .resourceId("resourceId")
 *                                         // the properties below are optional
 *                                         .permission("permission")
 *                                         .build()))
 *                                 .variables(variables)
 *                                 .build())
 *                         .execArgs("execArgs")
 *                         .executable("executable")
 *                         .memorySize(123)
 *                         .pinned(false)
 *                         .timeout(123)
 *                         .build())
 *                 .id("id")
 *                 .build()))
 *         // the properties below are optional
 *         .defaultConfig(DefaultConfigProperty.builder()
 *                 .execution(ExecutionProperty.builder()
 *                         .isolationMode("isolationMode")
 *                         .runAs(RunAsProperty.builder()
 *                                 .gid(123)
 *                                 .uid(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:39.631Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnFunctionDefinitionVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFunctionDefinitionVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the function definition associated with this version.
     * <p>
     * This value is a GUID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionDefinitionId();

    /**
     * The functions in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFunctions();

    /**
     * The default configuration that applies to all Lambda functions in the group.
     * <p>
     * Individual Lambda functions can override these settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFunctionDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFunctionDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFunctionDefinitionVersionProps> {
        java.lang.String functionDefinitionId;
        java.lang.Object functions;
        java.lang.Object defaultConfig;

        /**
         * Sets the value of {@link CfnFunctionDefinitionVersionProps#getFunctionDefinitionId}
         * @param functionDefinitionId The ID of the function definition associated with this version. This parameter is required.
         *                             This value is a GUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionDefinitionId(java.lang.String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionDefinitionVersionProps#getFunctions}
         * @param functions The functions in this version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functions(software.amazon.awscdk.IResolvable functions) {
            this.functions = functions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionDefinitionVersionProps#getFunctions}
         * @param functions The functions in this version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functions(java.util.List<? extends java.lang.Object> functions) {
            this.functions = functions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionDefinitionVersionProps#getDefaultConfig}
         * @param defaultConfig The default configuration that applies to all Lambda functions in the group.
         *                      Individual Lambda functions can override these settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultConfig(software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.DefaultConfigProperty defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFunctionDefinitionVersionProps#getDefaultConfig}
         * @param defaultConfig The default configuration that applies to all Lambda functions in the group.
         *                      Individual Lambda functions can override these settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultConfig(software.amazon.awscdk.IResolvable defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFunctionDefinitionVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFunctionDefinitionVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFunctionDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFunctionDefinitionVersionProps {
        private final java.lang.String functionDefinitionId;
        private final java.lang.Object functions;
        private final java.lang.Object defaultConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionDefinitionId = software.amazon.jsii.Kernel.get(this, "functionDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functions = software.amazon.jsii.Kernel.get(this, "functions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultConfig = software.amazon.jsii.Kernel.get(this, "defaultConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionDefinitionId = java.util.Objects.requireNonNull(builder.functionDefinitionId, "functionDefinitionId is required");
            this.functions = java.util.Objects.requireNonNull(builder.functions, "functions is required");
            this.defaultConfig = builder.defaultConfig;
        }

        @Override
        public final java.lang.String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        public final java.lang.Object getFunctions() {
            return this.functions;
        }

        @Override
        public final java.lang.Object getDefaultConfig() {
            return this.defaultConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionDefinitionId", om.valueToTree(this.getFunctionDefinitionId()));
            data.set("functions", om.valueToTree(this.getFunctions()));
            if (this.getDefaultConfig() != null) {
                data.set("defaultConfig", om.valueToTree(this.getDefaultConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFunctionDefinitionVersionProps.Jsii$Proxy that = (CfnFunctionDefinitionVersionProps.Jsii$Proxy) o;

            if (!functionDefinitionId.equals(that.functionDefinitionId)) return false;
            if (!functions.equals(that.functions)) return false;
            return this.defaultConfig != null ? this.defaultConfig.equals(that.defaultConfig) : that.defaultConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionDefinitionId.hashCode();
            result = 31 * result + (this.functions.hashCode());
            result = 31 * result + (this.defaultConfig != null ? this.defaultConfig.hashCode() : 0);
            return result;
        }
    }
}
