package software.amazon.awscdk.services.elasticache;

/**
 * A CloudFormation `AWS::ElastiCache::ReplicationGroup`.
 * <p>
 * The <code>AWS::ElastiCache::ReplicationGroup</code> resource creates an Amazon ElastiCache Redis replication group. A Redis (cluster mode disabled) replication group is a collection of cache clusters, where one of the clusters is a primary read-write cluster and the others are read-only replicas.
 * <p>
 * A Redis (cluster mode enabled) cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed.
 * <p>
 * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html">Creating a Subnet Group</a> . For versions below 5.0.6, the limit is 250 per cluster.
 * <p>
 * To request a limit increase, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Service Limits</a> and choose the limit type <em>Nodes per cluster per instance type</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnReplicationGroup cfnReplicationGroup = CfnReplicationGroup.Builder.create(this, "MyCfnReplicationGroup")
 *         .replicationGroupDescription("replicationGroupDescription")
 *         // the properties below are optional
 *         .atRestEncryptionEnabled(false)
 *         .authToken("authToken")
 *         .automaticFailoverEnabled(false)
 *         .autoMinorVersionUpgrade(false)
 *         .cacheNodeType("cacheNodeType")
 *         .cacheParameterGroupName("cacheParameterGroupName")
 *         .cacheSecurityGroupNames(List.of("cacheSecurityGroupNames"))
 *         .cacheSubnetGroupName("cacheSubnetGroupName")
 *         .dataTieringEnabled(false)
 *         .engine("engine")
 *         .engineVersion("engineVersion")
 *         .globalReplicationGroupId("globalReplicationGroupId")
 *         .kmsKeyId("kmsKeyId")
 *         .logDeliveryConfigurations(List.of(LogDeliveryConfigurationRequestProperty.builder()
 *                 .destinationDetails(DestinationDetailsProperty.builder()
 *                         .cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty.builder()
 *                                 .logGroup("logGroup")
 *                                 .build())
 *                         .kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty.builder()
 *                                 .deliveryStream("deliveryStream")
 *                                 .build())
 *                         .build())
 *                 .destinationType("destinationType")
 *                 .logFormat("logFormat")
 *                 .logType("logType")
 *                 .build()))
 *         .multiAzEnabled(false)
 *         .nodeGroupConfiguration(List.of(NodeGroupConfigurationProperty.builder()
 *                 .nodeGroupId("nodeGroupId")
 *                 .primaryAvailabilityZone("primaryAvailabilityZone")
 *                 .replicaAvailabilityZones(List.of("replicaAvailabilityZones"))
 *                 .replicaCount(123)
 *                 .slots("slots")
 *                 .build()))
 *         .notificationTopicArn("notificationTopicArn")
 *         .numCacheClusters(123)
 *         .numNodeGroups(123)
 *         .port(123)
 *         .preferredCacheClusterAZs(List.of("preferredCacheClusterAZs"))
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .primaryClusterId("primaryClusterId")
 *         .replicasPerNodeGroup(123)
 *         .replicationGroupId("replicationGroupId")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .snapshotArns(List.of("snapshotArns"))
 *         .snapshotName("snapshotName")
 *         .snapshotRetentionLimit(123)
 *         .snapshottingClusterId("snapshottingClusterId")
 *         .snapshotWindow("snapshotWindow")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitEncryptionEnabled(false)
 *         .userGroupIds(List.of("userGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:38.987Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnReplicationGroup")
public class CfnReplicationGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnReplicationGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReplicationGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticache.CfnReplicationGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ElastiCache::ReplicationGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnReplicationGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticache.CfnReplicationGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The DNS hostname of the cache node.
     * <p>
     * <blockquote>
     * <p>
     * Redis (cluster mode disabled) replication groups don't have this attribute. Therefore, <code>Fn::GetAtt</code> returns a value for this attribute only if the replication group is clustered. Otherwise, <code>Fn::GetAtt</code> fails. For Redis (cluster mode disabled) replication groups, use the <code>PrimaryEndpoint</code> or <code>ReadEndpoint</code> attributes.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationEndPointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationEndPointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number that the cache engine is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationEndPointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationEndPointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS address of the primary read-write cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrimaryEndPointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrPrimaryEndPointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of the port that the primary read-write cache engine is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrimaryEndPointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrPrimaryEndPointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string with a list of endpoints for the primary and read-only replicas.
     * <p>
     * The order of the addresses maps to the order of the ports from the <code>ReadEndPoint.Ports</code> attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReadEndPointAddresses() {
        return software.amazon.jsii.Kernel.get(this, "attrReadEndPointAddresses", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string with a list of endpoints for the read-only replicas.
     * <p>
     * The order of the addresses maps to the order of the ports from the <code>ReadEndPoint.Ports</code> attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrReadEndPointAddressesList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrReadEndPointAddressesList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A string with a list of ports for the read-only replicas.
     * <p>
     * The order of the ports maps to the order of the addresses from the <code>ReadEndPoint.Addresses</code> attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReadEndPointPorts() {
        return software.amazon.jsii.Kernel.get(this, "attrReadEndPointPorts", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string with a list of ports for the read-only replicas.
     * <p>
     * The order of the ports maps to the order of the addresses from the ReadEndPoint.Addresses attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrReadEndPointPortsList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrReadEndPointPortsList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The address of the reader endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReaderEndPointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrReaderEndPointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port used by the reader endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReaderEndPointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrReaderEndPointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of tags to be added to this resource.
     * <p>
     * Tags are comma-separated key,value pairs (e.g. Key= <code>myKey</code> , Value= <code>myKeyValue</code> . You can include multiple tags as shown following: Key= <code>myKey</code> , Value= <code>myKeyValue</code> Key= <code>mySecondKey</code> , Value= <code>mySecondKeyValue</code> . Tags on replication groups will be replicated to all nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A user-created description for the replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReplicationGroupDescription() {
        return software.amazon.jsii.Kernel.get(this, "replicationGroupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-created description for the replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationGroupDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicationGroupDescription", java.util.Objects.requireNonNull(value, "replicationGroupDescription is required"));
    }

    /**
     * A flag that enables encryption at rest when set to `true` .
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     * <p>
     * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAtRestEncryptionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "atRestEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A flag that enables encryption at rest when set to `true` .
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     * <p>
     * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAtRestEncryptionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "atRestEncryptionEnabled", value);
    }

    /**
     * A flag that enables encryption at rest when set to `true` .
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     * <p>
     * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAtRestEncryptionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "atRestEncryptionEnabled", value);
    }

    /**
     * *Reserved parameter.* The password used to access a password protected server.
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with the Redis AUTH Command</a> .
     * <p>
     * <blockquote>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
     * <p>
     * </blockquote>
     * <p>
     * Password constraints:
     * <p>
     * <ul>
     * <li>Must be only printable ASCII characters.</li>
     * <li>Must be at least 16 characters and no more than 128 characters in length.</li>
     * <li>Nonalphanumeric characters are restricted to (!, &amp;, #, $, ^, &lt;, &gt;, -, ).</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthToken() {
        return software.amazon.jsii.Kernel.get(this, "authToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * *Reserved parameter.* The password used to access a password protected server.
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with the Redis AUTH Command</a> .
     * <p>
     * <blockquote>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
     * <p>
     * </blockquote>
     * <p>
     * Password constraints:
     * <p>
     * <ul>
     * <li>Must be only printable ASCII characters.</li>
     * <li>Must be at least 16 characters and no more than 128 characters in length.</li>
     * <li>Nonalphanumeric characters are restricted to (!, &amp;, #, $, ^, &lt;, &gt;, -, ).</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthToken(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authToken", value);
    }

    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFailoverEnabled() {
        return software.amazon.jsii.Kernel.get(this, "automaticFailoverEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomaticFailoverEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "automaticFailoverEnabled", value);
    }

    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomaticFailoverEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "automaticFailoverEnabled", value);
    }

    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * The compute and memory capacity of the nodes in the node group (shard).
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
     * <p>
     * <ul>
     * <li>General purpose:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.24xlarge</code>
     * <p>
     * <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
     * <p>
     * <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
     * <p>
     * <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
     * <p>
     * <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
     * <p>
     * <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>T1 node types:</em> <code>cache.t1.micro</code>
     * <p>
     * <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
     * <p>
     * <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
     * <p>
     * <ul>
     * <li>Compute optimized:</li>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>C1 node types:</em> <code>cache.c1.xlarge</code>
     * <p>
     * <ul>
     * <li>Memory optimized:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
     * <p>
     * </blockquote>
     * <p>
     * <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.24xlarge</code>
     * <p>
     * <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
     * <p>
     * <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
     * <p>
     * <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
     * <p>
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Amazon Region</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheNodeType() {
        return software.amazon.jsii.Kernel.get(this, "cacheNodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compute and memory capacity of the nodes in the node group (shard).
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
     * <p>
     * <ul>
     * <li>General purpose:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.24xlarge</code>
     * <p>
     * <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
     * <p>
     * <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
     * <p>
     * <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
     * <p>
     * <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
     * <p>
     * <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>T1 node types:</em> <code>cache.t1.micro</code>
     * <p>
     * <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
     * <p>
     * <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
     * <p>
     * <ul>
     * <li>Compute optimized:</li>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>C1 node types:</em> <code>cache.c1.xlarge</code>
     * <p>
     * <ul>
     * <li>Memory optimized:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
     * <p>
     * </blockquote>
     * <p>
     * <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.24xlarge</code>
     * <p>
     * <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
     * <p>
     * <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
     * <p>
     * <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
     * <p>
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Amazon Region</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheNodeType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheNodeType", value);
    }

    /**
     * The name of the parameter group to associate with this replication group.
     * <p>
     * If this argument is omitted, the default cache parameter group for the specified engine is used.
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name.
     * <p>
     * <ul>
     * <li>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code> .</li>
     * <li>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "cacheParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the parameter group to associate with this replication group.
     * <p>
     * If this argument is omitted, the default cache parameter group for the specified engine is used.
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name.
     * <p>
     * <ul>
     * <li>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code> .</li>
     * <li>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheParameterGroupName", value);
    }

    /**
     * A list of cache security group names to associate with this replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCacheSecurityGroupNames() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "cacheSecurityGroupNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of cache security group names to associate with this replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheSecurityGroupNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "cacheSecurityGroupNames", value);
    }

    /**
     * The name of the cache subnet group to be used for the replication group.
     * <p>
     * <blockquote>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html">AWS::ElastiCache::SubnetGroup</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "cacheSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cache subnet group to be used for the replication group.
     * <p>
     * <blockquote>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html">AWS::ElastiCache::SubnetGroup</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheSubnetGroupName", value);
    }

    /**
     * Enables data tiering.
     * <p>
     * Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataTieringEnabled() {
        return software.amazon.jsii.Kernel.get(this, "dataTieringEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables data tiering.
     * <p>
     * Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataTieringEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "dataTieringEnabled", value);
    }

    /**
     * Enables data tiering.
     * <p>
     * Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataTieringEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataTieringEnabled", value);
    }

    /**
     * The name of the cache engine to be used for the clusters in this replication group.
     * <p>
     * Must be Redis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cache engine to be used for the clusters in this replication group.
     * <p>
     * Must be Redis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     * The version number of the cache engine to be used for the clusters in this replication group.
     * <p>
     * To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * <p>
     * <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ) in the <em>ElastiCache User Guide</em> , but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the cache engine to be used for the clusters in this replication group.
     * <p>
     * To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * <p>
     * <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ) in the <em>ElastiCache User Guide</em> , but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * The name of the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGlobalReplicationGroupId() {
        return software.amazon.jsii.Kernel.get(this, "globalReplicationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalReplicationGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "globalReplicationGroupId", value);
    }

    /**
     * The ID of the KMS key used to encrypt the disk on the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the KMS key used to encrypt the disk on the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Specifies the destination, format and type of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogDeliveryConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "logDeliveryConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the destination, format and type of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDeliveryConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logDeliveryConfigurations", value);
    }

    /**
     * Specifies the destination, format and type of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDeliveryConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticache.CfnReplicationGroup.LogDeliveryConfigurationRequestProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.elasticache.CfnReplicationGroup.LogDeliveryConfigurationRequestProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "logDeliveryConfigurations", value);
    }

    /**
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiAzEnabled() {
        return software.amazon.jsii.Kernel.get(this, "multiAzEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiAzEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiAzEnabled", value);
    }

    /**
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiAzEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiAzEnabled", value);
    }

    /**
     * `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
     * <p>
     * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NodeGroupConfiguration</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NodeGroupConfiguration</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodeGroupConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "nodeGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
     * <p>
     * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NodeGroupConfiguration</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NodeGroupConfiguration</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeGroupConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "nodeGroupConfiguration", value);
    }

    /**
     * `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
     * <p>
     * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NodeGroupConfiguration</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NodeGroupConfiguration</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeGroupConfiguration(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticache.CfnReplicationGroup.NodeGroupConfigurationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.elasticache.CfnReplicationGroup.NodeGroupConfigurationProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "nodeGroupConfiguration", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     * <p>
     * <blockquote>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNotificationTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "notificationTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     * <p>
     * <blockquote>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationTopicArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "notificationTopicArn", value);
    }

    /**
     * The number of clusters this replication group initially has.
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code> , the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getNumCacheClusters() {
        return software.amazon.jsii.Kernel.get(this, "numCacheClusters", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of clusters this replication group initially has.
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code> , the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNumCacheClusters(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "numCacheClusters", value);
    }

    /**
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group.
     * <p>
     * For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * <p>
     * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NumNodeGroups</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NumNodeGroups</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getNumNodeGroups() {
        return software.amazon.jsii.Kernel.get(this, "numNodeGroups", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group.
     * <p>
     * For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * <p>
     * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NumNodeGroups</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NumNodeGroups</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNumNodeGroups(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "numNodeGroups", value);
    }

    /**
     * The port number on which each member of the replication group accepts connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port number on which each member of the replication group accepts connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * A list of EC2 Availability Zones in which the replication group's clusters are created.
     * <p>
     * The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.
     * <p>
     * <blockquote>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code> .
     * <p>
     * </blockquote>
     * <p>
     * Default: system chosen Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPreferredCacheClusterAZs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "preferredCacheClusterAZs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of EC2 Availability Zones in which the replication group's clusters are created.
     * <p>
     * The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.
     * <p>
     * <blockquote>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code> .
     * <p>
     * </blockquote>
     * <p>
     * Default: system chosen Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredCacheClusterAZs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "preferredCacheClusterAZs", value);
    }

    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed.
     * <p>
     * It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * <p>
     * Valid values for <code>ddd</code> are:
     * <p>
     * <ul>
     * <li><code>sun</code></li>
     * <li><code>mon</code></li>
     * <li><code>tue</code></li>
     * <li><code>wed</code></li>
     * <li><code>thu</code></li>
     * <li><code>fri</code></li>
     * <li><code>sat</code></li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed.
     * <p>
     * It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * <p>
     * Valid values for <code>ddd</code> are:
     * <p>
     * <ul>
     * <li><code>sun</code></li>
     * <li><code>mon</code></li>
     * <li><code>tue</code></li>
     * <li><code>wed</code></li>
     * <li><code>thu</code></li>
     * <li><code>fri</code></li>
     * <li><code>sat</code></li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * The identifier of the cluster that serves as the primary for this replication group.
     * <p>
     * This cluster must already exist and have a status of <code>available</code> .
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code> , <code>NumNodeGroups</code> , or <code>ReplicasPerNodeGroup</code> is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrimaryClusterId() {
        return software.amazon.jsii.Kernel.get(this, "primaryClusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the cluster that serves as the primary for this replication group.
     * <p>
     * This cluster must already exist and have a status of <code>available</code> .
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code> , <code>NumNodeGroups</code> , or <code>ReplicasPerNodeGroup</code> is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrimaryClusterId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "primaryClusterId", value);
    }

    /**
     * An optional parameter that specifies the number of replica nodes in each node group (shard).
     * <p>
     * Valid values are 0 to 5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getReplicasPerNodeGroup() {
        return software.amazon.jsii.Kernel.get(this, "replicasPerNodeGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * An optional parameter that specifies the number of replica nodes in each node group (shard).
     * <p>
     * Valid values are 0 to 5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicasPerNodeGroup(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "replicasPerNodeGroup", value);
    }

    /**
     * The replication group identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>A name must contain from 1 to 40 alphanumeric characters or hyphens.</li>
     * <li>The first character must be a letter.</li>
     * <li>A name cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReplicationGroupId() {
        return software.amazon.jsii.Kernel.get(this, "replicationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The replication group identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>A name must contain from 1 to 40 alphanumeric characters or hyphens.</li>
     * <li>The first character must be a letter.</li>
     * <li>A name cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicationGroupId", value);
    }

    /**
     * One or more Amazon VPC security groups associated with this replication group.
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more Amazon VPC security groups associated with this replication group.
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * <p>
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <em>NumNodeGroups</em> or the number of node groups configured by <em>NodeGroupConfiguration</em> regardless of the number of ARNs specified here.
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSnapshotArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "snapshotArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * <p>
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <em>NumNodeGroups</em> or the number of node groups configured by <em>NodeGroupConfiguration</em> regardless of the number of ARNs specified here.
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "snapshotArns", value);
    }

    /**
     * The name of a snapshot from which to restore data into the new replication group.
     * <p>
     * The snapshot status changes to <code>restoring</code> while the new replication group is being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotName() {
        return software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a snapshot from which to restore data into the new replication group.
     * <p>
     * The snapshot status changes to <code>restoring</code> while the new replication group is being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotName", value);
    }

    /**
     * The number of days for which ElastiCache retains automatic snapshots before deleting them.
     * <p>
     * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotRetentionLimit() {
        return software.amazon.jsii.Kernel.get(this, "snapshotRetentionLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days for which ElastiCache retains automatic snapshots before deleting them.
     * <p>
     * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotRetentionLimit(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "snapshotRetentionLimit", value);
    }

    /**
     * The cluster ID that is used as the daily snapshot source for the replication group.
     * <p>
     * This parameter cannot be set for Redis (cluster mode enabled) replication groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshottingClusterId() {
        return software.amazon.jsii.Kernel.get(this, "snapshottingClusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cluster ID that is used as the daily snapshot source for the replication group.
     * <p>
     * This parameter cannot be set for Redis (cluster mode enabled) replication groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshottingClusterId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshottingClusterId", value);
    }

    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * <p>
     * Example: <code>05:00-09:00</code>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotWindow() {
        return software.amazon.jsii.Kernel.get(this, "snapshotWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * <p>
     * Example: <code>05:00-09:00</code>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotWindow", value);
    }

    /**
     * A flag that enables in-transit encryption when set to `true` .
     * <p>
     * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code> , the <code>EngineVersion</code> parameter is <code>3.2.6</code> or <code>4.x</code> onward, and the cluster is being created in an Amazon VPC.
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code> .
     * <p>
     * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
     * <p>
     * Default: <code>false</code>
     * <p>
     * <blockquote>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTransitEncryptionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "transitEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A flag that enables in-transit encryption when set to `true` .
     * <p>
     * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code> , the <code>EngineVersion</code> parameter is <code>3.2.6</code> or <code>4.x</code> onward, and the cluster is being created in an Amazon VPC.
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code> .
     * <p>
     * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
     * <p>
     * Default: <code>false</code>
     * <p>
     * <blockquote>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitEncryptionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "transitEncryptionEnabled", value);
    }

    /**
     * A flag that enables in-transit encryption when set to `true` .
     * <p>
     * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code> , the <code>EngineVersion</code> parameter is <code>3.2.6</code> or <code>4.x</code> onward, and the cluster is being created in an Amazon VPC.
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code> .
     * <p>
     * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
     * <p>
     * Default: <code>false</code>
     * <p>
     * <blockquote>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitEncryptionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "transitEncryptionEnabled", value);
    }

    /**
     * The list of user groups to associate with the replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUserGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "userGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of user groups to associate with the replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "userGroupIds", value);
    }
    /**
     * The configuration details of the CloudWatch Logs destination.
     * <p>
     * Note that this field is marked as required but only if CloudWatch Logs was chosen as the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * CloudWatchLogsDestinationDetailsProperty cloudWatchLogsDestinationDetailsProperty = CloudWatchLogsDestinationDetailsProperty.builder()
     *         .logGroup("logGroup")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnReplicationGroup.CloudWatchLogsDestinationDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsDestinationDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsDestinationDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch Logs log group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroup();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsDestinationDetailsProperty> {
            java.lang.String logGroup;

            /**
             * Sets the value of {@link CloudWatchLogsDestinationDetailsProperty#getLogGroup}
             * @param logGroup The name of the CloudWatch Logs log group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroup(java.lang.String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsDestinationDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsDestinationDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsDestinationDetailsProperty {
            private final java.lang.String logGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroup = java.util.Objects.requireNonNull(builder.logGroup, "logGroup is required");
            }

            @Override
            public final java.lang.String getLogGroup() {
                return this.logGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroup", om.valueToTree(this.getLogGroup()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnReplicationGroup.CloudWatchLogsDestinationDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsDestinationDetailsProperty.Jsii$Proxy that = (CloudWatchLogsDestinationDetailsProperty.Jsii$Proxy) o;

                return this.logGroup.equals(that.logGroup);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroup.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * DestinationDetailsProperty destinationDetailsProperty = DestinationDetailsProperty.builder()
     *         .cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty.builder()
     *                 .logGroup("logGroup")
     *                 .build())
     *         .kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty.builder()
     *                 .deliveryStream("deliveryStream")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnReplicationGroup.DestinationDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration details of the CloudWatch Logs destination.
         * <p>
         * Note that this field is marked as required but only if CloudWatch Logs was chosen as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogsDetails() {
            return null;
        }

        /**
         * The configuration details of the Kinesis Data Firehose destination.
         * <p>
         * Note that this field is marked as required but only if Kinesis Data Firehose was chosen as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseDetails() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationDetailsProperty> {
            java.lang.Object cloudWatchLogsDetails;
            java.lang.Object kinesisFirehoseDetails;

            /**
             * Sets the value of {@link DestinationDetailsProperty#getCloudWatchLogsDetails}
             * @param cloudWatchLogsDetails The configuration details of the CloudWatch Logs destination.
             *                              Note that this field is marked as required but only if CloudWatch Logs was chosen as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsDetails(software.amazon.awscdk.services.elasticache.CfnReplicationGroup.CloudWatchLogsDestinationDetailsProperty cloudWatchLogsDetails) {
                this.cloudWatchLogsDetails = cloudWatchLogsDetails;
                return this;
            }

            /**
             * Sets the value of {@link DestinationDetailsProperty#getCloudWatchLogsDetails}
             * @param cloudWatchLogsDetails The configuration details of the CloudWatch Logs destination.
             *                              Note that this field is marked as required but only if CloudWatch Logs was chosen as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsDetails(software.amazon.awscdk.IResolvable cloudWatchLogsDetails) {
                this.cloudWatchLogsDetails = cloudWatchLogsDetails;
                return this;
            }

            /**
             * Sets the value of {@link DestinationDetailsProperty#getKinesisFirehoseDetails}
             * @param kinesisFirehoseDetails The configuration details of the Kinesis Data Firehose destination.
             *                               Note that this field is marked as required but only if Kinesis Data Firehose was chosen as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDetails(software.amazon.awscdk.services.elasticache.CfnReplicationGroup.KinesisFirehoseDestinationDetailsProperty kinesisFirehoseDetails) {
                this.kinesisFirehoseDetails = kinesisFirehoseDetails;
                return this;
            }

            /**
             * Sets the value of {@link DestinationDetailsProperty#getKinesisFirehoseDetails}
             * @param kinesisFirehoseDetails The configuration details of the Kinesis Data Firehose destination.
             *                               Note that this field is marked as required but only if Kinesis Data Firehose was chosen as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDetails(software.amazon.awscdk.IResolvable kinesisFirehoseDetails) {
                this.kinesisFirehoseDetails = kinesisFirehoseDetails;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationDetailsProperty {
            private final java.lang.Object cloudWatchLogsDetails;
            private final java.lang.Object kinesisFirehoseDetails;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsDetails = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisFirehoseDetails = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsDetails = builder.cloudWatchLogsDetails;
                this.kinesisFirehoseDetails = builder.kinesisFirehoseDetails;
            }

            @Override
            public final java.lang.Object getCloudWatchLogsDetails() {
                return this.cloudWatchLogsDetails;
            }

            @Override
            public final java.lang.Object getKinesisFirehoseDetails() {
                return this.kinesisFirehoseDetails;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsDetails() != null) {
                    data.set("cloudWatchLogsDetails", om.valueToTree(this.getCloudWatchLogsDetails()));
                }
                if (this.getKinesisFirehoseDetails() != null) {
                    data.set("kinesisFirehoseDetails", om.valueToTree(this.getKinesisFirehoseDetails()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnReplicationGroup.DestinationDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationDetailsProperty.Jsii$Proxy that = (DestinationDetailsProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogsDetails != null ? !this.cloudWatchLogsDetails.equals(that.cloudWatchLogsDetails) : that.cloudWatchLogsDetails != null) return false;
                return this.kinesisFirehoseDetails != null ? this.kinesisFirehoseDetails.equals(that.kinesisFirehoseDetails) : that.kinesisFirehoseDetails == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsDetails != null ? this.cloudWatchLogsDetails.hashCode() : 0;
                result = 31 * result + (this.kinesisFirehoseDetails != null ? this.kinesisFirehoseDetails.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration details of the Kinesis Data Firehose destination.
     * <p>
     * Note that this field is marked as required but only if Kinesis Data Firehose was chosen as the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * KinesisFirehoseDestinationDetailsProperty kinesisFirehoseDestinationDetailsProperty = KinesisFirehoseDestinationDetailsProperty.builder()
     *         .deliveryStream("deliveryStream")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnReplicationGroup.KinesisFirehoseDestinationDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseDestinationDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseDestinationDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Kinesis Data Firehose delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStream();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseDestinationDetailsProperty> {
            java.lang.String deliveryStream;

            /**
             * Sets the value of {@link KinesisFirehoseDestinationDetailsProperty#getDeliveryStream}
             * @param deliveryStream The name of the Kinesis Data Firehose delivery stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStream(java.lang.String deliveryStream) {
                this.deliveryStream = deliveryStream;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseDestinationDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseDestinationDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseDestinationDetailsProperty {
            private final java.lang.String deliveryStream;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryStream = software.amazon.jsii.Kernel.get(this, "deliveryStream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryStream = java.util.Objects.requireNonNull(builder.deliveryStream, "deliveryStream is required");
            }

            @Override
            public final java.lang.String getDeliveryStream() {
                return this.deliveryStream;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deliveryStream", om.valueToTree(this.getDeliveryStream()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnReplicationGroup.KinesisFirehoseDestinationDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseDestinationDetailsProperty.Jsii$Proxy that = (KinesisFirehoseDestinationDetailsProperty.Jsii$Proxy) o;

                return this.deliveryStream.equals(that.deliveryStream);
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryStream.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the destination, format and type of the logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * LogDeliveryConfigurationRequestProperty logDeliveryConfigurationRequestProperty = LogDeliveryConfigurationRequestProperty.builder()
     *         .destinationDetails(DestinationDetailsProperty.builder()
     *                 .cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty.builder()
     *                         .logGroup("logGroup")
     *                         .build())
     *                 .kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty.builder()
     *                         .deliveryStream("deliveryStream")
     *                         .build())
     *                 .build())
     *         .destinationType("destinationType")
     *         .logFormat("logFormat")
     *         .logType("logType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnReplicationGroup.LogDeliveryConfigurationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(LogDeliveryConfigurationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogDeliveryConfigurationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationDetails();

        /**
         * Specify either CloudWatch Logs or Kinesis Data Firehose as the destination type.
         * <p>
         * Valid values are either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationType();

        /**
         * Valid values are either `json` or `text` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogFormat();

        /**
         * Valid value is either `slow-log` , which refers to [slow-log](https://docs.aws.amazon.com/https://redis.io/commands/slowlog) or `engine-log` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogType();

        /**
         * @return a {@link Builder} of {@link LogDeliveryConfigurationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogDeliveryConfigurationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogDeliveryConfigurationRequestProperty> {
            java.lang.Object destinationDetails;
            java.lang.String destinationType;
            java.lang.String logFormat;
            java.lang.String logType;

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getDestinationDetails}
             * @param destinationDetails Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationDetails(software.amazon.awscdk.services.elasticache.CfnReplicationGroup.DestinationDetailsProperty destinationDetails) {
                this.destinationDetails = destinationDetails;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getDestinationDetails}
             * @param destinationDetails Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationDetails(software.amazon.awscdk.IResolvable destinationDetails) {
                this.destinationDetails = destinationDetails;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getDestinationType}
             * @param destinationType Specify either CloudWatch Logs or Kinesis Data Firehose as the destination type. This parameter is required.
             *                        Valid values are either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationType(java.lang.String destinationType) {
                this.destinationType = destinationType;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getLogFormat}
             * @param logFormat Valid values are either `json` or `text` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logFormat(java.lang.String logFormat) {
                this.logFormat = logFormat;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getLogType}
             * @param logType Valid value is either `slow-log` , which refers to [slow-log](https://docs.aws.amazon.com/https://redis.io/commands/slowlog) or `engine-log` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logType(java.lang.String logType) {
                this.logType = logType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogDeliveryConfigurationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogDeliveryConfigurationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogDeliveryConfigurationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDeliveryConfigurationRequestProperty {
            private final java.lang.Object destinationDetails;
            private final java.lang.String destinationType;
            private final java.lang.String logFormat;
            private final java.lang.String logType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationDetails = software.amazon.jsii.Kernel.get(this, "destinationDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationType = software.amazon.jsii.Kernel.get(this, "destinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logFormat = software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logType = software.amazon.jsii.Kernel.get(this, "logType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationDetails = java.util.Objects.requireNonNull(builder.destinationDetails, "destinationDetails is required");
                this.destinationType = java.util.Objects.requireNonNull(builder.destinationType, "destinationType is required");
                this.logFormat = java.util.Objects.requireNonNull(builder.logFormat, "logFormat is required");
                this.logType = java.util.Objects.requireNonNull(builder.logType, "logType is required");
            }

            @Override
            public final java.lang.Object getDestinationDetails() {
                return this.destinationDetails;
            }

            @Override
            public final java.lang.String getDestinationType() {
                return this.destinationType;
            }

            @Override
            public final java.lang.String getLogFormat() {
                return this.logFormat;
            }

            @Override
            public final java.lang.String getLogType() {
                return this.logType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationDetails", om.valueToTree(this.getDestinationDetails()));
                data.set("destinationType", om.valueToTree(this.getDestinationType()));
                data.set("logFormat", om.valueToTree(this.getLogFormat()));
                data.set("logType", om.valueToTree(this.getLogType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnReplicationGroup.LogDeliveryConfigurationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogDeliveryConfigurationRequestProperty.Jsii$Proxy that = (LogDeliveryConfigurationRequestProperty.Jsii$Proxy) o;

                if (!destinationDetails.equals(that.destinationDetails)) return false;
                if (!destinationType.equals(that.destinationType)) return false;
                if (!logFormat.equals(that.logFormat)) return false;
                return this.logType.equals(that.logType);
            }

            @Override
            public final int hashCode() {
                int result = this.destinationDetails.hashCode();
                result = 31 * result + (this.destinationType.hashCode());
                result = 31 * result + (this.logFormat.hashCode());
                result = 31 * result + (this.logType.hashCode());
                return result;
            }
        }
    }
    /**
     * `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * NodeGroupConfigurationProperty nodeGroupConfigurationProperty = NodeGroupConfigurationProperty.builder()
     *         .nodeGroupId("nodeGroupId")
     *         .primaryAvailabilityZone("primaryAvailabilityZone")
     *         .replicaAvailabilityZones(List.of("replicaAvailabilityZones"))
     *         .replicaCount(123)
     *         .slots("slots")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnReplicationGroup.NodeGroupConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeGroupConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeGroupConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these configuration values apply to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNodeGroupId() {
            return null;
        }

        /**
         * The Availability Zone where the primary node of this node group (shard) is launched.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrimaryAvailabilityZone() {
            return null;
        }

        /**
         * A list of Availability Zones to be used for the read replicas.
         * <p>
         * The number of Availability Zones in this list must match the value of <code>ReplicaCount</code> or <code>ReplicasPerNodeGroup</code> if not specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReplicaAvailabilityZones() {
            return null;
        }

        /**
         * The number of read replica nodes in this node group (shard).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReplicaCount() {
            return null;
        }

        /**
         * A string of comma-separated values where the first set of values are the slot numbers (zero based), and the second set of values are the keyspaces for each slot.
         * <p>
         * The following example specifies three slots (numbered 0, 1, and 2): <code>0,1,2,0-4999,5000-9999,10000-16,383</code> .
         * <p>
         * If you don't specify a value, ElastiCache allocates keys equally among each slot.
         * <p>
         * When you use an <code>UseOnlineResharding</code> update policy to update the number of node groups without interruption, ElastiCache evenly distributes the keyspaces between the specified number of slots. This cannot be updated later. Therefore, after updating the number of node groups in this way, you should remove the value specified for the <code>Slots</code> property of each <code>NodeGroupConfiguration</code> from the stack template, as it no longer reflects the actual values in each node group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding Policy</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlots() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeGroupConfigurationProperty> {
            java.lang.String nodeGroupId;
            java.lang.String primaryAvailabilityZone;
            java.util.List<java.lang.String> replicaAvailabilityZones;
            java.lang.Number replicaCount;
            java.lang.String slots;

            /**
             * Sets the value of {@link NodeGroupConfigurationProperty#getNodeGroupId}
             * @param nodeGroupId Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these configuration values apply to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeGroupId(java.lang.String nodeGroupId) {
                this.nodeGroupId = nodeGroupId;
                return this;
            }

            /**
             * Sets the value of {@link NodeGroupConfigurationProperty#getPrimaryAvailabilityZone}
             * @param primaryAvailabilityZone The Availability Zone where the primary node of this node group (shard) is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryAvailabilityZone(java.lang.String primaryAvailabilityZone) {
                this.primaryAvailabilityZone = primaryAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link NodeGroupConfigurationProperty#getReplicaAvailabilityZones}
             * @param replicaAvailabilityZones A list of Availability Zones to be used for the read replicas.
             *                                 The number of Availability Zones in this list must match the value of <code>ReplicaCount</code> or <code>ReplicasPerNodeGroup</code> if not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicaAvailabilityZones(java.util.List<java.lang.String> replicaAvailabilityZones) {
                this.replicaAvailabilityZones = replicaAvailabilityZones;
                return this;
            }

            /**
             * Sets the value of {@link NodeGroupConfigurationProperty#getReplicaCount}
             * @param replicaCount The number of read replica nodes in this node group (shard).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicaCount(java.lang.Number replicaCount) {
                this.replicaCount = replicaCount;
                return this;
            }

            /**
             * Sets the value of {@link NodeGroupConfigurationProperty#getSlots}
             * @param slots A string of comma-separated values where the first set of values are the slot numbers (zero based), and the second set of values are the keyspaces for each slot.
             *              The following example specifies three slots (numbered 0, 1, and 2): <code>0,1,2,0-4999,5000-9999,10000-16,383</code> .
             *              <p>
             *              If you don't specify a value, ElastiCache allocates keys equally among each slot.
             *              <p>
             *              When you use an <code>UseOnlineResharding</code> update policy to update the number of node groups without interruption, ElastiCache evenly distributes the keyspaces between the specified number of slots. This cannot be updated later. Therefore, after updating the number of node groups in this way, you should remove the value specified for the <code>Slots</code> property of each <code>NodeGroupConfiguration</code> from the stack template, as it no longer reflects the actual values in each node group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding Policy</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slots(java.lang.String slots) {
                this.slots = slots;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeGroupConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeGroupConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeGroupConfigurationProperty {
            private final java.lang.String nodeGroupId;
            private final java.lang.String primaryAvailabilityZone;
            private final java.util.List<java.lang.String> replicaAvailabilityZones;
            private final java.lang.Number replicaCount;
            private final java.lang.String slots;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nodeGroupId = software.amazon.jsii.Kernel.get(this, "nodeGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryAvailabilityZone = software.amazon.jsii.Kernel.get(this, "primaryAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replicaAvailabilityZones = software.amazon.jsii.Kernel.get(this, "replicaAvailabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.replicaCount = software.amazon.jsii.Kernel.get(this, "replicaCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.slots = software.amazon.jsii.Kernel.get(this, "slots", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nodeGroupId = builder.nodeGroupId;
                this.primaryAvailabilityZone = builder.primaryAvailabilityZone;
                this.replicaAvailabilityZones = builder.replicaAvailabilityZones;
                this.replicaCount = builder.replicaCount;
                this.slots = builder.slots;
            }

            @Override
            public final java.lang.String getNodeGroupId() {
                return this.nodeGroupId;
            }

            @Override
            public final java.lang.String getPrimaryAvailabilityZone() {
                return this.primaryAvailabilityZone;
            }

            @Override
            public final java.util.List<java.lang.String> getReplicaAvailabilityZones() {
                return this.replicaAvailabilityZones;
            }

            @Override
            public final java.lang.Number getReplicaCount() {
                return this.replicaCount;
            }

            @Override
            public final java.lang.String getSlots() {
                return this.slots;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNodeGroupId() != null) {
                    data.set("nodeGroupId", om.valueToTree(this.getNodeGroupId()));
                }
                if (this.getPrimaryAvailabilityZone() != null) {
                    data.set("primaryAvailabilityZone", om.valueToTree(this.getPrimaryAvailabilityZone()));
                }
                if (this.getReplicaAvailabilityZones() != null) {
                    data.set("replicaAvailabilityZones", om.valueToTree(this.getReplicaAvailabilityZones()));
                }
                if (this.getReplicaCount() != null) {
                    data.set("replicaCount", om.valueToTree(this.getReplicaCount()));
                }
                if (this.getSlots() != null) {
                    data.set("slots", om.valueToTree(this.getSlots()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnReplicationGroup.NodeGroupConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeGroupConfigurationProperty.Jsii$Proxy that = (NodeGroupConfigurationProperty.Jsii$Proxy) o;

                if (this.nodeGroupId != null ? !this.nodeGroupId.equals(that.nodeGroupId) : that.nodeGroupId != null) return false;
                if (this.primaryAvailabilityZone != null ? !this.primaryAvailabilityZone.equals(that.primaryAvailabilityZone) : that.primaryAvailabilityZone != null) return false;
                if (this.replicaAvailabilityZones != null ? !this.replicaAvailabilityZones.equals(that.replicaAvailabilityZones) : that.replicaAvailabilityZones != null) return false;
                if (this.replicaCount != null ? !this.replicaCount.equals(that.replicaCount) : that.replicaCount != null) return false;
                return this.slots != null ? this.slots.equals(that.slots) : that.slots == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nodeGroupId != null ? this.nodeGroupId.hashCode() : 0;
                result = 31 * result + (this.primaryAvailabilityZone != null ? this.primaryAvailabilityZone.hashCode() : 0);
                result = 31 * result + (this.replicaAvailabilityZones != null ? this.replicaAvailabilityZones.hashCode() : 0);
                result = 31 * result + (this.replicaCount != null ? this.replicaCount.hashCode() : 0);
                result = 31 * result + (this.slots != null ? this.slots.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticache.CfnReplicationGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticache.CfnReplicationGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticache.CfnReplicationGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticache.CfnReplicationGroupProps.Builder();
        }

        /**
         * A user-created description for the replication group.
         * <p>
         * @return {@code this}
         * @param replicationGroupDescription A user-created description for the replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationGroupDescription(final java.lang.String replicationGroupDescription) {
            this.props.replicationGroupDescription(replicationGroupDescription);
            return this;
        }

        /**
         * A flag that enables encryption at rest when set to `true` .
         * <p>
         * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
         * <p>
         * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @return {@code this}
         * @param atRestEncryptionEnabled A flag that enables encryption at rest when set to `true` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atRestEncryptionEnabled(final java.lang.Boolean atRestEncryptionEnabled) {
            this.props.atRestEncryptionEnabled(atRestEncryptionEnabled);
            return this;
        }
        /**
         * A flag that enables encryption at rest when set to `true` .
         * <p>
         * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
         * <p>
         * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @return {@code this}
         * @param atRestEncryptionEnabled A flag that enables encryption at rest when set to `true` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atRestEncryptionEnabled(final software.amazon.awscdk.IResolvable atRestEncryptionEnabled) {
            this.props.atRestEncryptionEnabled(atRestEncryptionEnabled);
            return this;
        }

        /**
         * *Reserved parameter.* The password used to access a password protected server.
         * <p>
         * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with the Redis AUTH Command</a> .
         * <p>
         * <blockquote>
         * <p>
         * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
         * <p>
         * </blockquote>
         * <p>
         * Password constraints:
         * <p>
         * <ul>
         * <li>Must be only printable ASCII characters.</li>
         * <li>Must be at least 16 characters and no more than 128 characters in length.</li>
         * <li>Nonalphanumeric characters are restricted to (!, &amp;, #, $, ^, &lt;, &gt;, -, ).</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.
         * <p>
         * @return {@code this}
         * @param authToken *Reserved parameter.* The password used to access a password protected server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authToken(final java.lang.String authToken) {
            this.props.authToken(authToken);
            return this;
        }

        /**
         * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         * <p>
         * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param automaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticFailoverEnabled(final java.lang.Boolean automaticFailoverEnabled) {
            this.props.automaticFailoverEnabled(automaticFailoverEnabled);
            return this;
        }
        /**
         * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         * <p>
         * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param automaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticFailoverEnabled(final software.amazon.awscdk.IResolvable automaticFailoverEnabled) {
            this.props.automaticFailoverEnabled(automaticFailoverEnabled);
            return this;
        }

        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * The compute and memory capacity of the nodes in the node group (shard).
         * <p>
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
         * <p>
         * <ul>
         * <li>General purpose:</li>
         * <li>Current generation:</li>
         * </ul>
         * <p>
         * <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.24xlarge</code>
         * <p>
         * <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
         * <p>
         * <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
         * <p>
         * <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
         * <p>
         * <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
         * <p>
         * <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
         * <p>
         * <ul>
         * <li>Previous generation: (not recommended)</li>
         * </ul>
         * <p>
         * <em>T1 node types:</em> <code>cache.t1.micro</code>
         * <p>
         * <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
         * <p>
         * <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
         * <p>
         * <ul>
         * <li>Compute optimized:</li>
         * <li>Previous generation: (not recommended)</li>
         * </ul>
         * <p>
         * <em>C1 node types:</em> <code>cache.c1.xlarge</code>
         * <p>
         * <ul>
         * <li>Memory optimized:</li>
         * <li>Current generation:</li>
         * </ul>
         * <p>
         * <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
         * <p>
         * <blockquote>
         * <p>
         * The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
         * <p>
         * </blockquote>
         * <p>
         * <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.24xlarge</code>
         * <p>
         * <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
         * <p>
         * <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
         * <p>
         * <ul>
         * <li>Previous generation: (not recommended)</li>
         * </ul>
         * <p>
         * <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
         * <p>
         * <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
         * <p>
         * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Amazon Region</a>
         * <p>
         * @return {@code this}
         * @param cacheNodeType The compute and memory capacity of the nodes in the node group (shard). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNodeType(final java.lang.String cacheNodeType) {
            this.props.cacheNodeType(cacheNodeType);
            return this;
        }

        /**
         * The name of the parameter group to associate with this replication group.
         * <p>
         * If this argument is omitted, the default cache parameter group for the specified engine is used.
         * <p>
         * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name.
         * <p>
         * <ul>
         * <li>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code> .</li>
         * <li>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param cacheParameterGroupName The name of the parameter group to associate with this replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheParameterGroupName(final java.lang.String cacheParameterGroupName) {
            this.props.cacheParameterGroupName(cacheParameterGroupName);
            return this;
        }

        /**
         * A list of cache security group names to associate with this replication group.
         * <p>
         * @return {@code this}
         * @param cacheSecurityGroupNames A list of cache security group names to associate with this replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSecurityGroupNames(final java.util.List<java.lang.String> cacheSecurityGroupNames) {
            this.props.cacheSecurityGroupNames(cacheSecurityGroupNames);
            return this;
        }

        /**
         * The name of the cache subnet group to be used for the replication group.
         * <p>
         * <blockquote>
         * <p>
         * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html">AWS::ElastiCache::SubnetGroup</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param cacheSubnetGroupName The name of the cache subnet group to be used for the replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSubnetGroupName(final java.lang.String cacheSubnetGroupName) {
            this.props.cacheSubnetGroupName(cacheSubnetGroupName);
            return this;
        }

        /**
         * Enables data tiering.
         * <p>
         * Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a> .
         * <p>
         * @return {@code this}
         * @param dataTieringEnabled Enables data tiering. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTieringEnabled(final java.lang.Boolean dataTieringEnabled) {
            this.props.dataTieringEnabled(dataTieringEnabled);
            return this;
        }
        /**
         * Enables data tiering.
         * <p>
         * Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a> .
         * <p>
         * @return {@code this}
         * @param dataTieringEnabled Enables data tiering. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTieringEnabled(final software.amazon.awscdk.IResolvable dataTieringEnabled) {
            this.props.dataTieringEnabled(dataTieringEnabled);
            return this;
        }

        /**
         * The name of the cache engine to be used for the clusters in this replication group.
         * <p>
         * Must be Redis.
         * <p>
         * @return {@code this}
         * @param engine The name of the cache engine to be used for the clusters in this replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * The version number of the cache engine to be used for the clusters in this replication group.
         * <p>
         * To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
         * <p>
         * <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ) in the <em>ElastiCache User Guide</em> , but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
         * <p>
         * @return {@code this}
         * @param engineVersion The version number of the cache engine to be used for the clusters in this replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * The name of the Global datastore.
         * <p>
         * @return {@code this}
         * @param globalReplicationGroupId The name of the Global datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalReplicationGroupId(final java.lang.String globalReplicationGroupId) {
            this.props.globalReplicationGroupId(globalReplicationGroupId);
            return this;
        }

        /**
         * The ID of the KMS key used to encrypt the disk on the cluster.
         * <p>
         * @return {@code this}
         * @param kmsKeyId The ID of the KMS key used to encrypt the disk on the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Specifies the destination, format and type of the logs.
         * <p>
         * @return {@code this}
         * @param logDeliveryConfigurations Specifies the destination, format and type of the logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurations(final software.amazon.awscdk.IResolvable logDeliveryConfigurations) {
            this.props.logDeliveryConfigurations(logDeliveryConfigurations);
            return this;
        }
        /**
         * Specifies the destination, format and type of the logs.
         * <p>
         * @return {@code this}
         * @param logDeliveryConfigurations Specifies the destination, format and type of the logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurations(final java.util.List<? extends java.lang.Object> logDeliveryConfigurations) {
            this.props.logDeliveryConfigurations(logDeliveryConfigurations);
            return this;
        }

        /**
         * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> .
         * <p>
         * @return {@code this}
         * @param multiAzEnabled A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAzEnabled(final java.lang.Boolean multiAzEnabled) {
            this.props.multiAzEnabled(multiAzEnabled);
            return this;
        }
        /**
         * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> .
         * <p>
         * @return {@code this}
         * @param multiAzEnabled A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAzEnabled(final software.amazon.awscdk.IResolvable multiAzEnabled) {
            this.props.multiAzEnabled(multiAzEnabled);
            return this;
        }

        /**
         * `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
         * <p>
         * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NodeGroupConfiguration</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NodeGroupConfiguration</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * @return {@code this}
         * @param nodeGroupConfiguration `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeGroupConfiguration(final software.amazon.awscdk.IResolvable nodeGroupConfiguration) {
            this.props.nodeGroupConfiguration(nodeGroupConfiguration);
            return this;
        }
        /**
         * `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
         * <p>
         * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NodeGroupConfiguration</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NodeGroupConfiguration</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * @return {@code this}
         * @param nodeGroupConfiguration `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeGroupConfiguration(final java.util.List<? extends java.lang.Object> nodeGroupConfiguration) {
            this.props.nodeGroupConfiguration(nodeGroupConfiguration);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
         * <p>
         * <blockquote>
         * <p>
         * The Amazon SNS topic owner must be the same as the cluster owner.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param notificationTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopicArn(final java.lang.String notificationTopicArn) {
            this.props.notificationTopicArn(notificationTopicArn);
            return this;
        }

        /**
         * The number of clusters this replication group initially has.
         * <p>
         * This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.
         * <p>
         * If <code>AutomaticFailoverEnabled</code> is <code>true</code> , the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.
         * <p>
         * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
         * <p>
         * @return {@code this}
         * @param numCacheClusters The number of clusters this replication group initially has. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numCacheClusters(final java.lang.Number numCacheClusters) {
            this.props.numCacheClusters(numCacheClusters);
            return this;
        }

        /**
         * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group.
         * <p>
         * For Redis (cluster mode disabled) either omit this parameter or set it to 1.
         * <p>
         * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NumNodeGroups</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NumNodeGroups</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param numNodeGroups An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numNodeGroups(final java.lang.Number numNodeGroups) {
            this.props.numNodeGroups(numNodeGroups);
            return this;
        }

        /**
         * The port number on which each member of the replication group accepts connections.
         * <p>
         * @return {@code this}
         * @param port The port number on which each member of the replication group accepts connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * A list of EC2 Availability Zones in which the replication group's clusters are created.
         * <p>
         * The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.
         * <p>
         * This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.
         * <p>
         * <blockquote>
         * <p>
         * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code> .
         * <p>
         * </blockquote>
         * <p>
         * Default: system chosen Availability Zones.
         * <p>
         * @return {@code this}
         * @param preferredCacheClusterAZs A list of EC2 Availability Zones in which the replication group's clusters are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredCacheClusterAZs(final java.util.List<java.lang.String> preferredCacheClusterAZs) {
            this.props.preferredCacheClusterAZs(preferredCacheClusterAZs);
            return this;
        }

        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed.
         * <p>
         * It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         * <p>
         * Valid values for <code>ddd</code> are:
         * <p>
         * <ul>
         * <li><code>sun</code></li>
         * <li><code>mon</code></li>
         * <li><code>tue</code></li>
         * <li><code>wed</code></li>
         * <li><code>thu</code></li>
         * <li><code>fri</code></li>
         * <li><code>sat</code></li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster is performed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The identifier of the cluster that serves as the primary for this replication group.
         * <p>
         * This cluster must already exist and have a status of <code>available</code> .
         * <p>
         * This parameter is not required if <code>NumCacheClusters</code> , <code>NumNodeGroups</code> , or <code>ReplicasPerNodeGroup</code> is specified.
         * <p>
         * @return {@code this}
         * @param primaryClusterId The identifier of the cluster that serves as the primary for this replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryClusterId(final java.lang.String primaryClusterId) {
            this.props.primaryClusterId(primaryClusterId);
            return this;
        }

        /**
         * An optional parameter that specifies the number of replica nodes in each node group (shard).
         * <p>
         * Valid values are 0 to 5.
         * <p>
         * @return {@code this}
         * @param replicasPerNodeGroup An optional parameter that specifies the number of replica nodes in each node group (shard). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicasPerNodeGroup(final java.lang.Number replicasPerNodeGroup) {
            this.props.replicasPerNodeGroup(replicasPerNodeGroup);
            return this;
        }

        /**
         * The replication group identifier. This parameter is stored as a lowercase string.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>A name must contain from 1 to 40 alphanumeric characters or hyphens.</li>
         * <li>The first character must be a letter.</li>
         * <li>A name cannot end with a hyphen or contain two consecutive hyphens.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param replicationGroupId The replication group identifier. This parameter is stored as a lowercase string. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationGroupId(final java.lang.String replicationGroupId) {
            this.props.replicationGroupId(replicationGroupId);
            return this;
        }

        /**
         * One or more Amazon VPC security groups associated with this replication group.
         * <p>
         * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).
         * <p>
         * @return {@code this}
         * @param securityGroupIds One or more Amazon VPC security groups associated with this replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
         * <p>
         * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <em>NumNodeGroups</em> or the number of node groups configured by <em>NodeGroupConfiguration</em> regardless of the number of ARNs specified here.
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * <p>
         * @return {@code this}
         * @param snapshotArns A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotArns(final java.util.List<java.lang.String> snapshotArns) {
            this.props.snapshotArns(snapshotArns);
            return this;
        }

        /**
         * The name of a snapshot from which to restore data into the new replication group.
         * <p>
         * The snapshot status changes to <code>restoring</code> while the new replication group is being created.
         * <p>
         * @return {@code this}
         * @param snapshotName The name of a snapshot from which to restore data into the new replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotName(final java.lang.String snapshotName) {
            this.props.snapshotName(snapshotName);
            return this;
        }

        /**
         * The number of days for which ElastiCache retains automatic snapshots before deleting them.
         * <p>
         * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         * <p>
         * Default: 0 (i.e., automatic backups are disabled for this cluster).
         * <p>
         * @return {@code this}
         * @param snapshotRetentionLimit The number of days for which ElastiCache retains automatic snapshots before deleting them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotRetentionLimit(final java.lang.Number snapshotRetentionLimit) {
            this.props.snapshotRetentionLimit(snapshotRetentionLimit);
            return this;
        }

        /**
         * The cluster ID that is used as the daily snapshot source for the replication group.
         * <p>
         * This parameter cannot be set for Redis (cluster mode enabled) replication groups.
         * <p>
         * @return {@code this}
         * @param snapshottingClusterId The cluster ID that is used as the daily snapshot source for the replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshottingClusterId(final java.lang.String snapshottingClusterId) {
            this.props.snapshottingClusterId(snapshottingClusterId);
            return this;
        }

        /**
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
         * <p>
         * Example: <code>05:00-09:00</code>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * <p>
         * @return {@code this}
         * @param snapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotWindow(final java.lang.String snapshotWindow) {
            this.props.snapshotWindow(snapshotWindow);
            return this;
        }

        /**
         * A list of tags to be added to this resource.
         * <p>
         * Tags are comma-separated key,value pairs (e.g. Key= <code>myKey</code> , Value= <code>myKeyValue</code> . You can include multiple tags as shown following: Key= <code>myKey</code> , Value= <code>myKeyValue</code> Key= <code>mySecondKey</code> , Value= <code>mySecondKeyValue</code> . Tags on replication groups will be replicated to all nodes.
         * <p>
         * @return {@code this}
         * @param tags A list of tags to be added to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A flag that enables in-transit encryption when set to `true` .
         * <p>
         * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.
         * <p>
         * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code> , the <code>EngineVersion</code> parameter is <code>3.2.6</code> or <code>4.x</code> onward, and the cluster is being created in an Amazon VPC.
         * <p>
         * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code> .
         * <p>
         * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
         * <p>
         * Default: <code>false</code>
         * <p>
         * <blockquote>
         * <p>
         * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param transitEncryptionEnabled A flag that enables in-transit encryption when set to `true` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(final java.lang.Boolean transitEncryptionEnabled) {
            this.props.transitEncryptionEnabled(transitEncryptionEnabled);
            return this;
        }
        /**
         * A flag that enables in-transit encryption when set to `true` .
         * <p>
         * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.
         * <p>
         * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code> , the <code>EngineVersion</code> parameter is <code>3.2.6</code> or <code>4.x</code> onward, and the cluster is being created in an Amazon VPC.
         * <p>
         * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code> .
         * <p>
         * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
         * <p>
         * Default: <code>false</code>
         * <p>
         * <blockquote>
         * <p>
         * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param transitEncryptionEnabled A flag that enables in-transit encryption when set to `true` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(final software.amazon.awscdk.IResolvable transitEncryptionEnabled) {
            this.props.transitEncryptionEnabled(transitEncryptionEnabled);
            return this;
        }

        /**
         * The list of user groups to associate with the replication group.
         * <p>
         * @return {@code this}
         * @param userGroupIds The list of user groups to associate with the replication group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userGroupIds(final java.util.List<java.lang.String> userGroupIds) {
            this.props.userGroupIds(userGroupIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticache.CfnReplicationGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticache.CfnReplicationGroup build() {
            return new software.amazon.awscdk.services.elasticache.CfnReplicationGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
