package software.amazon.awscdk.services.efs;

/**
 * EFS Performance mode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FileSystem fileSystem = FileSystem.Builder.create(this, "MyEfsFileSystem")
 *         .vpc(new Vpc(this, "VPC"))
 *         .lifecyclePolicy(LifecyclePolicy.AFTER_14_DAYS) // files are not transitioned to infrequent access (IA) storage by default
 *         .performanceMode(PerformanceMode.GENERAL_PURPOSE) // default
 *         .outOfInfrequentAccessPolicy(OutOfInfrequentAccessPolicy.AFTER_1_ACCESS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes">https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:38.862Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.PerformanceMode")
public enum PerformanceMode {
    /**
     * General Purpose is ideal for latency-sensitive use cases, like web serving environments, content management systems, home directories, and general file serving.
     * <p>
     * Recommended for the majority of Amazon EFS file systems.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GENERAL_PURPOSE,
    /**
     * File systems in the Max I/O mode can scale to higher levels of aggregate throughput and operations per second.
     * <p>
     * This scaling is done with a tradeoff
     * of slightly higher latencies for file metadata operations.
     * Highly parallelized applications and workloads, such as big data analysis,
     * media processing, and genomics analysis, can benefit from this mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAX_IO,
}
