package software.amazon.awscdk.services.dms;

/**
 * Properties for defining a `CfnReplicationTask`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnReplicationTaskProps cfnReplicationTaskProps = CfnReplicationTaskProps.builder()
 *         .migrationType("migrationType")
 *         .replicationInstanceArn("replicationInstanceArn")
 *         .sourceEndpointArn("sourceEndpointArn")
 *         .tableMappings("tableMappings")
 *         .targetEndpointArn("targetEndpointArn")
 *         // the properties below are optional
 *         .cdcStartPosition("cdcStartPosition")
 *         .cdcStartTime(123)
 *         .cdcStopPosition("cdcStopPosition")
 *         .replicationTaskIdentifier("replicationTaskIdentifier")
 *         .replicationTaskSettings("replicationTaskSettings")
 *         .resourceIdentifier("resourceIdentifier")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskData("taskData")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:38.008Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnReplicationTaskProps")
@software.amazon.jsii.Jsii.Proxy(CfnReplicationTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReplicationTaskProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The migration type.
     * <p>
     * Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMigrationType();

    /**
     * The Amazon Resource Name (ARN) of a replication instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReplicationInstanceArn();

    /**
     * An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceEndpointArn();

    /**
     * The table mappings for the task, in JSON format.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table Mapping to Specify Task Settings</a> in the <em>AWS Database Migration Service User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableMappings();

    /**
     * An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetEndpointArn();

    /**
     * Indicates when you want a change data capture (CDC) operation to start.
     * <p>
     * Use either <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want a CDC operation to start. Specifying both values results in an error.
     * <p>
     * The value can be in date, checkpoint, log sequence number (LSN), or system change number (SCN) format.
     * <p>
     * Here is a date example: <code>--cdc-start-position "2018-03-08T12:12:12"</code>
     * <p>
     * Here is a checkpoint example: <code>--cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</code>
     * <p>
     * Here is an LSN example: <code>--cdc-start-position “mysql-bin-changelog.000024:373”</code>
     * <p>
     * <blockquote>
     * <p>
     * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCdcStartPosition() {
        return null;
    }

    /**
     * Indicates the start time for a change data capture (CDC) operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCdcStartTime() {
        return null;
    }

    /**
     * Indicates when you want a change data capture (CDC) operation to stop.
     * <p>
     * The value can be either server time or commit time.
     * <p>
     * Here is a server time example: <code>--cdc-stop-position "server_time:2018-02-09T12:12:12"</code>
     * <p>
     * Here is a commit time example: <code>--cdc-stop-position "commit_time: 2018-02-09T12:12:12"</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCdcStopPosition() {
        return null;
    }

    /**
     * An identifier for the replication task.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1-255 alphanumeric characters or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplicationTaskIdentifier() {
        return null;
    }

    /**
     * Overall settings for the task, in JSON format.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task Settings for AWS Database Migration Service Tasks</a> in the <em>AWS Database Migration Service User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplicationTaskSettings() {
        return null;
    }

    /**
     * A display name for the resource identifier at the end of the `EndpointArn` response parameter that is returned in the created `Endpoint` object.
     * <p>
     * The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code> .
     * <p>
     * For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code> . If you don't specify a <code>ResourceIdentifier</code> value, AWS DMS generates a default identifier value for the end of <code>EndpointArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdentifier() {
        return null;
    }

    /**
     * One or more tags to be assigned to the replication task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::DMS::ReplicationTask.TaskData`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTaskData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReplicationTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReplicationTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReplicationTaskProps> {
        java.lang.String migrationType;
        java.lang.String replicationInstanceArn;
        java.lang.String sourceEndpointArn;
        java.lang.String tableMappings;
        java.lang.String targetEndpointArn;
        java.lang.String cdcStartPosition;
        java.lang.Number cdcStartTime;
        java.lang.String cdcStopPosition;
        java.lang.String replicationTaskIdentifier;
        java.lang.String replicationTaskSettings;
        java.lang.String resourceIdentifier;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String taskData;

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getMigrationType}
         * @param migrationType The migration type. This parameter is required.
         *                      Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder migrationType(java.lang.String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getReplicationInstanceArn}
         * @param replicationInstanceArn The Amazon Resource Name (ARN) of a replication instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationInstanceArn(java.lang.String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getSourceEndpointArn}
         * @param sourceEndpointArn An Amazon Resource Name (ARN) that uniquely identifies the source endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEndpointArn(java.lang.String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getTableMappings}
         * @param tableMappings The table mappings for the task, in JSON format. This parameter is required.
         *                      For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table Mapping to Specify Task Settings</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableMappings(java.lang.String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getTargetEndpointArn}
         * @param targetEndpointArn An Amazon Resource Name (ARN) that uniquely identifies the target endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetEndpointArn(java.lang.String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getCdcStartPosition}
         * @param cdcStartPosition Indicates when you want a change data capture (CDC) operation to start.
         *                         Use either <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want a CDC operation to start. Specifying both values results in an error.
         *                         <p>
         *                         The value can be in date, checkpoint, log sequence number (LSN), or system change number (SCN) format.
         *                         <p>
         *                         Here is a date example: <code>--cdc-start-position "2018-03-08T12:12:12"</code>
         *                         <p>
         *                         Here is a checkpoint example: <code>--cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</code>
         *                         <p>
         *                         Here is an LSN example: <code>--cdc-start-position “mysql-bin-changelog.000024:373”</code>
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdcStartPosition(java.lang.String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getCdcStartTime}
         * @param cdcStartTime Indicates the start time for a change data capture (CDC) operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdcStartTime(java.lang.Number cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getCdcStopPosition}
         * @param cdcStopPosition Indicates when you want a change data capture (CDC) operation to stop.
         *                        The value can be either server time or commit time.
         *                        <p>
         *                        Here is a server time example: <code>--cdc-stop-position "server_time:2018-02-09T12:12:12"</code>
         *                        <p>
         *                        Here is a commit time example: <code>--cdc-stop-position "commit_time: 2018-02-09T12:12:12"</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdcStopPosition(java.lang.String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getReplicationTaskIdentifier}
         * @param replicationTaskIdentifier An identifier for the replication task.
         *                                  Constraints:
         *                                  <p>
         *                                  <ul>
         *                                  <li>Must contain 1-255 alphanumeric characters or hyphens.</li>
         *                                  <li>First character must be a letter.</li>
         *                                  <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         *                                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationTaskIdentifier(java.lang.String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getReplicationTaskSettings}
         * @param replicationTaskSettings Overall settings for the task, in JSON format.
         *                                For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task Settings for AWS Database Migration Service Tasks</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationTaskSettings(java.lang.String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getResourceIdentifier}
         * @param resourceIdentifier A display name for the resource identifier at the end of the `EndpointArn` response parameter that is returned in the created `Endpoint` object.
         *                           The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code> .
         *                           <p>
         *                           For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code> . If you don't specify a <code>ResourceIdentifier</code> value, AWS DMS generates a default identifier value for the end of <code>EndpointArn</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(java.lang.String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getTags}
         * @param tags One or more tags to be assigned to the replication task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationTaskProps#getTaskData}
         * @param taskData `AWS::DMS::ReplicationTask.TaskData`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskData(java.lang.String taskData) {
            this.taskData = taskData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReplicationTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReplicationTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReplicationTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReplicationTaskProps {
        private final java.lang.String migrationType;
        private final java.lang.String replicationInstanceArn;
        private final java.lang.String sourceEndpointArn;
        private final java.lang.String tableMappings;
        private final java.lang.String targetEndpointArn;
        private final java.lang.String cdcStartPosition;
        private final java.lang.Number cdcStartTime;
        private final java.lang.String cdcStopPosition;
        private final java.lang.String replicationTaskIdentifier;
        private final java.lang.String replicationTaskSettings;
        private final java.lang.String resourceIdentifier;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String taskData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.migrationType = software.amazon.jsii.Kernel.get(this, "migrationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationInstanceArn = software.amazon.jsii.Kernel.get(this, "replicationInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceEndpointArn = software.amazon.jsii.Kernel.get(this, "sourceEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableMappings = software.amazon.jsii.Kernel.get(this, "tableMappings", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetEndpointArn = software.amazon.jsii.Kernel.get(this, "targetEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cdcStartPosition = software.amazon.jsii.Kernel.get(this, "cdcStartPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cdcStartTime = software.amazon.jsii.Kernel.get(this, "cdcStartTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.cdcStopPosition = software.amazon.jsii.Kernel.get(this, "cdcStopPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationTaskIdentifier = software.amazon.jsii.Kernel.get(this, "replicationTaskIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationTaskSettings = software.amazon.jsii.Kernel.get(this, "replicationTaskSettings", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceIdentifier = software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.taskData = software.amazon.jsii.Kernel.get(this, "taskData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.migrationType = java.util.Objects.requireNonNull(builder.migrationType, "migrationType is required");
            this.replicationInstanceArn = java.util.Objects.requireNonNull(builder.replicationInstanceArn, "replicationInstanceArn is required");
            this.sourceEndpointArn = java.util.Objects.requireNonNull(builder.sourceEndpointArn, "sourceEndpointArn is required");
            this.tableMappings = java.util.Objects.requireNonNull(builder.tableMappings, "tableMappings is required");
            this.targetEndpointArn = java.util.Objects.requireNonNull(builder.targetEndpointArn, "targetEndpointArn is required");
            this.cdcStartPosition = builder.cdcStartPosition;
            this.cdcStartTime = builder.cdcStartTime;
            this.cdcStopPosition = builder.cdcStopPosition;
            this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
            this.replicationTaskSettings = builder.replicationTaskSettings;
            this.resourceIdentifier = builder.resourceIdentifier;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.taskData = builder.taskData;
        }

        @Override
        public final java.lang.String getMigrationType() {
            return this.migrationType;
        }

        @Override
        public final java.lang.String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final java.lang.String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        @Override
        public final java.lang.String getTableMappings() {
            return this.tableMappings;
        }

        @Override
        public final java.lang.String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        @Override
        public final java.lang.String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        @Override
        public final java.lang.Number getCdcStartTime() {
            return this.cdcStartTime;
        }

        @Override
        public final java.lang.String getCdcStopPosition() {
            return this.cdcStopPosition;
        }

        @Override
        public final java.lang.String getReplicationTaskIdentifier() {
            return this.replicationTaskIdentifier;
        }

        @Override
        public final java.lang.String getReplicationTaskSettings() {
            return this.replicationTaskSettings;
        }

        @Override
        public final java.lang.String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTaskData() {
            return this.taskData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("migrationType", om.valueToTree(this.getMigrationType()));
            data.set("replicationInstanceArn", om.valueToTree(this.getReplicationInstanceArn()));
            data.set("sourceEndpointArn", om.valueToTree(this.getSourceEndpointArn()));
            data.set("tableMappings", om.valueToTree(this.getTableMappings()));
            data.set("targetEndpointArn", om.valueToTree(this.getTargetEndpointArn()));
            if (this.getCdcStartPosition() != null) {
                data.set("cdcStartPosition", om.valueToTree(this.getCdcStartPosition()));
            }
            if (this.getCdcStartTime() != null) {
                data.set("cdcStartTime", om.valueToTree(this.getCdcStartTime()));
            }
            if (this.getCdcStopPosition() != null) {
                data.set("cdcStopPosition", om.valueToTree(this.getCdcStopPosition()));
            }
            if (this.getReplicationTaskIdentifier() != null) {
                data.set("replicationTaskIdentifier", om.valueToTree(this.getReplicationTaskIdentifier()));
            }
            if (this.getReplicationTaskSettings() != null) {
                data.set("replicationTaskSettings", om.valueToTree(this.getReplicationTaskSettings()));
            }
            if (this.getResourceIdentifier() != null) {
                data.set("resourceIdentifier", om.valueToTree(this.getResourceIdentifier()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaskData() != null) {
                data.set("taskData", om.valueToTree(this.getTaskData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnReplicationTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReplicationTaskProps.Jsii$Proxy that = (CfnReplicationTaskProps.Jsii$Proxy) o;

            if (!migrationType.equals(that.migrationType)) return false;
            if (!replicationInstanceArn.equals(that.replicationInstanceArn)) return false;
            if (!sourceEndpointArn.equals(that.sourceEndpointArn)) return false;
            if (!tableMappings.equals(that.tableMappings)) return false;
            if (!targetEndpointArn.equals(that.targetEndpointArn)) return false;
            if (this.cdcStartPosition != null ? !this.cdcStartPosition.equals(that.cdcStartPosition) : that.cdcStartPosition != null) return false;
            if (this.cdcStartTime != null ? !this.cdcStartTime.equals(that.cdcStartTime) : that.cdcStartTime != null) return false;
            if (this.cdcStopPosition != null ? !this.cdcStopPosition.equals(that.cdcStopPosition) : that.cdcStopPosition != null) return false;
            if (this.replicationTaskIdentifier != null ? !this.replicationTaskIdentifier.equals(that.replicationTaskIdentifier) : that.replicationTaskIdentifier != null) return false;
            if (this.replicationTaskSettings != null ? !this.replicationTaskSettings.equals(that.replicationTaskSettings) : that.replicationTaskSettings != null) return false;
            if (this.resourceIdentifier != null ? !this.resourceIdentifier.equals(that.resourceIdentifier) : that.resourceIdentifier != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.taskData != null ? this.taskData.equals(that.taskData) : that.taskData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.migrationType.hashCode();
            result = 31 * result + (this.replicationInstanceArn.hashCode());
            result = 31 * result + (this.sourceEndpointArn.hashCode());
            result = 31 * result + (this.tableMappings.hashCode());
            result = 31 * result + (this.targetEndpointArn.hashCode());
            result = 31 * result + (this.cdcStartPosition != null ? this.cdcStartPosition.hashCode() : 0);
            result = 31 * result + (this.cdcStartTime != null ? this.cdcStartTime.hashCode() : 0);
            result = 31 * result + (this.cdcStopPosition != null ? this.cdcStopPosition.hashCode() : 0);
            result = 31 * result + (this.replicationTaskIdentifier != null ? this.replicationTaskIdentifier.hashCode() : 0);
            result = 31 * result + (this.replicationTaskSettings != null ? this.replicationTaskSettings.hashCode() : 0);
            result = 31 * result + (this.resourceIdentifier != null ? this.resourceIdentifier.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taskData != null ? this.taskData.hashCode() : 0);
            return result;
        }
    }
}
