package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a `CfnTask`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnTaskProps cfnTaskProps = CfnTaskProps.builder()
 *         .destinationLocationArn("destinationLocationArn")
 *         .sourceLocationArn("sourceLocationArn")
 *         // the properties below are optional
 *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *         .excludes(List.of(FilterRuleProperty.builder()
 *                 .filterType("filterType")
 *                 .value("value")
 *                 .build()))
 *         .includes(List.of(FilterRuleProperty.builder()
 *                 .filterType("filterType")
 *                 .value("value")
 *                 .build()))
 *         .name("name")
 *         .options(OptionsProperty.builder()
 *                 .atime("atime")
 *                 .bytesPerSecond(123)
 *                 .gid("gid")
 *                 .logLevel("logLevel")
 *                 .mtime("mtime")
 *                 .objectTags("objectTags")
 *                 .overwriteMode("overwriteMode")
 *                 .posixPermissions("posixPermissions")
 *                 .preserveDeletedFiles("preserveDeletedFiles")
 *                 .preserveDevices("preserveDevices")
 *                 .securityDescriptorCopyFlags("securityDescriptorCopyFlags")
 *                 .taskQueueing("taskQueueing")
 *                 .transferMode("transferMode")
 *                 .uid("uid")
 *                 .verifyMode("verifyMode")
 *                 .build())
 *         .schedule(TaskScheduleProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.901Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTaskProps")
@software.amazon.jsii.Jsii.Proxy(CfnTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTaskProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of an AWS storage resource's location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestinationLocationArn();

    /**
     * The Amazon Resource Name (ARN) of the source location for the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationArn();

    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
     * <p>
     * For more information about how to use CloudWatch Logs with DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/monitor-datasync.html#cloudwatchlogs">Monitoring Your Task</a> in the <em>AWS DataSync User Guide.</em>
     * <p>
     * For more information about these groups, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> in the <em>Amazon CloudWatch Logs User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogGroupArn() {
        return null;
    }

    /**
     * A list of filter rules that determines which files to exclude from a task.
     * <p>
     * The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExcludes() {
        return null;
    }

    /**
     * A list of filter rules that determines which files to include when running a task.
     * <p>
     * The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIncludes() {
        return null;
    }

    /**
     * The name of a task.
     * <p>
     * This value is a text reference that is used to identify the task in the console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` .
     * <p>
     * You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
     * <p>
     * For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return null;
    }

    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location.
     * <p>
     * The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return null;
    }

    /**
     * The key-value pair that represents the tag that you want to add to the resource.
     * <p>
     * The value can be an empty string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTaskProps> {
        java.lang.String destinationLocationArn;
        java.lang.String sourceLocationArn;
        java.lang.String cloudWatchLogGroupArn;
        java.lang.Object excludes;
        java.lang.Object includes;
        java.lang.String name;
        java.lang.Object options;
        java.lang.Object schedule;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTaskProps#getDestinationLocationArn}
         * @param destinationLocationArn The Amazon Resource Name (ARN) of an AWS storage resource's location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationLocationArn(java.lang.String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getSourceLocationArn}
         * @param sourceLocationArn The Amazon Resource Name (ARN) of the source location for the task. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationArn(java.lang.String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getCloudWatchLogGroupArn}
         * @param cloudWatchLogGroupArn The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
         *                              For more information about how to use CloudWatch Logs with DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/monitor-datasync.html#cloudwatchlogs">Monitoring Your Task</a> in the <em>AWS DataSync User Guide.</em>
         *                              <p>
         *                              For more information about these groups, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> in the <em>Amazon CloudWatch Logs User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroupArn(java.lang.String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getExcludes}
         * @param excludes A list of filter rules that determines which files to exclude from a task.
         *                 The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludes(software.amazon.awscdk.IResolvable excludes) {
            this.excludes = excludes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getExcludes}
         * @param excludes A list of filter rules that determines which files to exclude from a task.
         *                 The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludes(java.util.List<? extends java.lang.Object> excludes) {
            this.excludes = excludes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getIncludes}
         * @param includes A list of filter rules that determines which files to include when running a task.
         *                 The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includes(software.amazon.awscdk.IResolvable includes) {
            this.includes = includes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getIncludes}
         * @param includes A list of filter rules that determines which files to include when running a task.
         *                 The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includes(java.util.List<? extends java.lang.Object> includes) {
            this.includes = includes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getName}
         * @param name The name of a task.
         *             This value is a text reference that is used to identify the task in the console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getOptions}
         * @param options The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` .
         *                You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
         *                <p>
         *                For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getOptions}
         * @param options The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` .
         *                You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
         *                <p>
         *                For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.IResolvable options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getSchedule}
         * @param schedule Specifies a schedule used to periodically transfer files from a source to a destination location.
         *                 The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.datasync.CfnTask.TaskScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getSchedule}
         * @param schedule Specifies a schedule used to periodically transfer files from a source to a destination location.
         *                 The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getTags}
         * @param tags The key-value pair that represents the tag that you want to add to the resource.
         *             The value can be an empty string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTaskProps {
        private final java.lang.String destinationLocationArn;
        private final java.lang.String sourceLocationArn;
        private final java.lang.String cloudWatchLogGroupArn;
        private final java.lang.Object excludes;
        private final java.lang.Object includes;
        private final java.lang.String name;
        private final java.lang.Object options;
        private final java.lang.Object schedule;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationLocationArn = software.amazon.jsii.Kernel.get(this, "destinationLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceLocationArn = software.amazon.jsii.Kernel.get(this, "sourceLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudWatchLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.excludes = software.amazon.jsii.Kernel.get(this, "excludes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.includes = software.amazon.jsii.Kernel.get(this, "includes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationLocationArn = java.util.Objects.requireNonNull(builder.destinationLocationArn, "destinationLocationArn is required");
            this.sourceLocationArn = java.util.Objects.requireNonNull(builder.sourceLocationArn, "sourceLocationArn is required");
            this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
            this.excludes = builder.excludes;
            this.includes = builder.includes;
            this.name = builder.name;
            this.options = builder.options;
            this.schedule = builder.schedule;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDestinationLocationArn() {
            return this.destinationLocationArn;
        }

        @Override
        public final java.lang.String getSourceLocationArn() {
            return this.sourceLocationArn;
        }

        @Override
        public final java.lang.String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        @Override
        public final java.lang.Object getExcludes() {
            return this.excludes;
        }

        @Override
        public final java.lang.Object getIncludes() {
            return this.includes;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOptions() {
            return this.options;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationLocationArn", om.valueToTree(this.getDestinationLocationArn()));
            data.set("sourceLocationArn", om.valueToTree(this.getSourceLocationArn()));
            if (this.getCloudWatchLogGroupArn() != null) {
                data.set("cloudWatchLogGroupArn", om.valueToTree(this.getCloudWatchLogGroupArn()));
            }
            if (this.getExcludes() != null) {
                data.set("excludes", om.valueToTree(this.getExcludes()));
            }
            if (this.getIncludes() != null) {
                data.set("includes", om.valueToTree(this.getIncludes()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTaskProps.Jsii$Proxy that = (CfnTaskProps.Jsii$Proxy) o;

            if (!destinationLocationArn.equals(that.destinationLocationArn)) return false;
            if (!sourceLocationArn.equals(that.sourceLocationArn)) return false;
            if (this.cloudWatchLogGroupArn != null ? !this.cloudWatchLogGroupArn.equals(that.cloudWatchLogGroupArn) : that.cloudWatchLogGroupArn != null) return false;
            if (this.excludes != null ? !this.excludes.equals(that.excludes) : that.excludes != null) return false;
            if (this.includes != null ? !this.includes.equals(that.includes) : that.includes != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationLocationArn.hashCode();
            result = 31 * result + (this.sourceLocationArn.hashCode());
            result = 31 * result + (this.cloudWatchLogGroupArn != null ? this.cloudWatchLogGroupArn.hashCode() : 0);
            result = 31 * result + (this.excludes != null ? this.excludes.hashCode() : 0);
            result = 31 * result + (this.includes != null ? this.includes.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
