package software.amazon.awscdk.services.config;

/**
 * A CloudFormation `AWS::Config::ConfigurationRecorder`.
 * <p>
 * The AWS::Config::ConfigurationRecorder resource describes the AWS resource types for which AWS Config records configuration changes. The configuration recorder stores the configurations of the supported resources in your account as configuration items.
 * <p>
 * <blockquote>
 * <p>
 * To enable AWS Config , you must create a configuration recorder and a delivery channel. AWS Config uses the delivery channel to deliver the configuration changes to your Amazon S3 bucket or Amazon SNS topic. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html">AWS::Config::DeliveryChannel</a> .
 * <p>
 * </blockquote>
 * <p>
 * AWS CloudFormation starts the recorder as soon as the delivery channel is available.
 * <p>
 * To stop the recorder and delete it, delete the configuration recorder from your stack. To stop the recorder without deleting it, call the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html">StopConfigurationRecorder</a> action of the AWS Config API directly.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.html#config-recorder">Configuration Recorder</a> in the AWS Config Developer Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnConfigurationRecorder cfnConfigurationRecorder = CfnConfigurationRecorder.Builder.create(this, "MyCfnConfigurationRecorder")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .name("name")
 *         .recordingGroup(RecordingGroupProperty.builder()
 *                 .allSupported(false)
 *                 .includeGlobalResourceTypes(false)
 *                 .resourceTypes(List.of("resourceTypes"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.722Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorder")
public class CfnConfigurationRecorder extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConfigurationRecorder(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationRecorder(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.CfnConfigurationRecorder.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Config::ConfigurationRecorder`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationRecorder(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnConfigurationRecorderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM (IAM) role that is used to make read or write requests to the delivery channel that you specify and to get configuration details for supported AWS resources.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html">Permissions for the IAM Role Assigned</a> to AWS Config in the AWS Config Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM (IAM) role that is used to make read or write requests to the delivery channel that you specify and to get configuration details for supported AWS resources.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html">Permissions for the IAM Role Assigned</a> to AWS Config in the AWS Config Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * A name for the configuration recorder.
     * <p>
     * If you don't specify a name, AWS CloudFormation CloudFormation generates a unique physical ID and uses that ID for the configuration recorder name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * After you create a configuration recorder, you cannot rename it. If you don't want a name that AWS CloudFormation generates, specify a value for this property.
     * <p>
     * </blockquote>
     * <p>
     * Updates are not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the configuration recorder.
     * <p>
     * If you don't specify a name, AWS CloudFormation CloudFormation generates a unique physical ID and uses that ID for the configuration recorder name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * After you create a configuration recorder, you cannot rename it. If you don't want a name that AWS CloudFormation generates, specify a value for this property.
     * <p>
     * </blockquote>
     * <p>
     * Updates are not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Indicates whether to record configurations for all supported resources or for a list of resource types.
     * <p>
     * The resource types that you list must be supported by AWS Config .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecordingGroup() {
        return software.amazon.jsii.Kernel.get(this, "recordingGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether to record configurations for all supported resources or for a list of resource types.
     * <p>
     * The resource types that you list must be supported by AWS Config .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordingGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingGroupProperty value) {
        software.amazon.jsii.Kernel.set(this, "recordingGroup", value);
    }

    /**
     * Indicates whether to record configurations for all supported resources or for a list of resource types.
     * <p>
     * The resource types that you list must be supported by AWS Config .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordingGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recordingGroup", value);
    }
    /**
     * Specifies the types of AWS resource for which AWS Config records configuration changes.
     * <p>
     * In the recording group, you specify whether all supported types or specific types of resources are recorded.
     * <p>
     * By default, AWS Config records configuration changes for all supported types of regional resources that AWS Config discovers in the region in which it is running. Regional resources are tied to a region and can be used only in that region. Examples of regional resources are EC2 instances and EBS volumes.
     * <p>
     * You can also have AWS Config record configuration changes for supported types of global resources (for example, IAM resources). Global resources are not tied to an individual region and can be used in all regions.
     * <p>
     * <blockquote>
     * <p>
     * The configuration details for any global resource are the same in all regions. If you customize AWS Config in multiple regions to record global resources, it will create multiple configuration items each time a global resource changes: one configuration item for each region. These configuration items will contain identical data. To prevent duplicate configuration items, you should consider customizing AWS Config in only one region to record global resources, unless you want the configuration items to be available in multiple regions.
     * <p>
     * </blockquote>
     * <p>
     * If you don't want AWS Config to record all resources, you can specify which types of resources it will record with the <code>resourceTypes</code> parameter.
     * <p>
     * For a list of supported resource types, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Resource Types</a> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html">Selecting Which Resources AWS Config Records</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * RecordingGroupProperty recordingGroupProperty = RecordingGroupProperty.builder()
     *         .allSupported(false)
     *         .includeGlobalResourceTypes(false)
     *         .resourceTypes(List.of("resourceTypes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordingGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordingGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether AWS Config records configuration changes for every supported type of regional resource.
         * <p>
         * If you set this option to <code>true</code> , when AWS Config adds support for a new type of regional resource, it starts recording resources of that type automatically.
         * <p>
         * If you set this option to <code>true</code> , you cannot enumerate a list of <code>resourceTypes</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllSupported() {
            return null;
        }

        /**
         * Specifies whether AWS Config includes all supported types of global resources (for example, IAM resources) with the resources that it records.
         * <p>
         * Before you can set this option to <code>true</code> , you must set the <code>AllSupported</code> option to <code>true</code> .
         * <p>
         * If you set this option to <code>true</code> , when AWS Config adds support for a new type of global resource, it starts recording resources of that type automatically.
         * <p>
         * The configuration details for any global resource are the same in all regions. To prevent duplicate configuration items, you should consider customizing AWS Config in only one region to record global resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeGlobalResourceTypes() {
            return null;
        }

        /**
         * A comma-separated list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail` ).
         * <p>
         * To record all configuration changes, you must set the <code>AllSupported</code> option to <code>false</code> .
         * <p>
         * If you set this option to <code>true</code> , when AWS Config adds support for a new type of resource, it will not record resources of that type unless you manually add that type to your recording group.
         * <p>
         * For a list of valid <code>resourceTypes</code> values, see the <em>resourceType Value</em> column in <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported AWS Resource Types</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordingGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordingGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordingGroupProperty> {
            java.lang.Object allSupported;
            java.lang.Object includeGlobalResourceTypes;
            java.util.List<java.lang.String> resourceTypes;

            /**
             * Sets the value of {@link RecordingGroupProperty#getAllSupported}
             * @param allSupported Specifies whether AWS Config records configuration changes for every supported type of regional resource.
             *                     If you set this option to <code>true</code> , when AWS Config adds support for a new type of regional resource, it starts recording resources of that type automatically.
             *                     <p>
             *                     If you set this option to <code>true</code> , you cannot enumerate a list of <code>resourceTypes</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allSupported(java.lang.Boolean allSupported) {
                this.allSupported = allSupported;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getAllSupported}
             * @param allSupported Specifies whether AWS Config records configuration changes for every supported type of regional resource.
             *                     If you set this option to <code>true</code> , when AWS Config adds support for a new type of regional resource, it starts recording resources of that type automatically.
             *                     <p>
             *                     If you set this option to <code>true</code> , you cannot enumerate a list of <code>resourceTypes</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allSupported(software.amazon.awscdk.IResolvable allSupported) {
                this.allSupported = allSupported;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getIncludeGlobalResourceTypes}
             * @param includeGlobalResourceTypes Specifies whether AWS Config includes all supported types of global resources (for example, IAM resources) with the resources that it records.
             *                                   Before you can set this option to <code>true</code> , you must set the <code>AllSupported</code> option to <code>true</code> .
             *                                   <p>
             *                                   If you set this option to <code>true</code> , when AWS Config adds support for a new type of global resource, it starts recording resources of that type automatically.
             *                                   <p>
             *                                   The configuration details for any global resource are the same in all regions. To prevent duplicate configuration items, you should consider customizing AWS Config in only one region to record global resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeGlobalResourceTypes(java.lang.Boolean includeGlobalResourceTypes) {
                this.includeGlobalResourceTypes = includeGlobalResourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getIncludeGlobalResourceTypes}
             * @param includeGlobalResourceTypes Specifies whether AWS Config includes all supported types of global resources (for example, IAM resources) with the resources that it records.
             *                                   Before you can set this option to <code>true</code> , you must set the <code>AllSupported</code> option to <code>true</code> .
             *                                   <p>
             *                                   If you set this option to <code>true</code> , when AWS Config adds support for a new type of global resource, it starts recording resources of that type automatically.
             *                                   <p>
             *                                   The configuration details for any global resource are the same in all regions. To prevent duplicate configuration items, you should consider customizing AWS Config in only one region to record global resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeGlobalResourceTypes(software.amazon.awscdk.IResolvable includeGlobalResourceTypes) {
                this.includeGlobalResourceTypes = includeGlobalResourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link RecordingGroupProperty#getResourceTypes}
             * @param resourceTypes A comma-separated list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail` ).
             *                      To record all configuration changes, you must set the <code>AllSupported</code> option to <code>false</code> .
             *                      <p>
             *                      If you set this option to <code>true</code> , when AWS Config adds support for a new type of resource, it will not record resources of that type unless you manually add that type to your recording group.
             *                      <p>
             *                      For a list of valid <code>resourceTypes</code> values, see the <em>resourceType Value</em> column in <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported AWS Resource Types</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypes(java.util.List<java.lang.String> resourceTypes) {
                this.resourceTypes = resourceTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordingGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordingGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordingGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordingGroupProperty {
            private final java.lang.Object allSupported;
            private final java.lang.Object includeGlobalResourceTypes;
            private final java.util.List<java.lang.String> resourceTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allSupported = software.amazon.jsii.Kernel.get(this, "allSupported", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeGlobalResourceTypes = software.amazon.jsii.Kernel.get(this, "includeGlobalResourceTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceTypes = software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allSupported = builder.allSupported;
                this.includeGlobalResourceTypes = builder.includeGlobalResourceTypes;
                this.resourceTypes = builder.resourceTypes;
            }

            @Override
            public final java.lang.Object getAllSupported() {
                return this.allSupported;
            }

            @Override
            public final java.lang.Object getIncludeGlobalResourceTypes() {
                return this.includeGlobalResourceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypes() {
                return this.resourceTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllSupported() != null) {
                    data.set("allSupported", om.valueToTree(this.getAllSupported()));
                }
                if (this.getIncludeGlobalResourceTypes() != null) {
                    data.set("includeGlobalResourceTypes", om.valueToTree(this.getIncludeGlobalResourceTypes()));
                }
                if (this.getResourceTypes() != null) {
                    data.set("resourceTypes", om.valueToTree(this.getResourceTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationRecorder.RecordingGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordingGroupProperty.Jsii$Proxy that = (RecordingGroupProperty.Jsii$Proxy) o;

                if (this.allSupported != null ? !this.allSupported.equals(that.allSupported) : that.allSupported != null) return false;
                if (this.includeGlobalResourceTypes != null ? !this.includeGlobalResourceTypes.equals(that.includeGlobalResourceTypes) : that.includeGlobalResourceTypes != null) return false;
                return this.resourceTypes != null ? this.resourceTypes.equals(that.resourceTypes) : that.resourceTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allSupported != null ? this.allSupported.hashCode() : 0;
                result = 31 * result + (this.includeGlobalResourceTypes != null ? this.includeGlobalResourceTypes.hashCode() : 0);
                result = 31 * result + (this.resourceTypes != null ? this.resourceTypes.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CfnConfigurationRecorder}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CfnConfigurationRecorder> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.config.CfnConfigurationRecorderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.config.CfnConfigurationRecorderProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM (IAM) role that is used to make read or write requests to the delivery channel that you specify and to get configuration details for supported AWS resources.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html">Permissions for the IAM Role Assigned</a> to AWS Config in the AWS Config Developer Guide.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM (IAM) role that is used to make read or write requests to the delivery channel that you specify and to get configuration details for supported AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * A name for the configuration recorder.
         * <p>
         * If you don't specify a name, AWS CloudFormation CloudFormation generates a unique physical ID and uses that ID for the configuration recorder name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * <blockquote>
         * <p>
         * After you create a configuration recorder, you cannot rename it. If you don't want a name that AWS CloudFormation generates, specify a value for this property.
         * <p>
         * </blockquote>
         * <p>
         * Updates are not supported.
         * <p>
         * @return {@code this}
         * @param name A name for the configuration recorder. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Indicates whether to record configurations for all supported resources or for a list of resource types.
         * <p>
         * The resource types that you list must be supported by AWS Config .
         * <p>
         * @return {@code this}
         * @param recordingGroup Indicates whether to record configurations for all supported resources or for a list of resource types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingGroup(final software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingGroupProperty recordingGroup) {
            this.props.recordingGroup(recordingGroup);
            return this;
        }
        /**
         * Indicates whether to record configurations for all supported resources or for a list of resource types.
         * <p>
         * The resource types that you list must be supported by AWS Config .
         * <p>
         * @return {@code this}
         * @param recordingGroup Indicates whether to record configurations for all supported resources or for a list of resource types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingGroup(final software.amazon.awscdk.IResolvable recordingGroup) {
            this.props.recordingGroup(recordingGroup);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.config.CfnConfigurationRecorder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CfnConfigurationRecorder build() {
            return new software.amazon.awscdk.services.config.CfnConfigurationRecorder(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
