package software.amazon.awscdk.services.codepipeline;

/**
 * Properties for defining a `CfnWebhook`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * CfnWebhookProps cfnWebhookProps = CfnWebhookProps.builder()
 *         .authentication("authentication")
 *         .authenticationConfiguration(WebhookAuthConfigurationProperty.builder()
 *                 .allowedIpRange("allowedIpRange")
 *                 .secretToken("secretToken")
 *                 .build())
 *         .filters(List.of(WebhookFilterRuleProperty.builder()
 *                 .jsonPath("jsonPath")
 *                 // the properties below are optional
 *                 .matchEquals("matchEquals")
 *                 .build()))
 *         .targetAction("targetAction")
 *         .targetPipeline("targetPipeline")
 *         .targetPipelineVersion(123)
 *         // the properties below are optional
 *         .name("name")
 *         .registerWithThirdParty(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.475Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnWebhookProps")
@software.amazon.jsii.Jsii.Proxy(CfnWebhookProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWebhookProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.
     * <p>
     * <ul>
     * <li>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://docs.aws.amazon.com/https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</li>
     * <li>IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</li>
     * <li>UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthentication();

    /**
     * Properties that configure the authentication applied to incoming webhook trigger requests.
     * <p>
     * The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set. For IP, only the <code>AllowedIPRange</code> property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationConfiguration();

    /**
     * A list of rules applied to the body/payload sent in the POST request to a webhook URL.
     * <p>
     * All defined rules must pass for the request to be accepted and the pipeline started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFilters();

    /**
     * The name of the action in a pipeline you want to connect to the webhook.
     * <p>
     * The action must be from the source (first) stage of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetAction();

    /**
     * The name of the pipeline you want to connect to the webhook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetPipeline();

    /**
     * The version number of the pipeline to be connected to the trigger request.
     * <p>
     * Required: Yes
     * <p>
     * Type: Integer
     * <p>
     * Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-no-interrupt">No interruption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTargetPipelineVersion();

    /**
     * The name of the webhook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Configures a connection between the webhook that was created and the external tool with events to be detected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRegisterWithThirdParty() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWebhookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWebhookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWebhookProps> {
        java.lang.String authentication;
        java.lang.Object authenticationConfiguration;
        java.lang.Object filters;
        java.lang.String targetAction;
        java.lang.String targetPipeline;
        java.lang.Number targetPipelineVersion;
        java.lang.String name;
        java.lang.Object registerWithThirdParty;

        /**
         * Sets the value of {@link CfnWebhookProps#getAuthentication}
         * @param authentication Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED. This parameter is required.
         *                       <ul>
         *                       <li>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://docs.aws.amazon.com/https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</li>
         *                       <li>IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</li>
         *                       <li>UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authentication(java.lang.String authentication) {
            this.authentication = authentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getAuthenticationConfiguration}
         * @param authenticationConfiguration Properties that configure the authentication applied to incoming webhook trigger requests. This parameter is required.
         *                                    The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set. For IP, only the <code>AllowedIPRange</code> property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationConfiguration(software.amazon.awscdk.services.codepipeline.CfnWebhook.WebhookAuthConfigurationProperty authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getAuthenticationConfiguration}
         * @param authenticationConfiguration Properties that configure the authentication applied to incoming webhook trigger requests. This parameter is required.
         *                                    The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set. For IP, only the <code>AllowedIPRange</code> property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getFilters}
         * @param filters A list of rules applied to the body/payload sent in the POST request to a webhook URL. This parameter is required.
         *                All defined rules must pass for the request to be accepted and the pipeline started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(software.amazon.awscdk.IResolvable filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getFilters}
         * @param filters A list of rules applied to the body/payload sent in the POST request to a webhook URL. This parameter is required.
         *                All defined rules must pass for the request to be accepted and the pipeline started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(java.util.List<? extends java.lang.Object> filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getTargetAction}
         * @param targetAction The name of the action in a pipeline you want to connect to the webhook. This parameter is required.
         *                     The action must be from the source (first) stage of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetAction(java.lang.String targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getTargetPipeline}
         * @param targetPipeline The name of the pipeline you want to connect to the webhook. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPipeline(java.lang.String targetPipeline) {
            this.targetPipeline = targetPipeline;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getTargetPipelineVersion}
         * @param targetPipelineVersion The version number of the pipeline to be connected to the trigger request. This parameter is required.
         *                              Required: Yes
         *                              <p>
         *                              Type: Integer
         *                              <p>
         *                              Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-no-interrupt">No interruption</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPipelineVersion(java.lang.Number targetPipelineVersion) {
            this.targetPipelineVersion = targetPipelineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getName}
         * @param name The name of the webhook.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getRegisterWithThirdParty}
         * @param registerWithThirdParty Configures a connection between the webhook that was created and the external tool with events to be detected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registerWithThirdParty(java.lang.Boolean registerWithThirdParty) {
            this.registerWithThirdParty = registerWithThirdParty;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebhookProps#getRegisterWithThirdParty}
         * @param registerWithThirdParty Configures a connection between the webhook that was created and the external tool with events to be detected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registerWithThirdParty(software.amazon.awscdk.IResolvable registerWithThirdParty) {
            this.registerWithThirdParty = registerWithThirdParty;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWebhookProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWebhookProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWebhookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWebhookProps {
        private final java.lang.String authentication;
        private final java.lang.Object authenticationConfiguration;
        private final java.lang.Object filters;
        private final java.lang.String targetAction;
        private final java.lang.String targetPipeline;
        private final java.lang.Number targetPipelineVersion;
        private final java.lang.String name;
        private final java.lang.Object registerWithThirdParty;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authentication = software.amazon.jsii.Kernel.get(this, "authentication", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetAction = software.amazon.jsii.Kernel.get(this, "targetAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetPipeline = software.amazon.jsii.Kernel.get(this, "targetPipeline", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetPipelineVersion = software.amazon.jsii.Kernel.get(this, "targetPipelineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.registerWithThirdParty = software.amazon.jsii.Kernel.get(this, "registerWithThirdParty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authentication = java.util.Objects.requireNonNull(builder.authentication, "authentication is required");
            this.authenticationConfiguration = java.util.Objects.requireNonNull(builder.authenticationConfiguration, "authenticationConfiguration is required");
            this.filters = java.util.Objects.requireNonNull(builder.filters, "filters is required");
            this.targetAction = java.util.Objects.requireNonNull(builder.targetAction, "targetAction is required");
            this.targetPipeline = java.util.Objects.requireNonNull(builder.targetPipeline, "targetPipeline is required");
            this.targetPipelineVersion = java.util.Objects.requireNonNull(builder.targetPipelineVersion, "targetPipelineVersion is required");
            this.name = builder.name;
            this.registerWithThirdParty = builder.registerWithThirdParty;
        }

        @Override
        public final java.lang.String getAuthentication() {
            return this.authentication;
        }

        @Override
        public final java.lang.Object getAuthenticationConfiguration() {
            return this.authenticationConfiguration;
        }

        @Override
        public final java.lang.Object getFilters() {
            return this.filters;
        }

        @Override
        public final java.lang.String getTargetAction() {
            return this.targetAction;
        }

        @Override
        public final java.lang.String getTargetPipeline() {
            return this.targetPipeline;
        }

        @Override
        public final java.lang.Number getTargetPipelineVersion() {
            return this.targetPipelineVersion;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRegisterWithThirdParty() {
            return this.registerWithThirdParty;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authentication", om.valueToTree(this.getAuthentication()));
            data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
            data.set("filters", om.valueToTree(this.getFilters()));
            data.set("targetAction", om.valueToTree(this.getTargetAction()));
            data.set("targetPipeline", om.valueToTree(this.getTargetPipeline()));
            data.set("targetPipelineVersion", om.valueToTree(this.getTargetPipelineVersion()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRegisterWithThirdParty() != null) {
                data.set("registerWithThirdParty", om.valueToTree(this.getRegisterWithThirdParty()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnWebhookProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWebhookProps.Jsii$Proxy that = (CfnWebhookProps.Jsii$Proxy) o;

            if (!authentication.equals(that.authentication)) return false;
            if (!authenticationConfiguration.equals(that.authenticationConfiguration)) return false;
            if (!filters.equals(that.filters)) return false;
            if (!targetAction.equals(that.targetAction)) return false;
            if (!targetPipeline.equals(that.targetPipeline)) return false;
            if (!targetPipelineVersion.equals(that.targetPipelineVersion)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.registerWithThirdParty != null ? this.registerWithThirdParty.equals(that.registerWithThirdParty) : that.registerWithThirdParty == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authentication.hashCode();
            result = 31 * result + (this.authenticationConfiguration.hashCode());
            result = 31 * result + (this.filters.hashCode());
            result = 31 * result + (this.targetAction.hashCode());
            result = 31 * result + (this.targetPipeline.hashCode());
            result = 31 * result + (this.targetPipelineVersion.hashCode());
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.registerWithThirdParty != null ? this.registerWithThirdParty.hashCode() : 0);
            return result;
        }
    }
}
