package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties needed to make an alarm from a metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * HostedZone myHostedZone;
 * Certificate certificate = Certificate.Builder.create(this, "Certificate")
 *         .domainName("hello.example.com")
 *         .validation(CertificateValidation.fromDns(myHostedZone))
 *         .build();
 * certificate.metricDaysToExpiry().createAlarm(this, "Alarm", CreateAlarmOptions.builder()
 *         .comparisonOperator(ComparisonOperator.LESS_THAN_THRESHOLD)
 *         .evaluationPeriods(1)
 *         .threshold(45)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.254Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CreateAlarmOptions")
@software.amazon.jsii.Jsii.Proxy(CreateAlarmOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CreateAlarmOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getEvaluationPeriods();

    /**
     * The value against which the specified statistic is compared.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

    /**
     * Whether the actions for this alarm are enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getActionsEnabled() {
        return null;
    }

    /**
     * Description for the alarm.
     * <p>
     * Default: No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmDescription() {
        return null;
    }

    /**
     * Name of the alarm.
     * <p>
     * Default: Automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmName() {
        return null;
    }

    /**
     * Comparison to use to check if metric is breaching.
     * <p>
     * Default: GreaterThanOrEqualToThreshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.ComparisonOperator getComparisonOperator() {
        return null;
    }

    /**
     * The number of datapoints that must be breaching to trigger the alarm.
     * <p>
     * This is used only if you are setting an "M
     * out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
     * CloudWatch User Guide.
     * <p>
     * Default: ``evaluationPeriods``
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDatapointsToAlarm() {
        return null;
    }

    /**
     * Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
     * <p>
     * Used only for alarms that are based on percentiles.
     * <p>
     * Default: - Not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEvaluateLowSampleCountPercentile() {
        return null;
    }

    /**
     * Sets how this alarm is to handle missing data points.
     * <p>
     * Default: TreatMissingData.Missing
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.TreatMissingData getTreatMissingData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CreateAlarmOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CreateAlarmOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CreateAlarmOptions> {
        java.lang.Number evaluationPeriods;
        java.lang.Number threshold;
        java.lang.Boolean actionsEnabled;
        java.lang.String alarmDescription;
        java.lang.String alarmName;
        software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator;
        java.lang.Number datapointsToAlarm;
        java.lang.String evaluateLowSampleCountPercentile;
        software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData;

        /**
         * Sets the value of {@link CreateAlarmOptions#getEvaluationPeriods}
         * @param evaluationPeriods The number of periods over which data is compared to the specified threshold. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        /**
         * Sets the value of {@link CreateAlarmOptions#getThreshold}
         * @param threshold The value against which the specified statistic is compared. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder threshold(java.lang.Number threshold) {
            this.threshold = threshold;
            return this;
        }

        /**
         * Sets the value of {@link CreateAlarmOptions#getActionsEnabled}
         * @param actionsEnabled Whether the actions for this alarm are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(java.lang.Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CreateAlarmOptions#getAlarmDescription}
         * @param alarmDescription Description for the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(java.lang.String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        /**
         * Sets the value of {@link CreateAlarmOptions#getAlarmName}
         * @param alarmName Name of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(java.lang.String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        /**
         * Sets the value of {@link CreateAlarmOptions#getComparisonOperator}
         * @param comparisonOperator Comparison to use to check if metric is breaching.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comparisonOperator(software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        /**
         * Sets the value of {@link CreateAlarmOptions#getDatapointsToAlarm}
         * @param datapointsToAlarm The number of datapoints that must be breaching to trigger the alarm.
         *                          This is used only if you are setting an "M
         *                          out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
         *                          CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datapointsToAlarm(java.lang.Number datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        /**
         * Sets the value of {@link CreateAlarmOptions#getEvaluateLowSampleCountPercentile}
         * @param evaluateLowSampleCountPercentile Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
         *                                         Used only for alarms that are based on percentiles.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluateLowSampleCountPercentile(java.lang.String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        /**
         * Sets the value of {@link CreateAlarmOptions#getTreatMissingData}
         * @param treatMissingData Sets how this alarm is to handle missing data points.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatMissingData(software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CreateAlarmOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CreateAlarmOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CreateAlarmOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateAlarmOptions {
        private final java.lang.Number evaluationPeriods;
        private final java.lang.Number threshold;
        private final java.lang.Boolean actionsEnabled;
        private final java.lang.String alarmDescription;
        private final java.lang.String alarmName;
        private final software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator;
        private final java.lang.Number datapointsToAlarm;
        private final java.lang.String evaluateLowSampleCountPercentile;
        private final software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.actionsEnabled = software.amazon.jsii.Kernel.get(this, "actionsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.alarmDescription = software.amazon.jsii.Kernel.get(this, "alarmDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.ComparisonOperator.class));
            this.datapointsToAlarm = software.amazon.jsii.Kernel.get(this, "datapointsToAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.evaluateLowSampleCountPercentile = software.amazon.jsii.Kernel.get(this, "evaluateLowSampleCountPercentile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.treatMissingData = software.amazon.jsii.Kernel.get(this, "treatMissingData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TreatMissingData.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.evaluationPeriods = java.util.Objects.requireNonNull(builder.evaluationPeriods, "evaluationPeriods is required");
            this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
            this.actionsEnabled = builder.actionsEnabled;
            this.alarmDescription = builder.alarmDescription;
            this.alarmName = builder.alarmName;
            this.comparisonOperator = builder.comparisonOperator;
            this.datapointsToAlarm = builder.datapointsToAlarm;
            this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
            this.treatMissingData = builder.treatMissingData;
        }

        @Override
        public final java.lang.Number getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final java.lang.Number getThreshold() {
            return this.threshold;
        }

        @Override
        public final java.lang.Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final java.lang.String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final java.lang.String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.ComparisonOperator getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final java.lang.Number getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final java.lang.String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.TreatMissingData getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
            data.set("threshold", om.valueToTree(this.getThreshold()));
            if (this.getActionsEnabled() != null) {
                data.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
            }
            if (this.getAlarmDescription() != null) {
                data.set("alarmDescription", om.valueToTree(this.getAlarmDescription()));
            }
            if (this.getAlarmName() != null) {
                data.set("alarmName", om.valueToTree(this.getAlarmName()));
            }
            if (this.getComparisonOperator() != null) {
                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
            }
            if (this.getDatapointsToAlarm() != null) {
                data.set("datapointsToAlarm", om.valueToTree(this.getDatapointsToAlarm()));
            }
            if (this.getEvaluateLowSampleCountPercentile() != null) {
                data.set("evaluateLowSampleCountPercentile", om.valueToTree(this.getEvaluateLowSampleCountPercentile()));
            }
            if (this.getTreatMissingData() != null) {
                data.set("treatMissingData", om.valueToTree(this.getTreatMissingData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CreateAlarmOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CreateAlarmOptions.Jsii$Proxy that = (CreateAlarmOptions.Jsii$Proxy) o;

            if (!evaluationPeriods.equals(that.evaluationPeriods)) return false;
            if (!threshold.equals(that.threshold)) return false;
            if (this.actionsEnabled != null ? !this.actionsEnabled.equals(that.actionsEnabled) : that.actionsEnabled != null) return false;
            if (this.alarmDescription != null ? !this.alarmDescription.equals(that.alarmDescription) : that.alarmDescription != null) return false;
            if (this.alarmName != null ? !this.alarmName.equals(that.alarmName) : that.alarmName != null) return false;
            if (this.comparisonOperator != null ? !this.comparisonOperator.equals(that.comparisonOperator) : that.comparisonOperator != null) return false;
            if (this.datapointsToAlarm != null ? !this.datapointsToAlarm.equals(that.datapointsToAlarm) : that.datapointsToAlarm != null) return false;
            if (this.evaluateLowSampleCountPercentile != null ? !this.evaluateLowSampleCountPercentile.equals(that.evaluateLowSampleCountPercentile) : that.evaluateLowSampleCountPercentile != null) return false;
            return this.treatMissingData != null ? this.treatMissingData.equals(that.treatMissingData) : that.treatMissingData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.evaluationPeriods.hashCode();
            result = 31 * result + (this.threshold.hashCode());
            result = 31 * result + (this.actionsEnabled != null ? this.actionsEnabled.hashCode() : 0);
            result = 31 * result + (this.alarmDescription != null ? this.alarmDescription.hashCode() : 0);
            result = 31 * result + (this.alarmName != null ? this.alarmName.hashCode() : 0);
            result = 31 * result + (this.comparisonOperator != null ? this.comparisonOperator.hashCode() : 0);
            result = 31 * result + (this.datapointsToAlarm != null ? this.datapointsToAlarm.hashCode() : 0);
            result = 31 * result + (this.evaluateLowSampleCountPercentile != null ? this.evaluateLowSampleCountPercentile.hashCode() : 0);
            result = 31 * result + (this.treatMissingData != null ? this.treatMissingData.hashCode() : 0);
            return result;
        }
    }
}
