package software.amazon.awscdk.services.cloudtrail;

/**
 * Properties for defining a `CfnEventDataStore`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnEventDataStoreProps cfnEventDataStoreProps = CfnEventDataStoreProps.builder()
 *         .advancedEventSelectors(List.of(AdvancedEventSelectorProperty.builder()
 *                 .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
 *                         .field("field")
 *                         // the properties below are optional
 *                         .endsWith(List.of("endsWith"))
 *                         .equalTo(List.of("equalTo"))
 *                         .notEndsWith(List.of("notEndsWith"))
 *                         .notEquals(List.of("notEquals"))
 *                         .notStartsWith(List.of("notStartsWith"))
 *                         .startsWith(List.of("startsWith"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .multiRegionEnabled(false)
 *         .name("name")
 *         .organizationEnabled(false)
 *         .retentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .terminationProtectionEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.183Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStoreProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventDataStoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventDataStoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedEventSelectors() {
        return null;
    }

    /**
     * `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegionEnabled() {
        return null;
    }

    /**
     * `AWS::CloudTrail::EventDataStore.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * `AWS::CloudTrail::EventDataStore.OrganizationEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationEnabled() {
        return null;
    }

    /**
     * `AWS::CloudTrail::EventDataStore.RetentionPeriod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriod() {
        return null;
    }

    /**
     * `AWS::CloudTrail::EventDataStore.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtectionEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventDataStoreProps> {
        java.lang.Object advancedEventSelectors;
        java.lang.Object multiRegionEnabled;
        java.lang.String name;
        java.lang.Object organizationEnabled;
        java.lang.Number retentionPeriod;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object terminationProtectionEnabled;

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getAdvancedEventSelectors}
         * @param advancedEventSelectors `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(software.amazon.awscdk.IResolvable advancedEventSelectors) {
            this.advancedEventSelectors = advancedEventSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getAdvancedEventSelectors}
         * @param advancedEventSelectors `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(java.util.List<? extends java.lang.Object> advancedEventSelectors) {
            this.advancedEventSelectors = advancedEventSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getMultiRegionEnabled}
         * @param multiRegionEnabled `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(java.lang.Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getMultiRegionEnabled}
         * @param multiRegionEnabled `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(software.amazon.awscdk.IResolvable multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getName}
         * @param name `AWS::CloudTrail::EventDataStore.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getOrganizationEnabled}
         * @param organizationEnabled `AWS::CloudTrail::EventDataStore.OrganizationEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(java.lang.Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getOrganizationEnabled}
         * @param organizationEnabled `AWS::CloudTrail::EventDataStore.OrganizationEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(software.amazon.awscdk.IResolvable organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getRetentionPeriod}
         * @param retentionPeriod `AWS::CloudTrail::EventDataStore.RetentionPeriod`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(java.lang.Number retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTags}
         * @param tags `AWS::CloudTrail::EventDataStore.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTerminationProtectionEnabled}
         * @param terminationProtectionEnabled `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(java.lang.Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTerminationProtectionEnabled}
         * @param terminationProtectionEnabled `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(software.amazon.awscdk.IResolvable terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventDataStoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventDataStoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventDataStoreProps {
        private final java.lang.Object advancedEventSelectors;
        private final java.lang.Object multiRegionEnabled;
        private final java.lang.String name;
        private final java.lang.Object organizationEnabled;
        private final java.lang.Number retentionPeriod;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object terminationProtectionEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.advancedEventSelectors = software.amazon.jsii.Kernel.get(this, "advancedEventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.multiRegionEnabled = software.amazon.jsii.Kernel.get(this, "multiRegionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationEnabled = software.amazon.jsii.Kernel.get(this, "organizationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.terminationProtectionEnabled = software.amazon.jsii.Kernel.get(this, "terminationProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.advancedEventSelectors = builder.advancedEventSelectors;
            this.multiRegionEnabled = builder.multiRegionEnabled;
            this.name = builder.name;
            this.organizationEnabled = builder.organizationEnabled;
            this.retentionPeriod = builder.retentionPeriod;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        }

        @Override
        public final java.lang.Object getAdvancedEventSelectors() {
            return this.advancedEventSelectors;
        }

        @Override
        public final java.lang.Object getMultiRegionEnabled() {
            return this.multiRegionEnabled;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOrganizationEnabled() {
            return this.organizationEnabled;
        }

        @Override
        public final java.lang.Number getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdvancedEventSelectors() != null) {
                data.set("advancedEventSelectors", om.valueToTree(this.getAdvancedEventSelectors()));
            }
            if (this.getMultiRegionEnabled() != null) {
                data.set("multiRegionEnabled", om.valueToTree(this.getMultiRegionEnabled()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOrganizationEnabled() != null) {
                data.set("organizationEnabled", om.valueToTree(this.getOrganizationEnabled()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminationProtectionEnabled() != null) {
                data.set("terminationProtectionEnabled", om.valueToTree(this.getTerminationProtectionEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnEventDataStoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventDataStoreProps.Jsii$Proxy that = (CfnEventDataStoreProps.Jsii$Proxy) o;

            if (this.advancedEventSelectors != null ? !this.advancedEventSelectors.equals(that.advancedEventSelectors) : that.advancedEventSelectors != null) return false;
            if (this.multiRegionEnabled != null ? !this.multiRegionEnabled.equals(that.multiRegionEnabled) : that.multiRegionEnabled != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.organizationEnabled != null ? !this.organizationEnabled.equals(that.organizationEnabled) : that.organizationEnabled != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.terminationProtectionEnabled != null ? this.terminationProtectionEnabled.equals(that.terminationProtectionEnabled) : that.terminationProtectionEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.advancedEventSelectors != null ? this.advancedEventSelectors.hashCode() : 0;
            result = 31 * result + (this.multiRegionEnabled != null ? this.multiRegionEnabled.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.organizationEnabled != null ? this.organizationEnabled.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminationProtectionEnabled != null ? this.terminationProtectionEnabled.hashCode() : 0);
            return result;
        }
    }
}
