package software.amazon.awscdk.services.cloudfront;

/**
 * How HTTPs should be handled with your distribution.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Distribution with configured HTTP methods and viewer protocol policy of the cache.
 * Bucket myBucket;
 * Distribution myWebDistribution = Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(myBucket))
 *                 .allowedMethods(AllowedMethods.ALLOW_ALL)
 *                 .viewerProtocolPolicy(ViewerProtocolPolicy.REDIRECT_TO_HTTPS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.155Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ViewerProtocolPolicy")
public enum ViewerProtocolPolicy {
    /**
     * HTTPS only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS_ONLY,
    /**
     * Will redirect HTTP requests to HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REDIRECT_TO_HTTPS,
    /**
     * Both HTTP and HTTPS supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALLOW_ALL,
}
