package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFormation `AWS::CloudFront::OriginAccessControl`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnOriginAccessControl cfnOriginAccessControl = CfnOriginAccessControl.Builder.create(this, "MyCfnOriginAccessControl")
 *         .originAccessControlConfig(OriginAccessControlConfigProperty.builder()
 *                 .name("name")
 *                 .originAccessControlOriginType("originAccessControlOriginType")
 *                 .signingBehavior("signingBehavior")
 *                 .signingProtocol("signingProtocol")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.096Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnOriginAccessControl")
public class CfnOriginAccessControl extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnOriginAccessControl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOriginAccessControl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFront::OriginAccessControl`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOriginAccessControl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnOriginAccessControlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CloudFront::OriginAccessControl.OriginAccessControlConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOriginAccessControlConfig() {
        return software.amazon.jsii.Kernel.get(this, "originAccessControlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudFront::OriginAccessControl.OriginAccessControlConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginAccessControlConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl.OriginAccessControlConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "originAccessControlConfig", java.util.Objects.requireNonNull(value, "originAccessControlConfig is required"));
    }

    /**
     * `AWS::CloudFront::OriginAccessControl.OriginAccessControlConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginAccessControlConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "originAccessControlConfig", java.util.Objects.requireNonNull(value, "originAccessControlConfig is required"));
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginAccessControlConfigProperty originAccessControlConfigProperty = OriginAccessControlConfigProperty.builder()
     *         .name("name")
     *         .originAccessControlOriginType("originAccessControlOriginType")
     *         .signingBehavior("signingBehavior")
     *         .signingProtocol("signingProtocol")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnOriginAccessControl.OriginAccessControlConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginAccessControlConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginAccessControlConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnOriginAccessControl.OriginAccessControlConfigProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnOriginAccessControl.OriginAccessControlConfigProperty.OriginAccessControlOriginType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessControlOriginType();

        /**
         * `CfnOriginAccessControl.OriginAccessControlConfigProperty.SigningBehavior`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSigningBehavior();

        /**
         * `CfnOriginAccessControl.OriginAccessControlConfigProperty.SigningProtocol`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSigningProtocol();

        /**
         * `CfnOriginAccessControl.OriginAccessControlConfigProperty.Description`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginAccessControlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginAccessControlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginAccessControlConfigProperty> {
            java.lang.String name;
            java.lang.String originAccessControlOriginType;
            java.lang.String signingBehavior;
            java.lang.String signingProtocol;
            java.lang.String description;

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getName}
             * @param name `CfnOriginAccessControl.OriginAccessControlConfigProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getOriginAccessControlOriginType}
             * @param originAccessControlOriginType `CfnOriginAccessControl.OriginAccessControlConfigProperty.OriginAccessControlOriginType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessControlOriginType(java.lang.String originAccessControlOriginType) {
                this.originAccessControlOriginType = originAccessControlOriginType;
                return this;
            }

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getSigningBehavior}
             * @param signingBehavior `CfnOriginAccessControl.OriginAccessControlConfigProperty.SigningBehavior`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingBehavior(java.lang.String signingBehavior) {
                this.signingBehavior = signingBehavior;
                return this;
            }

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getSigningProtocol}
             * @param signingProtocol `CfnOriginAccessControl.OriginAccessControlConfigProperty.SigningProtocol`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingProtocol(java.lang.String signingProtocol) {
                this.signingProtocol = signingProtocol;
                return this;
            }

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getDescription}
             * @param description `CfnOriginAccessControl.OriginAccessControlConfigProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginAccessControlConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginAccessControlConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginAccessControlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginAccessControlConfigProperty {
            private final java.lang.String name;
            private final java.lang.String originAccessControlOriginType;
            private final java.lang.String signingBehavior;
            private final java.lang.String signingProtocol;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originAccessControlOriginType = software.amazon.jsii.Kernel.get(this, "originAccessControlOriginType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signingBehavior = software.amazon.jsii.Kernel.get(this, "signingBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signingProtocol = software.amazon.jsii.Kernel.get(this, "signingProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.originAccessControlOriginType = java.util.Objects.requireNonNull(builder.originAccessControlOriginType, "originAccessControlOriginType is required");
                this.signingBehavior = java.util.Objects.requireNonNull(builder.signingBehavior, "signingBehavior is required");
                this.signingProtocol = java.util.Objects.requireNonNull(builder.signingProtocol, "signingProtocol is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getOriginAccessControlOriginType() {
                return this.originAccessControlOriginType;
            }

            @Override
            public final java.lang.String getSigningBehavior() {
                return this.signingBehavior;
            }

            @Override
            public final java.lang.String getSigningProtocol() {
                return this.signingProtocol;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("originAccessControlOriginType", om.valueToTree(this.getOriginAccessControlOriginType()));
                data.set("signingBehavior", om.valueToTree(this.getSigningBehavior()));
                data.set("signingProtocol", om.valueToTree(this.getSigningProtocol()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnOriginAccessControl.OriginAccessControlConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginAccessControlConfigProperty.Jsii$Proxy that = (OriginAccessControlConfigProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!originAccessControlOriginType.equals(that.originAccessControlOriginType)) return false;
                if (!signingBehavior.equals(that.signingBehavior)) return false;
                if (!signingProtocol.equals(that.signingProtocol)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.originAccessControlOriginType.hashCode());
                result = 31 * result + (this.signingBehavior.hashCode());
                result = 31 * result + (this.signingProtocol.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnOriginAccessControlProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnOriginAccessControlProps.Builder();
        }

        /**
         * `AWS::CloudFront::OriginAccessControl.OriginAccessControlConfig`.
         * <p>
         * @return {@code this}
         * @param originAccessControlConfig `AWS::CloudFront::OriginAccessControl.OriginAccessControlConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlConfig(final software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl.OriginAccessControlConfigProperty originAccessControlConfig) {
            this.props.originAccessControlConfig(originAccessControlConfig);
            return this;
        }
        /**
         * `AWS::CloudFront::OriginAccessControl.OriginAccessControlConfig`.
         * <p>
         * @return {@code this}
         * @param originAccessControlConfig `AWS::CloudFront::OriginAccessControl.OriginAccessControlConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlConfig(final software.amazon.awscdk.IResolvable originAccessControlConfig) {
            this.props.originAccessControlConfig(originAccessControlConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl build() {
            return new software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
