package software.amazon.awscdk.services.backup;

/**
 * Properties for a BackupSelection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * import software.amazon.awscdk.services.iam.*;
 * BackupPlan backupPlan;
 * BackupResource backupResource;
 * Role role;
 * BackupSelectionProps backupSelectionProps = BackupSelectionProps.builder()
 *         .backupPlan(backupPlan)
 *         .resources(List.of(backupResource))
 *         // the properties below are optional
 *         .allowRestores(false)
 *         .backupSelectionName("backupSelectionName")
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.852Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupSelectionProps")
@software.amazon.jsii.Jsii.Proxy(BackupSelectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BackupSelectionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.backup.BackupSelectionOptions {

    /**
     * The backup plan for this selection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.IBackupPlan getBackupPlan();

    /**
     * @return a {@link Builder} of {@link BackupSelectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupSelectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BackupSelectionProps> {
        software.amazon.awscdk.services.backup.IBackupPlan backupPlan;
        java.util.List<software.amazon.awscdk.services.backup.BackupResource> resources;
        java.lang.Boolean allowRestores;
        java.lang.String backupSelectionName;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link BackupSelectionProps#getBackupPlan}
         * @param backupPlan The backup plan for this selection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlan(software.amazon.awscdk.services.backup.IBackupPlan backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        /**
         * Sets the value of {@link BackupSelectionProps#getResources}
         * @param resources The resources to backup. This parameter is required.
         *                  Use the helper static methods defined on <code>BackupResource</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resources(java.util.List<? extends software.amazon.awscdk.services.backup.BackupResource> resources) {
            this.resources = (java.util.List<software.amazon.awscdk.services.backup.BackupResource>)resources;
            return this;
        }

        /**
         * Sets the value of {@link BackupSelectionProps#getAllowRestores}
         * @param allowRestores Whether to automatically give restores permissions to the role that AWS Backup uses.
         *                      If <code>true</code>, the <code>AWSBackupServiceRolePolicyForRestores</code> managed
         *                      policy will be attached to the role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowRestores(java.lang.Boolean allowRestores) {
            this.allowRestores = allowRestores;
            return this;
        }

        /**
         * Sets the value of {@link BackupSelectionProps#getBackupSelectionName}
         * @param backupSelectionName The name for this selection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupSelectionName(java.lang.String backupSelectionName) {
            this.backupSelectionName = backupSelectionName;
            return this;
        }

        /**
         * Sets the value of {@link BackupSelectionProps#getRole}
         * @param role The role that AWS Backup uses to authenticate when backuping or restoring the resources.
         *             The <code>AWSBackupServiceRolePolicyForBackup</code> managed policy
         *             will be attached to this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupSelectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BackupSelectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackupSelectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupSelectionProps {
        private final software.amazon.awscdk.services.backup.IBackupPlan backupPlan;
        private final java.util.List<software.amazon.awscdk.services.backup.BackupResource> resources;
        private final java.lang.Boolean allowRestores;
        private final java.lang.String backupSelectionName;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupPlan = software.amazon.jsii.Kernel.get(this, "backupPlan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.IBackupPlan.class));
            this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class)));
            this.allowRestores = software.amazon.jsii.Kernel.get(this, "allowRestores", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.backupSelectionName = software.amazon.jsii.Kernel.get(this, "backupSelectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupPlan = java.util.Objects.requireNonNull(builder.backupPlan, "backupPlan is required");
            this.resources = (java.util.List<software.amazon.awscdk.services.backup.BackupResource>)java.util.Objects.requireNonNull(builder.resources, "resources is required");
            this.allowRestores = builder.allowRestores;
            this.backupSelectionName = builder.backupSelectionName;
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.backup.IBackupPlan getBackupPlan() {
            return this.backupPlan;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.backup.BackupResource> getResources() {
            return this.resources;
        }

        @Override
        public final java.lang.Boolean getAllowRestores() {
            return this.allowRestores;
        }

        @Override
        public final java.lang.String getBackupSelectionName() {
            return this.backupSelectionName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backupPlan", om.valueToTree(this.getBackupPlan()));
            data.set("resources", om.valueToTree(this.getResources()));
            if (this.getAllowRestores() != null) {
                data.set("allowRestores", om.valueToTree(this.getAllowRestores()));
            }
            if (this.getBackupSelectionName() != null) {
                data.set("backupSelectionName", om.valueToTree(this.getBackupSelectionName()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.BackupSelectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupSelectionProps.Jsii$Proxy that = (BackupSelectionProps.Jsii$Proxy) o;

            if (!backupPlan.equals(that.backupPlan)) return false;
            if (!resources.equals(that.resources)) return false;
            if (this.allowRestores != null ? !this.allowRestores.equals(that.allowRestores) : that.allowRestores != null) return false;
            if (this.backupSelectionName != null ? !this.backupSelectionName.equals(that.backupSelectionName) : that.backupSelectionName != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backupPlan.hashCode();
            result = 31 * result + (this.resources.hashCode());
            result = 31 * result + (this.allowRestores != null ? this.allowRestores.hashCode() : 0);
            result = 31 * result + (this.backupSelectionName != null ? this.backupSelectionName.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
