package software.amazon.awscdk.services.autoscaling;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * AutoScalingGroup autoScalingGroup;
 * Metric workerUtilizationMetric = Metric.Builder.create()
 *         .namespace("MyService")
 *         .metricName("WorkerUtilization")
 *         .build();
 * autoScalingGroup.scaleOnMetric("ScaleToCPU", BasicStepScalingPolicyProps.builder()
 *         .metric(workerUtilizationMetric)
 *         .scalingSteps(List.of(ScalingInterval.builder().upper(10).change(-1).build(), ScalingInterval.builder().lower(50).change(+1).build(), ScalingInterval.builder().lower(70).change(+3).build()))
 *         // Change this to AdjustmentType.PERCENT_CHANGE_IN_CAPACITY to interpret the
 *         // 'change' numbers before as percentages instead of capacity counts.
 *         .adjustmentType(AdjustmentType.CHANGE_IN_CAPACITY)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.726Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.BasicStepScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(BasicStepScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BasicStepScalingPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Metric to scale on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric getMetric();

    /**
     * The intervals for scaling.
     * <p>
     * Maps a range of metric values to a particular scaling behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> getScalingSteps();

    /**
     * How the adjustment numbers inside 'intervals' are interpreted.
     * <p>
     * Default: ChangeInCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.AdjustmentType getAdjustmentType() {
        return null;
    }

    /**
     * Grace period after scaling activity.
     * <p>
     * Default: Default cooldown period on your AutoScalingGroup
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getCooldown() {
        return null;
    }

    /**
     * Estimated time until a newly launched instance can send metrics to CloudWatch.
     * <p>
     * Default: Same as the cooldown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getEstimatedInstanceWarmup() {
        return null;
    }

    /**
     * How many evaluation periods of the metric to wait before triggering a scaling action.
     * <p>
     * Raising this value can be used to smooth out the metric, at the expense
     * of slower response times.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationPeriods() {
        return null;
    }

    /**
     * Aggregation to apply to all data points over the evaluation periods.
     * <p>
     * Only has meaning if <code>evaluationPeriods != 1</code>.
     * <p>
     * Default: - The statistic from the metric if applicable (MIN, MAX, AVERAGE), otherwise AVERAGE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.MetricAggregationType getMetricAggregationType() {
        return null;
    }

    /**
     * Minimum absolute number to adjust capacity with as result of percentage scaling.
     * <p>
     * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
     * the minimum absolute effect size.
     * <p>
     * Default: No minimum scaling effect
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinAdjustmentMagnitude() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BasicStepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BasicStepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BasicStepScalingPolicyProps> {
        software.amazon.awscdk.services.cloudwatch.IMetric metric;
        java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> scalingSteps;
        software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType;
        software.amazon.awscdk.Duration cooldown;
        software.amazon.awscdk.Duration estimatedInstanceWarmup;
        java.lang.Number evaluationPeriods;
        software.amazon.awscdk.services.autoscaling.MetricAggregationType metricAggregationType;
        java.lang.Number minAdjustmentMagnitude;

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getMetric}
         * @param metric Metric to scale on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getScalingSteps}
         * @param scalingSteps The intervals for scaling. This parameter is required.
         *                     Maps a range of metric values to a particular scaling behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder scalingSteps(java.util.List<? extends software.amazon.awscdk.services.autoscaling.ScalingInterval> scalingSteps) {
            this.scalingSteps = (java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval>)scalingSteps;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getAdjustmentType}
         * @param adjustmentType How the adjustment numbers inside 'intervals' are interpreted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getCooldown}
         * @param cooldown Grace period after scaling activity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getEstimatedInstanceWarmup}
         * @param estimatedInstanceWarmup Estimated time until a newly launched instance can send metrics to CloudWatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder estimatedInstanceWarmup(software.amazon.awscdk.Duration estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getEvaluationPeriods}
         * @param evaluationPeriods How many evaluation periods of the metric to wait before triggering a scaling action.
         *                          Raising this value can be used to smooth out the metric, at the expense
         *                          of slower response times.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getMetricAggregationType}
         * @param metricAggregationType Aggregation to apply to all data points over the evaluation periods.
         *                              Only has meaning if <code>evaluationPeriods != 1</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricAggregationType(software.amazon.awscdk.services.autoscaling.MetricAggregationType metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getMinAdjustmentMagnitude}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling.
         *                               Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         *                               the minimum absolute effect size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BasicStepScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BasicStepScalingPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BasicStepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicStepScalingPolicyProps {
        private final software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> scalingSteps;
        private final software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType;
        private final software.amazon.awscdk.Duration cooldown;
        private final software.amazon.awscdk.Duration estimatedInstanceWarmup;
        private final java.lang.Number evaluationPeriods;
        private final software.amazon.awscdk.services.autoscaling.MetricAggregationType metricAggregationType;
        private final java.lang.Number minAdjustmentMagnitude;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
            this.scalingSteps = software.amazon.jsii.Kernel.get(this, "scalingSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingInterval.class)));
            this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AdjustmentType.class));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.estimatedInstanceWarmup = software.amazon.jsii.Kernel.get(this, "estimatedInstanceWarmup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricAggregationType = software.amazon.jsii.Kernel.get(this, "metricAggregationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.MetricAggregationType.class));
            this.minAdjustmentMagnitude = software.amazon.jsii.Kernel.get(this, "minAdjustmentMagnitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
            this.scalingSteps = (java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval>)java.util.Objects.requireNonNull(builder.scalingSteps, "scalingSteps is required");
            this.adjustmentType = builder.adjustmentType;
            this.cooldown = builder.cooldown;
            this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
            this.evaluationPeriods = builder.evaluationPeriods;
            this.metricAggregationType = builder.metricAggregationType;
            this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
            return this.metric;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> getScalingSteps() {
            return this.scalingSteps;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.AdjustmentType getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final software.amazon.awscdk.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final software.amazon.awscdk.Duration getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public final java.lang.Number getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.MetricAggregationType getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final java.lang.Number getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metric", om.valueToTree(this.getMetric()));
            data.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
            if (this.getAdjustmentType() != null) {
                data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getEstimatedInstanceWarmup() != null) {
                data.set("estimatedInstanceWarmup", om.valueToTree(this.getEstimatedInstanceWarmup()));
            }
            if (this.getEvaluationPeriods() != null) {
                data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
            }
            if (this.getMetricAggregationType() != null) {
                data.set("metricAggregationType", om.valueToTree(this.getMetricAggregationType()));
            }
            if (this.getMinAdjustmentMagnitude() != null) {
                data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.BasicStepScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BasicStepScalingPolicyProps.Jsii$Proxy that = (BasicStepScalingPolicyProps.Jsii$Proxy) o;

            if (!metric.equals(that.metric)) return false;
            if (!scalingSteps.equals(that.scalingSteps)) return false;
            if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.estimatedInstanceWarmup != null ? !this.estimatedInstanceWarmup.equals(that.estimatedInstanceWarmup) : that.estimatedInstanceWarmup != null) return false;
            if (this.evaluationPeriods != null ? !this.evaluationPeriods.equals(that.evaluationPeriods) : that.evaluationPeriods != null) return false;
            if (this.metricAggregationType != null ? !this.metricAggregationType.equals(that.metricAggregationType) : that.metricAggregationType != null) return false;
            return this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metric.hashCode();
            result = 31 * result + (this.scalingSteps.hashCode());
            result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.hashCode() : 0);
            result = 31 * result + (this.evaluationPeriods != null ? this.evaluationPeriods.hashCode() : 0);
            result = 31 * result + (this.metricAggregationType != null ? this.metricAggregationType.hashCode() : 0);
            result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
            return result;
        }
    }
}
