package software.amazon.awscdk.services.appmesh;

/**
 * Properties for a VirtualRouter listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * VirtualRouterListenerConfig virtualRouterListenerConfig = VirtualRouterListenerConfig.builder()
 *         .listener(VirtualRouterListenerProperty.builder()
 *                 .portMapping(PortMappingProperty.builder()
 *                         .port(123)
 *                         .protocol("protocol")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.588Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualRouterListenerConfig")
@software.amazon.jsii.Jsii.Proxy(VirtualRouterListenerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualRouterListenerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Single listener config for a VirtualRouter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualRouter.VirtualRouterListenerProperty getListener();

    /**
     * @return a {@link Builder} of {@link VirtualRouterListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualRouterListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualRouterListenerConfig> {
        software.amazon.awscdk.services.appmesh.CfnVirtualRouter.VirtualRouterListenerProperty listener;

        /**
         * Sets the value of {@link VirtualRouterListenerConfig#getListener}
         * @param listener Single listener config for a VirtualRouter. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.appmesh.CfnVirtualRouter.VirtualRouterListenerProperty listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualRouterListenerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualRouterListenerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualRouterListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualRouterListenerConfig {
        private final software.amazon.awscdk.services.appmesh.CfnVirtualRouter.VirtualRouterListenerProperty listener;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listener = software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnVirtualRouter.VirtualRouterListenerProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listener = java.util.Objects.requireNonNull(builder.listener, "listener is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnVirtualRouter.VirtualRouterListenerProperty getListener() {
            return this.listener;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listener", om.valueToTree(this.getListener()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualRouterListenerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualRouterListenerConfig.Jsii$Proxy that = (VirtualRouterListenerConfig.Jsii$Proxy) o;

            return this.listener.equals(that.listener);
        }

        @Override
        public final int hashCode() {
            int result = this.listener.hashCode();
            return result;
        }
    }
}
