package software.amazon.awscdk.services.appmesh;

/**
 * Properties for a VirtualNode listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * VirtualNodeListenerConfig virtualNodeListenerConfig = VirtualNodeListenerConfig.builder()
 *         .listener(ListenerProperty.builder()
 *                 .portMapping(PortMappingProperty.builder()
 *                         .port(123)
 *                         .protocol("protocol")
 *                         .build())
 *                 // the properties below are optional
 *                 .connectionPool(VirtualNodeConnectionPoolProperty.builder()
 *                         .grpc(VirtualNodeGrpcConnectionPoolProperty.builder()
 *                                 .maxRequests(123)
 *                                 .build())
 *                         .http(VirtualNodeHttpConnectionPoolProperty.builder()
 *                                 .maxConnections(123)
 *                                 // the properties below are optional
 *                                 .maxPendingRequests(123)
 *                                 .build())
 *                         .http2(VirtualNodeHttp2ConnectionPoolProperty.builder()
 *                                 .maxRequests(123)
 *                                 .build())
 *                         .tcp(VirtualNodeTcpConnectionPoolProperty.builder()
 *                                 .maxConnections(123)
 *                                 .build())
 *                         .build())
 *                 .healthCheck(HealthCheckProperty.builder()
 *                         .healthyThreshold(123)
 *                         .intervalMillis(123)
 *                         .protocol("protocol")
 *                         .timeoutMillis(123)
 *                         .unhealthyThreshold(123)
 *                         // the properties below are optional
 *                         .path("path")
 *                         .port(123)
 *                         .build())
 *                 .outlierDetection(OutlierDetectionProperty.builder()
 *                         .baseEjectionDuration(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .interval(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .maxEjectionPercent(123)
 *                         .maxServerErrors(123)
 *                         .build())
 *                 .timeout(ListenerTimeoutProperty.builder()
 *                         .grpc(GrpcTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .http(HttpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .http2(HttpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .tcp(TcpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .tls(ListenerTlsProperty.builder()
 *                         .certificate(ListenerTlsCertificateProperty.builder()
 *                                 .acm(ListenerTlsAcmCertificateProperty.builder()
 *                                         .certificateArn("certificateArn")
 *                                         .build())
 *                                 .file(ListenerTlsFileCertificateProperty.builder()
 *                                         .certificateChain("certificateChain")
 *                                         .privateKey("privateKey")
 *                                         .build())
 *                                 .sds(ListenerTlsSdsCertificateProperty.builder()
 *                                         .secretName("secretName")
 *                                         .build())
 *                                 .build())
 *                         .mode("mode")
 *                         // the properties below are optional
 *                         .validation(ListenerTlsValidationContextProperty.builder()
 *                                 .trust(ListenerTlsValidationContextTrustProperty.builder()
 *                                         .file(TlsValidationContextFileTrustProperty.builder()
 *                                                 .certificateChain("certificateChain")
 *                                                 .build())
 *                                         .sds(TlsValidationContextSdsTrustProperty.builder()
 *                                                 .secretName("secretName")
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                         .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                 .exact(List.of("exact"))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.586Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualNodeListenerConfig")
@software.amazon.jsii.Jsii.Proxy(VirtualNodeListenerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualNodeListenerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Single listener config for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerProperty getListener();

    /**
     * @return a {@link Builder} of {@link VirtualNodeListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualNodeListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeListenerConfig> {
        software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerProperty listener;

        /**
         * Sets the value of {@link VirtualNodeListenerConfig#getListener}
         * @param listener Single listener config for a VirtualNode. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerProperty listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualNodeListenerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualNodeListenerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualNodeListenerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeListenerConfig {
        private final software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerProperty listener;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listener = software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listener = java.util.Objects.requireNonNull(builder.listener, "listener is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerProperty getListener() {
            return this.listener;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listener", om.valueToTree(this.getListener()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualNodeListenerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualNodeListenerConfig.Jsii$Proxy that = (VirtualNodeListenerConfig.Jsii$Proxy) o;

            return this.listener.equals(that.listener);
        }

        @Override
        public final int hashCode() {
            int result = this.listener.hashCode();
            return result;
        }
    }
}
