package software.amazon.awscdk.pipelines;

/**
 * Options to pass to `addStage`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline;
 * MyApplicationStage preprod = new MyApplicationStage(this, "PreProd");
 * MyApplicationStage prod = new MyApplicationStage(this, "Prod");
 * pipeline.addStage(preprod, AddStageOpts.builder()
 *         .post(List.of(
 *             ShellStep.Builder.create("Validate Endpoint")
 *                     .commands(List.of("curl -Ssf https://my.webservice.com/"))
 *                     .build()))
 *         .build());
 * pipeline.addStage(prod, AddStageOpts.builder()
 *         .pre(List.of(
 *             new ManualApprovalStep("PromoteToProd")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:42.926Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.AddStageOpts")
@software.amazon.jsii.Jsii.Proxy(AddStageOpts.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddStageOpts extends software.amazon.jsii.JsiiSerializable {

    /**
     * Additional steps to run after all of the stacks in the stage.
     * <p>
     * Default: - No additional steps
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
        return null;
    }

    /**
     * Additional steps to run before any of the stacks in the stage.
     * <p>
     * Default: - No additional steps
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
        return null;
    }

    /**
     * Instructions for stack level steps.
     * <p>
     * Default: - No additional instructions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.StackSteps> getStackSteps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddStageOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddStageOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddStageOpts> {
        java.util.List<software.amazon.awscdk.pipelines.Step> post;
        java.util.List<software.amazon.awscdk.pipelines.Step> pre;
        java.util.List<software.amazon.awscdk.pipelines.StackSteps> stackSteps;

        /**
         * Sets the value of {@link AddStageOpts#getPost}
         * @param post Additional steps to run after all of the stacks in the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder post(java.util.List<? extends software.amazon.awscdk.pipelines.Step> post) {
            this.post = (java.util.List<software.amazon.awscdk.pipelines.Step>)post;
            return this;
        }

        /**
         * Sets the value of {@link AddStageOpts#getPre}
         * @param pre Additional steps to run before any of the stacks in the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder pre(java.util.List<? extends software.amazon.awscdk.pipelines.Step> pre) {
            this.pre = (java.util.List<software.amazon.awscdk.pipelines.Step>)pre;
            return this;
        }

        /**
         * Sets the value of {@link AddStageOpts#getStackSteps}
         * @param stackSteps Instructions for stack level steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder stackSteps(java.util.List<? extends software.amazon.awscdk.pipelines.StackSteps> stackSteps) {
            this.stackSteps = (java.util.List<software.amazon.awscdk.pipelines.StackSteps>)stackSteps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddStageOpts}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddStageOpts build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddStageOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddStageOpts {
        private final java.util.List<software.amazon.awscdk.pipelines.Step> post;
        private final java.util.List<software.amazon.awscdk.pipelines.Step> pre;
        private final java.util.List<software.amazon.awscdk.pipelines.StackSteps> stackSteps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.post = software.amazon.jsii.Kernel.get(this, "post", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class)));
            this.pre = software.amazon.jsii.Kernel.get(this, "pre", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class)));
            this.stackSteps = software.amazon.jsii.Kernel.get(this, "stackSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackSteps.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.post = (java.util.List<software.amazon.awscdk.pipelines.Step>)builder.post;
            this.pre = (java.util.List<software.amazon.awscdk.pipelines.Step>)builder.pre;
            this.stackSteps = (java.util.List<software.amazon.awscdk.pipelines.StackSteps>)builder.stackSteps;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
            return this.post;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
            return this.pre;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.StackSteps> getStackSteps() {
            return this.stackSteps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPost() != null) {
                data.set("post", om.valueToTree(this.getPost()));
            }
            if (this.getPre() != null) {
                data.set("pre", om.valueToTree(this.getPre()));
            }
            if (this.getStackSteps() != null) {
                data.set("stackSteps", om.valueToTree(this.getStackSteps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.AddStageOpts"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddStageOpts.Jsii$Proxy that = (AddStageOpts.Jsii$Proxy) o;

            if (this.post != null ? !this.post.equals(that.post) : that.post != null) return false;
            if (this.pre != null ? !this.pre.equals(that.pre) : that.pre != null) return false;
            return this.stackSteps != null ? this.stackSteps.equals(that.stackSteps) : that.stackSteps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.post != null ? this.post.hashCode() : 0;
            result = 31 * result + (this.pre != null ? this.pre.hashCode() : 0);
            result = 31 * result + (this.stackSteps != null ? this.stackSteps.hashCode() : 0);
            return result;
        }
    }
}
