package software.amazon.awscdk.services.xray;

/**
 * Properties for defining a `CfnGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.xray.*;
 * Object tags;
 * CfnGroupProps cfnGroupProps = CfnGroupProps.builder()
 *         .filterExpression("filterExpression")
 *         .groupName("groupName")
 *         .insightsConfiguration(InsightsConfigurationProperty.builder()
 *                 .insightsEnabled(false)
 *                 .notificationsEnabled(false)
 *                 .build())
 *         .tags(List.of(tags))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:02.902Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_xray.CfnGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The filter expression defining the parameters to include traces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFilterExpression() {
        return null;
    }

    /**
     * The unique case-sensitive name of the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return null;
    }

    /**
     * The structure containing configurations related to insights.
     * <p>
     * <ul>
     * <li>The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for the group.</li>
     * <li>The NotificationsEnabled boolean can be set to true to enable insights notifications through Amazon EventBridge for the group.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInsightsConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGroupProps> {
        java.lang.String filterExpression;
        java.lang.String groupName;
        java.lang.Object insightsConfiguration;
        java.util.List<java.lang.Object> tags;

        /**
         * Sets the value of {@link CfnGroupProps#getFilterExpression}
         * @param filterExpression The filter expression defining the parameters to include traces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterExpression(java.lang.String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getGroupName}
         * @param groupName The unique case-sensitive name of the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getInsightsConfiguration}
         * @param insightsConfiguration The structure containing configurations related to insights.
         *                              <ul>
         *                              <li>The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for the group.</li>
         *                              <li>The NotificationsEnabled boolean can be set to true to enable insights notifications through Amazon EventBridge for the group.</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightsConfiguration(software.amazon.awscdk.services.xray.CfnGroup.InsightsConfigurationProperty insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getInsightsConfiguration}
         * @param insightsConfiguration The structure containing configurations related to insights.
         *                              <ul>
         *                              <li>The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for the group.</li>
         *                              <li>The NotificationsEnabled boolean can be set to true to enable insights notifications through Amazon EventBridge for the group.</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightsConfiguration(software.amazon.awscdk.IResolvable insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends java.lang.Object> tags) {
            this.tags = (java.util.List<java.lang.Object>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGroupProps {
        private final java.lang.String filterExpression;
        private final java.lang.String groupName;
        private final java.lang.Object insightsConfiguration;
        private final java.util.List<java.lang.Object> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filterExpression = software.amazon.jsii.Kernel.get(this, "filterExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insightsConfiguration = software.amazon.jsii.Kernel.get(this, "insightsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filterExpression = builder.filterExpression;
            this.groupName = builder.groupName;
            this.insightsConfiguration = builder.insightsConfiguration;
            this.tags = (java.util.List<java.lang.Object>)builder.tags;
        }

        @Override
        public final java.lang.String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public final java.lang.Object getInsightsConfiguration() {
            return this.insightsConfiguration;
        }

        @Override
        public final java.util.List<java.lang.Object> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFilterExpression() != null) {
                data.set("filterExpression", om.valueToTree(this.getFilterExpression()));
            }
            if (this.getGroupName() != null) {
                data.set("groupName", om.valueToTree(this.getGroupName()));
            }
            if (this.getInsightsConfiguration() != null) {
                data.set("insightsConfiguration", om.valueToTree(this.getInsightsConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_xray.CfnGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGroupProps.Jsii$Proxy that = (CfnGroupProps.Jsii$Proxy) o;

            if (this.filterExpression != null ? !this.filterExpression.equals(that.filterExpression) : that.filterExpression != null) return false;
            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
            if (this.insightsConfiguration != null ? !this.insightsConfiguration.equals(that.insightsConfiguration) : that.insightsConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.filterExpression != null ? this.filterExpression.hashCode() : 0;
            result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
            result = 31 * result + (this.insightsConfiguration != null ? this.insightsConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
