package software.amazon.awscdk.services.transfer;

/**
 * A CloudFormation `AWS::Transfer::Workflow`.
 * <p>
 * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes. After creating a workflow, you can associate the workflow created with any transfer servers by specifying the <code>workflow-details</code> field in <code>CreateServer</code> and <code>UpdateServer</code> operations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * Object copyStepDetails;
 * Object customStepDetails;
 * Object deleteStepDetails;
 * Object tagStepDetails;
 * CfnWorkflow cfnWorkflow = CfnWorkflow.Builder.create(this, "MyCfnWorkflow")
 *         .steps(List.of(WorkflowStepProperty.builder()
 *                 .copyStepDetails(copyStepDetails)
 *                 .customStepDetails(customStepDetails)
 *                 .deleteStepDetails(deleteStepDetails)
 *                 .tagStepDetails(tagStepDetails)
 *                 .type("type")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .onExceptionSteps(List.of(WorkflowStepProperty.builder()
 *                 .copyStepDetails(copyStepDetails)
 *                 .customStepDetails(customStepDetails)
 *                 .deleteStepDetails(deleteStepDetails)
 *                 .tagStepDetails(tagStepDetails)
 *                 .type("type")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:02.666Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow")
public class CfnWorkflow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnWorkflow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkflow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnWorkflow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Transfer::Workflow`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkflow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnWorkflowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for a workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkflowId() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkflowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Key-value pairs that can be used to group and search for workflows.
     * <p>
     * Tags are metadata attached to workflows for any purpose.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies the details for the steps that are in the specified workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSteps() {
        return software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the details for the steps that are in the specified workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "steps", java.util.Objects.requireNonNull(value, "steps is required"));
    }

    /**
     * Specifies the details for the steps that are in the specified workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "steps", java.util.Objects.requireNonNull(value, "steps is required"));
    }

    /**
     * Specifies the text description for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the text description for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnExceptionSteps() {
        return software.amazon.jsii.Kernel.get(this, "onExceptionSteps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnExceptionSteps(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onExceptionSteps", value);
    }

    /**
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnExceptionSteps(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "onExceptionSteps", value);
    }
    /**
     * The basic building block of a workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * Object copyStepDetails;
     * Object customStepDetails;
     * Object deleteStepDetails;
     * Object tagStepDetails;
     * WorkflowStepProperty workflowStepProperty = WorkflowStepProperty.builder()
     *         .copyStepDetails(copyStepDetails)
     *         .customStepDetails(customStepDetails)
     *         .deleteStepDetails(deleteStepDetails)
     *         .tagStepDetails(tagStepDetails)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.WorkflowStepProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowStepProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowStepProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details for a step that performs a file copy.
         * <p>
         * Consists of the following values:
         * <p>
         * <ul>
         * <li>A description</li>
         * <li>An S3 location for the destination of the file copy.</li>
         * <li>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyStepDetails() {
            return null;
        }

        /**
         * Details for a step that invokes a lambda function.
         * <p>
         * Consists of the lambda function name, target, and timeout (in seconds).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomStepDetails() {
            return null;
        }

        /**
         * Details for a step that deletes the file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteStepDetails() {
            return null;
        }

        /**
         * Details for a step that creates one or more tags.
         * <p>
         * You specify one or more tags: each tag contains a key/value pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagStepDetails() {
            return null;
        }

        /**
         * Currently, the following step types are supported.
         * <p>
         * <ul>
         * <li><em>COPY</em> : copy the file to another location</li>
         * <li><em>CUSTOM</em> : custom step with a lambda target</li>
         * <li><em>DELETE</em> : delete the file</li>
         * <li><em>TAG</em> : add a tag to the file</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkflowStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowStepProperty> {
            java.lang.Object copyStepDetails;
            java.lang.Object customStepDetails;
            java.lang.Object deleteStepDetails;
            java.lang.Object tagStepDetails;
            java.lang.String type;

            /**
             * Sets the value of {@link WorkflowStepProperty#getCopyStepDetails}
             * @param copyStepDetails Details for a step that performs a file copy.
             *                        Consists of the following values:
             *                        <p>
             *                        <ul>
             *                        <li>A description</li>
             *                        <li>An S3 location for the destination of the file copy.</li>
             *                        <li>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyStepDetails(java.lang.Object copyStepDetails) {
                this.copyStepDetails = copyStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getCustomStepDetails}
             * @param customStepDetails Details for a step that invokes a lambda function.
             *                          Consists of the lambda function name, target, and timeout (in seconds).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customStepDetails(java.lang.Object customStepDetails) {
                this.customStepDetails = customStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getDeleteStepDetails}
             * @param deleteStepDetails Details for a step that deletes the file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteStepDetails(java.lang.Object deleteStepDetails) {
                this.deleteStepDetails = deleteStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getTagStepDetails}
             * @param tagStepDetails Details for a step that creates one or more tags.
             *                       You specify one or more tags: each tag contains a key/value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagStepDetails(java.lang.Object tagStepDetails) {
                this.tagStepDetails = tagStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getType}
             * @param type Currently, the following step types are supported.
             *             <ul>
             *             <li><em>COPY</em> : copy the file to another location</li>
             *             <li><em>CUSTOM</em> : custom step with a lambda target</li>
             *             <li><em>DELETE</em> : delete the file</li>
             *             <li><em>TAG</em> : add a tag to the file</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowStepProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowStepProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowStepProperty {
            private final java.lang.Object copyStepDetails;
            private final java.lang.Object customStepDetails;
            private final java.lang.Object deleteStepDetails;
            private final java.lang.Object tagStepDetails;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyStepDetails = software.amazon.jsii.Kernel.get(this, "copyStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customStepDetails = software.amazon.jsii.Kernel.get(this, "customStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deleteStepDetails = software.amazon.jsii.Kernel.get(this, "deleteStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagStepDetails = software.amazon.jsii.Kernel.get(this, "tagStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyStepDetails = builder.copyStepDetails;
                this.customStepDetails = builder.customStepDetails;
                this.deleteStepDetails = builder.deleteStepDetails;
                this.tagStepDetails = builder.tagStepDetails;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getCopyStepDetails() {
                return this.copyStepDetails;
            }

            @Override
            public final java.lang.Object getCustomStepDetails() {
                return this.customStepDetails;
            }

            @Override
            public final java.lang.Object getDeleteStepDetails() {
                return this.deleteStepDetails;
            }

            @Override
            public final java.lang.Object getTagStepDetails() {
                return this.tagStepDetails;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopyStepDetails() != null) {
                    data.set("copyStepDetails", om.valueToTree(this.getCopyStepDetails()));
                }
                if (this.getCustomStepDetails() != null) {
                    data.set("customStepDetails", om.valueToTree(this.getCustomStepDetails()));
                }
                if (this.getDeleteStepDetails() != null) {
                    data.set("deleteStepDetails", om.valueToTree(this.getDeleteStepDetails()));
                }
                if (this.getTagStepDetails() != null) {
                    data.set("tagStepDetails", om.valueToTree(this.getTagStepDetails()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.WorkflowStepProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowStepProperty.Jsii$Proxy that = (WorkflowStepProperty.Jsii$Proxy) o;

                if (this.copyStepDetails != null ? !this.copyStepDetails.equals(that.copyStepDetails) : that.copyStepDetails != null) return false;
                if (this.customStepDetails != null ? !this.customStepDetails.equals(that.customStepDetails) : that.customStepDetails != null) return false;
                if (this.deleteStepDetails != null ? !this.deleteStepDetails.equals(that.deleteStepDetails) : that.deleteStepDetails != null) return false;
                if (this.tagStepDetails != null ? !this.tagStepDetails.equals(that.tagStepDetails) : that.tagStepDetails != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copyStepDetails != null ? this.copyStepDetails.hashCode() : 0;
                result = 31 * result + (this.customStepDetails != null ? this.customStepDetails.hashCode() : 0);
                result = 31 * result + (this.deleteStepDetails != null ? this.deleteStepDetails.hashCode() : 0);
                result = 31 * result + (this.tagStepDetails != null ? this.tagStepDetails.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnWorkflow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.transfer.CfnWorkflow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.transfer.CfnWorkflowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.transfer.CfnWorkflowProps.Builder();
        }

        /**
         * Specifies the details for the steps that are in the specified workflow.
         * <p>
         * @return {@code this}
         * @param steps Specifies the details for the steps that are in the specified workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final software.amazon.awscdk.IResolvable steps) {
            this.props.steps(steps);
            return this;
        }
        /**
         * Specifies the details for the steps that are in the specified workflow.
         * <p>
         * @return {@code this}
         * @param steps Specifies the details for the steps that are in the specified workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final java.util.List<? extends java.lang.Object> steps) {
            this.props.steps(steps);
            return this;
        }

        /**
         * Specifies the text description for the workflow.
         * <p>
         * @return {@code this}
         * @param description Specifies the text description for the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * <p>
         * @return {@code this}
         * @param onExceptionSteps Specifies the steps (actions) to take if errors are encountered during execution of the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onExceptionSteps(final software.amazon.awscdk.IResolvable onExceptionSteps) {
            this.props.onExceptionSteps(onExceptionSteps);
            return this;
        }
        /**
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * <p>
         * @return {@code this}
         * @param onExceptionSteps Specifies the steps (actions) to take if errors are encountered during execution of the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onExceptionSteps(final java.util.List<? extends java.lang.Object> onExceptionSteps) {
            this.props.onExceptionSteps(onExceptionSteps);
            return this;
        }

        /**
         * Key-value pairs that can be used to group and search for workflows.
         * <p>
         * Tags are metadata attached to workflows for any purpose.
         * <p>
         * @return {@code this}
         * @param tags Key-value pairs that can be used to group and search for workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnWorkflow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.transfer.CfnWorkflow build() {
            return new software.amazon.awscdk.services.transfer.CfnWorkflow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
