/**
 * <h1>AWS Systems Manager Construct Library</h1>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Install the module:
 * <p>
 * <blockquote><pre>
 * $ npm i &#64;aws-cdk/aws-ssm
 * </pre></blockquote>
 * <p>
 * Import it into your code:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ssm.*;
 * </pre></blockquote>
 * <p>
 * <h2>Using existing SSM Parameters in your CDK app</h2>
 * <p>
 * You can reference existing SSM Parameter Store values that you want to use in
 * your CDK app by using <code>ssm.StringParameter.fromStringParameterAttributes</code>:
 * <p>
 * <blockquote><pre>
 * // Retrieve the latest value of the non-secret parameter
 * // with name "/My/String/Parameter".
 * String stringValue = StringParameter.fromStringParameterAttributes(this, "MyValue", StringParameterAttributes.builder()
 *         .parameterName("/My/Public/Parameter")
 *         .build()).getStringValue();
 * String stringValueVersionFromToken = StringParameter.fromStringParameterAttributes(this, "MyValueVersionFromToken", StringParameterAttributes.builder()
 *         .parameterName("/My/Public/Parameter")
 *         // parameter version from token
 *         .version(parameterVersion)
 *         .build()).getStringValue();
 * 
 * // Retrieve a specific version of the secret (SecureString) parameter.
 * // 'version' is always required.
 * IStringParameter secretValue = StringParameter.fromSecureStringParameterAttributes(this, "MySecureValue", SecureStringParameterAttributes.builder()
 *         .parameterName("/My/Secret/Parameter")
 *         .version(5)
 *         .build());
 * IStringParameter secretValueVersionFromToken = StringParameter.fromSecureStringParameterAttributes(this, "MySecureValueVersionFromToken", SecureStringParameterAttributes.builder()
 *         .parameterName("/My/Secret/Parameter")
 *         // parameter version from token
 *         .version(parameterVersion)
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h2>Creating new SSM Parameters in your CDK app</h2>
 * <p>
 * You can create either <code>ssm.StringParameter</code> or <code>ssm.StringListParameter</code>s in
 * a CDK app. These are public (not secret) values. Parameters of type
 * <em>SecureString</em> cannot be created directly from a CDK application; if you want
 * to provision secrets automatically, use Secrets Manager Secrets (see the
 * <code>&#64;aws-cdk/aws-secretsmanager</code> package).
 * <p>
 * <blockquote><pre>
 * StringParameter.Builder.create(this, "Parameter")
 *         .allowedPattern(".*")
 *         .description("The value Foo")
 *         .parameterName("FooParameter")
 *         .stringValue("Foo")
 *         .tier(ParameterTier.ADVANCED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * // Create a new SSM Parameter holding a String
 * StringParameter param = StringParameter.Builder.create(stack, "StringParameter")
 *         // description: 'Some user-friendly description',
 *         // name: 'ParameterName',
 *         .stringValue("Initial parameter value")
 *         .build();
 * 
 * // Grant read access to some Role
 * param.grantRead(role);
 * 
 * // Create a new SSM Parameter holding a StringList
 * StringListParameter listParameter = StringListParameter.Builder.create(stack, "StringListParameter")
 *         // description: 'Some user-friendly description',
 *         // name: 'ParameterName',
 *         .stringListValue(List.of("Initial parameter value A", "Initial parameter value B"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * When specifying an <code>allowedPattern</code>, the values provided as string literals
 * are validated against the pattern and an exception is raised if a value
 * provided does not comply.
 */
package software.amazon.awscdk.services.ssm;
