package software.amazon.awscdk.services.ses;

/**
 * Reasons for which recipient email addresses should be automatically added to your account's suppression list.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IDedicatedIpPool myPool;
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .customTrackingRedirectDomain("track.cdk.dev")
 *         .suppressionReasons(SuppressionReasons.COMPLAINTS_ONLY)
 *         .tlsPolicy(ConfigurationSetTlsPolicy.REQUIRE)
 *         .dedicatedIpPool(myPool)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:01.983Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.SuppressionReasons")
public enum SuppressionReasons {
    /**
     * Bounces and complaints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOUNCES_AND_COMPLAINTS,
    /**
     * Bounces only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOUNCES_ONLY,
    /**
     * Complaints only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPLAINTS_ONLY,
}
