package software.amazon.awscdk.services.ses;

/**
 * A dedicated IP pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * new DedicatedIpPool(this, "Pool");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:01.942Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.DedicatedIpPool")
public class DedicatedIpPool extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ses.IDedicatedIpPool {

    protected DedicatedIpPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DedicatedIpPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DedicatedIpPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.DedicatedIpPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DedicatedIpPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Use an existing dedicated IP pool.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param dedicatedIpPoolName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IDedicatedIpPool fromDedicatedIpPoolName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String dedicatedIpPoolName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.DedicatedIpPool.class, "fromDedicatedIpPoolName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IDedicatedIpPool.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(dedicatedIpPoolName, "dedicatedIpPoolName is required") });
    }

    /**
     * The name of the dedicated IP pool.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDedicatedIpPoolName() {
        return software.amazon.jsii.Kernel.get(this, "dedicatedIpPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.DedicatedIpPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.DedicatedIpPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ses.DedicatedIpPoolProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A name for the dedicated IP pool.
         * <p>
         * Default: - a CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param dedicatedIpPoolName A name for the dedicated IP pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedIpPoolName(final java.lang.String dedicatedIpPoolName) {
            this.props().dedicatedIpPoolName(dedicatedIpPoolName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ses.DedicatedIpPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.DedicatedIpPool build() {
            return new software.amazon.awscdk.services.ses.DedicatedIpPool(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ses.DedicatedIpPoolProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ses.DedicatedIpPoolProps.Builder();
            }
            return this.props;
        }
    }
}
