package software.amazon.awscdk.services.servicediscovery;

/**
 * Instance that is accessible using a domain name (CNAME).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * Service service;
 * CnameInstance cnameInstance = CnameInstance.Builder.create(this, "MyCnameInstance")
 *         .instanceCname("instanceCname")
 *         .service(service)
 *         // the properties below are optional
 *         .customAttributes(Map.of(
 *                 "customAttributesKey", "customAttributes"))
 *         .instanceId("instanceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:01.850Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.CnameInstance")
public class CnameInstance extends software.amazon.awscdk.services.servicediscovery.InstanceBase {

    protected CnameInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CnameInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CnameInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.CnameInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The domain name returned by DNS queries for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCname() {
        return software.amazon.jsii.Kernel.get(this, "cname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Id of the instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Cloudmap service to which the instance is registered.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IService.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicediscovery.CnameInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicediscovery.CnameInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicediscovery.CnameInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicediscovery.CnameInstanceProps.Builder();
        }

        /**
         * Custom attributes of the instance.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param customAttributes Custom attributes of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAttributes(final java.util.Map<java.lang.String, java.lang.String> customAttributes) {
            this.props.customAttributes(customAttributes);
            return this;
        }

        /**
         * The id of the instance resource.
         * <p>
         * Default: Automatically generated name
         * <p>
         * @return {@code this}
         * @param instanceId The id of the instance resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(final java.lang.String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        /**
         * If the service configuration includes a CNAME record, the domain name that you want Route 53 to return in response to DNS queries, for example, example.com. This value is required if the service specified by ServiceId includes settings for an CNAME record.
         * <p>
         * @return {@code this}
         * @param instanceCname If the service configuration includes a CNAME record, the domain name that you want Route 53 to return in response to DNS queries, for example, example.com. This value is required if the service specified by ServiceId includes settings for an CNAME record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceCname(final java.lang.String instanceCname) {
            this.props.instanceCname(instanceCname);
            return this;
        }

        /**
         * The Cloudmap service this resource is registered to.
         * <p>
         * @return {@code this}
         * @param service The Cloudmap service this resource is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final software.amazon.awscdk.services.servicediscovery.IService service) {
            this.props.service(service);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicediscovery.CnameInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicediscovery.CnameInstance build() {
            return new software.amazon.awscdk.services.servicediscovery.CnameInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
