package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a `CfnDBCluster`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBClusterProps cfnDBClusterProps = CfnDBClusterProps.builder()
 *         .engine("engine")
 *         // the properties below are optional
 *         .associatedRoles(List.of(DBClusterRoleProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .featureName("featureName")
 *                 .build()))
 *         .availabilityZones(List.of("availabilityZones"))
 *         .backtrackWindow(123)
 *         .backupRetentionPeriod(123)
 *         .copyTagsToSnapshot(false)
 *         .databaseName("databaseName")
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbClusterParameterGroupName("dbClusterParameterGroupName")
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .deletionProtection(false)
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .enableHttpEndpoint(false)
 *         .enableIamDatabaseAuthentication(false)
 *         .engineMode("engineMode")
 *         .engineVersion("engineVersion")
 *         .globalClusterIdentifier("globalClusterIdentifier")
 *         .kmsKeyId("kmsKeyId")
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .port(123)
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .replicationSourceIdentifier("replicationSourceIdentifier")
 *         .restoreType("restoreType")
 *         .scalingConfiguration(ScalingConfigurationProperty.builder()
 *                 .autoPause(false)
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .secondsUntilAutoPause(123)
 *                 .build())
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .sourceRegion("sourceRegion")
 *         .storageEncrypted(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useLatestRestorableTime(false)
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:01.072Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the database engine to be used for this DB cluster.
     * <p>
     * Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngine();

    /**
     * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return null;
    }

    /**
     * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return null;
    }

    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * <p>
     * <blockquote>
     * <p>
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     * <p>
     * </blockquote>
     * <p>
     * Default: 0
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBacktrackWindow() {
        return null;
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 1 to 35</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return null;
    }

    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * <p>
     * The default is not to copy them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return null;
    }

    /**
     * The name of your database.
     * <p>
     * If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return null;
    }

    /**
     * The DB cluster identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return null;
    }

    /**
     * The name of the DB cluster parameter group to associate with this DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
     * <p>
     * If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
     * <p>
     * </blockquote>
     * <p>
     * To list all of the available DB cluster parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterParameterGroupName() {
        return null;
    }

    /**
     * A DB subnet group that you want to associate with this DB cluster.
     * <p>
     * If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return null;
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return null;
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <em>Aurora MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Aurora PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return null;
    }

    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
     * <p>
     * By default, the HTTP endpoint is disabled.
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableHttpEndpoint() {
        return null;
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamDatabaseAuthentication() {
        return null;
    }

    /**
     * The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` .
     * <p>
     * The <code>serverless</code> engine mode only supports Aurora Serverless v1. Currently, AWS CloudFormation doesn't support Aurora Serverless v2.
     * <p>
     * The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.
     * <p>
     * The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.
     * <p>
     * The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
     * <p>
     * For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.
     * <p>
     * Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <em>Amazon Aurora User Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">Limitations of Parallel Query</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">Limitations of Aurora Global Databases</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">Limitations of Multi-Master Clusters</a></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineMode() {
        return null;
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-postgresql</code> , use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
     * <p>
     * To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
     * <p>
     * If you aren't configuring a global database cluster, don't specify this property.
     * <p>
     * <blockquote>
     * <p>
     * To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
     * <p>
     * </blockquote>
     * <p>
     * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlobalClusterIdentifier() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
     * <p>
     * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The name of the master user for the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return null;
    }

    /**
     * The master password for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return null;
    }

    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     * <p>
     * Default:
     * <p>
     * <ul>
     * <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
     * <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
     * <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
     * <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The daily time range during which automated backups are created.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return null;
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Adjusting the Preferred DB Cluster Maintenance Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplicationSourceIdentifier() {
        return null;
    }

    /**
     * The type of restore to be performed. You can specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
     * <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
     * </ul>
     * <p>
     * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRestoreType() {
        return null;
    }

    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfiguration() {
        return null;
    }

    /**
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
     * <p>
     * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>GlobalClusterIdentifier</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>ReplicationSourceIdentifier</code></li>
     * <li><code>RestoreType</code></li>
     * <li><code>SourceDBClusterIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
     * <li><code>UseLatestRestorableTime</code></li>
     * </ul>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing Snapshot.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return null;
    }

    /**
     * When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing DBCluster.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return null;
    }

    /**
     * The AWS Region which contains the source DB cluster when replicating a DB cluster.
     * <p>
     * For example, <code>us-east-1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceRegion() {
        return null;
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return null;
    }

    /**
     * Tags to assign to the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
     * <p>
     * By default, the DB cluster is not restored to the latest restorable backup time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseLatestRestorableTime() {
        return null;
    }

    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBClusterProps> {
        java.lang.String engine;
        java.lang.Object associatedRoles;
        java.util.List<java.lang.String> availabilityZones;
        java.lang.Number backtrackWindow;
        java.lang.Number backupRetentionPeriod;
        java.lang.Object copyTagsToSnapshot;
        java.lang.String databaseName;
        java.lang.String dbClusterIdentifier;
        java.lang.String dbClusterParameterGroupName;
        java.lang.String dbSubnetGroupName;
        java.lang.Object deletionProtection;
        java.util.List<java.lang.String> enableCloudwatchLogsExports;
        java.lang.Object enableHttpEndpoint;
        java.lang.Object enableIamDatabaseAuthentication;
        java.lang.String engineMode;
        java.lang.String engineVersion;
        java.lang.String globalClusterIdentifier;
        java.lang.String kmsKeyId;
        java.lang.String masterUsername;
        java.lang.String masterUserPassword;
        java.lang.Number port;
        java.lang.String preferredBackupWindow;
        java.lang.String preferredMaintenanceWindow;
        java.lang.String replicationSourceIdentifier;
        java.lang.String restoreType;
        java.lang.Object scalingConfiguration;
        java.lang.String snapshotIdentifier;
        java.lang.String sourceDbClusterIdentifier;
        java.lang.String sourceRegion;
        java.lang.Object storageEncrypted;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object useLatestRestorableTime;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnDBClusterProps#getEngine}
         * @param engine The name of the database engine to be used for this DB cluster. This parameter is required.
         *               Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAssociatedRoles}
         * @param associatedRoles Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
         *                        IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(software.amazon.awscdk.IResolvable associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAssociatedRoles}
         * @param associatedRoles Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
         *                        IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(java.util.List<? extends java.lang.Object> associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAvailabilityZones}
         * @param availabilityZones A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         *                          For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getBacktrackWindow}
         * @param backtrackWindow The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         *                        <blockquote>
         *                        <p>
         *                        Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         *                        <p>
         *                        </blockquote>
         *                        <p>
         *                        Default: 0
         *                        <p>
         *                        Constraints:
         *                        <p>
         *                        <ul>
         *                        <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backtrackWindow(java.lang.Number backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getBackupRetentionPeriod}
         * @param backupRetentionPeriod The number of days for which automated backups are retained.
         *                              Default: 1
         *                              <p>
         *                              Constraints:
         *                              <p>
         *                              <ul>
         *                              <li>Must be a value from 1 to 35</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(java.lang.Number backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         *                           The default is not to copy them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(java.lang.Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         *                           The default is not to copy them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDatabaseName}
         * @param databaseName The name of your database.
         *                     If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbClusterIdentifier}
         * @param dbClusterIdentifier The DB cluster identifier. This parameter is stored as a lowercase string.
         *                            Constraints:
         *                            <p>
         *                            <ul>
         *                            <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
         *                            <li>First character must be a letter.</li>
         *                            <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
         *                            </ul>
         *                            <p>
         *                            Example: <code>my-cluster1</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(java.lang.String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbClusterParameterGroupName}
         * @param dbClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB cluster.
         *                                    <blockquote>
         *                                    <p>
         *                                    If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
         *                                    <p>
         *                                    If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
         *                                    <p>
         *                                    </blockquote>
         *                                    <p>
         *                                    To list all of the available DB cluster parameter group names, use the following command:
         *                                    <p>
         *                                    <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterParameterGroupName(java.lang.String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbSubnetGroupName}
         * @param dbSubnetGroupName A DB subnet group that you want to associate with this DB cluster.
         *                          If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(java.lang.String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDeletionProtection}
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled.
         *                           The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDeletionProtection}
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled.
         *                           The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(software.amazon.awscdk.IResolvable deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableCloudwatchLogsExports}
         * @param enableCloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs.
         *                                    The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
         *                                    <p>
         *                                    <em>Aurora MySQL</em>
         *                                    <p>
         *                                    Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         *                                    <p>
         *                                    <em>Aurora PostgreSQL</em>
         *                                    <p>
         *                                    Valid values: <code>postgresql</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = enableCloudwatchLogsExports;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableHttpEndpoint}
         * @param enableHttpEndpoint A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
         *                           By default, the HTTP endpoint is disabled.
         *                           <p>
         *                           When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(java.lang.Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableHttpEndpoint}
         * @param enableHttpEndpoint A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
         *                           By default, the HTTP endpoint is disabled.
         *                           <p>
         *                           When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(software.amazon.awscdk.IResolvable enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableIamDatabaseAuthentication}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         *                                        By default, mapping is disabled.
         *                                        <p>
         *                                        For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(java.lang.Boolean enableIamDatabaseAuthentication) {
            this.enableIamDatabaseAuthentication = enableIamDatabaseAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableIamDatabaseAuthentication}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         *                                        By default, mapping is disabled.
         *                                        <p>
         *                                        For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(software.amazon.awscdk.IResolvable enableIamDatabaseAuthentication) {
            this.enableIamDatabaseAuthentication = enableIamDatabaseAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEngineMode}
         * @param engineMode The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` .
         *                   The <code>serverless</code> engine mode only supports Aurora Serverless v1. Currently, AWS CloudFormation doesn't support Aurora Serverless v2.
         *                   <p>
         *                   The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.
         *                   <p>
         *                   The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.
         *                   <p>
         *                   The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
         *                   <p>
         *                   For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.
         *                   <p>
         *                   Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <em>Amazon Aurora User Guide</em> :
         *                   <p>
         *                   <ul>
         *                   <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless</a></li>
         *                   <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">Limitations of Parallel Query</a></li>
         *                   <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">Limitations of Aurora Global Databases</a></li>
         *                   <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">Limitations of Multi-Master Clusters</a></li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineMode(java.lang.String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEngineVersion}
         * @param engineVersion The version number of the database engine to use.
         *                      To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:
         *                      <p>
         *                      <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
         *                      <p>
         *                      To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:
         *                      <p>
         *                      <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         *                      <p>
         *                      To list all of the available engine versions for <code>aurora-postgresql</code> , use the following command:
         *                      <p>
         *                      <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getGlobalClusterIdentifier}
         * @param globalClusterIdentifier If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
         *                                To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
         *                                <p>
         *                                If you aren't configuring a global database cluster, don't specify this property.
         *                                <p>
         *                                <blockquote>
         *                                <p>
         *                                To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
         *                                <p>
         *                                </blockquote>
         *                                <p>
         *                                For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalClusterIdentifier(java.lang.String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getKmsKeyId}
         * @param kmsKeyId The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
         *                 If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
         *                 <p>
         *                 If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getMasterUsername}
         * @param masterUsername The name of the master user for the DB cluster.
         *                       <blockquote>
         *                       <p>
         *                       If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(java.lang.String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getMasterUserPassword}
         * @param masterUserPassword The master password for the DB instance.
         *                           <blockquote>
         *                           <p>
         *                           If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(java.lang.String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPort}
         * @param port The port number on which the DB instances in the DB cluster accept connections.
         *             Default:
         *             <p>
         *             <ul>
         *             <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
         *             <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
         *             <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
         *             <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
         *             </ul>
         *             <p>
         *             <blockquote>
         *             <p>
         *             The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPreferredBackupWindow}
         * @param preferredBackupWindow The daily time range during which automated backups are created.
         *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
         *                              <p>
         *                              Constraints:
         *                              <p>
         *                              <ul>
         *                              <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
         *                              <li>Must be in Universal Coordinated Time (UTC).</li>
         *                              <li>Must not conflict with the preferred maintenance window.</li>
         *                              <li>Must be at least 30 minutes.</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *                                   Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   <p>
         *                                   The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Adjusting the Preferred DB Cluster Maintenance Window</a> in the <em>Amazon Aurora User Guide.</em>
         *                                   <p>
         *                                   Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *                                   <p>
         *                                   Constraints: Minimum 30-minute window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getReplicationSourceIdentifier}
         * @param replicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSourceIdentifier(java.lang.String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getRestoreType}
         * @param restoreType The type of restore to be performed. You can specify one of the following values:.
         *                    <ul>
         *                    <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
         *                    <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
         *                    </ul>
         *                    <p>
         *                    Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.
         *                    <p>
         *                    If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreType(java.lang.String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getScalingConfiguration}
         * @param scalingConfiguration The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
         *                             Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getScalingConfiguration}
         * @param scalingConfiguration The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
         *                             Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(software.amazon.awscdk.IResolvable scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSnapshotIdentifier}
         * @param snapshotIdentifier The identifier for the DB snapshot or DB cluster snapshot to restore from.
         *                           You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
         *                           <p>
         *                           After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
         *                           <p>
         *                           If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
         *                           <p>
         *                           <ul>
         *                           <li><code>GlobalClusterIdentifier</code></li>
         *                           <li><code>MasterUsername</code></li>
         *                           <li><code>MasterUserPassword</code></li>
         *                           <li><code>ReplicationSourceIdentifier</code></li>
         *                           <li><code>RestoreType</code></li>
         *                           <li><code>SourceDBClusterIdentifier</code></li>
         *                           <li><code>SourceRegion</code></li>
         *                           <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
         *                           <li><code>UseLatestRestorableTime</code></li>
         *                           </ul>
         *                           <p>
         *                           Constraints:
         *                           <p>
         *                           <ul>
         *                           <li>Must match the identifier of an existing Snapshot.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(java.lang.String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSourceDbClusterIdentifier}
         * @param sourceDbClusterIdentifier When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
         *                                  Constraints:
         *                                  <p>
         *                                  <ul>
         *                                  <li>Must match the identifier of an existing DBCluster.</li>
         *                                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(java.lang.String sourceDbClusterIdentifier) {
            this.sourceDbClusterIdentifier = sourceDbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSourceRegion}
         * @param sourceRegion The AWS Region which contains the source DB cluster when replicating a DB cluster.
         *                     For example, <code>us-east-1</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRegion(java.lang.String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getStorageEncrypted}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted.
         *                         If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         *                         <p>
         *                         If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getStorageEncrypted}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted.
         *                         If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         *                         <p>
         *                         If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(software.amazon.awscdk.IResolvable storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getTags}
         * @param tags Tags to assign to the DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getUseLatestRestorableTime}
         * @param useLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest restorable backup time.
         *                                By default, the DB cluster is not restored to the latest restorable backup time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(java.lang.Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getUseLatestRestorableTime}
         * @param useLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest restorable backup time.
         *                                By default, the DB cluster is not restored to the latest restorable backup time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(software.amazon.awscdk.IResolvable useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster.
         *                            If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBClusterProps {
        private final java.lang.String engine;
        private final java.lang.Object associatedRoles;
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Number backtrackWindow;
        private final java.lang.Number backupRetentionPeriod;
        private final java.lang.Object copyTagsToSnapshot;
        private final java.lang.String databaseName;
        private final java.lang.String dbClusterIdentifier;
        private final java.lang.String dbClusterParameterGroupName;
        private final java.lang.String dbSubnetGroupName;
        private final java.lang.Object deletionProtection;
        private final java.util.List<java.lang.String> enableCloudwatchLogsExports;
        private final java.lang.Object enableHttpEndpoint;
        private final java.lang.Object enableIamDatabaseAuthentication;
        private final java.lang.String engineMode;
        private final java.lang.String engineVersion;
        private final java.lang.String globalClusterIdentifier;
        private final java.lang.String kmsKeyId;
        private final java.lang.String masterUsername;
        private final java.lang.String masterUserPassword;
        private final java.lang.Number port;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.String replicationSourceIdentifier;
        private final java.lang.String restoreType;
        private final java.lang.Object scalingConfiguration;
        private final java.lang.String snapshotIdentifier;
        private final java.lang.String sourceDbClusterIdentifier;
        private final java.lang.String sourceRegion;
        private final java.lang.Object storageEncrypted;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object useLatestRestorableTime;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.associatedRoles = software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.backtrackWindow = software.amazon.jsii.Kernel.get(this, "backtrackWindow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.backupRetentionPeriod = software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.copyTagsToSnapshot = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterParameterGroupName = software.amazon.jsii.Kernel.get(this, "dbClusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbSubnetGroupName = software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableCloudwatchLogsExports = software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.enableHttpEndpoint = software.amazon.jsii.Kernel.get(this, "enableHttpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableIamDatabaseAuthentication = software.amazon.jsii.Kernel.get(this, "enableIamDatabaseAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engineMode = software.amazon.jsii.Kernel.get(this, "engineMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalClusterIdentifier = software.amazon.jsii.Kernel.get(this, "globalClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUsername = software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationSourceIdentifier = software.amazon.jsii.Kernel.get(this, "replicationSourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreType = software.amazon.jsii.Kernel.get(this, "restoreType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalingConfiguration = software.amazon.jsii.Kernel.get(this, "scalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotIdentifier = software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceRegion = software.amazon.jsii.Kernel.get(this, "sourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.useLatestRestorableTime = software.amazon.jsii.Kernel.get(this, "useLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
            this.associatedRoles = builder.associatedRoles;
            this.availabilityZones = builder.availabilityZones;
            this.backtrackWindow = builder.backtrackWindow;
            this.backupRetentionPeriod = builder.backupRetentionPeriod;
            this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
            this.databaseName = builder.databaseName;
            this.dbClusterIdentifier = builder.dbClusterIdentifier;
            this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
            this.dbSubnetGroupName = builder.dbSubnetGroupName;
            this.deletionProtection = builder.deletionProtection;
            this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
            this.enableHttpEndpoint = builder.enableHttpEndpoint;
            this.enableIamDatabaseAuthentication = builder.enableIamDatabaseAuthentication;
            this.engineMode = builder.engineMode;
            this.engineVersion = builder.engineVersion;
            this.globalClusterIdentifier = builder.globalClusterIdentifier;
            this.kmsKeyId = builder.kmsKeyId;
            this.masterUsername = builder.masterUsername;
            this.masterUserPassword = builder.masterUserPassword;
            this.port = builder.port;
            this.preferredBackupWindow = builder.preferredBackupWindow;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
            this.restoreType = builder.restoreType;
            this.scalingConfiguration = builder.scalingConfiguration;
            this.snapshotIdentifier = builder.snapshotIdentifier;
            this.sourceDbClusterIdentifier = builder.sourceDbClusterIdentifier;
            this.sourceRegion = builder.sourceRegion;
            this.storageEncrypted = builder.storageEncrypted;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.useLatestRestorableTime = builder.useLatestRestorableTime;
            this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.Object getAssociatedRoles() {
            return this.associatedRoles;
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.Number getBacktrackWindow() {
            return this.backtrackWindow;
        }

        @Override
        public final java.lang.Number getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final java.lang.Object getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final java.lang.String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final java.lang.String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final java.lang.Object getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final java.lang.Object getEnableHttpEndpoint() {
            return this.enableHttpEndpoint;
        }

        @Override
        public final java.lang.Object getEnableIamDatabaseAuthentication() {
            return this.enableIamDatabaseAuthentication;
        }

        @Override
        public final java.lang.String getEngineMode() {
            return this.engineMode;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final java.lang.String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        @Override
        public final java.lang.String getRestoreType() {
            return this.restoreType;
        }

        @Override
        public final java.lang.Object getScalingConfiguration() {
            return this.scalingConfiguration;
        }

        @Override
        public final java.lang.String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final java.lang.String getSourceDbClusterIdentifier() {
            return this.sourceDbClusterIdentifier;
        }

        @Override
        public final java.lang.String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final java.lang.Object getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("engine", om.valueToTree(this.getEngine()));
            if (this.getAssociatedRoles() != null) {
                data.set("associatedRoles", om.valueToTree(this.getAssociatedRoles()));
            }
            if (this.getAvailabilityZones() != null) {
                data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            }
            if (this.getBacktrackWindow() != null) {
                data.set("backtrackWindow", om.valueToTree(this.getBacktrackWindow()));
            }
            if (this.getBackupRetentionPeriod() != null) {
                data.set("backupRetentionPeriod", om.valueToTree(this.getBackupRetentionPeriod()));
            }
            if (this.getCopyTagsToSnapshot() != null) {
                data.set("copyTagsToSnapshot", om.valueToTree(this.getCopyTagsToSnapshot()));
            }
            if (this.getDatabaseName() != null) {
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            }
            if (this.getDbClusterIdentifier() != null) {
                data.set("dbClusterIdentifier", om.valueToTree(this.getDbClusterIdentifier()));
            }
            if (this.getDbClusterParameterGroupName() != null) {
                data.set("dbClusterParameterGroupName", om.valueToTree(this.getDbClusterParameterGroupName()));
            }
            if (this.getDbSubnetGroupName() != null) {
                data.set("dbSubnetGroupName", om.valueToTree(this.getDbSubnetGroupName()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getEnableCloudwatchLogsExports() != null) {
                data.set("enableCloudwatchLogsExports", om.valueToTree(this.getEnableCloudwatchLogsExports()));
            }
            if (this.getEnableHttpEndpoint() != null) {
                data.set("enableHttpEndpoint", om.valueToTree(this.getEnableHttpEndpoint()));
            }
            if (this.getEnableIamDatabaseAuthentication() != null) {
                data.set("enableIamDatabaseAuthentication", om.valueToTree(this.getEnableIamDatabaseAuthentication()));
            }
            if (this.getEngineMode() != null) {
                data.set("engineMode", om.valueToTree(this.getEngineMode()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getGlobalClusterIdentifier() != null) {
                data.set("globalClusterIdentifier", om.valueToTree(this.getGlobalClusterIdentifier()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getMasterUsername() != null) {
                data.set("masterUsername", om.valueToTree(this.getMasterUsername()));
            }
            if (this.getMasterUserPassword() != null) {
                data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getReplicationSourceIdentifier() != null) {
                data.set("replicationSourceIdentifier", om.valueToTree(this.getReplicationSourceIdentifier()));
            }
            if (this.getRestoreType() != null) {
                data.set("restoreType", om.valueToTree(this.getRestoreType()));
            }
            if (this.getScalingConfiguration() != null) {
                data.set("scalingConfiguration", om.valueToTree(this.getScalingConfiguration()));
            }
            if (this.getSnapshotIdentifier() != null) {
                data.set("snapshotIdentifier", om.valueToTree(this.getSnapshotIdentifier()));
            }
            if (this.getSourceDbClusterIdentifier() != null) {
                data.set("sourceDbClusterIdentifier", om.valueToTree(this.getSourceDbClusterIdentifier()));
            }
            if (this.getSourceRegion() != null) {
                data.set("sourceRegion", om.valueToTree(this.getSourceRegion()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUseLatestRestorableTime() != null) {
                data.set("useLatestRestorableTime", om.valueToTree(this.getUseLatestRestorableTime()));
            }
            if (this.getVpcSecurityGroupIds() != null) {
                data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBClusterProps.Jsii$Proxy that = (CfnDBClusterProps.Jsii$Proxy) o;

            if (!engine.equals(that.engine)) return false;
            if (this.associatedRoles != null ? !this.associatedRoles.equals(that.associatedRoles) : that.associatedRoles != null) return false;
            if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
            if (this.backtrackWindow != null ? !this.backtrackWindow.equals(that.backtrackWindow) : that.backtrackWindow != null) return false;
            if (this.backupRetentionPeriod != null ? !this.backupRetentionPeriod.equals(that.backupRetentionPeriod) : that.backupRetentionPeriod != null) return false;
            if (this.copyTagsToSnapshot != null ? !this.copyTagsToSnapshot.equals(that.copyTagsToSnapshot) : that.copyTagsToSnapshot != null) return false;
            if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
            if (this.dbClusterIdentifier != null ? !this.dbClusterIdentifier.equals(that.dbClusterIdentifier) : that.dbClusterIdentifier != null) return false;
            if (this.dbClusterParameterGroupName != null ? !this.dbClusterParameterGroupName.equals(that.dbClusterParameterGroupName) : that.dbClusterParameterGroupName != null) return false;
            if (this.dbSubnetGroupName != null ? !this.dbSubnetGroupName.equals(that.dbSubnetGroupName) : that.dbSubnetGroupName != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.enableCloudwatchLogsExports != null ? !this.enableCloudwatchLogsExports.equals(that.enableCloudwatchLogsExports) : that.enableCloudwatchLogsExports != null) return false;
            if (this.enableHttpEndpoint != null ? !this.enableHttpEndpoint.equals(that.enableHttpEndpoint) : that.enableHttpEndpoint != null) return false;
            if (this.enableIamDatabaseAuthentication != null ? !this.enableIamDatabaseAuthentication.equals(that.enableIamDatabaseAuthentication) : that.enableIamDatabaseAuthentication != null) return false;
            if (this.engineMode != null ? !this.engineMode.equals(that.engineMode) : that.engineMode != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.globalClusterIdentifier != null ? !this.globalClusterIdentifier.equals(that.globalClusterIdentifier) : that.globalClusterIdentifier != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.masterUsername != null ? !this.masterUsername.equals(that.masterUsername) : that.masterUsername != null) return false;
            if (this.masterUserPassword != null ? !this.masterUserPassword.equals(that.masterUserPassword) : that.masterUserPassword != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.replicationSourceIdentifier != null ? !this.replicationSourceIdentifier.equals(that.replicationSourceIdentifier) : that.replicationSourceIdentifier != null) return false;
            if (this.restoreType != null ? !this.restoreType.equals(that.restoreType) : that.restoreType != null) return false;
            if (this.scalingConfiguration != null ? !this.scalingConfiguration.equals(that.scalingConfiguration) : that.scalingConfiguration != null) return false;
            if (this.snapshotIdentifier != null ? !this.snapshotIdentifier.equals(that.snapshotIdentifier) : that.snapshotIdentifier != null) return false;
            if (this.sourceDbClusterIdentifier != null ? !this.sourceDbClusterIdentifier.equals(that.sourceDbClusterIdentifier) : that.sourceDbClusterIdentifier != null) return false;
            if (this.sourceRegion != null ? !this.sourceRegion.equals(that.sourceRegion) : that.sourceRegion != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.useLatestRestorableTime != null ? !this.useLatestRestorableTime.equals(that.useLatestRestorableTime) : that.useLatestRestorableTime != null) return false;
            return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engine.hashCode();
            result = 31 * result + (this.associatedRoles != null ? this.associatedRoles.hashCode() : 0);
            result = 31 * result + (this.availabilityZones != null ? this.availabilityZones.hashCode() : 0);
            result = 31 * result + (this.backtrackWindow != null ? this.backtrackWindow.hashCode() : 0);
            result = 31 * result + (this.backupRetentionPeriod != null ? this.backupRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.copyTagsToSnapshot != null ? this.copyTagsToSnapshot.hashCode() : 0);
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            result = 31 * result + (this.dbClusterIdentifier != null ? this.dbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.dbClusterParameterGroupName != null ? this.dbClusterParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.dbSubnetGroupName != null ? this.dbSubnetGroupName.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.enableCloudwatchLogsExports != null ? this.enableCloudwatchLogsExports.hashCode() : 0);
            result = 31 * result + (this.enableHttpEndpoint != null ? this.enableHttpEndpoint.hashCode() : 0);
            result = 31 * result + (this.enableIamDatabaseAuthentication != null ? this.enableIamDatabaseAuthentication.hashCode() : 0);
            result = 31 * result + (this.engineMode != null ? this.engineMode.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.globalClusterIdentifier != null ? this.globalClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.masterUsername != null ? this.masterUsername.hashCode() : 0);
            result = 31 * result + (this.masterUserPassword != null ? this.masterUserPassword.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.replicationSourceIdentifier != null ? this.replicationSourceIdentifier.hashCode() : 0);
            result = 31 * result + (this.restoreType != null ? this.restoreType.hashCode() : 0);
            result = 31 * result + (this.scalingConfiguration != null ? this.scalingConfiguration.hashCode() : 0);
            result = 31 * result + (this.snapshotIdentifier != null ? this.snapshotIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceDbClusterIdentifier != null ? this.sourceDbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceRegion != null ? this.sourceRegion.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.useLatestRestorableTime != null ? this.useLatestRestorableTime.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
            return result;
        }
    }
}
