package software.amazon.awscdk.services.opensearchservice;

/**
 * Reference to an Amazon OpenSearch Service domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opensearchservice.*;
 * DomainAttributes domainAttributes = DomainAttributes.builder()
 *         .domainArn("domainArn")
 *         .domainEndpoint("domainEndpoint")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.814Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.DomainAttributes")
@software.amazon.jsii.Jsii.Proxy(DomainAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Amazon OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainArn();

    /**
     * The domain endpoint of the Amazon OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainEndpoint();

    /**
     * @return a {@link Builder} of {@link DomainAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainAttributes> {
        java.lang.String domainArn;
        java.lang.String domainEndpoint;

        /**
         * Sets the value of {@link DomainAttributes#getDomainArn}
         * @param domainArn The ARN of the Amazon OpenSearch Service domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainArn(java.lang.String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        /**
         * Sets the value of {@link DomainAttributes#getDomainEndpoint}
         * @param domainEndpoint The domain endpoint of the Amazon OpenSearch Service domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpoint(java.lang.String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainAttributes {
        private final java.lang.String domainArn;
        private final java.lang.String domainEndpoint;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainArn = software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainEndpoint = software.amazon.jsii.Kernel.get(this, "domainEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainArn = java.util.Objects.requireNonNull(builder.domainArn, "domainArn is required");
            this.domainEndpoint = java.util.Objects.requireNonNull(builder.domainEndpoint, "domainEndpoint is required");
        }

        @Override
        public final java.lang.String getDomainArn() {
            return this.domainArn;
        }

        @Override
        public final java.lang.String getDomainEndpoint() {
            return this.domainEndpoint;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainArn", om.valueToTree(this.getDomainArn()));
            data.set("domainEndpoint", om.valueToTree(this.getDomainEndpoint()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.DomainAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainAttributes.Jsii$Proxy that = (DomainAttributes.Jsii$Proxy) o;

            if (!domainArn.equals(that.domainArn)) return false;
            return this.domainEndpoint.equals(that.domainEndpoint);
        }

        @Override
        public final int hashCode() {
            int result = this.domainArn.hashCode();
            result = 31 * result + (this.domainEndpoint.hashCode());
            return result;
        }
    }
}
