package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a `CfnCustomerGatewayAssociation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnCustomerGatewayAssociationProps cfnCustomerGatewayAssociationProps = CfnCustomerGatewayAssociationProps.builder()
 *         .customerGatewayArn("customerGatewayArn")
 *         .deviceId("deviceId")
 *         .globalNetworkId("globalNetworkId")
 *         // the properties below are optional
 *         .linkId("linkId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.765Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnCustomerGatewayAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnCustomerGatewayAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCustomerGatewayAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the customer gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayArn();

    /**
     * The ID of the device.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeviceId();

    /**
     * The ID of the global network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlobalNetworkId();

    /**
     * The ID of the link.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLinkId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCustomerGatewayAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCustomerGatewayAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCustomerGatewayAssociationProps> {
        java.lang.String customerGatewayArn;
        java.lang.String deviceId;
        java.lang.String globalNetworkId;
        java.lang.String linkId;

        /**
         * Sets the value of {@link CfnCustomerGatewayAssociationProps#getCustomerGatewayArn}
         * @param customerGatewayArn The Amazon Resource Name (ARN) of the customer gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerGatewayArn(java.lang.String customerGatewayArn) {
            this.customerGatewayArn = customerGatewayArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomerGatewayAssociationProps#getDeviceId}
         * @param deviceId The ID of the device. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceId(java.lang.String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomerGatewayAssociationProps#getGlobalNetworkId}
         * @param globalNetworkId The ID of the global network. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNetworkId(java.lang.String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomerGatewayAssociationProps#getLinkId}
         * @param linkId The ID of the link.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkId(java.lang.String linkId) {
            this.linkId = linkId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomerGatewayAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCustomerGatewayAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCustomerGatewayAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomerGatewayAssociationProps {
        private final java.lang.String customerGatewayArn;
        private final java.lang.String deviceId;
        private final java.lang.String globalNetworkId;
        private final java.lang.String linkId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customerGatewayArn = software.amazon.jsii.Kernel.get(this, "customerGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deviceId = software.amazon.jsii.Kernel.get(this, "deviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalNetworkId = software.amazon.jsii.Kernel.get(this, "globalNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.linkId = software.amazon.jsii.Kernel.get(this, "linkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customerGatewayArn = java.util.Objects.requireNonNull(builder.customerGatewayArn, "customerGatewayArn is required");
            this.deviceId = java.util.Objects.requireNonNull(builder.deviceId, "deviceId is required");
            this.globalNetworkId = java.util.Objects.requireNonNull(builder.globalNetworkId, "globalNetworkId is required");
            this.linkId = builder.linkId;
        }

        @Override
        public final java.lang.String getCustomerGatewayArn() {
            return this.customerGatewayArn;
        }

        @Override
        public final java.lang.String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final java.lang.String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        @Override
        public final java.lang.String getLinkId() {
            return this.linkId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("customerGatewayArn", om.valueToTree(this.getCustomerGatewayArn()));
            data.set("deviceId", om.valueToTree(this.getDeviceId()));
            data.set("globalNetworkId", om.valueToTree(this.getGlobalNetworkId()));
            if (this.getLinkId() != null) {
                data.set("linkId", om.valueToTree(this.getLinkId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnCustomerGatewayAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomerGatewayAssociationProps.Jsii$Proxy that = (CfnCustomerGatewayAssociationProps.Jsii$Proxy) o;

            if (!customerGatewayArn.equals(that.customerGatewayArn)) return false;
            if (!deviceId.equals(that.deviceId)) return false;
            if (!globalNetworkId.equals(that.globalNetworkId)) return false;
            return this.linkId != null ? this.linkId.equals(that.linkId) : that.linkId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.customerGatewayArn.hashCode();
            result = 31 * result + (this.deviceId.hashCode());
            result = 31 * result + (this.globalNetworkId.hashCode());
            result = 31 * result + (this.linkId != null ? this.linkId.hashCode() : 0);
            return result;
        }
    }
}
