package software.amazon.awscdk.services.lightsail;

/**
 * A CloudFormation `AWS::Lightsail::LoadBalancerTlsCertificate`.
 * <p>
 * The <code>AWS::Lightsail::LoadBalancerTlsCertificate</code> resource specifies a TLS certificate that can be used with a Lightsail load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnLoadBalancerTlsCertificate cfnLoadBalancerTlsCertificate = CfnLoadBalancerTlsCertificate.Builder.create(this, "MyCfnLoadBalancerTlsCertificate")
 *         .certificateDomainName("certificateDomainName")
 *         .certificateName("certificateName")
 *         .loadBalancerName("loadBalancerName")
 *         // the properties below are optional
 *         .certificateAlternativeNames(List.of("certificateAlternativeNames"))
 *         .httpsRedirectionEnabled(false)
 *         .isAttached(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.384Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnLoadBalancerTlsCertificate")
public class CfnLoadBalancerTlsCertificate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLoadBalancerTlsCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoadBalancerTlsCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Lightsail::LoadBalancerTlsCertificate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLoadBalancerTlsCertificate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the SSL/TLS certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoadBalancerTlsCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLoadBalancerTlsCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The validation status of the SSL/TLS certificate.
     * <p>
     * Valid Values: <code>PENDING_VALIDATION</code> | <code>ISSUED</code> | <code>INACTIVE</code> | <code>EXPIRED</code> | <code>VALIDATION_TIMED_OUT</code> | <code>REVOKED</code> | <code>FAILED</code> | <code>UNKNOWN</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The domain name for the SSL/TLS certificate.
     * <p>
     * For example, <code>example.com</code> or <code>www.example.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateDomainName() {
        return software.amazon.jsii.Kernel.get(this, "certificateDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name for the SSL/TLS certificate.
     * <p>
     * For example, <code>example.com</code> or <code>www.example.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateDomainName", java.util.Objects.requireNonNull(value, "certificateDomainName is required"));
    }

    /**
     * The name of the SSL/TLS certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateName() {
        return software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SSL/TLS certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateName", java.util.Objects.requireNonNull(value, "certificateName is required"));
    }

    /**
     * The name of the load balancer that the SSL/TLS certificate is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerName() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the load balancer that the SSL/TLS certificate is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancerName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancerName", java.util.Objects.requireNonNull(value, "loadBalancerName is required"));
    }

    /**
     * An array of alternative domain names and subdomain names for your SSL/TLS certificate.
     * <p>
     * In addition to the primary domain name, you can have up to nine alternative domain names. Wildcards (such as <code>*.example.com</code> ) are not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCertificateAlternativeNames() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "certificateAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of alternative domain names and subdomain names for your SSL/TLS certificate.
     * <p>
     * In addition to the primary domain name, you can have up to nine alternative domain names. Wildcards (such as <code>*.example.com</code> ) are not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateAlternativeNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "certificateAlternativeNames", value);
    }

    /**
     * A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHttpsRedirectionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "httpsRedirectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpsRedirectionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "httpsRedirectionEnabled", value);
    }

    /**
     * A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpsRedirectionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "httpsRedirectionEnabled", value);
    }

    /**
     * A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsAttached() {
        return software.amazon.jsii.Kernel.get(this, "isAttached", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsAttached(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isAttached", value);
    }

    /**
     * A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsAttached(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isAttached", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificateProps.Builder();
        }

        /**
         * The domain name for the SSL/TLS certificate.
         * <p>
         * For example, <code>example.com</code> or <code>www.example.com</code> .
         * <p>
         * @return {@code this}
         * @param certificateDomainName The domain name for the SSL/TLS certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateDomainName(final java.lang.String certificateDomainName) {
            this.props.certificateDomainName(certificateDomainName);
            return this;
        }

        /**
         * The name of the SSL/TLS certificate.
         * <p>
         * @return {@code this}
         * @param certificateName The name of the SSL/TLS certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(final java.lang.String certificateName) {
            this.props.certificateName(certificateName);
            return this;
        }

        /**
         * The name of the load balancer that the SSL/TLS certificate is attached to.
         * <p>
         * @return {@code this}
         * @param loadBalancerName The name of the load balancer that the SSL/TLS certificate is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(final java.lang.String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        /**
         * An array of alternative domain names and subdomain names for your SSL/TLS certificate.
         * <p>
         * In addition to the primary domain name, you can have up to nine alternative domain names. Wildcards (such as <code>*.example.com</code> ) are not supported.
         * <p>
         * @return {@code this}
         * @param certificateAlternativeNames An array of alternative domain names and subdomain names for your SSL/TLS certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateAlternativeNames(final java.util.List<java.lang.String> certificateAlternativeNames) {
            this.props.certificateAlternativeNames(certificateAlternativeNames);
            return this;
        }

        /**
         * A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to.
         * <p>
         * @return {@code this}
         * @param httpsRedirectionEnabled A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsRedirectionEnabled(final java.lang.Boolean httpsRedirectionEnabled) {
            this.props.httpsRedirectionEnabled(httpsRedirectionEnabled);
            return this;
        }
        /**
         * A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to.
         * <p>
         * @return {@code this}
         * @param httpsRedirectionEnabled A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsRedirectionEnabled(final software.amazon.awscdk.IResolvable httpsRedirectionEnabled) {
            this.props.httpsRedirectionEnabled(httpsRedirectionEnabled);
            return this;
        }

        /**
         * A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer.
         * <p>
         * @return {@code this}
         * @param isAttached A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isAttached(final java.lang.Boolean isAttached) {
            this.props.isAttached(isAttached);
            return this;
        }
        /**
         * A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer.
         * <p>
         * @return {@code this}
         * @param isAttached A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isAttached(final software.amazon.awscdk.IResolvable isAttached) {
            this.props.isAttached(isAttached);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificate build() {
            return new software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
