package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a `CfnAlarm`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnAlarmProps cfnAlarmProps = CfnAlarmProps.builder()
 *         .alarmName("alarmName")
 *         .comparisonOperator("comparisonOperator")
 *         .evaluationPeriods(123)
 *         .metricName("metricName")
 *         .monitoredResourceName("monitoredResourceName")
 *         .threshold(123)
 *         // the properties below are optional
 *         .contactProtocols(List.of("contactProtocols"))
 *         .datapointsToAlarm(123)
 *         .notificationEnabled(false)
 *         .notificationTriggers(List.of("notificationTriggers"))
 *         .treatMissingData("treatMissingData")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.331Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnAlarmProps")
@software.amazon.jsii.Jsii.Proxy(CfnAlarmProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAlarmProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlarmName();

    /**
     * The arithmetic operation to use when comparing the specified statistic and threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getEvaluationPeriods();

    /**
     * The name of the metric associated with the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

    /**
     * The name of the Lightsail resource that the alarm monitors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMonitoredResourceName();

    /**
     * The value against which the specified statistic is compared.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

    /**
     * The contact protocols for the alarm, such as `Email` , `SMS` (text messaging), or both.
     * <p>
     * <em>Allowed Values</em> : <code>Email</code> | <code>SMS</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContactProtocols() {
        return null;
    }

    /**
     * The number of data points within the evaluation periods that must be breaching to cause the alarm to go to the `ALARM` state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDatapointsToAlarm() {
        return null;
    }

    /**
     * A Boolean value indicating whether the alarm is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationEnabled() {
        return null;
    }

    /**
     * The alarm states that trigger a notification.
     * <p>
     * <blockquote>
     * <p>
     * To specify the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values, you must also specify <code>ContactProtocols</code> values. Otherwise, the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values will not take effect and the stack will drift.
     * <p>
     * </blockquote>
     * <p>
     * <em>Allowed Values</em> : <code>OK</code> | <code>ALARM</code> | <code>INSUFFICIENT_DATA</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationTriggers() {
        return null;
    }

    /**
     * Specifies how the alarm handles missing data points.
     * <p>
     * An alarm can treat missing data in the following ways:
     * <p>
     * <ul>
     * <li><code>breaching</code> - Assumes the missing data is not within the threshold. Missing data counts towards the number of times that the metric is not within the threshold.</li>
     * <li><code>notBreaching</code> - Assumes the missing data is within the threshold. Missing data does not count towards the number of times that the metric is not within the threshold.</li>
     * <li><code>ignore</code> - Ignores the missing data. Maintains the current alarm state.</li>
     * <li><code>missing</code> - Missing data is treated as missing.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTreatMissingData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAlarmProps> {
        java.lang.String alarmName;
        java.lang.String comparisonOperator;
        java.lang.Number evaluationPeriods;
        java.lang.String metricName;
        java.lang.String monitoredResourceName;
        java.lang.Number threshold;
        java.util.List<java.lang.String> contactProtocols;
        java.lang.Number datapointsToAlarm;
        java.lang.Object notificationEnabled;
        java.util.List<java.lang.String> notificationTriggers;
        java.lang.String treatMissingData;

        /**
         * Sets the value of {@link CfnAlarmProps#getAlarmName}
         * @param alarmName The name of the alarm. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(java.lang.String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getComparisonOperator}
         * @param comparisonOperator The arithmetic operation to use when comparing the specified statistic and threshold. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comparisonOperator(java.lang.String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getEvaluationPeriods}
         * @param evaluationPeriods The number of periods over which data is compared to the specified threshold. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getMetricName}
         * @param metricName The name of the metric associated with the alarm. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getMonitoredResourceName}
         * @param monitoredResourceName The name of the Lightsail resource that the alarm monitors. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoredResourceName(java.lang.String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getThreshold}
         * @param threshold The value against which the specified statistic is compared. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder threshold(java.lang.Number threshold) {
            this.threshold = threshold;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getContactProtocols}
         * @param contactProtocols The contact protocols for the alarm, such as `Email` , `SMS` (text messaging), or both.
         *                         <em>Allowed Values</em> : <code>Email</code> | <code>SMS</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactProtocols(java.util.List<java.lang.String> contactProtocols) {
            this.contactProtocols = contactProtocols;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getDatapointsToAlarm}
         * @param datapointsToAlarm The number of data points within the evaluation periods that must be breaching to cause the alarm to go to the `ALARM` state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datapointsToAlarm(java.lang.Number datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getNotificationEnabled}
         * @param notificationEnabled A Boolean value indicating whether the alarm is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationEnabled(java.lang.Boolean notificationEnabled) {
            this.notificationEnabled = notificationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getNotificationEnabled}
         * @param notificationEnabled A Boolean value indicating whether the alarm is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationEnabled(software.amazon.awscdk.IResolvable notificationEnabled) {
            this.notificationEnabled = notificationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getNotificationTriggers}
         * @param notificationTriggers The alarm states that trigger a notification.
         *                             <blockquote>
         *                             <p>
         *                             To specify the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values, you must also specify <code>ContactProtocols</code> values. Otherwise, the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values will not take effect and the stack will drift.
         *                             <p>
         *                             </blockquote>
         *                             <p>
         *                             <em>Allowed Values</em> : <code>OK</code> | <code>ALARM</code> | <code>INSUFFICIENT_DATA</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTriggers(java.util.List<java.lang.String> notificationTriggers) {
            this.notificationTriggers = notificationTriggers;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getTreatMissingData}
         * @param treatMissingData Specifies how the alarm handles missing data points.
         *                         An alarm can treat missing data in the following ways:
         *                         <p>
         *                         <ul>
         *                         <li><code>breaching</code> - Assumes the missing data is not within the threshold. Missing data counts towards the number of times that the metric is not within the threshold.</li>
         *                         <li><code>notBreaching</code> - Assumes the missing data is within the threshold. Missing data does not count towards the number of times that the metric is not within the threshold.</li>
         *                         <li><code>ignore</code> - Ignores the missing data. Maintains the current alarm state.</li>
         *                         <li><code>missing</code> - Missing data is treated as missing.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatMissingData(java.lang.String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAlarmProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAlarmProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAlarmProps {
        private final java.lang.String alarmName;
        private final java.lang.String comparisonOperator;
        private final java.lang.Number evaluationPeriods;
        private final java.lang.String metricName;
        private final java.lang.String monitoredResourceName;
        private final java.lang.Number threshold;
        private final java.util.List<java.lang.String> contactProtocols;
        private final java.lang.Number datapointsToAlarm;
        private final java.lang.Object notificationEnabled;
        private final java.util.List<java.lang.String> notificationTriggers;
        private final java.lang.String treatMissingData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.monitoredResourceName = software.amazon.jsii.Kernel.get(this, "monitoredResourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.contactProtocols = software.amazon.jsii.Kernel.get(this, "contactProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.datapointsToAlarm = software.amazon.jsii.Kernel.get(this, "datapointsToAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.notificationEnabled = software.amazon.jsii.Kernel.get(this, "notificationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationTriggers = software.amazon.jsii.Kernel.get(this, "notificationTriggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.treatMissingData = software.amazon.jsii.Kernel.get(this, "treatMissingData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarmName = java.util.Objects.requireNonNull(builder.alarmName, "alarmName is required");
            this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
            this.evaluationPeriods = java.util.Objects.requireNonNull(builder.evaluationPeriods, "evaluationPeriods is required");
            this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
            this.monitoredResourceName = java.util.Objects.requireNonNull(builder.monitoredResourceName, "monitoredResourceName is required");
            this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
            this.contactProtocols = builder.contactProtocols;
            this.datapointsToAlarm = builder.datapointsToAlarm;
            this.notificationEnabled = builder.notificationEnabled;
            this.notificationTriggers = builder.notificationTriggers;
            this.treatMissingData = builder.treatMissingData;
        }

        @Override
        public final java.lang.String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final java.lang.String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final java.lang.Number getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getMonitoredResourceName() {
            return this.monitoredResourceName;
        }

        @Override
        public final java.lang.Number getThreshold() {
            return this.threshold;
        }

        @Override
        public final java.util.List<java.lang.String> getContactProtocols() {
            return this.contactProtocols;
        }

        @Override
        public final java.lang.Number getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final java.lang.Object getNotificationEnabled() {
            return this.notificationEnabled;
        }

        @Override
        public final java.util.List<java.lang.String> getNotificationTriggers() {
            return this.notificationTriggers;
        }

        @Override
        public final java.lang.String getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarmName", om.valueToTree(this.getAlarmName()));
            data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
            data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
            data.set("metricName", om.valueToTree(this.getMetricName()));
            data.set("monitoredResourceName", om.valueToTree(this.getMonitoredResourceName()));
            data.set("threshold", om.valueToTree(this.getThreshold()));
            if (this.getContactProtocols() != null) {
                data.set("contactProtocols", om.valueToTree(this.getContactProtocols()));
            }
            if (this.getDatapointsToAlarm() != null) {
                data.set("datapointsToAlarm", om.valueToTree(this.getDatapointsToAlarm()));
            }
            if (this.getNotificationEnabled() != null) {
                data.set("notificationEnabled", om.valueToTree(this.getNotificationEnabled()));
            }
            if (this.getNotificationTriggers() != null) {
                data.set("notificationTriggers", om.valueToTree(this.getNotificationTriggers()));
            }
            if (this.getTreatMissingData() != null) {
                data.set("treatMissingData", om.valueToTree(this.getTreatMissingData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnAlarmProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAlarmProps.Jsii$Proxy that = (CfnAlarmProps.Jsii$Proxy) o;

            if (!alarmName.equals(that.alarmName)) return false;
            if (!comparisonOperator.equals(that.comparisonOperator)) return false;
            if (!evaluationPeriods.equals(that.evaluationPeriods)) return false;
            if (!metricName.equals(that.metricName)) return false;
            if (!monitoredResourceName.equals(that.monitoredResourceName)) return false;
            if (!threshold.equals(that.threshold)) return false;
            if (this.contactProtocols != null ? !this.contactProtocols.equals(that.contactProtocols) : that.contactProtocols != null) return false;
            if (this.datapointsToAlarm != null ? !this.datapointsToAlarm.equals(that.datapointsToAlarm) : that.datapointsToAlarm != null) return false;
            if (this.notificationEnabled != null ? !this.notificationEnabled.equals(that.notificationEnabled) : that.notificationEnabled != null) return false;
            if (this.notificationTriggers != null ? !this.notificationTriggers.equals(that.notificationTriggers) : that.notificationTriggers != null) return false;
            return this.treatMissingData != null ? this.treatMissingData.equals(that.treatMissingData) : that.treatMissingData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alarmName.hashCode();
            result = 31 * result + (this.comparisonOperator.hashCode());
            result = 31 * result + (this.evaluationPeriods.hashCode());
            result = 31 * result + (this.metricName.hashCode());
            result = 31 * result + (this.monitoredResourceName.hashCode());
            result = 31 * result + (this.threshold.hashCode());
            result = 31 * result + (this.contactProtocols != null ? this.contactProtocols.hashCode() : 0);
            result = 31 * result + (this.datapointsToAlarm != null ? this.datapointsToAlarm.hashCode() : 0);
            result = 31 * result + (this.notificationEnabled != null ? this.notificationEnabled.hashCode() : 0);
            result = 31 * result + (this.notificationTriggers != null ? this.notificationTriggers.hashCode() : 0);
            result = 31 * result + (this.treatMissingData != null ? this.treatMissingData.hashCode() : 0);
            return result;
        }
    }
}
