package software.amazon.awscdk.services.lex;

/**
 * Properties for defining a `CfnBotAlias`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lex.*;
 * Object sentimentAnalysisSettings;
 * CfnBotAliasProps cfnBotAliasProps = CfnBotAliasProps.builder()
 *         .botAliasName("botAliasName")
 *         .botId("botId")
 *         // the properties below are optional
 *         .botAliasLocaleSettings(List.of(BotAliasLocaleSettingsItemProperty.builder()
 *                 .botAliasLocaleSetting(BotAliasLocaleSettingsProperty.builder()
 *                         .enabled(false)
 *                         // the properties below are optional
 *                         .codeHookSpecification(CodeHookSpecificationProperty.builder()
 *                                 .lambdaCodeHook(LambdaCodeHookProperty.builder()
 *                                         .codeHookInterfaceVersion("codeHookInterfaceVersion")
 *                                         .lambdaArn("lambdaArn")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .localeId("localeId")
 *                 .build()))
 *         .botAliasTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .botVersion("botVersion")
 *         .conversationLogSettings(ConversationLogSettingsProperty.builder()
 *                 .audioLogSettings(List.of(AudioLogSettingProperty.builder()
 *                         .destination(AudioLogDestinationProperty.builder()
 *                                 .s3Bucket(S3BucketLogDestinationProperty.builder()
 *                                         .logPrefix("logPrefix")
 *                                         .s3BucketArn("s3BucketArn")
 *                                         // the properties below are optional
 *                                         .kmsKeyArn("kmsKeyArn")
 *                                         .build())
 *                                 .build())
 *                         .enabled(false)
 *                         .build()))
 *                 .textLogSettings(List.of(TextLogSettingProperty.builder()
 *                         .destination(TextLogDestinationProperty.builder()
 *                                 .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
 *                                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                                         .logPrefix("logPrefix")
 *                                         .build())
 *                                 .build())
 *                         .enabled(false)
 *                         .build()))
 *                 .build())
 *         .description("description")
 *         .sentimentAnalysisSettings(sentimentAnalysisSettings)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.308Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAliasProps")
@software.amazon.jsii.Jsii.Proxy(CfnBotAliasProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBotAliasProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the bot alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBotAliasName();

    /**
     * The unique identifier of the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBotId();

    /**
     * Maps configuration information to a specific locale.
     * <p>
     * You can use this parameter to specify a specific Lambda function to run different functions in different locales.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBotAliasLocaleSettings() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * You can only add tags when you specify an alias.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBotAliasTags() {
        return null;
    }

    /**
     * The version of the bot that the bot alias references.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBotVersion() {
        return null;
    }

    /**
     * Specifies whether Amazon Lex logs text and audio for conversations with the bot.
     * <p>
     * When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch logs. Audio logs store input in Amazon S3 .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConversationLogSettings() {
        return null;
    }

    /**
     * The description of the bot alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSentimentAnalysisSettings() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBotAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBotAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBotAliasProps> {
        java.lang.String botAliasName;
        java.lang.String botId;
        java.lang.Object botAliasLocaleSettings;
        java.lang.Object botAliasTags;
        java.lang.String botVersion;
        java.lang.Object conversationLogSettings;
        java.lang.String description;
        java.lang.Object sentimentAnalysisSettings;

        /**
         * Sets the value of {@link CfnBotAliasProps#getBotAliasName}
         * @param botAliasName The name of the bot alias. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasName(java.lang.String botAliasName) {
            this.botAliasName = botAliasName;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getBotId}
         * @param botId The unique identifier of the bot. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botId(java.lang.String botId) {
            this.botId = botId;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getBotAliasLocaleSettings}
         * @param botAliasLocaleSettings Maps configuration information to a specific locale.
         *                               You can use this parameter to specify a specific Lambda function to run different functions in different locales.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasLocaleSettings(software.amazon.awscdk.IResolvable botAliasLocaleSettings) {
            this.botAliasLocaleSettings = botAliasLocaleSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getBotAliasLocaleSettings}
         * @param botAliasLocaleSettings Maps configuration information to a specific locale.
         *                               You can use this parameter to specify a specific Lambda function to run different functions in different locales.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasLocaleSettings(java.util.List<? extends java.lang.Object> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = botAliasLocaleSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getBotAliasTags}
         * @param botAliasTags An array of key-value pairs to apply to this resource.
         *                     You can only add tags when you specify an alias.
         *                     <p>
         *                     For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasTags(software.amazon.awscdk.IResolvable botAliasTags) {
            this.botAliasTags = botAliasTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getBotAliasTags}
         * @param botAliasTags An array of key-value pairs to apply to this resource.
         *                     You can only add tags when you specify an alias.
         *                     <p>
         *                     For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasTags(java.util.List<? extends java.lang.Object> botAliasTags) {
            this.botAliasTags = botAliasTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getBotVersion}
         * @param botVersion The version of the bot that the bot alias references.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botVersion(java.lang.String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getConversationLogSettings}
         * @param conversationLogSettings Specifies whether Amazon Lex logs text and audio for conversations with the bot.
         *                                When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch logs. Audio logs store input in Amazon S3 .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conversationLogSettings(software.amazon.awscdk.services.lex.CfnBotAlias.ConversationLogSettingsProperty conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getConversationLogSettings}
         * @param conversationLogSettings Specifies whether Amazon Lex logs text and audio for conversations with the bot.
         *                                When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch logs. Audio logs store input in Amazon S3 .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conversationLogSettings(software.amazon.awscdk.IResolvable conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getDescription}
         * @param description The description of the bot alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotAliasProps#getSentimentAnalysisSettings}
         * @param sentimentAnalysisSettings Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sentimentAnalysisSettings(java.lang.Object sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBotAliasProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBotAliasProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBotAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBotAliasProps {
        private final java.lang.String botAliasName;
        private final java.lang.String botId;
        private final java.lang.Object botAliasLocaleSettings;
        private final java.lang.Object botAliasTags;
        private final java.lang.String botVersion;
        private final java.lang.Object conversationLogSettings;
        private final java.lang.String description;
        private final java.lang.Object sentimentAnalysisSettings;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.botAliasName = software.amazon.jsii.Kernel.get(this, "botAliasName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.botId = software.amazon.jsii.Kernel.get(this, "botId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.botAliasLocaleSettings = software.amazon.jsii.Kernel.get(this, "botAliasLocaleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.botAliasTags = software.amazon.jsii.Kernel.get(this, "botAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.botVersion = software.amazon.jsii.Kernel.get(this, "botVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.conversationLogSettings = software.amazon.jsii.Kernel.get(this, "conversationLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sentimentAnalysisSettings = software.amazon.jsii.Kernel.get(this, "sentimentAnalysisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.botAliasName = java.util.Objects.requireNonNull(builder.botAliasName, "botAliasName is required");
            this.botId = java.util.Objects.requireNonNull(builder.botId, "botId is required");
            this.botAliasLocaleSettings = builder.botAliasLocaleSettings;
            this.botAliasTags = builder.botAliasTags;
            this.botVersion = builder.botVersion;
            this.conversationLogSettings = builder.conversationLogSettings;
            this.description = builder.description;
            this.sentimentAnalysisSettings = builder.sentimentAnalysisSettings;
        }

        @Override
        public final java.lang.String getBotAliasName() {
            return this.botAliasName;
        }

        @Override
        public final java.lang.String getBotId() {
            return this.botId;
        }

        @Override
        public final java.lang.Object getBotAliasLocaleSettings() {
            return this.botAliasLocaleSettings;
        }

        @Override
        public final java.lang.Object getBotAliasTags() {
            return this.botAliasTags;
        }

        @Override
        public final java.lang.String getBotVersion() {
            return this.botVersion;
        }

        @Override
        public final java.lang.Object getConversationLogSettings() {
            return this.conversationLogSettings;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getSentimentAnalysisSettings() {
            return this.sentimentAnalysisSettings;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("botAliasName", om.valueToTree(this.getBotAliasName()));
            data.set("botId", om.valueToTree(this.getBotId()));
            if (this.getBotAliasLocaleSettings() != null) {
                data.set("botAliasLocaleSettings", om.valueToTree(this.getBotAliasLocaleSettings()));
            }
            if (this.getBotAliasTags() != null) {
                data.set("botAliasTags", om.valueToTree(this.getBotAliasTags()));
            }
            if (this.getBotVersion() != null) {
                data.set("botVersion", om.valueToTree(this.getBotVersion()));
            }
            if (this.getConversationLogSettings() != null) {
                data.set("conversationLogSettings", om.valueToTree(this.getConversationLogSettings()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getSentimentAnalysisSettings() != null) {
                data.set("sentimentAnalysisSettings", om.valueToTree(this.getSentimentAnalysisSettings()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAliasProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBotAliasProps.Jsii$Proxy that = (CfnBotAliasProps.Jsii$Proxy) o;

            if (!botAliasName.equals(that.botAliasName)) return false;
            if (!botId.equals(that.botId)) return false;
            if (this.botAliasLocaleSettings != null ? !this.botAliasLocaleSettings.equals(that.botAliasLocaleSettings) : that.botAliasLocaleSettings != null) return false;
            if (this.botAliasTags != null ? !this.botAliasTags.equals(that.botAliasTags) : that.botAliasTags != null) return false;
            if (this.botVersion != null ? !this.botVersion.equals(that.botVersion) : that.botVersion != null) return false;
            if (this.conversationLogSettings != null ? !this.conversationLogSettings.equals(that.conversationLogSettings) : that.conversationLogSettings != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.sentimentAnalysisSettings != null ? this.sentimentAnalysisSettings.equals(that.sentimentAnalysisSettings) : that.sentimentAnalysisSettings == null;
        }

        @Override
        public final int hashCode() {
            int result = this.botAliasName.hashCode();
            result = 31 * result + (this.botId.hashCode());
            result = 31 * result + (this.botAliasLocaleSettings != null ? this.botAliasLocaleSettings.hashCode() : 0);
            result = 31 * result + (this.botAliasTags != null ? this.botAliasTags.hashCode() : 0);
            result = 31 * result + (this.botVersion != null ? this.botVersion.hashCode() : 0);
            result = 31 * result + (this.conversationLogSettings != null ? this.conversationLogSettings.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.sentimentAnalysisSettings != null ? this.sentimentAnalysisSettings.hashCode() : 0);
            return result;
        }
    }
}
