package software.amazon.awscdk.services.lambda;

/**
 * Lambda code from a local directory.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.App;
 * import software.amazon.awscdk.Stack;
 * import software.amazon.awscdk.services.apigateway.MockIntegration;
 * import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
 * import software.amazon.awscdk.services.apigateway.RestApi;
 * import software.amazon.awscdk.services.apigateway.TokenAuthorizer;
 * /*
 *  * Stack verification steps:
 *  * * `curl -s -o /dev/null -w "%{http_code}" &lt;url&gt;` should return 401
 *  * * `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' &lt;url&gt;` should return 403
 *  * * `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' &lt;url&gt;` should return 200
 *  *&#47;
 * App app = new App();
 * Stack stack = new Stack(app, "TokenAuthorizerInteg");
 * Function authorizerFn = Function.Builder.create(stack, "MyAuthorizerFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(AssetCode.fromAsset(join(__dirname, "integ.token-authorizer.handler")))
 *         .build();
 * RestApi restapi = new RestApi(stack, "MyRestApi");
 * TokenAuthorizer authorizer = TokenAuthorizer.Builder.create(stack, "MyAuthorizer")
 *         .handler(authorizerFn)
 *         .build();
 * restapi.root.addMethod("ANY", MockIntegration.Builder.create()
 *         .integrationResponses(List.of(IntegrationResponse.builder().statusCode("200").build()))
 *         .passthroughBehavior(PassthroughBehavior.NEVER)
 *         .requestTemplates(Map.of(
 *                 "application/json", "{ \"statusCode\": 200 }"))
 *         .build(), MethodOptions.builder()
 *         .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.087Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.AssetCode")
public class AssetCode extends software.amazon.awscdk.services.lambda.Code {

    protected AssetCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param path The path to the asset file or directory. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetCode(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * @param path The path to the asset file or directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetCode(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Called after the CFN function resource has been created to allow the code class to bind to it.
     * <p>
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     * <p>
     * @param resource This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bindToResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource resource, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ResourceBindOptions options) {
        software.amazon.jsii.Kernel.call(this, "bindToResource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required"), options });
    }

    /**
     * Called after the CFN function resource has been created to allow the code class to bind to it.
     * <p>
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bindToResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource resource) {
        software.amazon.jsii.Kernel.call(this, "bindToResource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Determines whether this Code is inline code or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsInline() {
        return software.amazon.jsii.Kernel.get(this, "isInline", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The path to the asset file or directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.AssetCode}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.AssetCode> {
        /**
         * @return a new instance of {@link Builder}.
         * @param path The path to the asset file or directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String path) {
            return new Builder(path);
        }

        private final java.lang.String path;
        private software.amazon.awscdk.services.s3.assets.AssetOptions.Builder options;

        private Builder(final java.lang.String path) {
            this.path = path;
        }

        /**
         * Specify a custom hash for this asset.
         * <p>
         * If <code>assetHashType</code> is set it must
         * be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         * hash.
         * <p>
         * NOTE: the hash is used in order to identify a specific revision of the asset, and
         * used for optimizing and caching deployment activities related to this asset such as
         * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         * need to make sure it is updated every time the asset changes, or otherwise it is
         * possible that some deployments will not be invalidated.
         * <p>
         * Default: - based on `assetHashType`
         * <p>
         * @return {@code this}
         * @param assetHash Specify a custom hash for this asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHash(final java.lang.String assetHash) {
            this.options().assetHash(assetHash);
            return this;
        }

        /**
         * Specifies the type of hash to calculate for this asset.
         * <p>
         * If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         * <code>AssetHashType.CUSTOM</code>.
         * <p>
         * Default: - the default is `AssetHashType.SOURCE`, but if `assetHash` is
         * explicitly specified this value defaults to `AssetHashType.CUSTOM`.
         * <p>
         * @return {@code this}
         * @param assetHashType Specifies the type of hash to calculate for this asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHashType(final software.amazon.awscdk.AssetHashType assetHashType) {
            this.options().assetHashType(assetHashType);
            return this;
        }

        /**
         * Bundle the asset by executing a command in a Docker container or a custom bundling provider.
         * <p>
         * The asset path will be mounted at <code>/asset-input</code>. The Docker
         * container is responsible for putting content at <code>/asset-output</code>.
         * The content at <code>/asset-output</code> will be zipped and used as the
         * final asset.
         * <p>
         * Default: - uploaded as-is to S3 if the asset is a regular file or a .zip file,
         * archived into a .zip file and uploaded to S3 otherwise
         * <p>
         * @return {@code this}
         * @param bundling Bundle the asset by executing a command in a Docker container or a custom bundling provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundling(final software.amazon.awscdk.BundlingOptions bundling) {
            this.options().bundling(bundling);
            return this;
        }

        /**
         * Glob patterns to exclude from the copy.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude Glob patterns to exclude from the copy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.options().exclude(exclude);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(final software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.options().followSymlinks(followSymlinks);
            return this;
        }

        /**
         * The ignore behavior to use for exclude patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for exclude patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(final software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.options().ignoreMode(ignoreMode);
            return this;
        }

        /**
         * A list of principals that should be able to read this asset from S3.
         * <p>
         * You can use <code>asset.grantRead(principal)</code> to grant read permissions later.
         * <p>
         * Default: - No principals that can read file asset.
         * <p>
         * @return {@code this}
         * @param readers A list of principals that should be able to read this asset from S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readers(final java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers) {
            this.options().readers(readers);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.AssetCode}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.AssetCode build() {
            return new software.amazon.awscdk.services.lambda.AssetCode(
                this.path,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.s3.assets.AssetOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.s3.assets.AssetOptions.Builder();
            }
            return this.options;
        }
    }
}
