package software.amazon.awscdk.services.iotwireless;

/**
 * Properties for defining a `CfnWirelessGateway`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnWirelessGatewayProps cfnWirelessGatewayProps = CfnWirelessGatewayProps.builder()
 *         .loRaWan(LoRaWANGatewayProperty.builder()
 *                 .gatewayEui("gatewayEui")
 *                 .rfRegion("rfRegion")
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .lastUplinkReceivedAt("lastUplinkReceivedAt")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .thingArn("thingArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.792Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnWirelessGatewayProps")
@software.amazon.jsii.Jsii.Proxy(CfnWirelessGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWirelessGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The gateway configuration information to use to create the wireless gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLoRaWan();

    /**
     * The description of the new resource.
     * <p>
     * The maximum length is 2048 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The date and time when the most recent uplink was received.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLastUplinkReceivedAt() {
        return null;
    }

    /**
     * The name of the new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     * <p>
     * Tags can have a minimum of 0 and a maximum of 50 items.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ARN of the thing to associate with the wireless gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThingArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWirelessGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWirelessGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWirelessGatewayProps> {
        java.lang.Object loRaWan;
        java.lang.String description;
        java.lang.String lastUplinkReceivedAt;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String thingArn;

        /**
         * Sets the value of {@link CfnWirelessGatewayProps#getLoRaWan}
         * @param loRaWan The gateway configuration information to use to create the wireless gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(software.amazon.awscdk.services.iotwireless.CfnWirelessGateway.LoRaWANGatewayProperty loRaWan) {
            this.loRaWan = loRaWan;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessGatewayProps#getLoRaWan}
         * @param loRaWan The gateway configuration information to use to create the wireless gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(software.amazon.awscdk.IResolvable loRaWan) {
            this.loRaWan = loRaWan;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessGatewayProps#getDescription}
         * @param description The description of the new resource.
         *                    The maximum length is 2048 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessGatewayProps#getLastUplinkReceivedAt}
         * @param lastUplinkReceivedAt The date and time when the most recent uplink was received.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastUplinkReceivedAt(java.lang.String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessGatewayProps#getName}
         * @param name The name of the new resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessGatewayProps#getTags}
         * @param tags The tags are an array of key-value pairs to attach to the specified resource.
         *             Tags can have a minimum of 0 and a maximum of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessGatewayProps#getThingArn}
         * @param thingArn The ARN of the thing to associate with the wireless gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingArn(java.lang.String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWirelessGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWirelessGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWirelessGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWirelessGatewayProps {
        private final java.lang.Object loRaWan;
        private final java.lang.String description;
        private final java.lang.String lastUplinkReceivedAt;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String thingArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loRaWan = software.amazon.jsii.Kernel.get(this, "loRaWan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lastUplinkReceivedAt = software.amazon.jsii.Kernel.get(this, "lastUplinkReceivedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.thingArn = software.amazon.jsii.Kernel.get(this, "thingArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loRaWan = java.util.Objects.requireNonNull(builder.loRaWan, "loRaWan is required");
            this.description = builder.description;
            this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.thingArn = builder.thingArn;
        }

        @Override
        public final java.lang.Object getLoRaWan() {
            return this.loRaWan;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getLastUplinkReceivedAt() {
            return this.lastUplinkReceivedAt;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getThingArn() {
            return this.thingArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loRaWan", om.valueToTree(this.getLoRaWan()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLastUplinkReceivedAt() != null) {
                data.set("lastUplinkReceivedAt", om.valueToTree(this.getLastUplinkReceivedAt()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThingArn() != null) {
                data.set("thingArn", om.valueToTree(this.getThingArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnWirelessGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWirelessGatewayProps.Jsii$Proxy that = (CfnWirelessGatewayProps.Jsii$Proxy) o;

            if (!loRaWan.equals(that.loRaWan)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.lastUplinkReceivedAt != null ? !this.lastUplinkReceivedAt.equals(that.lastUplinkReceivedAt) : that.lastUplinkReceivedAt != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.thingArn != null ? this.thingArn.equals(that.thingArn) : that.thingArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.loRaWan.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.lastUplinkReceivedAt != null ? this.lastUplinkReceivedAt.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.thingArn != null ? this.thingArn.hashCode() : 0);
            return result;
        }
    }
}
