package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a `CfnTopicRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnTopicRuleProps cfnTopicRuleProps = CfnTopicRuleProps.builder()
 *         .topicRulePayload(TopicRulePayloadProperty.builder()
 *                 .actions(List.of(ActionProperty.builder()
 *                         .cloudwatchAlarm(CloudwatchAlarmActionProperty.builder()
 *                                 .alarmName("alarmName")
 *                                 .roleArn("roleArn")
 *                                 .stateReason("stateReason")
 *                                 .stateValue("stateValue")
 *                                 .build())
 *                         .cloudwatchLogs(CloudwatchLogsActionProperty.builder()
 *                                 .logGroupName("logGroupName")
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .cloudwatchMetric(CloudwatchMetricActionProperty.builder()
 *                                 .metricName("metricName")
 *                                 .metricNamespace("metricNamespace")
 *                                 .metricUnit("metricUnit")
 *                                 .metricValue("metricValue")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .metricTimestamp("metricTimestamp")
 *                                 .build())
 *                         .dynamoDb(DynamoDBActionProperty.builder()
 *                                 .hashKeyField("hashKeyField")
 *                                 .hashKeyValue("hashKeyValue")
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .hashKeyType("hashKeyType")
 *                                 .payloadField("payloadField")
 *                                 .rangeKeyField("rangeKeyField")
 *                                 .rangeKeyType("rangeKeyType")
 *                                 .rangeKeyValue("rangeKeyValue")
 *                                 .build())
 *                         .dynamoDBv2(DynamoDBv2ActionProperty.builder()
 *                                 .putItem(PutItemInputProperty.builder()
 *                                         .tableName("tableName")
 *                                         .build())
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .elasticsearch(ElasticsearchActionProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .id("id")
 *                                 .index("index")
 *                                 .roleArn("roleArn")
 *                                 .type("type")
 *                                 .build())
 *                         .firehose(FirehoseActionProperty.builder()
 *                                 .deliveryStreamName("deliveryStreamName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .separator("separator")
 *                                 .build())
 *                         .http(HttpActionProperty.builder()
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .auth(HttpAuthorizationProperty.builder()
 *                                         .sigv4(SigV4AuthorizationProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 .serviceName("serviceName")
 *                                                 .signingRegion("signingRegion")
 *                                                 .build())
 *                                         .build())
 *                                 .confirmationUrl("confirmationUrl")
 *                                 .headers(List.of(HttpActionHeaderProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .iotAnalytics(IotAnalyticsActionProperty.builder()
 *                                 .channelName("channelName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .build())
 *                         .iotEvents(IotEventsActionProperty.builder()
 *                                 .inputName("inputName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .messageId("messageId")
 *                                 .build())
 *                         .iotSiteWise(IotSiteWiseActionProperty.builder()
 *                                 .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
 *                                         .propertyValues(List.of(AssetPropertyValueProperty.builder()
 *                                                 .timestamp(AssetPropertyTimestampProperty.builder()
 *                                                         .timeInSeconds("timeInSeconds")
 *                                                         // the properties below are optional
 *                                                         .offsetInNanos("offsetInNanos")
 *                                                         .build())
 *                                                 .value(AssetPropertyVariantProperty.builder()
 *                                                         .booleanValue("booleanValue")
 *                                                         .doubleValue("doubleValue")
 *                                                         .integerValue("integerValue")
 *                                                         .stringValue("stringValue")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .quality("quality")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .assetId("assetId")
 *                                         .entryId("entryId")
 *                                         .propertyAlias("propertyAlias")
 *                                         .propertyId("propertyId")
 *                                         .build()))
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .kafka(KafkaActionProperty.builder()
 *                                 .clientProperties(Map.of(
 *                                         "clientPropertiesKey", "clientProperties"))
 *                                 .destinationArn("destinationArn")
 *                                 .topic("topic")
 *                                 // the properties below are optional
 *                                 .key("key")
 *                                 .partition("partition")
 *                                 .build())
 *                         .kinesis(KinesisActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .streamName("streamName")
 *                                 // the properties below are optional
 *                                 .partitionKey("partitionKey")
 *                                 .build())
 *                         .lambda(LambdaActionProperty.builder()
 *                                 .functionArn("functionArn")
 *                                 .build())
 *                         .openSearch(OpenSearchActionProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .id("id")
 *                                 .index("index")
 *                                 .roleArn("roleArn")
 *                                 .type("type")
 *                                 .build())
 *                         .republish(RepublishActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .topic("topic")
 *                                 // the properties below are optional
 *                                 .qos(123)
 *                                 .build())
 *                         .s3(S3ActionProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .key("key")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .cannedAcl("cannedAcl")
 *                                 .build())
 *                         .sns(SnsActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .targetArn("targetArn")
 *                                 // the properties below are optional
 *                                 .messageFormat("messageFormat")
 *                                 .build())
 *                         .sqs(SqsActionProperty.builder()
 *                                 .queueUrl("queueUrl")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .useBase64(false)
 *                                 .build())
 *                         .stepFunctions(StepFunctionsActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .stateMachineName("stateMachineName")
 *                                 // the properties below are optional
 *                                 .executionNamePrefix("executionNamePrefix")
 *                                 .build())
 *                         .timestream(TimestreamActionProperty.builder()
 *                                 .databaseName("databaseName")
 *                                 .dimensions(List.of(TimestreamDimensionProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .timestamp(TimestreamTimestampProperty.builder()
 *                                         .unit("unit")
 *                                         .value("value")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .sql("sql")
 *                 // the properties below are optional
 *                 .awsIotSqlVersion("awsIotSqlVersion")
 *                 .description("description")
 *                 .errorAction(ActionProperty.builder()
 *                         .cloudwatchAlarm(CloudwatchAlarmActionProperty.builder()
 *                                 .alarmName("alarmName")
 *                                 .roleArn("roleArn")
 *                                 .stateReason("stateReason")
 *                                 .stateValue("stateValue")
 *                                 .build())
 *                         .cloudwatchLogs(CloudwatchLogsActionProperty.builder()
 *                                 .logGroupName("logGroupName")
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .cloudwatchMetric(CloudwatchMetricActionProperty.builder()
 *                                 .metricName("metricName")
 *                                 .metricNamespace("metricNamespace")
 *                                 .metricUnit("metricUnit")
 *                                 .metricValue("metricValue")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .metricTimestamp("metricTimestamp")
 *                                 .build())
 *                         .dynamoDb(DynamoDBActionProperty.builder()
 *                                 .hashKeyField("hashKeyField")
 *                                 .hashKeyValue("hashKeyValue")
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .hashKeyType("hashKeyType")
 *                                 .payloadField("payloadField")
 *                                 .rangeKeyField("rangeKeyField")
 *                                 .rangeKeyType("rangeKeyType")
 *                                 .rangeKeyValue("rangeKeyValue")
 *                                 .build())
 *                         .dynamoDBv2(DynamoDBv2ActionProperty.builder()
 *                                 .putItem(PutItemInputProperty.builder()
 *                                         .tableName("tableName")
 *                                         .build())
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .elasticsearch(ElasticsearchActionProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .id("id")
 *                                 .index("index")
 *                                 .roleArn("roleArn")
 *                                 .type("type")
 *                                 .build())
 *                         .firehose(FirehoseActionProperty.builder()
 *                                 .deliveryStreamName("deliveryStreamName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .separator("separator")
 *                                 .build())
 *                         .http(HttpActionProperty.builder()
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .auth(HttpAuthorizationProperty.builder()
 *                                         .sigv4(SigV4AuthorizationProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 .serviceName("serviceName")
 *                                                 .signingRegion("signingRegion")
 *                                                 .build())
 *                                         .build())
 *                                 .confirmationUrl("confirmationUrl")
 *                                 .headers(List.of(HttpActionHeaderProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .iotAnalytics(IotAnalyticsActionProperty.builder()
 *                                 .channelName("channelName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .build())
 *                         .iotEvents(IotEventsActionProperty.builder()
 *                                 .inputName("inputName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .messageId("messageId")
 *                                 .build())
 *                         .iotSiteWise(IotSiteWiseActionProperty.builder()
 *                                 .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
 *                                         .propertyValues(List.of(AssetPropertyValueProperty.builder()
 *                                                 .timestamp(AssetPropertyTimestampProperty.builder()
 *                                                         .timeInSeconds("timeInSeconds")
 *                                                         // the properties below are optional
 *                                                         .offsetInNanos("offsetInNanos")
 *                                                         .build())
 *                                                 .value(AssetPropertyVariantProperty.builder()
 *                                                         .booleanValue("booleanValue")
 *                                                         .doubleValue("doubleValue")
 *                                                         .integerValue("integerValue")
 *                                                         .stringValue("stringValue")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .quality("quality")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .assetId("assetId")
 *                                         .entryId("entryId")
 *                                         .propertyAlias("propertyAlias")
 *                                         .propertyId("propertyId")
 *                                         .build()))
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .kafka(KafkaActionProperty.builder()
 *                                 .clientProperties(Map.of(
 *                                         "clientPropertiesKey", "clientProperties"))
 *                                 .destinationArn("destinationArn")
 *                                 .topic("topic")
 *                                 // the properties below are optional
 *                                 .key("key")
 *                                 .partition("partition")
 *                                 .build())
 *                         .kinesis(KinesisActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .streamName("streamName")
 *                                 // the properties below are optional
 *                                 .partitionKey("partitionKey")
 *                                 .build())
 *                         .lambda(LambdaActionProperty.builder()
 *                                 .functionArn("functionArn")
 *                                 .build())
 *                         .openSearch(OpenSearchActionProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .id("id")
 *                                 .index("index")
 *                                 .roleArn("roleArn")
 *                                 .type("type")
 *                                 .build())
 *                         .republish(RepublishActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .topic("topic")
 *                                 // the properties below are optional
 *                                 .qos(123)
 *                                 .build())
 *                         .s3(S3ActionProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .key("key")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .cannedAcl("cannedAcl")
 *                                 .build())
 *                         .sns(SnsActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .targetArn("targetArn")
 *                                 // the properties below are optional
 *                                 .messageFormat("messageFormat")
 *                                 .build())
 *                         .sqs(SqsActionProperty.builder()
 *                                 .queueUrl("queueUrl")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .useBase64(false)
 *                                 .build())
 *                         .stepFunctions(StepFunctionsActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .stateMachineName("stateMachineName")
 *                                 // the properties below are optional
 *                                 .executionNamePrefix("executionNamePrefix")
 *                                 .build())
 *                         .timestream(TimestreamActionProperty.builder()
 *                                 .databaseName("databaseName")
 *                                 .dimensions(List.of(TimestreamDimensionProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .timestamp(TimestreamTimestampProperty.builder()
 *                                         .unit("unit")
 *                                         .value("value")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .ruleDisabled(false)
 *                 .build())
 *         // the properties below are optional
 *         .ruleName("ruleName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.605Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnTopicRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTopicRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The rule payload.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTopicRulePayload();

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
        return null;
    }

    /**
     * Metadata which can be used to manage the topic rule.
     * <p>
     * <blockquote>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * <p>
     * For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTopicRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTopicRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTopicRuleProps> {
        java.lang.Object topicRulePayload;
        java.lang.String ruleName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTopicRuleProps#getTopicRulePayload}
         * @param topicRulePayload The rule payload. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicRulePayload(software.amazon.awscdk.services.iot.CfnTopicRule.TopicRulePayloadProperty topicRulePayload) {
            this.topicRulePayload = topicRulePayload;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicRuleProps#getTopicRulePayload}
         * @param topicRulePayload The rule payload. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicRulePayload(software.amazon.awscdk.IResolvable topicRulePayload) {
            this.topicRulePayload = topicRulePayload;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicRuleProps#getRuleName}
         * @param ruleName The name of the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicRuleProps#getTags}
         * @param tags Metadata which can be used to manage the topic rule.
         *             <blockquote>
         *             <p>
         *             For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *             <p>
         *             For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."
         *             <p>
         *             For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTopicRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTopicRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTopicRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTopicRuleProps {
        private final java.lang.Object topicRulePayload;
        private final java.lang.String ruleName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topicRulePayload = software.amazon.jsii.Kernel.get(this, "topicRulePayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topicRulePayload = java.util.Objects.requireNonNull(builder.topicRulePayload, "topicRulePayload is required");
            this.ruleName = builder.ruleName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getTopicRulePayload() {
            return this.topicRulePayload;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("topicRulePayload", om.valueToTree(this.getTopicRulePayload()));
            if (this.getRuleName() != null) {
                data.set("ruleName", om.valueToTree(this.getRuleName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTopicRuleProps.Jsii$Proxy that = (CfnTopicRuleProps.Jsii$Proxy) o;

            if (!topicRulePayload.equals(that.topicRulePayload)) return false;
            if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.topicRulePayload.hashCode();
            result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
