package software.amazon.awscdk.services.iot;

/**
 * A CloudFormation `AWS::IoT::DomainConfiguration`.
 * <p>
 * Specifies a domain configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnDomainConfiguration cfnDomainConfiguration = CfnDomainConfiguration.Builder.create(this, "MyCfnDomainConfiguration")
 *         .authorizerConfig(AuthorizerConfigProperty.builder()
 *                 .allowAuthorizerOverride(false)
 *                 .defaultAuthorizerName("defaultAuthorizerName")
 *                 .build())
 *         .domainConfigurationName("domainConfigurationName")
 *         .domainConfigurationStatus("domainConfigurationStatus")
 *         .domainName("domainName")
 *         .serverCertificateArns(List.of("serverCertificateArns"))
 *         .serviceType("serviceType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .validationCertificateArn("validationCertificateArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.531Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration")
public class CfnDomainConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDomainConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomainConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnDomainConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoT::DomainConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomainConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnDomainConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::IoT::DomainConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomainConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the domain configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of service delivered by the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainType() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
     * <p>
     * Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrServerCertificates() {
        return software.amazon.jsii.Kernel.get(this, "attrServerCertificates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Metadata which can be used to manage the domain configuration.
     * <p>
     * <blockquote>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * An object that specifies the authorization service for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizerConfig() {
        return software.amazon.jsii.Kernel.get(this, "authorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that specifies the authorization service for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnDomainConfiguration.AuthorizerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "authorizerConfig", value);
    }

    /**
     * An object that specifies the authorization service for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authorizerConfig", value);
    }

    /**
     * The name of the domain configuration.
     * <p>
     * This value must be unique to a region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainConfigurationName() {
        return software.amazon.jsii.Kernel.get(this, "domainConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the domain configuration.
     * <p>
     * This value must be unique to a region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainConfigurationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainConfigurationName", value);
    }

    /**
     * The status to which the domain configuration should be updated.
     * <p>
     * Valid values: <code>ENABLED</code> | <code>DISABLED</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainConfigurationStatus() {
        return software.amazon.jsii.Kernel.get(this, "domainConfigurationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status to which the domain configuration should be updated.
     * <p>
     * Valid values: <code>ENABLED</code> | <code>DISABLED</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainConfigurationStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainConfigurationStatus", value);
    }

    /**
     * The name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", value);
    }

    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
     * <p>
     * Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getServerCertificateArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "serverCertificateArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
     * <p>
     * Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerCertificateArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "serverCertificateArns", value);
    }

    /**
     * The type of service delivered by the endpoint.
     * <p>
     * <blockquote>
     * <p>
     * AWS IoT Core currently supports only the <code>DATA</code> service type.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceType() {
        return software.amazon.jsii.Kernel.get(this, "serviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of service delivered by the endpoint.
     * <p>
     * <blockquote>
     * <p>
     * AWS IoT Core currently supports only the <code>DATA</code> service type.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceType", value);
    }

    /**
     * The certificate used to validate the server certificate and prove domain name ownership.
     * <p>
     * This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidationCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "validationCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The certificate used to validate the server certificate and prove domain name ownership.
     * <p>
     * This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationCertificateArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validationCertificateArn", value);
    }
    /**
     * An object that specifies the authorization service for a domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AuthorizerConfigProperty authorizerConfigProperty = AuthorizerConfigProperty.builder()
     *         .allowAuthorizerOverride(false)
     *         .defaultAuthorizerName("defaultAuthorizerName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration.AuthorizerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean that specifies whether the domain configuration's authorization service can be overridden.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowAuthorizerOverride() {
            return null;
        }

        /**
         * The name of the authorization service for a domain configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAuthorizerName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizerConfigProperty> {
            java.lang.Object allowAuthorizerOverride;
            java.lang.String defaultAuthorizerName;

            /**
             * Sets the value of {@link AuthorizerConfigProperty#getAllowAuthorizerOverride}
             * @param allowAuthorizerOverride A Boolean that specifies whether the domain configuration's authorization service can be overridden.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowAuthorizerOverride(java.lang.Boolean allowAuthorizerOverride) {
                this.allowAuthorizerOverride = allowAuthorizerOverride;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizerConfigProperty#getAllowAuthorizerOverride}
             * @param allowAuthorizerOverride A Boolean that specifies whether the domain configuration's authorization service can be overridden.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowAuthorizerOverride(software.amazon.awscdk.IResolvable allowAuthorizerOverride) {
                this.allowAuthorizerOverride = allowAuthorizerOverride;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizerConfigProperty#getDefaultAuthorizerName}
             * @param defaultAuthorizerName The name of the authorization service for a domain configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultAuthorizerName(java.lang.String defaultAuthorizerName) {
                this.defaultAuthorizerName = defaultAuthorizerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizerConfigProperty {
            private final java.lang.Object allowAuthorizerOverride;
            private final java.lang.String defaultAuthorizerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowAuthorizerOverride = software.amazon.jsii.Kernel.get(this, "allowAuthorizerOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultAuthorizerName = software.amazon.jsii.Kernel.get(this, "defaultAuthorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowAuthorizerOverride = builder.allowAuthorizerOverride;
                this.defaultAuthorizerName = builder.defaultAuthorizerName;
            }

            @Override
            public final java.lang.Object getAllowAuthorizerOverride() {
                return this.allowAuthorizerOverride;
            }

            @Override
            public final java.lang.String getDefaultAuthorizerName() {
                return this.defaultAuthorizerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowAuthorizerOverride() != null) {
                    data.set("allowAuthorizerOverride", om.valueToTree(this.getAllowAuthorizerOverride()));
                }
                if (this.getDefaultAuthorizerName() != null) {
                    data.set("defaultAuthorizerName", om.valueToTree(this.getDefaultAuthorizerName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnDomainConfiguration.AuthorizerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizerConfigProperty.Jsii$Proxy that = (AuthorizerConfigProperty.Jsii$Proxy) o;

                if (this.allowAuthorizerOverride != null ? !this.allowAuthorizerOverride.equals(that.allowAuthorizerOverride) : that.allowAuthorizerOverride != null) return false;
                return this.defaultAuthorizerName != null ? this.defaultAuthorizerName.equals(that.defaultAuthorizerName) : that.defaultAuthorizerName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowAuthorizerOverride != null ? this.allowAuthorizerOverride.hashCode() : 0;
                result = 31 * result + (this.defaultAuthorizerName != null ? this.defaultAuthorizerName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that contains information about a server certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ServerCertificateSummaryProperty serverCertificateSummaryProperty = ServerCertificateSummaryProperty.builder()
     *         .serverCertificateArn("serverCertificateArn")
     *         .serverCertificateStatus("serverCertificateStatus")
     *         .serverCertificateStatusDetail("serverCertificateStatusDetail")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration.ServerCertificateSummaryProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerCertificateSummaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerCertificateSummaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the server certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerCertificateArn() {
            return null;
        }

        /**
         * The status of the server certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerCertificateStatus() {
            return null;
        }

        /**
         * Details that explain the status of the server certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerCertificateStatusDetail() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerCertificateSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerCertificateSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerCertificateSummaryProperty> {
            java.lang.String serverCertificateArn;
            java.lang.String serverCertificateStatus;
            java.lang.String serverCertificateStatusDetail;

            /**
             * Sets the value of {@link ServerCertificateSummaryProperty#getServerCertificateArn}
             * @param serverCertificateArn The ARN of the server certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificateArn(java.lang.String serverCertificateArn) {
                this.serverCertificateArn = serverCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateSummaryProperty#getServerCertificateStatus}
             * @param serverCertificateStatus The status of the server certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificateStatus(java.lang.String serverCertificateStatus) {
                this.serverCertificateStatus = serverCertificateStatus;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateSummaryProperty#getServerCertificateStatusDetail}
             * @param serverCertificateStatusDetail Details that explain the status of the server certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificateStatusDetail(java.lang.String serverCertificateStatusDetail) {
                this.serverCertificateStatusDetail = serverCertificateStatusDetail;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerCertificateSummaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerCertificateSummaryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerCertificateSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerCertificateSummaryProperty {
            private final java.lang.String serverCertificateArn;
            private final java.lang.String serverCertificateStatus;
            private final java.lang.String serverCertificateStatusDetail;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serverCertificateArn = software.amazon.jsii.Kernel.get(this, "serverCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverCertificateStatus = software.amazon.jsii.Kernel.get(this, "serverCertificateStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverCertificateStatusDetail = software.amazon.jsii.Kernel.get(this, "serverCertificateStatusDetail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverCertificateArn = builder.serverCertificateArn;
                this.serverCertificateStatus = builder.serverCertificateStatus;
                this.serverCertificateStatusDetail = builder.serverCertificateStatusDetail;
            }

            @Override
            public final java.lang.String getServerCertificateArn() {
                return this.serverCertificateArn;
            }

            @Override
            public final java.lang.String getServerCertificateStatus() {
                return this.serverCertificateStatus;
            }

            @Override
            public final java.lang.String getServerCertificateStatusDetail() {
                return this.serverCertificateStatusDetail;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServerCertificateArn() != null) {
                    data.set("serverCertificateArn", om.valueToTree(this.getServerCertificateArn()));
                }
                if (this.getServerCertificateStatus() != null) {
                    data.set("serverCertificateStatus", om.valueToTree(this.getServerCertificateStatus()));
                }
                if (this.getServerCertificateStatusDetail() != null) {
                    data.set("serverCertificateStatusDetail", om.valueToTree(this.getServerCertificateStatusDetail()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnDomainConfiguration.ServerCertificateSummaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerCertificateSummaryProperty.Jsii$Proxy that = (ServerCertificateSummaryProperty.Jsii$Proxy) o;

                if (this.serverCertificateArn != null ? !this.serverCertificateArn.equals(that.serverCertificateArn) : that.serverCertificateArn != null) return false;
                if (this.serverCertificateStatus != null ? !this.serverCertificateStatus.equals(that.serverCertificateStatus) : that.serverCertificateStatus != null) return false;
                return this.serverCertificateStatusDetail != null ? this.serverCertificateStatusDetail.equals(that.serverCertificateStatusDetail) : that.serverCertificateStatusDetail == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serverCertificateArn != null ? this.serverCertificateArn.hashCode() : 0;
                result = 31 * result + (this.serverCertificateStatus != null ? this.serverCertificateStatus.hashCode() : 0);
                result = 31 * result + (this.serverCertificateStatusDetail != null ? this.serverCertificateStatusDetail.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnDomainConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnDomainConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iot.CfnDomainConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An object that specifies the authorization service for a domain.
         * <p>
         * @return {@code this}
         * @param authorizerConfig An object that specifies the authorization service for a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfig(final software.amazon.awscdk.services.iot.CfnDomainConfiguration.AuthorizerConfigProperty authorizerConfig) {
            this.props().authorizerConfig(authorizerConfig);
            return this;
        }
        /**
         * An object that specifies the authorization service for a domain.
         * <p>
         * @return {@code this}
         * @param authorizerConfig An object that specifies the authorization service for a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfig(final software.amazon.awscdk.IResolvable authorizerConfig) {
            this.props().authorizerConfig(authorizerConfig);
            return this;
        }

        /**
         * The name of the domain configuration.
         * <p>
         * This value must be unique to a region.
         * <p>
         * @return {@code this}
         * @param domainConfigurationName The name of the domain configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationName(final java.lang.String domainConfigurationName) {
            this.props().domainConfigurationName(domainConfigurationName);
            return this;
        }

        /**
         * The status to which the domain configuration should be updated.
         * <p>
         * Valid values: <code>ENABLED</code> | <code>DISABLED</code>
         * <p>
         * @return {@code this}
         * @param domainConfigurationStatus The status to which the domain configuration should be updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationStatus(final java.lang.String domainConfigurationStatus) {
            this.props().domainConfigurationStatus(domainConfigurationStatus);
            return this;
        }

        /**
         * The name of the domain.
         * <p>
         * @return {@code this}
         * @param domainName The name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
         * <p>
         * Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
         * <p>
         * @return {@code this}
         * @param serverCertificateArns The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArns(final java.util.List<java.lang.String> serverCertificateArns) {
            this.props().serverCertificateArns(serverCertificateArns);
            return this;
        }

        /**
         * The type of service delivered by the endpoint.
         * <p>
         * <blockquote>
         * <p>
         * AWS IoT Core currently supports only the <code>DATA</code> service type.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param serviceType The type of service delivered by the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceType(final java.lang.String serviceType) {
            this.props().serviceType(serviceType);
            return this;
        }

        /**
         * Metadata which can be used to manage the domain configuration.
         * <p>
         * <blockquote>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param tags Metadata which can be used to manage the domain configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The certificate used to validate the server certificate and prove domain name ownership.
         * <p>
         * This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
         * <p>
         * @return {@code this}
         * @param validationCertificateArn The certificate used to validate the server certificate and prove domain name ownership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationCertificateArn(final java.lang.String validationCertificateArn) {
            this.props().validationCertificateArn(validationCertificateArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.CfnDomainConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnDomainConfiguration build() {
            return new software.amazon.awscdk.services.iot.CfnDomainConfiguration(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.CfnDomainConfigurationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.CfnDomainConfigurationProps.Builder();
            }
            return this.props;
        }
    }
}
