package software.amazon.awscdk.services.imagebuilder;

/**
 * A CloudFormation `AWS::ImageBuilder::ContainerRecipe`.
 * <p>
 * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnContainerRecipe cfnContainerRecipe = CfnContainerRecipe.Builder.create(this, "MyCfnContainerRecipe")
 *         .components(List.of(ComponentConfigurationProperty.builder()
 *                 .componentArn("componentArn")
 *                 .build()))
 *         .containerType("containerType")
 *         .name("name")
 *         .parentImage("parentImage")
 *         .targetRepository(TargetContainerRepositoryProperty.builder()
 *                 .repositoryName("repositoryName")
 *                 .service("service")
 *                 .build())
 *         .version("version")
 *         // the properties below are optional
 *         .description("description")
 *         .dockerfileTemplateData("dockerfileTemplateData")
 *         .dockerfileTemplateUri("dockerfileTemplateUri")
 *         .imageOsVersionOverride("imageOsVersionOverride")
 *         .instanceConfiguration(InstanceConfigurationProperty.builder()
 *                 .blockDeviceMappings(List.of(InstanceBlockDeviceMappingProperty.builder()
 *                         .deviceName("deviceName")
 *                         .ebs(EbsInstanceBlockDeviceSpecificationProperty.builder()
 *                                 .deleteOnTermination(false)
 *                                 .encrypted(false)
 *                                 .iops(123)
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .snapshotId("snapshotId")
 *                                 .throughput(123)
 *                                 .volumeSize(123)
 *                                 .volumeType("volumeType")
 *                                 .build())
 *                         .noDevice("noDevice")
 *                         .virtualName("virtualName")
 *                         .build()))
 *                 .image("image")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .platformOverride("platformOverride")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .workingDirectory("workingDirectory")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.482Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe")
public class CfnContainerRecipe extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnContainerRecipe(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContainerRecipe(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ImageBuilder::ContainerRecipe`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnContainerRecipe(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.imagebuilder.CfnContainerRecipeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the container recipe.
     * <p>
     * For example, <code>arn:aws:imagebuilder:us-east-1:123456789012:container-recipe/mybasicrecipe/2020.12.17</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of the container recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tags that are attached to the container recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Build and test components that are included in the container recipe.
     * <p>
     * Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getComponents() {
        return software.amazon.jsii.Kernel.get(this, "components", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Build and test components that are included in the container recipe.
     * <p>
     * Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "components", java.util.Objects.requireNonNull(value, "components is required"));
    }

    /**
     * Build and test components that are included in the container recipe.
     * <p>
     * Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponents(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "components", java.util.Objects.requireNonNull(value, "components is required"));
    }

    /**
     * Specifies the type of container, such as Docker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getContainerType() {
        return software.amazon.jsii.Kernel.get(this, "containerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the type of container, such as Docker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "containerType", java.util.Objects.requireNonNull(value, "containerType is required"));
    }

    /**
     * The name of the container recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the container recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The base image for the container recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParentImage() {
        return software.amazon.jsii.Kernel.get(this, "parentImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The base image for the container recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParentImage(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "parentImage", java.util.Objects.requireNonNull(value, "parentImage is required"));
    }

    /**
     * The destination repository for the container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargetRepository() {
        return software.amazon.jsii.Kernel.get(this, "targetRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The destination repository for the container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe.TargetContainerRepositoryProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetRepository", java.util.Objects.requireNonNull(value, "targetRepository is required"));
    }

    /**
     * The destination repository for the container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetRepository", java.util.Objects.requireNonNull(value, "targetRepository is required"));
    }

    /**
     * The semantic version of the container recipe.
     * <p>
     * <blockquote>
     * <p>
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     * <p>
     * <em>Assignment:</em> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     * <p>
     * <em>Patterns:</em> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     * <p>
     * <em>Filtering:</em> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The semantic version of the container recipe.
     * <p>
     * <blockquote>
     * <p>
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     * <p>
     * <em>Assignment:</em> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     * <p>
     * <em>Patterns:</em> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     * <p>
     * <em>Filtering:</em> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "version", java.util.Objects.requireNonNull(value, "version is required"));
    }

    /**
     * The description of the container recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the container recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside.
     * <p>
     * The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDockerfileTemplateData() {
        return software.amazon.jsii.Kernel.get(this, "dockerfileTemplateData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside.
     * <p>
     * The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDockerfileTemplateData(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dockerfileTemplateData", value);
    }

    /**
     * The S3 URI for the Dockerfile that will be used to build your container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDockerfileTemplateUri() {
        return software.amazon.jsii.Kernel.get(this, "dockerfileTemplateUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The S3 URI for the Dockerfile that will be used to build your container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDockerfileTemplateUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dockerfileTemplateUri", value);
    }

    /**
     * Specifies the operating system version for the base image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImageOsVersionOverride() {
        return software.amazon.jsii.Kernel.get(this, "imageOsVersionOverride", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the operating system version for the base image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageOsVersionOverride(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageOsVersionOverride", value);
    }

    /**
     * A group of options that can be used to configure an instance for building and testing container images.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "instanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A group of options that can be used to configure an instance for building and testing container images.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe.InstanceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "instanceConfiguration", value);
    }

    /**
     * A group of options that can be used to configure an instance for building and testing container images.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceConfiguration", value);
    }

    /**
     * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Specifies the operating system platform when you use a custom base image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlatformOverride() {
        return software.amazon.jsii.Kernel.get(this, "platformOverride", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the operating system platform when you use a custom base image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatformOverride(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "platformOverride", value);
    }

    /**
     * The working directory for use during build and test workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The working directory for use during build and test workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkingDirectory(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workingDirectory", value);
    }
    /**
     * Configuration details of the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * ComponentConfigurationProperty componentConfigurationProperty = ComponentConfigurationProperty.builder()
     *         .componentArn("componentArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.ComponentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the component.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentConfigurationProperty> {
            java.lang.String componentArn;

            /**
             * Sets the value of {@link ComponentConfigurationProperty#getComponentArn}
             * @param componentArn The Amazon Resource Name (ARN) of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentArn(java.lang.String componentArn) {
                this.componentArn = componentArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentConfigurationProperty {
            private final java.lang.String componentArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentArn = software.amazon.jsii.Kernel.get(this, "componentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentArn = builder.componentArn;
            }

            @Override
            public final java.lang.String getComponentArn() {
                return this.componentArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentArn() != null) {
                    data.set("componentArn", om.valueToTree(this.getComponentArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.ComponentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentConfigurationProperty.Jsii$Proxy that = (ComponentConfigurationProperty.Jsii$Proxy) o;

                return this.componentArn != null ? this.componentArn.equals(that.componentArn) : that.componentArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentArn != null ? this.componentArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Amazon EBS-specific block device mapping specifications.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * EbsInstanceBlockDeviceSpecificationProperty ebsInstanceBlockDeviceSpecificationProperty = EbsInstanceBlockDeviceSpecificationProperty.builder()
     *         .deleteOnTermination(false)
     *         .encrypted(false)
     *         .iops(123)
     *         .kmsKeyId("kmsKeyId")
     *         .snapshotId("snapshotId")
     *         .throughput(123)
     *         .volumeSize(123)
     *         .volumeType("volumeType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsInstanceBlockDeviceSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsInstanceBlockDeviceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use to configure delete on termination of the associated device.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * Use to configure device encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * Use to configure device IOPS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * Use to configure the KMS key to use when encrypting the device.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The snapshot that defines the device contents.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * *For GP3 volumes only* – The throughput in MiB/s that the volume supports.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
            return null;
        }

        /**
         * Use to override the device's volume size.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * Use to override the device's volume type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsInstanceBlockDeviceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsInstanceBlockDeviceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsInstanceBlockDeviceSpecificationProperty> {
            java.lang.Object deleteOnTermination;
            java.lang.Object encrypted;
            java.lang.Number iops;
            java.lang.String kmsKeyId;
            java.lang.String snapshotId;
            java.lang.Number throughput;
            java.lang.Number volumeSize;
            java.lang.String volumeType;

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getDeleteOnTermination}
             * @param deleteOnTermination Use to configure delete on termination of the associated device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getDeleteOnTermination}
             * @param deleteOnTermination Use to configure delete on termination of the associated device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getEncrypted}
             * @param encrypted Use to configure device encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getEncrypted}
             * @param encrypted Use to configure device encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getIops}
             * @param iops Use to configure device IOPS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getKmsKeyId}
             * @param kmsKeyId Use to configure the KMS key to use when encrypting the device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getSnapshotId}
             * @param snapshotId The snapshot that defines the device contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getThroughput}
             * @param throughput *For GP3 volumes only* – The throughput in MiB/s that the volume supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughput(java.lang.Number throughput) {
                this.throughput = throughput;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getVolumeSize}
             * @param volumeSize Use to override the device's volume size.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EbsInstanceBlockDeviceSpecificationProperty#getVolumeType}
             * @param volumeType Use to override the device's volume type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsInstanceBlockDeviceSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsInstanceBlockDeviceSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsInstanceBlockDeviceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsInstanceBlockDeviceSpecificationProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String kmsKeyId;
            private final java.lang.String snapshotId;
            private final java.lang.Number throughput;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = builder.deleteOnTermination;
                this.encrypted = builder.encrypted;
                this.iops = builder.iops;
                this.kmsKeyId = builder.kmsKeyId;
                this.snapshotId = builder.snapshotId;
                this.throughput = builder.throughput;
                this.volumeSize = builder.volumeSize;
                this.volumeType = builder.volumeType;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public final java.lang.Number getThroughput() {
                return this.throughput;
            }

            @Override
            public final java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getThroughput() != null) {
                    data.set("throughput", om.valueToTree(this.getThroughput()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsInstanceBlockDeviceSpecificationProperty.Jsii$Proxy that = (EbsInstanceBlockDeviceSpecificationProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines block device mappings for the instance used to configure your image.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * InstanceBlockDeviceMappingProperty instanceBlockDeviceMappingProperty = InstanceBlockDeviceMappingProperty.builder()
     *         .deviceName("deviceName")
     *         .ebs(EbsInstanceBlockDeviceSpecificationProperty.builder()
     *                 .deleteOnTermination(false)
     *                 .encrypted(false)
     *                 .iops(123)
     *                 .kmsKeyId("kmsKeyId")
     *                 .snapshotId("snapshotId")
     *                 .throughput(123)
     *                 .volumeSize(123)
     *                 .volumeType("volumeType")
     *                 .build())
     *         .noDevice("noDevice")
     *         .virtualName("virtualName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.InstanceBlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceBlockDeviceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceBlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The device to which these mappings apply.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceName() {
            return null;
        }

        /**
         * Use to manage Amazon EBS-specific configuration for this mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbs() {
            return null;
        }

        /**
         * Use to remove a mapping from the base image.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNoDevice() {
            return null;
        }

        /**
         * Use to manage instance ephemeral devices.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceBlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceBlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceBlockDeviceMappingProperty> {
            java.lang.String deviceName;
            java.lang.Object ebs;
            java.lang.String noDevice;
            java.lang.String virtualName;

            /**
             * Sets the value of {@link InstanceBlockDeviceMappingProperty#getDeviceName}
             * @param deviceName The device to which these mappings apply.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link InstanceBlockDeviceMappingProperty#getEbs}
             * @param ebs Use to manage Amazon EBS-specific configuration for this mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link InstanceBlockDeviceMappingProperty#getEbs}
             * @param ebs Use to manage Amazon EBS-specific configuration for this mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link InstanceBlockDeviceMappingProperty#getNoDevice}
             * @param noDevice Use to remove a mapping from the base image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(java.lang.String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceBlockDeviceMappingProperty#getVirtualName}
             * @param virtualName Use to manage instance ephemeral devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceBlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceBlockDeviceMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceBlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceBlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.String noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebs = software.amazon.jsii.Kernel.get(this, "ebs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noDevice = software.amazon.jsii.Kernel.get(this, "noDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.virtualName = software.amazon.jsii.Kernel.get(this, "virtualName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = builder.deviceName;
                this.ebs = builder.ebs;
                this.noDevice = builder.noDevice;
                this.virtualName = builder.virtualName;
            }

            @Override
            public final java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public final java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public final java.lang.String getNoDevice() {
                return this.noDevice;
            }

            @Override
            public final java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeviceName() != null) {
                    data.set("deviceName", om.valueToTree(this.getDeviceName()));
                }
                if (this.getEbs() != null) {
                    data.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    data.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    data.set("virtualName", om.valueToTree(this.getVirtualName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.InstanceBlockDeviceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceBlockDeviceMappingProperty.Jsii$Proxy that = (InstanceBlockDeviceMappingProperty.Jsii$Proxy) o;

                if (this.deviceName != null ? !this.deviceName.equals(that.deviceName) : that.deviceName != null) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceName != null ? this.deviceName.hashCode() : 0;
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a custom base AMI and block device mapping configurations of an instance used for building and testing container images.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * InstanceConfigurationProperty instanceConfigurationProperty = InstanceConfigurationProperty.builder()
     *         .blockDeviceMappings(List.of(InstanceBlockDeviceMappingProperty.builder()
     *                 .deviceName("deviceName")
     *                 .ebs(EbsInstanceBlockDeviceSpecificationProperty.builder()
     *                         .deleteOnTermination(false)
     *                         .encrypted(false)
     *                         .iops(123)
     *                         .kmsKeyId("kmsKeyId")
     *                         .snapshotId("snapshotId")
     *                         .throughput(123)
     *                         .volumeSize(123)
     *                         .volumeType("volumeType")
     *                         .build())
     *                 .noDevice("noDevice")
     *                 .virtualName("virtualName")
     *                 .build()))
     *         .image("image")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.InstanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the block devices to attach for building an instance from this Image Builder AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
            return null;
        }

        /**
         * The AMI ID to use as the base image for a container build and test instance.
         * <p>
         * If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceConfigurationProperty> {
            java.lang.Object blockDeviceMappings;
            java.lang.String image;

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings Defines the block devices to attach for building an instance from this Image Builder AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(software.amazon.awscdk.IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings Defines the block devices to attach for building an instance from this Image Builder AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getImage}
             * @param image The AMI ID to use as the base image for a container build and test instance.
             *              If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceConfigurationProperty {
            private final java.lang.Object blockDeviceMappings;
            private final java.lang.String image;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockDeviceMappings = software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockDeviceMappings = builder.blockDeviceMappings;
                this.image = builder.image;
            }

            @Override
            public final java.lang.Object getBlockDeviceMappings() {
                return this.blockDeviceMappings;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockDeviceMappings() != null) {
                    data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                }
                if (this.getImage() != null) {
                    data.set("image", om.valueToTree(this.getImage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.InstanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceConfigurationProperty.Jsii$Proxy that = (InstanceConfigurationProperty.Jsii$Proxy) o;

                if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
                return this.image != null ? this.image.equals(that.image) : that.image == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0;
                result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The container repository where the output container image is stored.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * TargetContainerRepositoryProperty targetContainerRepositoryProperty = TargetContainerRepositoryProperty.builder()
     *         .repositoryName("repositoryName")
     *         .service("service")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.TargetContainerRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetContainerRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetContainerRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the container repository where the output container image is stored.
         * <p>
         * This name is prefixed by the repository location.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
            return null;
        }

        /**
         * Specifies the service in which this image was registered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getService() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetContainerRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetContainerRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetContainerRepositoryProperty> {
            java.lang.String repositoryName;
            java.lang.String service;

            /**
             * Sets the value of {@link TargetContainerRepositoryProperty#getRepositoryName}
             * @param repositoryName The name of the container repository where the output container image is stored.
             *                       This name is prefixed by the repository location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryName(java.lang.String repositoryName) {
                this.repositoryName = repositoryName;
                return this;
            }

            /**
             * Sets the value of {@link TargetContainerRepositoryProperty#getService}
             * @param service Specifies the service in which this image was registered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder service(java.lang.String service) {
                this.service = service;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetContainerRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetContainerRepositoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetContainerRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetContainerRepositoryProperty {
            private final java.lang.String repositoryName;
            private final java.lang.String service;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repositoryName = builder.repositoryName;
                this.service = builder.service;
            }

            @Override
            public final java.lang.String getRepositoryName() {
                return this.repositoryName;
            }

            @Override
            public final java.lang.String getService() {
                return this.service;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRepositoryName() != null) {
                    data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
                }
                if (this.getService() != null) {
                    data.set("service", om.valueToTree(this.getService()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnContainerRecipe.TargetContainerRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetContainerRepositoryProperty.Jsii$Proxy that = (TargetContainerRepositoryProperty.Jsii$Proxy) o;

                if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
                return this.service != null ? this.service.equals(that.service) : that.service == null;
            }

            @Override
            public final int hashCode() {
                int result = this.repositoryName != null ? this.repositoryName.hashCode() : 0;
                result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.imagebuilder.CfnContainerRecipeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.imagebuilder.CfnContainerRecipeProps.Builder();
        }

        /**
         * Build and test components that are included in the container recipe.
         * <p>
         * Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
         * <p>
         * @return {@code this}
         * @param components Build and test components that are included in the container recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(final software.amazon.awscdk.IResolvable components) {
            this.props.components(components);
            return this;
        }
        /**
         * Build and test components that are included in the container recipe.
         * <p>
         * Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
         * <p>
         * @return {@code this}
         * @param components Build and test components that are included in the container recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(final java.util.List<? extends java.lang.Object> components) {
            this.props.components(components);
            return this;
        }

        /**
         * Specifies the type of container, such as Docker.
         * <p>
         * @return {@code this}
         * @param containerType Specifies the type of container, such as Docker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerType(final java.lang.String containerType) {
            this.props.containerType(containerType);
            return this;
        }

        /**
         * The name of the container recipe.
         * <p>
         * @return {@code this}
         * @param name The name of the container recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The base image for the container recipe.
         * <p>
         * @return {@code this}
         * @param parentImage The base image for the container recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentImage(final java.lang.String parentImage) {
            this.props.parentImage(parentImage);
            return this;
        }

        /**
         * The destination repository for the container image.
         * <p>
         * @return {@code this}
         * @param targetRepository The destination repository for the container image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetRepository(final software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe.TargetContainerRepositoryProperty targetRepository) {
            this.props.targetRepository(targetRepository);
            return this;
        }
        /**
         * The destination repository for the container image.
         * <p>
         * @return {@code this}
         * @param targetRepository The destination repository for the container image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetRepository(final software.amazon.awscdk.IResolvable targetRepository) {
            this.props.targetRepository(targetRepository);
            return this;
        }

        /**
         * The semantic version of the container recipe.
         * <p>
         * <blockquote>
         * <p>
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         * <p>
         * <em>Assignment:</em> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         * <p>
         * <em>Patterns:</em> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         * <p>
         * <em>Filtering:</em> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param version The semantic version of the container recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * The description of the container recipe.
         * <p>
         * @return {@code this}
         * @param description The description of the container recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside.
         * <p>
         * The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
         * <p>
         * @return {@code this}
         * @param dockerfileTemplateData Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerfileTemplateData(final java.lang.String dockerfileTemplateData) {
            this.props.dockerfileTemplateData(dockerfileTemplateData);
            return this;
        }

        /**
         * The S3 URI for the Dockerfile that will be used to build your container image.
         * <p>
         * @return {@code this}
         * @param dockerfileTemplateUri The S3 URI for the Dockerfile that will be used to build your container image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerfileTemplateUri(final java.lang.String dockerfileTemplateUri) {
            this.props.dockerfileTemplateUri(dockerfileTemplateUri);
            return this;
        }

        /**
         * Specifies the operating system version for the base image.
         * <p>
         * @return {@code this}
         * @param imageOsVersionOverride Specifies the operating system version for the base image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageOsVersionOverride(final java.lang.String imageOsVersionOverride) {
            this.props.imageOsVersionOverride(imageOsVersionOverride);
            return this;
        }

        /**
         * A group of options that can be used to configure an instance for building and testing container images.
         * <p>
         * @return {@code this}
         * @param instanceConfiguration A group of options that can be used to configure an instance for building and testing container images. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(final software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe.InstanceConfigurationProperty instanceConfiguration) {
            this.props.instanceConfiguration(instanceConfiguration);
            return this;
        }
        /**
         * A group of options that can be used to configure an instance for building and testing container images.
         * <p>
         * @return {@code this}
         * @param instanceConfiguration A group of options that can be used to configure an instance for building and testing container images. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(final software.amazon.awscdk.IResolvable instanceConfiguration) {
            this.props.instanceConfiguration(instanceConfiguration);
            return this;
        }

        /**
         * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
         * <p>
         * @return {@code this}
         * @param kmsKeyId Identifies which KMS key is used to encrypt the container image for distribution to the target Region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Specifies the operating system platform when you use a custom base image.
         * <p>
         * @return {@code this}
         * @param platformOverride Specifies the operating system platform when you use a custom base image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformOverride(final java.lang.String platformOverride) {
            this.props.platformOverride(platformOverride);
            return this;
        }

        /**
         * Tags that are attached to the container recipe.
         * <p>
         * @return {@code this}
         * @param tags Tags that are attached to the container recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The working directory for use during build and test workflows.
         * <p>
         * @return {@code this}
         * @param workingDirectory The working directory for use during build and test workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(final java.lang.String workingDirectory) {
            this.props.workingDirectory(workingDirectory);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe build() {
            return new software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
