package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a `CfnTable`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object parameters;
 * Object skewedColumnValueLocationMaps;
 * CfnTableProps cfnTableProps = CfnTableProps.builder()
 *         .catalogId("catalogId")
 *         .databaseName("databaseName")
 *         .tableInput(TableInputProperty.builder()
 *                 .description("description")
 *                 .name("name")
 *                 .owner("owner")
 *                 .parameters(parameters)
 *                 .partitionKeys(List.of(ColumnProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .comment("comment")
 *                         .type("type")
 *                         .build()))
 *                 .retention(123)
 *                 .storageDescriptor(StorageDescriptorProperty.builder()
 *                         .bucketColumns(List.of("bucketColumns"))
 *                         .columns(List.of(ColumnProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .comment("comment")
 *                                 .type("type")
 *                                 .build()))
 *                         .compressed(false)
 *                         .inputFormat("inputFormat")
 *                         .location("location")
 *                         .numberOfBuckets(123)
 *                         .outputFormat("outputFormat")
 *                         .parameters(parameters)
 *                         .schemaReference(SchemaReferenceProperty.builder()
 *                                 .schemaId(SchemaIdProperty.builder()
 *                                         .registryName("registryName")
 *                                         .schemaArn("schemaArn")
 *                                         .schemaName("schemaName")
 *                                         .build())
 *                                 .schemaVersionId("schemaVersionId")
 *                                 .schemaVersionNumber(123)
 *                                 .build())
 *                         .serdeInfo(SerdeInfoProperty.builder()
 *                                 .name("name")
 *                                 .parameters(parameters)
 *                                 .serializationLibrary("serializationLibrary")
 *                                 .build())
 *                         .skewedInfo(SkewedInfoProperty.builder()
 *                                 .skewedColumnNames(List.of("skewedColumnNames"))
 *                                 .skewedColumnValueLocationMaps(skewedColumnValueLocationMaps)
 *                                 .skewedColumnValues(List.of("skewedColumnValues"))
 *                                 .build())
 *                         .sortColumns(List.of(OrderProperty.builder()
 *                                 .column("column")
 *                                 .sortOrder(123)
 *                                 .build()))
 *                         .storedAsSubDirectories(false)
 *                         .build())
 *                 .tableType("tableType")
 *                 .targetTable(TableIdentifierProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         .build())
 *                 .viewExpandedText("viewExpandedText")
 *                 .viewOriginalText("viewOriginalText")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.268Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Data Catalog in which to create the `Table` .
     * <p>
     * If none is supplied, the AWS account ID is used by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

    /**
     * The name of the database where the table metadata resides.
     * <p>
     * For Hive compatibility, this must be all lowercase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

    /**
     * A structure used to define a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTableInput();

    /**
     * @return a {@link Builder} of {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTableProps> {
        java.lang.String catalogId;
        java.lang.String databaseName;
        java.lang.Object tableInput;

        /**
         * Sets the value of {@link CfnTableProps#getCatalogId}
         * @param catalogId The ID of the Data Catalog in which to create the `Table` . This parameter is required.
         *                  If none is supplied, the AWS account ID is used by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(java.lang.String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getDatabaseName}
         * @param databaseName The name of the database where the table metadata resides. This parameter is required.
         *                     For Hive compatibility, this must be all lowercase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableInput}
         * @param tableInput A structure used to define a table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableInput(software.amazon.awscdk.services.glue.CfnTable.TableInputProperty tableInput) {
            this.tableInput = tableInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableInput}
         * @param tableInput A structure used to define a table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableInput(software.amazon.awscdk.IResolvable tableInput) {
            this.tableInput = tableInput;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableProps {
        private final java.lang.String catalogId;
        private final java.lang.String databaseName;
        private final java.lang.Object tableInput;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableInput = software.amazon.jsii.Kernel.get(this, "tableInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            this.tableInput = java.util.Objects.requireNonNull(builder.tableInput, "tableInput is required");
        }

        @Override
        public final java.lang.String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.Object getTableInput() {
            return this.tableInput;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("catalogId", om.valueToTree(this.getCatalogId()));
            data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            data.set("tableInput", om.valueToTree(this.getTableInput()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableProps.Jsii$Proxy that = (CfnTableProps.Jsii$Proxy) o;

            if (!catalogId.equals(that.catalogId)) return false;
            if (!databaseName.equals(that.databaseName)) return false;
            return this.tableInput.equals(that.tableInput);
        }

        @Override
        public final int hashCode() {
            int result = this.catalogId.hashCode();
            result = 31 * result + (this.databaseName.hashCode());
            result = 31 * result + (this.tableInput.hashCode());
            return result;
        }
    }
}
