package software.amazon.awscdk.services.fsx;

/**
 * Properties specific to the Lustre version of the FSx file system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Vpc vpc;
 * s3.Bucket bucket;
 * Map&lt;String, Object&gt; lustreConfiguration = Map.of(
 *         "deploymentType", LustreDeploymentType.SCRATCH_2,
 *         "exportPath", bucket.s3UrlForObject(),
 *         "importPath", bucket.s3UrlForObject(),
 *         "autoImportPolicy", LustreAutoImportPolicy.NEW_CHANGED_DELETED);
 * LustreFileSystem fs = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .storageCapacityGiB(1200)
 *         .lustreConfiguration(lustreConfiguration)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.145Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreFileSystemProps")
@software.amazon.jsii.Jsii.Proxy(LustreFileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LustreFileSystemProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.fsx.FileSystemProps {

    /**
     * Additional configuration for FSx specific to Lustre.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.LustreConfiguration getLustreConfiguration();

    /**
     * The subnet that the file system will be accessible from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet getVpcSubnet();

    /**
     * @return a {@link Builder} of {@link LustreFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LustreFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LustreFileSystemProps> {
        software.amazon.awscdk.services.fsx.LustreConfiguration lustreConfiguration;
        software.amazon.awscdk.services.ec2.ISubnet vpcSubnet;
        java.lang.Number storageCapacityGiB;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.String backupId;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Sets the value of {@link LustreFileSystemProps#getLustreConfiguration}
         * @param lustreConfiguration Additional configuration for FSx specific to Lustre. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lustreConfiguration(software.amazon.awscdk.services.fsx.LustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link LustreFileSystemProps#getVpcSubnet}
         * @param vpcSubnet The subnet that the file system will be accessible from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnet(software.amazon.awscdk.services.ec2.ISubnet vpcSubnet) {
            this.vpcSubnet = vpcSubnet;
            return this;
        }

        /**
         * Sets the value of {@link LustreFileSystemProps#getStorageCapacityGiB}
         * @param storageCapacityGiB The storage capacity of the file system being created. This parameter is required.
         *                           For Windows file systems, valid values are 32 GiB to 65,536 GiB.
         *                           For SCRATCH_1 deployment types, valid values are 1,200, 2,400, 3,600, then continuing in increments of 3,600 GiB.
         *                           For SCRATCH_2 and PERSISTENT_1 types, valid values are 1,200, 2,400, then continuing in increments of 2,400 GiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCapacityGiB(java.lang.Number storageCapacityGiB) {
            this.storageCapacityGiB = storageCapacityGiB;
            return this;
        }

        /**
         * Sets the value of {@link LustreFileSystemProps#getVpc}
         * @param vpc The VPC to launch the file system in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link LustreFileSystemProps#getBackupId}
         * @param backupId The ID of the backup.
         *                 Specifies the backup to use if you're creating a file system from an existing backup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(java.lang.String backupId) {
            this.backupId = backupId;
            return this;
        }

        /**
         * Sets the value of {@link LustreFileSystemProps#getKmsKey}
         * @param kmsKey The KMS key used for encryption to protect your data at rest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link LustreFileSystemProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the file system is removed from the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LustreFileSystemProps#getSecurityGroup}
         * @param securityGroup Security Group to assign to this file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LustreFileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LustreFileSystemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LustreFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LustreFileSystemProps {
        private final software.amazon.awscdk.services.fsx.LustreConfiguration lustreConfiguration;
        private final software.amazon.awscdk.services.ec2.ISubnet vpcSubnet;
        private final java.lang.Number storageCapacityGiB;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.String backupId;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lustreConfiguration = software.amazon.jsii.Kernel.get(this, "lustreConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.LustreConfiguration.class));
            this.vpcSubnet = software.amazon.jsii.Kernel.get(this, "vpcSubnet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class));
            this.storageCapacityGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.backupId = software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lustreConfiguration = java.util.Objects.requireNonNull(builder.lustreConfiguration, "lustreConfiguration is required");
            this.vpcSubnet = java.util.Objects.requireNonNull(builder.vpcSubnet, "vpcSubnet is required");
            this.storageCapacityGiB = java.util.Objects.requireNonNull(builder.storageCapacityGiB, "storageCapacityGiB is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.backupId = builder.backupId;
            this.kmsKey = builder.kmsKey;
            this.removalPolicy = builder.removalPolicy;
            this.securityGroup = builder.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.fsx.LustreConfiguration getLustreConfiguration() {
            return this.lustreConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISubnet getVpcSubnet() {
            return this.vpcSubnet;
        }

        @Override
        public final java.lang.Number getStorageCapacityGiB() {
            return this.storageCapacityGiB;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.String getBackupId() {
            return this.backupId;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lustreConfiguration", om.valueToTree(this.getLustreConfiguration()));
            data.set("vpcSubnet", om.valueToTree(this.getVpcSubnet()));
            data.set("storageCapacityGiB", om.valueToTree(this.getStorageCapacityGiB()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getBackupId() != null) {
                data.set("backupId", om.valueToTree(this.getBackupId()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.LustreFileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LustreFileSystemProps.Jsii$Proxy that = (LustreFileSystemProps.Jsii$Proxy) o;

            if (!lustreConfiguration.equals(that.lustreConfiguration)) return false;
            if (!vpcSubnet.equals(that.vpcSubnet)) return false;
            if (!storageCapacityGiB.equals(that.storageCapacityGiB)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.backupId != null ? !this.backupId.equals(that.backupId) : that.backupId != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.securityGroup != null ? this.securityGroup.equals(that.securityGroup) : that.securityGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.lustreConfiguration.hashCode();
            result = 31 * result + (this.vpcSubnet.hashCode());
            result = 31 * result + (this.storageCapacityGiB.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.backupId != null ? this.backupId.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            return result;
        }
    }
}
