package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Load balancing protocol for application load balancers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationTargetGroup tg = ApplicationTargetGroup.Builder.create(this, "TG")
 *         .targetType(TargetType.IP)
 *         .port(50051)
 *         .protocol(ApplicationProtocol.HTTP)
 *         .protocolVersion(ApplicationProtocolVersion.GRPC)
 *         .healthCheck(HealthCheck.builder()
 *                 .enabled(true)
 *                 .healthyGrpcCodes("0-99")
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:58.746Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationProtocol")
public enum ApplicationProtocol {
    /**
     * HTTP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     * HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
}
