package software.amazon.awscdk.services.eks;

/**
 * Properties for defining a `CfnCluster`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .resourcesVpcConfig(ResourcesVpcConfigProperty.builder()
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .endpointPrivateAccess(false)
 *                 .endpointPublicAccess(false)
 *                 .publicAccessCidrs(List.of("publicAccessCidrs"))
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .encryptionConfig(List.of(EncryptionConfigProperty.builder()
 *                 .provider(ProviderProperty.builder()
 *                         .keyArn("keyArn")
 *                         .build())
 *                 .resources(List.of("resources"))
 *                 .build()))
 *         .kubernetesNetworkConfig(KubernetesNetworkConfigProperty.builder()
 *                 .ipFamily("ipFamily")
 *                 .serviceIpv4Cidr("serviceIpv4Cidr")
 *                 .serviceIpv6Cidr("serviceIpv6Cidr")
 *                 .build())
 *         .logging(LoggingProperty.builder()
 *                 .clusterLogging(ClusterLoggingProperty.builder()
 *                         .enabledTypes(List.of(LoggingTypeConfigProperty.builder()
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .version("version")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:58.587Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The VPC configuration that's used by the cluster control plane.
     * <p>
     * Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <em>Amazon EKS User Guide</em> . You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
     * <p>
     * <blockquote>
     * <p>
     * Updates require replacement of the <code>SecurityGroupIds</code> and <code>SubnetIds</code> sub-properties.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourcesVpcConfig();

    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <strong>Amazon EKS User Guide</strong> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The encryption configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfig() {
        return null;
    }

    /**
     * The Kubernetes network configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKubernetesNetworkConfig() {
        return null;
    }

    /**
     * The logging configuration for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
        return null;
    }

    /**
     * The unique name to give to your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The metadata that you apply to the cluster to assist with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Cluster tags don't propagate to any other resources associated with the cluster.
     * <p>
     * <blockquote>
     * <p>
     * You must have the <code>eks:TagResource</code> and <code>eks:UntagResource</code> permissions in your IAM user or IAM role used to manage the CloudFormation stack. If you don't have these permissions, there might be unexpected behavior with stack-level tags propagating to the resource during resource creation and update.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The desired Kubernetes version for your cluster.
     * <p>
     * If you don't specify a value here, the latest version available in Amazon EKS is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.Object resourcesVpcConfig;
        java.lang.String roleArn;
        java.lang.Object encryptionConfig;
        java.lang.Object kubernetesNetworkConfig;
        java.lang.Object logging;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String version;

        /**
         * Sets the value of {@link CfnClusterProps#getResourcesVpcConfig}
         * @param resourcesVpcConfig The VPC configuration that's used by the cluster control plane. This parameter is required.
         *                           Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <em>Amazon EKS User Guide</em> . You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           Updates require replacement of the <code>SecurityGroupIds</code> and <code>SubnetIds</code> sub-properties.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesVpcConfig(software.amazon.awscdk.services.eks.CfnCluster.ResourcesVpcConfigProperty resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getResourcesVpcConfig}
         * @param resourcesVpcConfig The VPC configuration that's used by the cluster control plane. This parameter is required.
         *                           Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <em>Amazon EKS User Guide</em> . You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           Updates require replacement of the <code>SecurityGroupIds</code> and <code>SubnetIds</code> sub-properties.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesVpcConfig(software.amazon.awscdk.IResolvable resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. This parameter is required.
         *                For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <strong>Amazon EKS User Guide</strong> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncryptionConfig}
         * @param encryptionConfig The encryption configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfig(software.amazon.awscdk.IResolvable encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncryptionConfig}
         * @param encryptionConfig The encryption configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfig(java.util.List<? extends java.lang.Object> encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKubernetesNetworkConfig}
         * @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubernetesNetworkConfig(software.amazon.awscdk.services.eks.CfnCluster.KubernetesNetworkConfigProperty kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKubernetesNetworkConfig}
         * @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubernetesNetworkConfig(software.amazon.awscdk.IResolvable kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLogging}
         * @param logging The logging configuration for your cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.eks.CfnCluster.LoggingProperty logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLogging}
         * @param logging The logging configuration for your cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.IResolvable logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getName}
         * @param name The unique name to give to your cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags The metadata that you apply to the cluster to assist with categorization and organization.
         *             Each tag consists of a key and an optional value, both of which you define. Cluster tags don't propagate to any other resources associated with the cluster.
         *             <p>
         *             <blockquote>
         *             <p>
         *             You must have the <code>eks:TagResource</code> and <code>eks:UntagResource</code> permissions in your IAM user or IAM role used to manage the CloudFormation stack. If you don't have these permissions, there might be unexpected behavior with stack-level tags propagating to the resource during resource creation and update.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVersion}
         * @param version The desired Kubernetes version for your cluster.
         *                If you don't specify a value here, the latest version available in Amazon EKS is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.Object resourcesVpcConfig;
        private final java.lang.String roleArn;
        private final java.lang.Object encryptionConfig;
        private final java.lang.Object kubernetesNetworkConfig;
        private final java.lang.Object logging;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourcesVpcConfig = software.amazon.jsii.Kernel.get(this, "resourcesVpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionConfig = software.amazon.jsii.Kernel.get(this, "encryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kubernetesNetworkConfig = software.amazon.jsii.Kernel.get(this, "kubernetesNetworkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourcesVpcConfig = java.util.Objects.requireNonNull(builder.resourcesVpcConfig, "resourcesVpcConfig is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.encryptionConfig = builder.encryptionConfig;
            this.kubernetesNetworkConfig = builder.kubernetesNetworkConfig;
            this.logging = builder.logging;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.version = builder.version;
        }

        @Override
        public final java.lang.Object getResourcesVpcConfig() {
            return this.resourcesVpcConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getEncryptionConfig() {
            return this.encryptionConfig;
        }

        @Override
        public final java.lang.Object getKubernetesNetworkConfig() {
            return this.kubernetesNetworkConfig;
        }

        @Override
        public final java.lang.Object getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourcesVpcConfig", om.valueToTree(this.getResourcesVpcConfig()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getEncryptionConfig() != null) {
                data.set("encryptionConfig", om.valueToTree(this.getEncryptionConfig()));
            }
            if (this.getKubernetesNetworkConfig() != null) {
                data.set("kubernetesNetworkConfig", om.valueToTree(this.getKubernetesNetworkConfig()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (!resourcesVpcConfig.equals(that.resourcesVpcConfig)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.encryptionConfig != null ? !this.encryptionConfig.equals(that.encryptionConfig) : that.encryptionConfig != null) return false;
            if (this.kubernetesNetworkConfig != null ? !this.kubernetesNetworkConfig.equals(that.kubernetesNetworkConfig) : that.kubernetesNetworkConfig != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourcesVpcConfig.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.encryptionConfig != null ? this.encryptionConfig.hashCode() : 0);
            result = 31 * result + (this.kubernetesNetworkConfig != null ? this.kubernetesNetworkConfig.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
