package software.amazon.awscdk.services.eks;

/**
 * Manages mapping between IAM users and roles to Kubernetes RBAC configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * Cluster cluster;
 * AwsAuth awsAuth = AwsAuth.Builder.create(this, "MyAwsAuth")
 *         .cluster(cluster)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/en_us/eks/latest/userguide/add-user-role.html">https://docs.aws.amazon.com/en_us/eks/latest/userguide/add-user-role.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:58.579Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AwsAuth")
public class AwsAuth extends software.constructs.Construct {

    protected AwsAuth(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsAuth(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AwsAuth(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AwsAuthProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Additional AWS account to add to the aws-auth configmap.
     * <p>
     * @param accountId account number. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccount(final @org.jetbrains.annotations.NotNull java.lang.String accountId) {
        software.amazon.jsii.Kernel.call(this, "addAccount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    /**
     * Adds the specified IAM role to the `system:masters` RBAC group, which means that anyone that can assume it will be able to administer this Kubernetes system.
     * <p>
     * @param role The IAM role to add. This parameter is required.
     * @param username Optional user (defaults to the role ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMastersRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role, final @org.jetbrains.annotations.Nullable java.lang.String username) {
        software.amazon.jsii.Kernel.call(this, "addMastersRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required"), username });
    }

    /**
     * Adds the specified IAM role to the `system:masters` RBAC group, which means that anyone that can assume it will be able to administer this Kubernetes system.
     * <p>
     * @param role The IAM role to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMastersRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        software.amazon.jsii.Kernel.call(this, "addMastersRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Adds a mapping between an IAM role to a Kubernetes user and groups.
     * <p>
     * @param role The IAM role to map. This parameter is required.
     * @param mapping Mapping to k8s user name and groups. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addRoleMapping(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AwsAuthMapping mapping) {
        software.amazon.jsii.Kernel.call(this, "addRoleMapping", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required"), java.util.Objects.requireNonNull(mapping, "mapping is required") });
    }

    /**
     * Adds a mapping between an IAM user to a Kubernetes user and groups.
     * <p>
     * @param user The IAM user to map. This parameter is required.
     * @param mapping Mapping to k8s user name and groups. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addUserMapping(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IUser user, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AwsAuthMapping mapping) {
        software.amazon.jsii.Kernel.call(this, "addUserMapping", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(user, "user is required"), java.util.Objects.requireNonNull(mapping, "mapping is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.AwsAuth}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.AwsAuth> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.AwsAuthProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.AwsAuthProps.Builder();
        }

        /**
         * The EKS cluster to apply this configuration to.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster to apply this configuration to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.Cluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.AwsAuth}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.AwsAuth build() {
            return new software.amazon.awscdk.services.eks.AwsAuth(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
