package software.amazon.awscdk.services.ecs;

/**
 * A container definition is used in a task definition to describe the containers that are launched as part of a task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TaskDefinition taskDefinition;
 * Cluster cluster;
 * // Add a container to the task definition
 * ContainerDefinition specificContainer = taskDefinition.addContainer("Container", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("/aws/aws-example-app"))
 *         .memoryLimitMiB(2048)
 *         .build());
 * // Add a port mapping
 * specificContainer.addPortMappings(PortMapping.builder()
 *         .containerPort(7600)
 *         .protocol(Protocol.TCP)
 *         .build());
 * Ec2Service.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .cloudMapOptions(CloudMapOptions.builder()
 *                 // Create SRV records - useful for bridge networking
 *                 .dnsRecordType(DnsRecordType.SRV)
 *                 // Targets port TCP port 7600 `specificContainer`
 *                 .container(specificContainer)
 *                 .containerPort(7600)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:58.364Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ContainerDefinition")
public class ContainerDefinition extends software.constructs.Construct {

    protected ContainerDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ContainerDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ContainerDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ContainerDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This method adds one or more container dependencies to the container.
     * <p>
     * @param containerDependencies This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addContainerDependencies(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDependency... containerDependencies) {
        software.amazon.jsii.Kernel.call(this, "addContainerDependencies", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(containerDependencies).toArray(Object[]::new));
    }

    /**
     * This method adds an environment variable to the container.
     * <p>
     * @param name This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "addEnvironment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * This method adds one or more resources to the container.
     * <p>
     * @param inferenceAcceleratorResources This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addInferenceAcceleratorResource(final @org.jetbrains.annotations.NotNull java.lang.String... inferenceAcceleratorResources) {
        software.amazon.jsii.Kernel.call(this, "addInferenceAcceleratorResource", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(inferenceAcceleratorResources).toArray(Object[]::new));
    }

    /**
     * This method adds a link which allows containers to communicate with each other without the need for port mappings.
     * <p>
     * This parameter is only supported if the task definition is using the bridge network mode.
     * Warning: The --link flag is a legacy feature of Docker. It may eventually be removed.
     * <p>
     * @param container This parameter is required.
     * @param alias
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLink(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition container, final @org.jetbrains.annotations.Nullable java.lang.String alias) {
        software.amazon.jsii.Kernel.call(this, "addLink", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(container, "container is required"), alias });
    }

    /**
     * This method adds a link which allows containers to communicate with each other without the need for port mappings.
     * <p>
     * This parameter is only supported if the task definition is using the bridge network mode.
     * Warning: The --link flag is a legacy feature of Docker. It may eventually be removed.
     * <p>
     * @param container This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLink(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition container) {
        software.amazon.jsii.Kernel.call(this, "addLink", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
    }

    /**
     * This method adds one or more mount points for data volumes to the container.
     * <p>
     * @param mountPoints This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMountPoints(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.MountPoint... mountPoints) {
        software.amazon.jsii.Kernel.call(this, "addMountPoints", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(mountPoints).toArray(Object[]::new));
    }

    /**
     * This method adds one or more port mappings to the container.
     * <p>
     * @param portMappings This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPortMappings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PortMapping... portMappings) {
        software.amazon.jsii.Kernel.call(this, "addPortMappings", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(portMappings).toArray(Object[]::new));
    }

    /**
     * This method mounts temporary disk space to the container.
     * <p>
     * This adds the correct container mountPoint and task definition volume.
     * <p>
     * @param scratch This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addScratch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ScratchSpace scratch) {
        software.amazon.jsii.Kernel.call(this, "addScratch", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scratch, "scratch is required") });
    }

    /**
     * This method adds the specified statement to the IAM task execution policy in the task definition.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToExecutionPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToExecutionPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * This method adds one or more ulimits to the container.
     * <p>
     * @param ulimits This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addUlimits(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ulimit... ulimits) {
        software.amazon.jsii.Kernel.call(this, "addUlimits", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(ulimits).toArray(Object[]::new));
    }

    /**
     * This method adds one or more volumes to the container.
     * <p>
     * @param volumesFrom This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addVolumesFrom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.VolumeFrom... volumesFrom) {
        software.amazon.jsii.Kernel.call(this, "addVolumesFrom", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(volumesFrom).toArray(Object[]::new));
    }

    /**
     * Returns the host port for the requested container port if it exists.
     * <p>
     * @param containerPort This parameter is required.
     * @param protocol This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PortMapping findPortMapping(final @org.jetbrains.annotations.NotNull java.lang.Number containerPort, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Protocol protocol) {
        return software.amazon.jsii.Kernel.call(this, "findPortMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PortMapping.class), new Object[] { java.util.Objects.requireNonNull(containerPort, "containerPort is required"), java.util.Objects.requireNonNull(protocol, "protocol is required") });
    }

    /**
     * Render this container definition to a CloudFormation object.
     * <p>
     * @param _taskDefinition [disable-awslint:ref-via-interface] (unused but kept to avoid breaking change).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.TaskDefinition _taskDefinition) {
        return software.amazon.jsii.Kernel.call(this, "renderContainerDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty.class), new Object[] { _taskDefinition });
    }

    /**
     * Render this container definition to a CloudFormation object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition() {
        return software.amazon.jsii.Kernel.call(this, "renderContainerDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty.class));
    }

    /**
     * An array dependencies defined for container startup and shutdown.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.ContainerDependency> getContainerDependencies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "containerDependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDependency.class))));
    }

    /**
     * The name of this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getContainerName() {
        return software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port the container will listen on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getContainerPort() {
        return software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies whether the container will be marked essential.
     * <p>
     * If the essential parameter of a container is marked as true, and that container
     * fails or stops for any reason, all other containers that are part of the task are
     * stopped. If the essential parameter of a container is marked as false, then its
     * failure does not affect the rest of the containers in a task.
     * <p>
     * If this parameter is omitted, a container is assumed to be essential.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getEssential() {
        return software.amazon.jsii.Kernel.get(this, "essential", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The name of the image referenced by this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageName() {
        return software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The inbound rules associated with the security group the task or service will use.
     * <p>
     * This property is only used for tasks that use the awsvpc network mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getIngressPort() {
        return software.amazon.jsii.Kernel.get(this, "ingressPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Whether there was at least one memory limit specified in this definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getMemoryLimitSpecified() {
        return software.amazon.jsii.Kernel.get(this, "memoryLimitSpecified", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The mount points for data volumes in your container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.MountPoint> getMountPoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "mountPoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.MountPoint.class))));
    }

    /**
     * The list of port mappings for the container.
     * <p>
     * Port mappings allow containers to access ports
     * on the host container instance to send or receive traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.PortMapping> getPortMappings() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "portMappings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PortMapping.class))));
    }

    /**
     * The name of the task definition that includes this container definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinition.class));
    }

    /**
     * An array of ulimits to set in the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.Ulimit> getUlimits() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Ulimit.class))));
    }

    /**
     * The data volumes to mount from another container in the same task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.VolumeFrom> getVolumesFrom() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumesFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.VolumeFrom.class))));
    }

    /**
     * The environment files for this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.EnvironmentFileConfig> getEnvironmentFiles() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ecs.EnvironmentFileConfig>)(software.amazon.jsii.Kernel.get(this, "environmentFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EnvironmentFileConfig.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LinuxParameters getLinuxParameters() {
        return software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LinuxParameters.class));
    }

    /**
     * The log configuration specification for the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriverConfig getLogDriverConfig() {
        return software.amazon.jsii.Kernel.get(this, "logDriverConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class));
    }

    /**
     * Whether this container definition references a specific JSON field of a secret stored in Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getReferencesSecretJsonField() {
        return software.amazon.jsii.Kernel.get(this, "referencesSecretJsonField", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.ContainerDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.ContainerDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.ContainerDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.ContainerDefinitionProps.Builder();
        }

        /**
         * The image used to start a container.
         * <p>
         * This string is passed directly to the Docker daemon.
         * Images in the Docker Hub registry are available by default.
         * Other repositories are specified with either repository-url/image:tag or repository-url/image&#64;digest.
         * TODO: Update these to specify using classes of IContainerImage
         * <p>
         * @return {@code this}
         * @param image The image used to start a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(final software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.props.image(image);
            return this;
        }

        /**
         * The command that is passed to the container.
         * <p>
         * If you provide a shell command as a single string, you have to quote command-line arguments.
         * <p>
         * Default: - CMD value built into container image.
         * <p>
         * @return {@code this}
         * @param command The command that is passed to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(final java.util.List<java.lang.String> command) {
            this.props.command(command);
            return this;
        }

        /**
         * The name of the container.
         * <p>
         * Default: - id of node associated with ContainerDefinition.
         * <p>
         * @return {@code this}
         * @param containerName The name of the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(final java.lang.String containerName) {
            this.props.containerName(containerName);
            return this;
        }

        /**
         * The minimum number of CPU units to reserve for the container.
         * <p>
         * Default: - No minimum CPU units reserved.
         * <p>
         * @return {@code this}
         * @param cpu The minimum number of CPU units to reserve for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * Specifies whether networking is disabled within the container.
         * <p>
         * When this parameter is true, networking is disabled within the container.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param disableNetworking Specifies whether networking is disabled within the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableNetworking(final java.lang.Boolean disableNetworking) {
            this.props.disableNetworking(disableNetworking);
            return this;
        }

        /**
         * A list of DNS search domains that are presented to the container.
         * <p>
         * Default: - No search domains.
         * <p>
         * @return {@code this}
         * @param dnsSearchDomains A list of DNS search domains that are presented to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsSearchDomains(final java.util.List<java.lang.String> dnsSearchDomains) {
            this.props.dnsSearchDomains(dnsSearchDomains);
            return this;
        }

        /**
         * A list of DNS servers that are presented to the container.
         * <p>
         * Default: - Default DNS servers.
         * <p>
         * @return {@code this}
         * @param dnsServers A list of DNS servers that are presented to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsServers(final java.util.List<java.lang.String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        /**
         * A key/value map of labels to add to the container.
         * <p>
         * Default: - No labels.
         * <p>
         * @return {@code this}
         * @param dockerLabels A key/value map of labels to add to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerLabels(final java.util.Map<java.lang.String, java.lang.String> dockerLabels) {
            this.props.dockerLabels(dockerLabels);
            return this;
        }

        /**
         * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         * <p>
         * Default: - No security labels.
         * <p>
         * @return {@code this}
         * @param dockerSecurityOptions A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerSecurityOptions(final java.util.List<java.lang.String> dockerSecurityOptions) {
            this.props.dockerSecurityOptions(dockerSecurityOptions);
            return this;
        }

        /**
         * The ENTRYPOINT value to pass to the container.
         * <p>
         * Default: - Entry point configured in container.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder/#entrypoint</a>
         * @param entryPoint The ENTRYPOINT value to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entryPoint(final java.util.List<java.lang.String> entryPoint) {
            this.props.entryPoint(entryPoint);
            return this;
        }

        /**
         * The environment variables to pass to the container.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param environment The environment variables to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The environment files to pass to the container.
         * <p>
         * Default: - No environment files.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html</a>
         * @param environmentFiles The environment files to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentFiles(final java.util.List<? extends software.amazon.awscdk.services.ecs.EnvironmentFile> environmentFiles) {
            this.props.environmentFiles(environmentFiles);
            return this;
        }

        /**
         * Specifies whether the container is marked essential.
         * <p>
         * If the essential parameter of a container is marked as true, and that container fails
         * or stops for any reason, all other containers that are part of the task are stopped.
         * If the essential parameter of a container is marked as false, then its failure does not
         * affect the rest of the containers in a task. All tasks must have at least one essential container.
         * <p>
         * If this parameter is omitted, a container is assumed to be essential.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param essential Specifies whether the container is marked essential. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder essential(final java.lang.Boolean essential) {
            this.props.essential(essential);
            return this;
        }

        /**
         * A list of hostnames and IP address mappings to append to the /etc/hosts file on the container.
         * <p>
         * Default: - No extra hosts.
         * <p>
         * @return {@code this}
         * @param extraHosts A list of hostnames and IP address mappings to append to the /etc/hosts file on the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHosts(final java.util.Map<java.lang.String, java.lang.String> extraHosts) {
            this.props.extraHosts(extraHosts);
            return this;
        }

        /**
         * The number of GPUs assigned to the container.
         * <p>
         * Default: - No GPUs assigned.
         * <p>
         * @return {@code this}
         * @param gpuCount The number of GPUs assigned to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuCount(final java.lang.Number gpuCount) {
            this.props.gpuCount(gpuCount);
            return this;
        }

        /**
         * The health check command and associated configuration parameters for the container.
         * <p>
         * Default: - Health check configuration from container.
         * <p>
         * @return {@code this}
         * @param healthCheck The health check command and associated configuration parameters for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.ecs.HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * The hostname to use for your container.
         * <p>
         * Default: - Automatic hostname.
         * <p>
         * @return {@code this}
         * @param hostname The hostname to use for your container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(final java.lang.String hostname) {
            this.props.hostname(hostname);
            return this;
        }

        /**
         * The inference accelerators referenced by the container.
         * <p>
         * Default: - No inference accelerators assigned.
         * <p>
         * @return {@code this}
         * @param inferenceAcceleratorResources The inference accelerators referenced by the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAcceleratorResources(final java.util.List<java.lang.String> inferenceAcceleratorResources) {
            this.props.inferenceAcceleratorResources(inferenceAcceleratorResources);
            return this;
        }

        /**
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         * <p>
         * For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a>.
         * <p>
         * Default: - No Linux parameters.
         * <p>
         * @return {@code this}
         * @param linuxParameters Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linuxParameters(final software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters) {
            this.props.linuxParameters(linuxParameters);
            return this;
        }

        /**
         * The log configuration specification for the container.
         * <p>
         * Default: - Containers use the same logging driver that the Docker daemon uses.
         * <p>
         * @return {@code this}
         * @param logging The log configuration specification for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.ecs.LogDriver logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * The amount (in MiB) of memory to present to the container.
         * <p>
         * If your container attempts to exceed the allocated memory, the container
         * is terminated.
         * <p>
         * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * <p>
         * Default: - No memory limit.
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The amount (in MiB) of memory to present to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * <p>
         * When system memory is under heavy contention, Docker attempts to keep the
         * container memory to this soft limit. However, your container can consume more
         * memory when it needs to, up to either the hard limit specified with the memory
         * parameter (if applicable), or all of the available memory on the container
         * instance, whichever comes first.
         * <p>
         * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * <p>
         * Default: - No memory reserved.
         * <p>
         * @return {@code this}
         * @param memoryReservationMiB The soft limit (in MiB) of memory to reserve for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservationMiB(final java.lang.Number memoryReservationMiB) {
            this.props.memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        /**
         * The port mappings to add to the container definition.
         * <p>
         * Default: - No ports are mapped.
         * <p>
         * @return {@code this}
         * @param portMappings The port mappings to add to the container definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portMappings(final java.util.List<? extends software.amazon.awscdk.services.ecs.PortMapping> portMappings) {
            this.props.portMappings(portMappings);
            return this;
        }

        /**
         * Specifies whether the container is marked as privileged.
         * <p>
         * When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param privileged Specifies whether the container is marked as privileged. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privileged(final java.lang.Boolean privileged) {
            this.props.privileged(privileged);
            return this;
        }

        /**
         * When this parameter is true, the container is given read-only access to its root file system.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonlyRootFilesystem(final java.lang.Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        /**
         * The secret environment variables to pass to the container.
         * <p>
         * Default: - No secret environment variables.
         * <p>
         * @return {@code this}
         * @param secrets The secret environment variables to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        /**
         * Time duration (in seconds) to wait before giving up on resolving dependencies for a container.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param startTimeout Time duration (in seconds) to wait before giving up on resolving dependencies for a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTimeout(final software.amazon.awscdk.Duration startTimeout) {
            this.props.startTimeout(startTimeout);
            return this;
        }

        /**
         * Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param stopTimeout Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopTimeout(final software.amazon.awscdk.Duration stopTimeout) {
            this.props.stopTimeout(stopTimeout);
            return this;
        }

        /**
         * A list of namespaced kernel parameters to set in the container.
         * <p>
         * Default: - No system controls are set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#container_definition_systemcontrols">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#container_definition_systemcontrols</a>
         * @param systemControls A list of namespaced kernel parameters to set in the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder systemControls(final java.util.List<? extends software.amazon.awscdk.services.ecs.SystemControl> systemControls) {
            this.props.systemControls(systemControls);
            return this;
        }

        /**
         * The user name to use inside the container.
         * <p>
         * Default: root
         * <p>
         * @return {@code this}
         * @param user The user name to use inside the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(final java.lang.String user) {
            this.props.user(user);
            return this;
        }

        /**
         * The working directory in which to run commands inside the container.
         * <p>
         * Default: /
         * <p>
         * @return {@code this}
         * @param workingDirectory The working directory in which to run commands inside the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(final java.lang.String workingDirectory) {
            this.props.workingDirectory(workingDirectory);
            return this;
        }

        /**
         * The name of the task definition that includes this container definition.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param taskDefinition The name of the task definition that includes this container definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.ContainerDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.ContainerDefinition build() {
            return new software.amazon.awscdk.services.ecs.ContainerDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
