package software.amazon.awscdk.services.ec2;

/**
 * The destination type for the flow log.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Vpc vpc;
 * LogGroup logGroup = new LogGroup(this, "MyCustomLogGroup");
 * Role role = Role.Builder.create(this, "MyCustomRole")
 *         .assumedBy(new ServicePrincipal("vpc-flow-logs.amazonaws.com"))
 *         .build();
 * FlowLog.Builder.create(this, "FlowLog")
 *         .resourceType(FlowLogResourceType.fromVpc(vpc))
 *         .destination(FlowLogDestination.toCloudWatchLogs(logGroup, role))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:58.098Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.FlowLogDestination")
public abstract class FlowLogDestination extends software.amazon.jsii.JsiiObject {

    protected FlowLogDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FlowLogDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected FlowLogDestination() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use CloudWatch logs as the destination.
     * <p>
     * @param logGroup
     * @param iamRole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestination toCloudWatchLogs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup logGroup, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole iamRole) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogDestination.class, "toCloudWatchLogs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestination.class), new Object[] { logGroup, iamRole });
    }

    /**
     * Use CloudWatch logs as the destination.
     * <p>
     * @param logGroup
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestination toCloudWatchLogs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup logGroup) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogDestination.class, "toCloudWatchLogs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestination.class), new Object[] { logGroup });
    }

    /**
     * Use CloudWatch logs as the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestination toCloudWatchLogs() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogDestination.class, "toCloudWatchLogs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestination.class));
    }

    /**
     * Use S3 as the destination.
     * <p>
     * @param bucket optional s3 bucket to publish logs to.
     * @param keyPrefix optional prefix within the bucket to write logs to.
     * @param options additional s3 destination options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestination toS3(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable java.lang.String keyPrefix, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.S3DestinationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogDestination.class, "toS3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestination.class), new Object[] { bucket, keyPrefix, options });
    }

    /**
     * Use S3 as the destination.
     * <p>
     * @param bucket optional s3 bucket to publish logs to.
     * @param keyPrefix optional prefix within the bucket to write logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestination toS3(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable java.lang.String keyPrefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogDestination.class, "toS3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestination.class), new Object[] { bucket, keyPrefix });
    }

    /**
     * Use S3 as the destination.
     * <p>
     * @param bucket optional s3 bucket to publish logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestination toS3(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket bucket) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogDestination.class, "toS3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestination.class), new Object[] { bucket });
    }

    /**
     * Use S3 as the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestination toS3() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogDestination.class, "toS3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestination.class));
    }

    /**
     * Generates a flow log destination configuration.
     * <p>
     * @param scope This parameter is required.
     * @param flowLog This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLog flowLog);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.FlowLogDestination {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Generates a flow log destination configuration.
         * <p>
         * @param scope This parameter is required.
         * @param flowLog This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLog flowLog) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(flowLog, "flowLog is required") });
        }
    }
}
