package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnNetworkInsightsAnalysis`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNetworkInsightsAnalysisProps cfnNetworkInsightsAnalysisProps = CfnNetworkInsightsAnalysisProps.builder()
 *         .networkInsightsPathId("networkInsightsPathId")
 *         // the properties below are optional
 *         .filterInArns(List.of("filterInArns"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:57.959Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysisProps")
@software.amazon.jsii.Jsii.Proxy(CfnNetworkInsightsAnalysisProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNetworkInsightsAnalysisProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsPathId();

    /**
     * The Amazon Resource Names (ARN) of the resources that the path must traverse.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFilterInArns() {
        return null;
    }

    /**
     * The tags to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNetworkInsightsAnalysisProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkInsightsAnalysisProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNetworkInsightsAnalysisProps> {
        java.lang.String networkInsightsPathId;
        java.util.List<java.lang.String> filterInArns;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnNetworkInsightsAnalysisProps#getNetworkInsightsPathId}
         * @param networkInsightsPathId The ID of the path. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsPathId(java.lang.String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsAnalysisProps#getFilterInArns}
         * @param filterInArns The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterInArns(java.util.List<java.lang.String> filterInArns) {
            this.filterInArns = filterInArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsAnalysisProps#getTags}
         * @param tags The tags to apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInsightsAnalysisProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNetworkInsightsAnalysisProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNetworkInsightsAnalysisProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkInsightsAnalysisProps {
        private final java.lang.String networkInsightsPathId;
        private final java.util.List<java.lang.String> filterInArns;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkInsightsPathId = software.amazon.jsii.Kernel.get(this, "networkInsightsPathId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterInArns = software.amazon.jsii.Kernel.get(this, "filterInArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkInsightsPathId = java.util.Objects.requireNonNull(builder.networkInsightsPathId, "networkInsightsPathId is required");
            this.filterInArns = builder.filterInArns;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getNetworkInsightsPathId() {
            return this.networkInsightsPathId;
        }

        @Override
        public final java.util.List<java.lang.String> getFilterInArns() {
            return this.filterInArns;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkInsightsPathId", om.valueToTree(this.getNetworkInsightsPathId()));
            if (this.getFilterInArns() != null) {
                data.set("filterInArns", om.valueToTree(this.getFilterInArns()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysisProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkInsightsAnalysisProps.Jsii$Proxy that = (CfnNetworkInsightsAnalysisProps.Jsii$Proxy) o;

            if (!networkInsightsPathId.equals(that.networkInsightsPathId)) return false;
            if (this.filterInArns != null ? !this.filterInArns.equals(that.filterInArns) : that.filterInArns != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.networkInsightsPathId.hashCode();
            result = 31 * result + (this.filterInArns != null ? this.filterInArns.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
