package software.amazon.awscdk.services.docdb;

/**
 * A CloudFormation `AWS::DocDB::DBCluster`.
 * <p>
 * The <code>AWS::DocDB::DBCluster</code> Amazon DocumentDB (with MongoDB compatibility) resource describes a DBCluster. Amazon DocumentDB is a fully managed, MongoDB-compatible document database engine. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBCluster.html">DBCluster</a> in the <em>Amazon DocumentDB Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.docdb.*;
 * CfnDBCluster cfnDBCluster = CfnDBCluster.Builder.create(this, "MyCfnDBCluster")
 *         .availabilityZones(List.of("availabilityZones"))
 *         .backupRetentionPeriod(123)
 *         .copyTagsToSnapshot(false)
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbClusterParameterGroupName("dbClusterParameterGroupName")
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .deletionProtection(false)
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .engineVersion("engineVersion")
 *         .kmsKeyId("kmsKeyId")
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .port(123)
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .storageEncrypted(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:57.704Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.CfnDBCluster")
public class CfnDBCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.CfnDBCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DocDB::DBCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.docdb.CfnDBClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::DocDB::DBCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The resource id for the cluster;
     * <p>
     * for example: <code>cluster-ABCD1234EFGH5678IJKL90MNOP</code> . The cluster ID uniquely identifies the cluster and is used in things like IAM authentication policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClusterResourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrClusterResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The connection endpoint for the cluster, such as `sample-cluster.cluster-cozrlsfrcjoc.us-east-1.docdb.amazonaws.com` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number on which the cluster accepts connections.
     * <p>
     * For example: <code>27017</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPort() {
        return software.amazon.jsii.Kernel.get(this, "attrPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The reader endpoint for the cluster.
     * <p>
     * For example: <code>sample-cluster.cluster-ro-cozrlsfrcjoc.us-east-1.docdb.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReadEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrReadEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to be assigned to the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZones(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZones", value);
    }

    /**
     * The number of days for which automated backups are retained. You must specify a minimum value of 1.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 1 to 35.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days for which automated backups are retained. You must specify a minimum value of 1.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 1 to 35.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backupRetentionPeriod", value);
    }

    /**
     * `AWS::DocDB::DBCluster.CopyTagsToSnapshot`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DocDB::DBCluster.CopyTagsToSnapshot`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * `AWS::DocDB::DBCluster.CopyTagsToSnapshot`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * The cluster identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>The first character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>my-cluster</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cluster identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>The first character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>my-cluster</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifier", value);
    }

    /**
     * The name of the cluster parameter group to associate with this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cluster parameter group to associate with this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterParameterGroupName", value);
    }

    /**
     * A subnet group to associate with this cluster.
     * <p>
     * Constraints: Must match the name of an existing <code>DBSubnetGroup</code> . Must not be default.
     * <p>
     * Example: <code>mySubnetgroup</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A subnet group to associate with this cluster.
     * <p>
     * Constraints: Must match the name of an existing <code>DBSubnetGroup</code> . Must not be default.
     * <p>
     * Example: <code>mySubnetgroup</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSubnetGroupName", value);
    }

    /**
     * Protects clusters from being accidentally deleted.
     * <p>
     * If enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Protects clusters from being accidentally deleted.
     * <p>
     * If enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * Protects clusters from being accidentally deleted.
     * <p>
     * If enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The list of log types that need to be enabled for exporting to Amazon CloudWatch Logs.
     * <p>
     * You can enable audit logs or profiler logs. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">Auditing Amazon DocumentDB Events</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">Profiling Amazon DocumentDB Operations</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of log types that need to be enabled for exporting to Amazon CloudWatch Logs.
     * <p>
     * You can enable audit logs or profiler logs. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">Auditing Amazon DocumentDB Events</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">Profiling Amazon DocumentDB Operations</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableCloudwatchLogsExports(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "enableCloudwatchLogsExports", value);
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * The AWS KMS key identifier for an encrypted cluster.
     * <p>
     * The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS KMS encryption key. If you are creating a cluster using the same AWS account that owns the AWS KMS encryption key that is used to encrypt the new cluster, you can use the AWS KMS key alias instead of the ARN for the AWS KMS encryption key.
     * <p>
     * If an encryption key is not specified in <code>KmsKeyId</code> :
     * <p>
     * <ul>
     * <li>If the <code>StorageEncrypted</code> parameter is <code>true</code> , Amazon DocumentDB uses your default encryption key.</li>
     * </ul>
     * <p>
     * AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Regions .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS KMS key identifier for an encrypted cluster.
     * <p>
     * The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS KMS encryption key. If you are creating a cluster using the same AWS account that owns the AWS KMS encryption key that is used to encrypt the new cluster, you can use the AWS KMS key alias instead of the ARN for the AWS KMS encryption key.
     * <p>
     * If an encryption key is not specified in <code>KmsKeyId</code> :
     * <p>
     * <ul>
     * <li>If the <code>StorageEncrypted</code> parameter is <code>true</code> , Amazon DocumentDB uses your default encryption key.</li>
     * </ul>
     * <p>
     * AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Regions .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The name of the master user for the cluster.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be from 1 to 63 letters or numbers.</li>
     * <li>The first character must be a letter.</li>
     * <li>Cannot be a reserved word for the chosen database engine.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the master user for the cluster.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be from 1 to 63 letters or numbers.</li>
     * <li>The first character must be a letter.</li>
     * <li>Cannot be a reserved word for the chosen database engine.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUsername", value);
    }

    /**
     * The password for the master database user.
     * <p>
     * This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (&#64;).
     * <p>
     * Constraints: Must contain from 8 to 100 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password for the master database user.
     * <p>
     * This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (&#64;).
     * <p>
     * Constraints: Must contain from 8 to 100 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUserPassword", value);
    }

    /**
     * Specifies the port that the database engine is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the port that the database engine is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled using the `BackupRetentionPeriod` parameter.
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region .
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled using the `BackupRetentionPeriod` parameter.
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region .
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredBackupWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredBackupWindow", value);
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region , occurring on a random day of the week.
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region , occurring on a random day of the week.
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * The identifier for the snapshot or cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can use only the ARN to specify a snapshot.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing snapshot.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the snapshot or cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can use only the ARN to specify a snapshot.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing snapshot.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotIdentifier", value);
    }

    /**
     * Specifies whether the cluster is encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the cluster is encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * Specifies whether the cluster is encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * A list of EC2 VPC security groups to associate with this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of EC2 VPC security groups to associate with this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroupIds", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.docdb.CfnDBCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.docdb.CfnDBCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.docdb.CfnDBClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
         * <p>
         * @return {@code this}
         * @param availabilityZones A list of Amazon EC2 Availability Zones that instances in the cluster can be created in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(final java.util.List<java.lang.String> availabilityZones) {
            this.props().availabilityZones(availabilityZones);
            return this;
        }

        /**
         * The number of days for which automated backups are retained. You must specify a minimum value of 1.
         * <p>
         * Default: 1
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be a value from 1 to 35.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param backupRetentionPeriod The number of days for which automated backups are retained. You must specify a minimum value of 1. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(final java.lang.Number backupRetentionPeriod) {
            this.props().backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        /**
         * `AWS::DocDB::DBCluster.CopyTagsToSnapshot`.
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot `AWS::DocDB::DBCluster.CopyTagsToSnapshot`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }
        /**
         * `AWS::DocDB::DBCluster.CopyTagsToSnapshot`.
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot `AWS::DocDB::DBCluster.CopyTagsToSnapshot`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * The cluster identifier. This parameter is stored as a lowercase string.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
         * <li>The first character must be a letter.</li>
         * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         * </ul>
         * <p>
         * Example: <code>my-cluster</code>
         * <p>
         * @return {@code this}
         * @param dbClusterIdentifier The cluster identifier. This parameter is stored as a lowercase string. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(final java.lang.String dbClusterIdentifier) {
            this.props().dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        /**
         * The name of the cluster parameter group to associate with this cluster.
         * <p>
         * @return {@code this}
         * @param dbClusterParameterGroupName The name of the cluster parameter group to associate with this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterParameterGroupName(final java.lang.String dbClusterParameterGroupName) {
            this.props().dbClusterParameterGroupName(dbClusterParameterGroupName);
            return this;
        }

        /**
         * A subnet group to associate with this cluster.
         * <p>
         * Constraints: Must match the name of an existing <code>DBSubnetGroup</code> . Must not be default.
         * <p>
         * Example: <code>mySubnetgroup</code>
         * <p>
         * @return {@code this}
         * @param dbSubnetGroupName A subnet group to associate with this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(final java.lang.String dbSubnetGroupName) {
            this.props().dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        /**
         * Protects clusters from being accidentally deleted.
         * <p>
         * If enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
         * <p>
         * @return {@code this}
         * @param deletionProtection Protects clusters from being accidentally deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }
        /**
         * Protects clusters from being accidentally deleted.
         * <p>
         * If enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
         * <p>
         * @return {@code this}
         * @param deletionProtection Protects clusters from being accidentally deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.IResolvable deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The list of log types that need to be enabled for exporting to Amazon CloudWatch Logs.
         * <p>
         * You can enable audit logs or profiler logs. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">Auditing Amazon DocumentDB Events</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">Profiling Amazon DocumentDB Operations</a> .
         * <p>
         * @return {@code this}
         * @param enableCloudwatchLogsExports The list of log types that need to be enabled for exporting to Amazon CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(final java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.props().enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        /**
         * The version number of the database engine to use.
         * <p>
         * The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.
         * <p>
         * @return {@code this}
         * @param engineVersion The version number of the database engine to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props().engineVersion(engineVersion);
            return this;
        }

        /**
         * The AWS KMS key identifier for an encrypted cluster.
         * <p>
         * The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS KMS encryption key. If you are creating a cluster using the same AWS account that owns the AWS KMS encryption key that is used to encrypt the new cluster, you can use the AWS KMS key alias instead of the ARN for the AWS KMS encryption key.
         * <p>
         * If an encryption key is not specified in <code>KmsKeyId</code> :
         * <p>
         * <ul>
         * <li>If the <code>StorageEncrypted</code> parameter is <code>true</code> , Amazon DocumentDB uses your default encryption key.</li>
         * </ul>
         * <p>
         * AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Regions .
         * <p>
         * @return {@code this}
         * @param kmsKeyId The AWS KMS key identifier for an encrypted cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The name of the master user for the cluster.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be from 1 to 63 letters or numbers.</li>
         * <li>The first character must be a letter.</li>
         * <li>Cannot be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param masterUsername The name of the master user for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(final java.lang.String masterUsername) {
            this.props().masterUsername(masterUsername);
            return this;
        }

        /**
         * The password for the master database user.
         * <p>
         * This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (&#64;).
         * <p>
         * Constraints: Must contain from 8 to 100 characters.
         * <p>
         * @return {@code this}
         * @param masterUserPassword The password for the master database user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(final java.lang.String masterUserPassword) {
            this.props().masterUserPassword(masterUserPassword);
            return this;
        }

        /**
         * Specifies the port that the database engine is listening on.
         * <p>
         * @return {@code this}
         * @param port Specifies the port that the database engine is listening on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props().port(port);
            return this;
        }

        /**
         * The daily time range during which automated backups are created if automated backups are enabled using the `BackupRetentionPeriod` parameter.
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region .
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
         * <li>Must be in Universal Coordinated Time (UTC).</li>
         * <li>Must not conflict with the preferred maintenance window.</li>
         * <li>Must be at least 30 minutes.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled using the `BackupRetentionPeriod` parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props().preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region , occurring on a random day of the week.
         * <p>
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * <p>
         * Constraints: Minimum 30-minute window.
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props().preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The identifier for the snapshot or cluster snapshot to restore from.
         * <p>
         * You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can use only the ARN to specify a snapshot.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must match the identifier of an existing snapshot.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param snapshotIdentifier The identifier for the snapshot or cluster snapshot to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(final java.lang.String snapshotIdentifier) {
            this.props().snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        /**
         * Specifies whether the cluster is encrypted.
         * <p>
         * @return {@code this}
         * @param storageEncrypted Specifies whether the cluster is encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }
        /**
         * Specifies whether the cluster is encrypted.
         * <p>
         * @return {@code this}
         * @param storageEncrypted Specifies whether the cluster is encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final software.amazon.awscdk.IResolvable storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * The tags to be assigned to the cluster.
         * <p>
         * @return {@code this}
         * @param tags The tags to be assigned to the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * A list of EC2 VPC security groups to associate with this cluster.
         * <p>
         * @return {@code this}
         * @param vpcSecurityGroupIds A list of EC2 VPC security groups to associate with this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(final java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.props().vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.docdb.CfnDBCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.docdb.CfnDBCluster build() {
            return new software.amazon.awscdk.services.docdb.CfnDBCluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.docdb.CfnDBClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.docdb.CfnDBClusterProps.Builder();
            }
            return this.props;
        }
    }
}
