package software.amazon.awscdk.services.directoryservice;

/**
 * Properties for defining a `CfnSimpleAD`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.directoryservice.*;
 * CfnSimpleADProps cfnSimpleADProps = CfnSimpleADProps.builder()
 *         .name("name")
 *         .password("password")
 *         .size("size")
 *         .vpcSettings(VpcSettingsProperty.builder()
 *                 .subnetIds(List.of("subnetIds"))
 *                 .vpcId("vpcId")
 *                 .build())
 *         // the properties below are optional
 *         .createAlias(false)
 *         .description("description")
 *         .enableSso(false)
 *         .shortName("shortName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:57.623Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_directoryservice.CfnSimpleADProps")
@software.amazon.jsii.Jsii.Proxy(CfnSimpleADProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSimpleADProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The fully qualified name for the directory, such as `corp.example.com` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The password for the directory administrator.
     * <p>
     * The directory creation process creates a directory administrator account with the user name <code>Administrator</code> and this password.
     * <p>
     * If you need to change the password for the administrator account, see the <a href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ResetUserPassword.html">ResetUserPassword</a> API call in the <em>AWS Directory Service API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPassword();

    /**
     * The size of the directory.
     * <p>
     * For valid values, see <a href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateDirectory.html">CreateDirectory</a> in the <em>AWS Directory Service API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSize();

    /**
     * A [DirectoryVpcSettings](https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DirectoryVpcSettings.html) object that contains additional information for the operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVpcSettings();

    /**
     * If set to `true` , specifies an alias for a directory and assigns the alias to the directory.
     * <p>
     * The alias is used to construct the access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code> . By default, this property is set to <code>false</code> .
     * <p>
     * <blockquote>
     * <p>
     * After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreateAlias() {
        return null;
    }

    /**
     * A description for the directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Whether to enable single sign-on for a directory.
     * <p>
     * If you don't specify a value, AWS CloudFormation disables single sign-on by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableSso() {
        return null;
    }

    /**
     * The NetBIOS name of the directory, such as `CORP` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getShortName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSimpleADProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSimpleADProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSimpleADProps> {
        java.lang.String name;
        java.lang.String password;
        java.lang.String size;
        java.lang.Object vpcSettings;
        java.lang.Object createAlias;
        java.lang.String description;
        java.lang.Object enableSso;
        java.lang.String shortName;

        /**
         * Sets the value of {@link CfnSimpleADProps#getName}
         * @param name The fully qualified name for the directory, such as `corp.example.com` . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getPassword}
         * @param password The password for the directory administrator. This parameter is required.
         *                 The directory creation process creates a directory administrator account with the user name <code>Administrator</code> and this password.
         *                 <p>
         *                 If you need to change the password for the administrator account, see the <a href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ResetUserPassword.html">ResetUserPassword</a> API call in the <em>AWS Directory Service API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getSize}
         * @param size The size of the directory. This parameter is required.
         *             For valid values, see <a href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateDirectory.html">CreateDirectory</a> in the <em>AWS Directory Service API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(java.lang.String size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getVpcSettings}
         * @param vpcSettings A [DirectoryVpcSettings](https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DirectoryVpcSettings.html) object that contains additional information for the operation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSettings(software.amazon.awscdk.services.directoryservice.CfnSimpleAD.VpcSettingsProperty vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getVpcSettings}
         * @param vpcSettings A [DirectoryVpcSettings](https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DirectoryVpcSettings.html) object that contains additional information for the operation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSettings(software.amazon.awscdk.IResolvable vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getCreateAlias}
         * @param createAlias If set to `true` , specifies an alias for a directory and assigns the alias to the directory.
         *                    The alias is used to construct the access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code> . By default, this property is set to <code>false</code> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createAlias(java.lang.Boolean createAlias) {
            this.createAlias = createAlias;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getCreateAlias}
         * @param createAlias If set to `true` , specifies an alias for a directory and assigns the alias to the directory.
         *                    The alias is used to construct the access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code> . By default, this property is set to <code>false</code> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createAlias(software.amazon.awscdk.IResolvable createAlias) {
            this.createAlias = createAlias;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getDescription}
         * @param description A description for the directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getEnableSso}
         * @param enableSso Whether to enable single sign-on for a directory.
         *                  If you don't specify a value, AWS CloudFormation disables single sign-on by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSso(java.lang.Boolean enableSso) {
            this.enableSso = enableSso;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getEnableSso}
         * @param enableSso Whether to enable single sign-on for a directory.
         *                  If you don't specify a value, AWS CloudFormation disables single sign-on by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSso(software.amazon.awscdk.IResolvable enableSso) {
            this.enableSso = enableSso;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleADProps#getShortName}
         * @param shortName The NetBIOS name of the directory, such as `CORP` .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shortName(java.lang.String shortName) {
            this.shortName = shortName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSimpleADProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSimpleADProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSimpleADProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSimpleADProps {
        private final java.lang.String name;
        private final java.lang.String password;
        private final java.lang.String size;
        private final java.lang.Object vpcSettings;
        private final java.lang.Object createAlias;
        private final java.lang.String description;
        private final java.lang.Object enableSso;
        private final java.lang.String shortName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcSettings = software.amazon.jsii.Kernel.get(this, "vpcSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.createAlias = software.amazon.jsii.Kernel.get(this, "createAlias", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableSso = software.amazon.jsii.Kernel.get(this, "enableSso", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.shortName = software.amazon.jsii.Kernel.get(this, "shortName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
            this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
            this.vpcSettings = java.util.Objects.requireNonNull(builder.vpcSettings, "vpcSettings is required");
            this.createAlias = builder.createAlias;
            this.description = builder.description;
            this.enableSso = builder.enableSso;
            this.shortName = builder.shortName;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.String getSize() {
            return this.size;
        }

        @Override
        public final java.lang.Object getVpcSettings() {
            return this.vpcSettings;
        }

        @Override
        public final java.lang.Object getCreateAlias() {
            return this.createAlias;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEnableSso() {
            return this.enableSso;
        }

        @Override
        public final java.lang.String getShortName() {
            return this.shortName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("password", om.valueToTree(this.getPassword()));
            data.set("size", om.valueToTree(this.getSize()));
            data.set("vpcSettings", om.valueToTree(this.getVpcSettings()));
            if (this.getCreateAlias() != null) {
                data.set("createAlias", om.valueToTree(this.getCreateAlias()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnableSso() != null) {
                data.set("enableSso", om.valueToTree(this.getEnableSso()));
            }
            if (this.getShortName() != null) {
                data.set("shortName", om.valueToTree(this.getShortName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_directoryservice.CfnSimpleADProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSimpleADProps.Jsii$Proxy that = (CfnSimpleADProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!password.equals(that.password)) return false;
            if (!size.equals(that.size)) return false;
            if (!vpcSettings.equals(that.vpcSettings)) return false;
            if (this.createAlias != null ? !this.createAlias.equals(that.createAlias) : that.createAlias != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enableSso != null ? !this.enableSso.equals(that.enableSso) : that.enableSso != null) return false;
            return this.shortName != null ? this.shortName.equals(that.shortName) : that.shortName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.password.hashCode());
            result = 31 * result + (this.size.hashCode());
            result = 31 * result + (this.vpcSettings.hashCode());
            result = 31 * result + (this.createAlias != null ? this.createAlias.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enableSso != null ? this.enableSso.hashCode() : 0);
            result = 31 * result + (this.shortName != null ? this.shortName.hashCode() : 0);
            return result;
        }
    }
}
