package software.amazon.awscdk.services.cognito;

/**
 * Properties to initialize UserPoolAmazonIdentityProvider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * UserPoolIdentityProviderAmazon provider = UserPoolIdentityProviderAmazon.Builder.create(this, "Amazon")
 *         .userPool(pool)
 *         .clientId("amzn-client-id")
 *         .clientSecret("amzn-client-secret")
 *         .build();
 * UserPoolClient client = pool.addClient("app-client", UserPoolClientOptions.builder()
 *         // ...
 *         .supportedIdentityProviders(List.of(UserPoolClientIdentityProvider.AMAZON))
 *         .build());
 * client.node.addDependency(provider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:57.394Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderAmazonProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolIdentityProviderAmazonProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolIdentityProviderAmazonProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.UserPoolIdentityProviderProps {

    /**
     * The client id recognized by 'Login with Amazon' APIs.
     * <p>
     * @see <a href="https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier">https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * The client secret to be accompanied with clientId for 'Login with Amazon' APIs to authenticate the client.
     * <p>
     * @see <a href="https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier">https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

    /**
     * The types of user profile data to obtain for the Amazon profile.
     * <p>
     * Default: [ profile ]
     * <p>
     * @see <a href="https://developer.amazon.com/docs/login-with-amazon/customer-profile.html">https://developer.amazon.com/docs/login-with-amazon/customer-profile.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getScopes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolIdentityProviderAmazonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolIdentityProviderAmazonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolIdentityProviderAmazonProps> {
        java.lang.String clientId;
        java.lang.String clientSecret;
        java.util.List<java.lang.String> scopes;
        software.amazon.awscdk.services.cognito.IUserPool userPool;
        software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Sets the value of {@link UserPoolIdentityProviderAmazonProps#getClientId}
         * @param clientId The client id recognized by 'Login with Amazon' APIs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderAmazonProps#getClientSecret}
         * @param clientSecret The client secret to be accompanied with clientId for 'Login with Amazon' APIs to authenticate the client. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSecret(java.lang.String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderAmazonProps#getScopes}
         * @param scopes The types of user profile data to obtain for the Amazon profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(java.util.List<java.lang.String> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderAmazonProps#getUserPool}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderAmazonProps#getAttributeMapping}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.attributeMapping = attributeMapping;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolIdentityProviderAmazonProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolIdentityProviderAmazonProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolIdentityProviderAmazonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolIdentityProviderAmazonProps {
        private final java.lang.String clientId;
        private final java.lang.String clientSecret;
        private final java.util.List<java.lang.String> scopes;
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class));
            this.attributeMapping = software.amazon.jsii.Kernel.get(this, "attributeMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.AttributeMapping.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
            this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
            this.scopes = builder.scopes;
            this.userPool = java.util.Objects.requireNonNull(builder.userPool, "userPool is required");
            this.attributeMapping = builder.attributeMapping;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final java.lang.String getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public final java.util.List<java.lang.String> getScopes() {
            return this.scopes;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.AttributeMapping getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("clientSecret", om.valueToTree(this.getClientSecret()));
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }
            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getAttributeMapping() != null) {
                data.set("attributeMapping", om.valueToTree(this.getAttributeMapping()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolIdentityProviderAmazonProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolIdentityProviderAmazonProps.Jsii$Proxy that = (UserPoolIdentityProviderAmazonProps.Jsii$Proxy) o;

            if (!clientId.equals(that.clientId)) return false;
            if (!clientSecret.equals(that.clientSecret)) return false;
            if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) return false;
            if (!userPool.equals(that.userPool)) return false;
            return this.attributeMapping != null ? this.attributeMapping.equals(that.attributeMapping) : that.attributeMapping == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + (this.clientSecret.hashCode());
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            result = 31 * result + (this.userPool.hashCode());
            result = 31 * result + (this.attributeMapping != null ? this.attributeMapping.hashCode() : 0);
            return result;
        }
    }
}
