package software.amazon.awscdk.services.codebuild;

/**
 * Event fields for the CodeBuild "phase change" event.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:57.064Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.PhaseChangeEvent")
public class PhaseChangeEvent extends software.amazon.jsii.JsiiObject {

    protected PhaseChangeEvent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PhaseChangeEvent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Whether the build is complete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getBuildComplete() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.PhaseChangeEvent.class, "buildComplete", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The triggering build's id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getBuildId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.PhaseChangeEvent.class, "buildId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The phase that was just completed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getCompletedPhase() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.PhaseChangeEvent.class, "completedPhase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The duration of the completed phase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getCompletedPhaseDurationSeconds() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.PhaseChangeEvent.class, "completedPhaseDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the completed phase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getCompletedPhaseStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.PhaseChangeEvent.class, "completedPhaseStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The triggering build's project name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getProjectName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.PhaseChangeEvent.class, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
