package software.amazon.awscdk.services.cloudwatch;

/**
 * Statistic to use over the aggregation period.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * DeliveryStream deliveryStream;
 * // Alarm that triggers when the per-second average of incoming bytes exceeds 90% of the current service limit
 * MathExpression incomingBytesPercentOfLimit = MathExpression.Builder.create()
 *         .expression("incomingBytes / 300 / bytePerSecLimit")
 *         .usingMetrics(Map.of(
 *                 "incomingBytes", deliveryStream.metricIncomingBytes(MetricOptions.builder().statistic(Statistic.SUM).build()),
 *                 "bytePerSecLimit", deliveryStream.metric("BytesPerSecondLimit")))
 *         .build();
 * Alarm.Builder.create(this, "Alarm")
 *         .metric(incomingBytesPercentOfLimit)
 *         .threshold(0.9)
 *         .evaluationPeriods(3)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:56.980Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Statistic")
public enum Statistic {
    /**
     * The count (number) of data points used for the statistical calculation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAMPLE_COUNT,
    /**
     * The value of Sum / SampleCount during the specified period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AVERAGE,
    /**
     * All values submitted for the matching metric added together.
     * <p>
     * This statistic can be useful for determining the total volume of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SUM,
    /**
     * The lowest value observed during the specified period.
     * <p>
     * You can use this value to determine low volumes of activity for your application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MINIMUM,
    /**
     * The highest value observed during the specified period.
     * <p>
     * You can use this value to determine high volumes of activity for your application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAXIMUM,
}
