package software.amazon.awscdk.services.budgets;

/**
 * Properties for defining a `CfnBudgetsAction`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.budgets.*;
 * CfnBudgetsActionProps cfnBudgetsActionProps = CfnBudgetsActionProps.builder()
 *         .actionThreshold(ActionThresholdProperty.builder()
 *                 .type("type")
 *                 .value(123)
 *                 .build())
 *         .actionType("actionType")
 *         .budgetName("budgetName")
 *         .definition(DefinitionProperty.builder()
 *                 .iamActionDefinition(IamActionDefinitionProperty.builder()
 *                         .policyArn("policyArn")
 *                         // the properties below are optional
 *                         .groups(List.of("groups"))
 *                         .roles(List.of("roles"))
 *                         .users(List.of("users"))
 *                         .build())
 *                 .scpActionDefinition(ScpActionDefinitionProperty.builder()
 *                         .policyId("policyId")
 *                         .targetIds(List.of("targetIds"))
 *                         .build())
 *                 .ssmActionDefinition(SsmActionDefinitionProperty.builder()
 *                         .instanceIds(List.of("instanceIds"))
 *                         .region("region")
 *                         .subtype("subtype")
 *                         .build())
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .notificationType("notificationType")
 *         .subscribers(List.of(SubscriberProperty.builder()
 *                 .address("address")
 *                 .type("type")
 *                 .build()))
 *         // the properties below are optional
 *         .approvalModel("approvalModel")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:56.649Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsActionProps")
@software.amazon.jsii.Jsii.Proxy(CfnBudgetsActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBudgetsActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The trigger threshold of the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActionThreshold();

    /**
     * The type of action.
     * <p>
     * This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getActionType();

    /**
     * A string that represents the budget name.
     * <p>
     * ":" and "" characters aren't allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBudgetName();

    /**
     * Specifies all of the type-specific parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefinition();

    /**
     * The role passed for action execution and reversion.
     * <p>
     * Roles and actions must be in the same account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn();

    /**
     * The type of a notification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNotificationType();

    /**
     * A list of subscribers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSubscribers();

    /**
     * This specifies if the action needs manual or automatic approval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApprovalModel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBudgetsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBudgetsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBudgetsActionProps> {
        java.lang.Object actionThreshold;
        java.lang.String actionType;
        java.lang.String budgetName;
        java.lang.Object definition;
        java.lang.String executionRoleArn;
        java.lang.String notificationType;
        java.lang.Object subscribers;
        java.lang.String approvalModel;

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getActionThreshold}
         * @param actionThreshold The trigger threshold of the action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionThreshold(software.amazon.awscdk.services.budgets.CfnBudgetsAction.ActionThresholdProperty actionThreshold) {
            this.actionThreshold = actionThreshold;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getActionThreshold}
         * @param actionThreshold The trigger threshold of the action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionThreshold(software.amazon.awscdk.IResolvable actionThreshold) {
            this.actionThreshold = actionThreshold;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getActionType}
         * @param actionType The type of action. This parameter is required.
         *                   This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionType(java.lang.String actionType) {
            this.actionType = actionType;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getBudgetName}
         * @param budgetName A string that represents the budget name. This parameter is required.
         *                   ":" and "" characters aren't allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder budgetName(java.lang.String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getDefinition}
         * @param definition Specifies all of the type-specific parameters. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.services.budgets.CfnBudgetsAction.DefinitionProperty definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getDefinition}
         * @param definition Specifies all of the type-specific parameters. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.IResolvable definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getExecutionRoleArn}
         * @param executionRoleArn The role passed for action execution and reversion. This parameter is required.
         *                         Roles and actions must be in the same account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getNotificationType}
         * @param notificationType The type of a notification. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationType(java.lang.String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getSubscribers}
         * @param subscribers A list of subscribers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribers(software.amazon.awscdk.IResolvable subscribers) {
            this.subscribers = subscribers;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getSubscribers}
         * @param subscribers A list of subscribers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribers(java.util.List<? extends java.lang.Object> subscribers) {
            this.subscribers = subscribers;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetsActionProps#getApprovalModel}
         * @param approvalModel This specifies if the action needs manual or automatic approval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvalModel(java.lang.String approvalModel) {
            this.approvalModel = approvalModel;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBudgetsActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBudgetsActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBudgetsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBudgetsActionProps {
        private final java.lang.Object actionThreshold;
        private final java.lang.String actionType;
        private final java.lang.String budgetName;
        private final java.lang.Object definition;
        private final java.lang.String executionRoleArn;
        private final java.lang.String notificationType;
        private final java.lang.Object subscribers;
        private final java.lang.String approvalModel;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionThreshold = software.amazon.jsii.Kernel.get(this, "actionThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.actionType = software.amazon.jsii.Kernel.get(this, "actionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.budgetName = software.amazon.jsii.Kernel.get(this, "budgetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationType = software.amazon.jsii.Kernel.get(this, "notificationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscribers = software.amazon.jsii.Kernel.get(this, "subscribers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.approvalModel = software.amazon.jsii.Kernel.get(this, "approvalModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionThreshold = java.util.Objects.requireNonNull(builder.actionThreshold, "actionThreshold is required");
            this.actionType = java.util.Objects.requireNonNull(builder.actionType, "actionType is required");
            this.budgetName = java.util.Objects.requireNonNull(builder.budgetName, "budgetName is required");
            this.definition = java.util.Objects.requireNonNull(builder.definition, "definition is required");
            this.executionRoleArn = java.util.Objects.requireNonNull(builder.executionRoleArn, "executionRoleArn is required");
            this.notificationType = java.util.Objects.requireNonNull(builder.notificationType, "notificationType is required");
            this.subscribers = java.util.Objects.requireNonNull(builder.subscribers, "subscribers is required");
            this.approvalModel = builder.approvalModel;
        }

        @Override
        public final java.lang.Object getActionThreshold() {
            return this.actionThreshold;
        }

        @Override
        public final java.lang.String getActionType() {
            return this.actionType;
        }

        @Override
        public final java.lang.String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final java.lang.Object getDefinition() {
            return this.definition;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final java.lang.Object getSubscribers() {
            return this.subscribers;
        }

        @Override
        public final java.lang.String getApprovalModel() {
            return this.approvalModel;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionThreshold", om.valueToTree(this.getActionThreshold()));
            data.set("actionType", om.valueToTree(this.getActionType()));
            data.set("budgetName", om.valueToTree(this.getBudgetName()));
            data.set("definition", om.valueToTree(this.getDefinition()));
            data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            data.set("notificationType", om.valueToTree(this.getNotificationType()));
            data.set("subscribers", om.valueToTree(this.getSubscribers()));
            if (this.getApprovalModel() != null) {
                data.set("approvalModel", om.valueToTree(this.getApprovalModel()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetsActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBudgetsActionProps.Jsii$Proxy that = (CfnBudgetsActionProps.Jsii$Proxy) o;

            if (!actionThreshold.equals(that.actionThreshold)) return false;
            if (!actionType.equals(that.actionType)) return false;
            if (!budgetName.equals(that.budgetName)) return false;
            if (!definition.equals(that.definition)) return false;
            if (!executionRoleArn.equals(that.executionRoleArn)) return false;
            if (!notificationType.equals(that.notificationType)) return false;
            if (!subscribers.equals(that.subscribers)) return false;
            return this.approvalModel != null ? this.approvalModel.equals(that.approvalModel) : that.approvalModel == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionThreshold.hashCode();
            result = 31 * result + (this.actionType.hashCode());
            result = 31 * result + (this.budgetName.hashCode());
            result = 31 * result + (this.definition.hashCode());
            result = 31 * result + (this.executionRoleArn.hashCode());
            result = 31 * result + (this.notificationType.hashCode());
            result = 31 * result + (this.subscribers.hashCode());
            result = 31 * result + (this.approvalModel != null ? this.approvalModel.hashCode() : 0);
            return result;
        }
    }
}
